# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Background message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class Background < Message
      ##
      # The location of the `Background` keyword
      ##
      attr_reader :location

      attr_reader :keyword

      attr_reader :name

      attr_reader :description

      attr_reader :steps

      attr_reader :id

      def initialize(
        location: Location.new,
        keyword: '',
        name: '',
        description: '',
        steps: [],
        id: ''
      )
        @location = location
        @keyword = keyword
        @name = name
        @description = description
        @steps = steps
        @id = id
        super()
      end

      ##
      # Returns a new Background from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Background.from_h(some_hash) # => #<Cucumber::Messages::Background:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          location: Location.from_h(hash[:location]),
          keyword: hash[:keyword],
          name: hash[:name],
          description: hash[:description],
          steps: hash[:steps]&.map { |item| Step.from_h(item) },
          id: hash[:id]
        )
      end
    end
  end
end
