-- Verkita originale por Fredrick BRENNAN (copypaste@kittens.ph) 2022-jare
-- Original file by Fredrick R. Brennan (copypaste@kittens.ph) in 2022

local hyphenator = { exceptions = {} }
hyphenator.patterns = {
   -- La fonto de la ŝablonoj ĉisubaj estas Sergio Pokrovskij (@pok49)'s GitHub-projekto «vortdivido».
   -- (The source of the patterns below is Sergio Pokrovskij (@pok49)'s «vortdivido» project on GitHub.)
   -- Ili uzendas LaTeX-permisile.
   -- (They're usable under the LaTeX Public License.)
   -- Mi la ŝablon´datumon ĉisuban kreis por tiuj komandoj vim-e kontraŭ la dosiero `eohyph.m4` (kvankam rimarku bv-e: unue mi ĝin `.l3`-datenaranĝigis por la operaciuma komando `m4 eohyph.m4 > hyphen_eo.l3`):
   -- (I made the pattern data below with these vim commands against the file `eohyph.m4` (altho pls note: I first had to translate it into `.l3` file format by running the shell command `m4 eohyph.m4 > hyphen_eo.l3`):)
   --[[
" run as e.g. `cp hyphen_eo.l3 hyphen_eo_2.l3 && ex hyphen_eo_2.l3 < l3_vimcommands.vim`
%s/%.*//g " remove comments
%s/\s\+/ /g " consolidation
%s/\n\+/\r/g
%s/\s$//g
%s/\n/ /g " all words now space-delimited on one line
%s/\S\+/"\0",/g " add quotes and commas
%s/,\s*$// " remove final comma
%s/^\s\+// " remove initial whitespace
wq " overwrite input
]]
   "3aj.",
   "3an.",
   "3ajn.",
   "1oj.",
   "1on.",
   "1ojn.",
   "1as.",
   "1is.",
   "1os.",
   "1us.",
   "a1",
   "e1",
   "i1",
   "o1",
   "u1",
   "2a3a2",
   "2ao2",
   "ae2",
   "1a2er",
   "ea2",
   "e3e4",
   "2eu2",
   ".ne2nia3",
   "kia4l",
   "tia4l",
   "kie2s",
   "oa2",
   "o3e",
   "oi2",
   "2e3o",
   "e2sper",
   "2ou",
   "uo2",
   "2hn.",
   "2sk.",
   ".br4",
   ".gl4",
   ".gr4",
   ".kl4",
   ".kr4",
   ".kv4",
   ".pl4",
   ".fl4",
   ".pr4",
   ".sk4",
   ".sp4",
   ".spr4",
   ".spl4",
   ".st4",
   ".tr4",
   ".str4",
   ".sv4",
   "1a2æa.",
   "1a2æ1aj.",
   "1a2æ1ajn.",
   "1a2æ3an.",
   "1a2æo.",
   "1a2æ1oj.",
   "1a2æ1ojn.",
   "1a2æ1on.",
   "1a2æe.",
   "1a2da.",
   "1a2d1aj.",
   "1a2d1ajn.",
   "1a2d3an.",
   "1a2do.",
   "1a2d1oj.",
   "1a2d1ojn.",
   "1a2d1on.",
   "1a2de.",
   "1a2d1as.",
   "1a2di.",
   "1a2d1is.",
   "1a2d3os.",
   "1a2du.",
   "1a2d1us.",
   ".ag1a2d",
   "ambas2a3d",
   ".avok2a3d",
   ".bal2a3d",
   "cik2a3d",
   "æokol2a3d",
   "fas2a3d",
   "gr2a3d",
   "migr3a4d",
   "inv2a3d",
   "kamar2a3d",
   ".kan2a3d",
   "limon2a3d",
   "persv2a3d",
   "pl2aæ",
   ".pom2a3d",
   "seren2a3d",
   ".aj2n1",
   ".aj3n2u",
   "1a2¼a.",
   "1a2¼1aj.",
   "1a2¼1ajn.",
   "1a2¼3an.",
   "1a2¼o.",
   "1a2¼1oj.",
   "1a2¼1ojn.",
   "1a2¼1on.",
   "1a2¼e.",
   ".al1est",
   "a2liø",
   ".al2t",
   "al3tabl",
   "al3t2a3r",
   "al3ter",
   "al3trui",
   "3a2mas",
   "fr4a3mason",
   "mals4am1",
   "rekl4am",
   "1an1ta.",
   "1an1t1aj.",
   "1an1t1ajn.",
   "1an1t3an.",
   "1an1to.",
   "1an1t1oj.",
   "1an1t1ojn.",
   "1an1t1on.",
   "1an1te.",
   "adjut2an3t",
   ".arog2an3t",
   "dilet2an3t",
   "elef2an3t",
   ".gal2an3t",
   ".gig2an3t",
   "inf2a4n3t",
   "inst2an3t",
   "konson2an3t",
   "k2an3t",
   "konst2an3t",
   "kvadr2an3t",
   "k2v2an3t",
   "sekva3",
   "leýten2an3t",
   "mom2ant",
   ".okt2an3t",
   ".ped2an3t",
   "tal2an3t",
   "batal3an4t",
   "1an2t1ig",
   "1an2t1ec",
   ".apu2d1",
   "1a2ra.",
   "1a2r1aj.",
   "1a2r1ajn.",
   "1a2r3an.",
   "1a2ro.",
   "1a2r1oj.",
   "1a2r1ojn.",
   "1a2r1on.",
   "1a2re.",
   "am2a3r",
   "barb2a3r3",
   "baz2a3r3",
   "biz2a3r",
   "bulg2a3r",
   ".cez2a3r",
   ".ci3d2a3r",
   "cig2a3r",
   "din2a3r",
   "dol2a3r",
   "er2a3r3",
   "f2a3r",
   "j2ar",
   "formul2a3r",
   "garg2a3r",
   "git2a3r3",
   "hung2a3r",
   "invent2a3r",
   "izob2a3r",
   "jug2u3l2a3r",
   "kalend2a3r3",
   "kap2i3l2a3r3",
   "kl2a3r",
   "k2n2ar3",
   "komis2a3r",
   "komp2a3r",
   "ko2þ1m2ar",
   "kulin2a3r",
   "k2v2a4r1",
   "kvatern2a3r",
   "lap2i3d2a3r",
   ".mol2a3r",
   "najb4a1r",
   ".om2a3r",
   "partik2u3l2a3r",
   ".pol2a3r",
   "pop2u3l2a3r",
   "prep2a3r",
   "prim2a3r",
   "rad2a3r",
   "remp2a3r",
   "rip2a3r",
   "v2a3r",
   "kla2v3a4r",
   "sanit2a3r",
   "sek2u3l2a3r",
   "sekund2a3r",
   "sing2u3l2ar",
   "skal2a3r",
   "s2t2a3r",
   "þ2p2ar",
   "sol2i3d2a3r",
   "tal2a3r",
   "tat2a3r",
   ".vel2a3r",
   "vulg2a3r",
   "1a2r2b",
   "b2ar3b",
   "ar3bitr",
   "f2ar3b",
   "k2ar3b",
   ".fi4garb",
   "po2marb",
   "1a2ta.",
   "1a2t1aj.",
   "1a2t1ajn.",
   "1a2t3an.",
   "1a2to.",
   "1a2t1oj.",
   "1a2t1ojn.",
   "1a2t1on.",
   "1a2te.",
   "1a2t1ec",
   "adiab2a3t",
   "a2g1reg2a3t",
   "aýtorit2a3t",
   ".ab2a3t",
   "a2dek2v2a3t",
   "advok2a3t",
   "afrik2a3t",
   ".ag2a3t",
   "a2k1rob2a3t",
   "a2kur2a3t",
   "alop2a3t",
   "3a2par2a3t",
   "a2rom2a3t",
   "b2at",
   ".bl2a3t",
   ".brok2a3t",
   "delik2a3t",
   "diplom2a3t",
   "dr2a3t",
   ".duk2a3t",
   ".et2a3t",
   "fakult2a3t",
   "form2a3t",
   "fr2a3t",
   ".gla3t",
   ".gran2a3t",
   "pl4at",
   ".hep2a3t",
   "kandid2a3t",
   ".kar2a3t",
   ".kazem2a3t",
   ".klim2a3t",
   ".kom2a3t",
   ".komit2a3t",
   "komp2a2t",
   "konkord2a3t",
   ".krav2a3t",
   "kro3m2a3t",
   ".magn2a3t",
   "majorit2a3t",
   "malgl2a3t",
   ".mand2a3t",
   ".mecen2a3t",
   "minorit2a3t",
   "mon2a3t",
   ".mul2a3t",
   ".musk2a3t",
   "okr2a3t",
   "ordin2a3t",
   ".pal2a3t",
   "pi3r2a3t",
   ".prel2a3t",
   ".prim2a3t",
   "priorit2a3t",
   ".priv2a3t",
   ".rab2a3t",
   ".ren2a3",
   "rezult2a3t",
   "ril2a3t",
   ".sab2a3t",
   ".sal2a3t",
   ".sen2a3t",
   "sindik2a3t",
   "skarl2a3t",
   "sold2a3t",
   ".son2a3t",
   "st2a3t",
   "stigm2a3t",
   "3s2tr2a2t",
   "surog2a3t",
   "þ2t2a3t",
   "þp2at",
   ".tok2a3t",
   "tom2a3t",
   "ultim2a3t",
   "universit2a3t",
   "vulg2a3t",
   ".be2l",
   "be2l1a2nim",
   "bel3e4g",
   ".be2l1a2r2t",
   "be2l1a2sp",
   ".bi4t1",
   "bi4t1o2k",
   ".bo2n1",
   "ma2lb2o2n1",
   ".bo3n2ev",
   ".bon2e",
   ".bon3ec",
   ".bon3eg",
   ".bon3e2du",
   ".æa2s",
   ".æe2f1",
   ".æi4a3",
   ".æia4m1",
   ".æi4e",
   ".æie4s1",
   ".æi4o",
   ".æio4m",
   "æio5manø",
   ".æi4u3",
   "æi2e2l1",
   "æj2",
   ".de2v",
   "de3ve2n",
   "de3vo2j",
   ".di2s3",
   ".di3s4ert",
   ".di3s4erv",
   ".di3s4ip",
   ".di3s4oci",
   "diver2s3",
   "diver3s4aspec",
   ".du2m1i2r",
   ".du2on1",
   "1e2bla.",
   "1e2bl1aj.",
   "1e2bl1ajn.",
   "1e2bl3an.",
   "1e2blo.",
   "1e2bl1oj.",
   "1e2bl1ojn.",
   "1e2bl1on.",
   "1e2ble.",
   "1e2bl1as.",
   "1e2bli.",
   "1e2bl1is.",
   "1e2bl3os.",
   "1e2blu.",
   "1e2bl1us.",
   "1e2bl1ec",
   "1e2bl1a¼",
   "1e2bl3ig",
   ".fe3b1l",
   ".me3b1l",
   "1e2ca.",
   "1e2c1aj.",
   "1e2c1ajn.",
   "1e2c3an.",
   "1e2co.",
   "1e2c1oj.",
   "1e2c1ojn.",
   "1e2c1on.",
   "1e2ce.",
   "e2cig",
   ".apr2e3c",
   ".de3c",
   "p2e3c",
   "1e2ga.",
   "1e2g1aj.",
   "1e2g1ajn.",
   "1e2g3an.",
   "1e2go.",
   "1e2g1oj.",
   "1e2g1ojn.",
   "1e2g1on.",
   "1e2ge.",
   "1e2g1as.",
   "1e2gi.",
   "1e2g1is.",
   "1e2g3os.",
   "1e2gu.",
   "1e2g1us.",
   "l2e3g",
   "ekr2eg",
   "gr2eg",
   "re3gal",
   ".om2e3g",
   ".stra3t2e3g",
   ".norv2e3g",
   "1e2ja.",
   "1e2j1aj.",
   "1e2j1ajn.",
   "1e2j3an.",
   "1e2jo.",
   "1e2j1oj.",
   "1e2j1ojn.",
   "1e2j1on.",
   "1e2je.",
   "1e2j1ig",
   "1e2j1iø",
   ".be3j",
   ".pl2e2j1",
   "malpl2e2j1",
   "pleja2",
   ".ek1",
   ".eka2m",
   ".ekf4",
   ".ek2ip",
   ".ek1l2um",
   ".ek1l4a2m",
   ".ekma2l1",
   ".ek2onom",
   ".ek2ume2n",
   ".ek2s1",
   "ek3s2alt",
   ".ek3s2ci",
   "1ek4s3c4i2t",
   "ek4s3ciz",
   ".ek3s2ekv",
   ".ek3s2ent",
   ".ek3s2id",
   "ek3s2ku",
   "ek4s3kur",
   "ek4s3kuz",
   ".ek3s2on",
   ".ek3s2tar",
   ".ekste2r1",
   ".el1i2r",
   ".sene2l1i2r",
   ".el1aæet",
   ".el1uz",
   ".el3v2",
   "1e2ma.",
   "1e2m1aj.",
   "1e2m1ajn.",
   "1e2m3an.",
   "1e2me.",
   "1e2mo.",
   "1e2mon.",
   "1e2m1ec",
   "1e2m1as.",
   "1e2m3os.",
   ".boh2e3m",
   "diad2e3m",
   ".dil2e3m",
   ".ed2e3m",
   "emfiz2e3m",
   ".ekz2e3m",
   "fon2e3m",
   "graf2e3m",
   "ø2e3m",
   "1i2ø3e4m",
   ".har2e3m",
   "jerusal2e3m",
   ".le3m",
   "morf2e3m",
   ".po2e3m",
   "pr2e3m",
   "prob1l2e4m3",
   "s2e3m",
   "t2e3m",
   ".tand2e3m",
   "te4or2em",
   "tr2e3m",
   ".en1i2r",
   ".en1e2st",
   ".en1a2m",
   ".en1u2z",
   "1e2ta.",
   "1e2t1aj.",
   "1e2t1ajn.",
   "1e2t3an.",
   "1e2to.",
   "1e2t1oj.",
   "1e2t1ojn.",
   "1e2t1on.",
   "1e2te.",
   "1e2t1as.",
   "1e2ti.",
   "1e2t1is.",
   "1e2t3os.",
   "1e2tu.",
   "1e2t1us.",
   "r2eta.",
   "r2et1aj.",
   "r2et1ajn.",
   "r2et3an.",
   "r2eto.",
   "r2et1oj.",
   "r2et1ojn.",
   "r2et1on.",
   "r2ete.",
   "a2æ2e3t",
   "alfab2e3t",
   "alum2e3t",
   "amul2e3t",
   ".ask2e3t",
   ".at1l2e3t",
   ".be3t",
   "bajon2e3t",
   "bil2e3t",
   ".bol2e3t",
   "bracel2e3t",
   "brev2e3t",
   ".buø2e3t",
   ".deb2e3t",
   ".dem2e3t",
   "diab2e3t",
   "disk1r2et",
   "elizab2e3t",
   ".enk2e3t",
   "epit2e3t",
   "fal3s4e3t",
   ".form2e3t",
   ".gaz2e3t",
   ".haml2et",
   ".herm2e3t",
   ".¼ak2e3t",
   "¼2e3t",
   "kabin2e3t",
   ".kad2e3t",
   "kastanj2e3t",
   ".kin2e3t",
   "klarn2e3t",
   "kloz2e3t",
   ".kom2e3t",
   "kompl2e3t",
   ".konf2e3t",
   "konkr2e3t",
   "kors2e3t",
   "korv2e3t",
   "ko2t1l2e3t",
   ".krik2e3t",
   ".krok2e3t",
   "kvodlib2e3t",
   "m2et",
   "var2m3",
   "dor2m3",
   "fer2m3",
   "magn2e3t",
   "marion2e3t",
   ".mot2e3t",
   ".ne3t",
   ".oml2e3t",
   "p2et",
   "pamfl2e3t",
   "parg2e3t",
   ".pl2e3t",
   ".po2e3t",
   "portr2e3t",
   "pr2et",
   "prof2e3t",
   ".prol2e3t",
   ".rak2e3t",
   ".rem2e3t",
   "sekr2e3t",
   "skel2e3t",
   ".son2e3t",
   ".sov2e3t",
   "spag2e3t",
   "spin2e3t",
   "staf2e3t",
   ".stil2e3t",
   "þibol2e3t",
   ".tib2e3t",
   "tr2et",
   "tual2e2t",
   "veg2e3t",
   ".vend2e3t",
   "vinj2et",
   "1e2s1tr",
   "fen2e3st3r",
   "or1k2e3str",
   ".pal2e3str",
   ".fal2s3",
   "fal3s4tel",
   ".fal3s4id",
   ".fik2s1",
   "fik2s1i2de",
   ".fo2r1",
   ".fo3r2in3t",
   ".fo3r2u3m",
   ".fu2þ3",
   ".øi4a3",
   ".øi2s1",
   "1i2da.",
   "1i2d1aj.",
   "1i2d1ajn.",
   "1i2d3an.",
   "1i2do.",
   "1i2d1oj.",
   "1i2d1ojn.",
   "1i2d1on.",
   ".abs2i3d",
   "3a2c2i2d",
   "st4a3c2i3",
   ".ak1r2i3d",
   ".aps2i3d",
   ".ar2i3d",
   ".askar2i3d",
   ".asp2i3d",
   "1av2i3d",
   ".bol2i3d",
   ".br2i3d",
   "c2i3d",
   "eýkl2i3d",
   ".eg2i3d",
   ".flor2i3d",
   ".fr2i3d",
   "v2i2d",
   "e2vi3dent",
   "bo2v3id",
   "divi3d",
   "hibr2i3d",
   "hum2i3d",
   "¶lam2i3d",
   ".ins2i3d",
   "kan3t2ar2i3d",
   ".konf2i3d",
   "krizal2i3d",
   ".lib2i3d",
   "likv2i3d",
   ".liv2i3d",
   ".madr2i3d",
   "morb2i3d",
   ".num2i3d",
   "oks2i3d",
   "perf2i3d",
   "pi3ram2id",
   "r2id",
   "rap2i3d",
   "rez2i3d",
   "rig2i3d",
   "sol2i3d",
   ".str2i3d",
   "tim2i3d",
   "val2i3d",
   "1i2d1i2na.",
   "1i2d1i2n1aj.",
   "1i2d1i2n1ajn.",
   "1i2d1i2n3an.",
   "1i2d1i2no.",
   "1i2d1i2n1oj.",
   "1i2d1i2n1ojn.",
   "1i2d1i2n1on.",
   "1i2d1i2ne.",
   "1i2ga.",
   "1i2g1aj.",
   "1i2g1ajn.",
   "1i2g3an.",
   "1i2go.",
   "1i2g1oj.",
   "1i2g1ojn.",
   "1i2g1on.",
   "1i2ge.",
   "1i2g1as.",
   "1i2gi.",
   "1i2g1is.",
   "1i2g3os.",
   "1i2gu.",
   "1i2g1us.",
   ".br2i3g",
   ".di3g",
   ".fi3g",
   ".in3d4i2g",
   ".inst2i3g",
   ".intr2i3g",
   ".kvadr2i3g",
   "l2ig",
   "a2l3ig",
   "pfen2i3g",
   ".pi3g",
   ".prod2i3g",
   "r3l2i3g",
   ".rodr2i3g",
   ".str2i3g",
   ".ti3g",
   ".nav2i3g",
   "1i2gebl",
   "1i2gant",
   "1i2gint",
   "1i2gont",
   "1i2gat",
   ".al4i3g2a3tor",
   "1i2git",
   "1i2g1a2d",
   "br2i3g2a3d",
   "1i2g1e2m",
   "1i2g1i2l",
   "1i2øa.",
   "1i2ø1aj.",
   "1i2ø1ajn.",
   "1i2ø3an.",
   "1i2øo.",
   "1i2ø1oj.",
   "1i2ø1ojn.",
   "1i2ø1on.",
   "1i2øe.",
   "1i2ø1as.",
   "1i2øi.",
   "1i2ø1is.",
   "1i2ø3os.",
   "1i2øu.",
   "1i2ø1us.",
   "1i2øant",
   "1i2øint",
   "1i2øont",
   ".br2i3ø",
   ".negl2i3ø",
   "pre2st2i3ø",
   ".vert2i3ø",
   ".ve2st2i3ø",
   "1i2ø1a2d",
   "1i2ø1e2m",
   "1i2la.",
   "1i2l1aj.",
   "1i2l1ajn.",
   "1i2l3an.",
   "1i2lo.",
   "1i2l1oj.",
   "1i2l1ojn.",
   "1i2l1on.",
   "1i2le.",
   "a2bu3t2i3l",
   "a2cet2i3l",
   ".ang2i3l",
   ".apr2i3l",
   ".arg2i3l",
   ".az2i3l",
   ".bab2i3l",
   ".bac2i3l",
   ".baz2i3l",
   ".ber2i3l",
   ".bi3l",
   "br2i3l",
   ".braz2i3l",
   ".ced2i3l",
   ".ci3r2i3l",
   ".civ2i3l",
   "æinæ2i3l",
   ".dakt2i3l",
   ".deb2i3l",
   ".def2i3l",
   ".dist2i3l",
   ".domic2i3l",
   ".dr2i3l",
   ".ed2i3l",
   ".ekz2i3l",
   ".et2i3l",
   ".fi3l",
   "fac2i3l3",
   ".fus2i3l",
   ".gor2i3l",
   ".gr2i3l",
   ".øent2i3l",
   ".jub2i3l",
   ".ki3l",
   ".kamar2i3l",
   ".ki3r2i3l",
   ".komp2i3l",
   "kons2i3l",
   "krokod2i3l",
   "m2i3l",
   ".mant2i3l",
   ".met2i3l",
   "mob2i3l",
   "naýt2i3l",
   "of2i3l",
   "1o2s3c2i3l",
   "paskv2i3l",
   "ps2i3l",
   "pterodakt2i3l",
   ".pup2i3l",
   "sen2il",
   "scint2i3l",
   ".st2i3l",
   "stab2i3l",
   "stenc2i3l",
   "strob2i3l",
   "subt2i3l",
   "svah2i3l",
   "trankv2i3l3",
   "u2t2i3l",
   "komput3i4l",
   ".van2i3l",
   ".vi3g2i3l",
   "vodev2i3l",
   "volat2i3l",
   "1i2l1ar",
   "b2i3l2a3rd",
   "2i4larb",
   "pl2i3l2a3rø",
   "f2i3l2a3ri",
   "frit2i3l2a3ri",
   "1e2str1i2na.",
   "1e2str1i2n1aj.",
   "1e2str1i2n1ajn.",
   "1e2str1i2n3an.",
   "1e2str1i2no.",
   "1e2str1i2n1oj.",
   "1e2str1i2n1ojn.",
   "1e2str1i2n1on.",
   "1e2str1i2ne.",
   "1i2s2t1i2na.",
   "1i2s2t1i2n1aj.",
   "1i2s2t1i2n1ajn.",
   "1i2s2t1i2n3an.",
   "1i2s2t1i2no.",
   "1i2s2t1i2n1oj.",
   "1i2s2t1i2n1ojn.",
   "1i2s2t1i2n1on.",
   "1i2s2t1i2ne.",
   "1u2l1i2na.",
   "1u2l1i2n1aj.",
   "1u2l1i2n1ajn.",
   "1u2l1i2n3an.",
   "1u2l1i2no.",
   "1u2l1i2n1oj.",
   "1u2l1i2n1ojn.",
   "1u2l1i2n1on.",
   "1u2l1i2ne.",
   "ins2ul2i3n",
   "1in2da.",
   "1in2d1aj.",
   "1in2d1ajn.",
   "1in2d3an.",
   "1in2de.",
   "1in2d1as.",
   "1in2d1is.",
   "1in2d3os.",
   "1in2d1us.",
   "1in2do.",
   "1in2don.",
   "1in2d3ec",
   "1in2d3ig",
   "1in2d3iø",
   ".hin3d",
   ".lin3d",
   "rozal4in3d",
   ".bl4in3d",
   ".pin3d",
   "tamar4in3d",
   "v2in3d",
   "in3d4iøen",
   "in2giø",
   "in2gig",
   "ciga4r1in2g",
   "kande2l1in2g",
   "pie2d1i2ng",
   "plu2m1in2g",
   "1in1ta.",
   "1in1t1aj.",
   "1in1t1ajn.",
   "1in1t3an.",
   "1in1to.",
   "1in1t1oj.",
   "1in1t1ojn.",
   "1in1t1on.",
   "1in1te.",
   "1in2t3ar",
   "1in2t3ec",
   "1in2t3us",
   ".abs2in3t",
   "hiac2in3t",
   ".jac2in3t",
   "kvi2n1",
   "labi3r2in3t",
   ".pin2t",
   "tereb2in3t",
   "1inte2r1",
   "inte3r2es",
   "inte3r2ez",
   "inte3r2upt",
   "2linter",
   ".io2m1",
   "i2r",
   "di3rekt",
   "hi3rund",
   "i3rurg",
   ".ti3ran",
   "si3rin",
   "1is2ma.",
   "1is2m1aj.",
   "1is2m1ajn.",
   "1is2m3an.",
   "1is2mo.",
   "1is2m1oj.",
   "1is2m1ojn.",
   "1is2m1on.",
   "1is2me.",
   "1i2s2m3ec",
   ".ab2is3m",
   ".pr2is3m",
   ".ris3m",
   ".sk2i3s3m",
   ".sis3m",
   ".sof2is3",
   "me¶2a3n2is3m",
   "mek2a3n2is3m",
   "1i2s2ta.",
   "1i2s2t1aj.",
   "1i2s2t1ajn.",
   "1i2s2t3an.",
   "1i2s2to.",
   "1i2s2t1oj.",
   "1i2s2t1ojn.",
   "1i2s2t1on.",
   "1i2s2te.",
   "1i2s2t3ec",
   "1i2s2t3a4r",
   ".amet2i3s3t",
   "antikr2i3s3t",
   "aor2i3s3t",
   ".ar2i3s3t",
   ".bal2i3s3t",
   ".bat2i3s3t",
   ".ci3s3t",
   "ekz2i3s3t",
   ".gen2i3s3t",
   ".gi3s3t",
   ".hi3s3t",
   "ins2i3s3t",
   "kons2i3s3t",
   ".ki3s3t",
   ".kr2i3s3t",
   ".li3s3t",
   ".pi3s3t",
   "pers2i3s3t",
   ".rez2i3s3t",
   ".sk2i3s3t",
   "1i2ta.",
   "1i2t1aj.",
   "1i2t1ajn.",
   "1i2t3an.",
   "1i2to.",
   "1i2t1oj.",
   "1i2t1ojn.",
   "1i2t1on.",
   "1i2te.",
   "1i2t3ec",
   "p2i3t4eci",
   ".ag2i3t",
   "ak1red2i3t",
   "antrac2i3t",
   ".apet2i3t",
   "b2i3t",
   ".band2i3t",
   "biskv2i3t",
   ".br2i3t",
   ".ci3t",
   ".cirkv2i3t",
   ".civ2i3t",
   "defic2i3t",
   ".di3g2i3t",
   "dinam2i3t",
   ".ef1r2i3t",
   "eksplic2i3t",
   ".el2i3t",
   ".erm2i3t",
   ".erud2i3t",
   ".ev2i3t",
   ".fr2i3t",
   ".gl2i3t",
   ".graf2i3t",
   ".gran2i3t",
   ".grav2i3t",
   "hermafrod2i3t",
   "hez2i3t",
   "kr2i3t",
   "im2i3t",
   ".inc2i3t",
   "infin2i3t",
   "inkogn2i3t",
   "interm2i3t",
   ".inv2i3t",
   "kapac2i3t",
   "komprom2i3t",
   ".konf2i3t",
   ".kred2i3t",
   ".kvi3r2i3t",
   ".kv2i3t",
   ".kval2i3t",
   ".kviv2i3t",
   ".li3t",
   ".mi3t",
   "malak2i3t",
   ".margar2i3t",
   ".marm2i3t",
   ".med2i3t",
   "megal2i3t",
   "mer2i3t",
   "mil2i4t1",
   "asimil3i4t",
   ".mosk2i3t",
   ".neof2i3t",
   "okcip2i3t",
   "ol2i3t",
   "palp2i3t",
   ".paraz2i3t",
   ".pi3r2i3t",
   "plebisc2i3t",
   "precip2i3t",
   "pre2s",
   "pre3skrib",
   "prestid2i3g2i3t",
   "preter2i3t",
   "prof2i3t",
   "prozel2i3t",
   "rehabil2i3t",
   "sanskr2i3t",
   "satel2i3t",
   "sibar2i3t",
   ".sk2i3t",
   ".sp2i3t",
   "spi3r2i3t",
   ".spl2i3t",
   "spr2i3t",
   "stalagm2i3t",
   "stalakt2i3t",
   ".stil2i3t",
   ".su3b2i3t",
   "þv2i3t",
   ".term2i3t",
   ".trans2i3t",
   "troglod2i3t",
   ".vi3t",
   "viz2i3t",
   "zen2i3t",
   ".ka2þ1",
   ".kel2k",
   ".ki4a3",
   ".ki4o",
   ".ki4u3",
   ".kro2m1",
   "krom2o",
   "kro3m2io",
   "kro3m2ia",
   ".ku2n1",
   "ku3n2ikl",
   ".li4a3",
   "li5an",
   "li5as",
   ".ma2l1",
   ".nema2l1",
   ".malsupre2n1",
   "malk4",
   ".ma3l2ic",
   "mala2m",
   "malno2v1",
   ".me2m1",
   "me3m2or",
   ".mem3a2",
   ".me3m2uar",
   ".me2z1",
   "mez2alianc",
   "me3z2embri",
   "me3z2enter",
   ".me3z2ere",
   ".mez2o",
   "me3z2u2r",
   ".mi4a3",
   "mi5asm",
   "mi5aý",
   ".mi4s3",
   ".mi5s4al",
   "mi5s4il",
   ".mi5s4ia",
   ".mi5s4ie",
   ".mi5s4ii",
   ".mi5s4io",
   ".mi5s4iu",
   ".nei2",
   "4ne.",
   "i4u3o",
   ".ni4a3",
   "3n2ja.",
   "3n2j1aj.",
   "3n2j1ajn.",
   "3n2j3an.",
   "3n2jo.",
   "3n2j1oj.",
   "3n2j1ojn.",
   "3n2j1on.",
   "3n2je.",
   ".no4v",
   "4oæambr",
   "1o2bla.",
   "1o2bl1aj.",
   "1o2bl1ajn.",
   "1o2bl3an.",
   "1o2blo.",
   "1o2bl1oj.",
   "1o2bl1ojn.",
   "1o2bl1on.",
   "1o2ble.",
   "1o2bl1ec",
   "n2o3bl",
   ".se2s3o2n",
   ".se2p3o2n",
   ".ok3o2n",
   "de2k3o2na",
   "de2k3o2ne.",
   "de2k3o2no",
   "cen2t3o2n",
   "mil3o2n",
   "1on2ta.",
   "1on2t1aj.",
   "1on2t1ajn.",
   "1on2t3an.",
   "1on2to.",
   "1on2t1oj.",
   "1on2t1ojn.",
   "1on2t1on.",
   "1on2te.",
   "disk2on3t",
   ".fon3t",
   ".fr2on3t",
   ".hon3t",
   "horiz2on3t",
   ".kon3t",
   "konfr2on3t",
   ".mon3t",
   "mastod2on3t",
   ".melol2on3t",
   ".pon3t",
   "rak2on3t",
   ".rem2on3t",
   ".renk2on3t",
   "vol2on3t",
   ".trio2p",
   "kvar3o2p",
   "kvin3o2p",
   ".se2s3o2p",
   ".se2p3o2p",
   ".ok3o2p",
   "de2k3o2p",
   "cen2t3o2p",
   "mil3o2p",
   ".or2t",
   ".ort2o3rel",
   ".pa2þ",
   ".pe2r1a2",
   ".ple2n3",
   "2oplen",
   ".plu2r1",
   ".po2r",
   ".po2s2t1",
   "pos3t2ament",
   "pos3t2e2n",
   "post2esign",
   "pos3t2iljon",
   "pos3t2u3l",
   ".po2þ",
   ".po2þ2t1",
   "poþ3t2ele",
   "poþ3t2uk",
   "poþ3t2ranæ",
   ".prete2r1",
   ".re2f3l2ig",
   ".re2spond",
   ".re2spublik",
   ".re2tro",
   ".sa2m",
   "sa3m2ar",
   ".sam1i2de",
   ".sa3m2u3m",
   "sa3m2uraj",
   "sa2m1ur2b",
   ".se2n1",
   ".sen3s4t",
   "sen2e2skal",
   ".si4a3",
   ".si2n",
   "sin1a2kuz",
   "sin1o2fer",
   "si3n2us",
   ".su2b1",
   ".su3b2ute",
   ".supe2r1",
   ".þi4a3",
   ".ti4a3",
   ".tia4m1",
   ".ti4e",
   ".tie4s",
   ".ti4o",
   ".tio4m1",
   ".ti4u3",
   "5m2anier",
   "iud2",
   "ias2",
   ".tran2s3",
   "tran3s4ept",
   "tran3s4i2stor",
   "tran3s4it",
   "tran4s5i4tal",
   "tran3s4pir",
   ".tris2",
   ".tu2t1",
   "1u2ja.",
   "1u2j1aj.",
   "1u2j1ajn.",
   "1u2j3an.",
   "1u2jo.",
   "1u2j1oj.",
   "1u2j1ojn.",
   "1u2j1on.",
   "1u2je.",
   "1u2j1ig",
   "1u2j1iø",
   ".and2u3j",
   ".halel2u3j",
   "1u2la.",
   "1u2l1aj.",
   "1u2l1ajn.",
   "1u2l3an.",
   "1u2lo.",
   "1u2l1oj.",
   "1u2l1ojn.",
   "1u2l1on.",
   "1u2le.",
   "1e2m1u2l",
   "e3m2u3ls",
   "1u2l3ec",
   ".un2u3l4e",
   "1u2l3ej",
   ".akum2u3l",
   "ang2u3l",
   ".bu3l",
   ".bet2u3l",
   "br2ul3",
   "ejak2u3l",
   ".fist2u3l",
   "form2u3l",
   ".fu3l",
   "galin2u3l",
   ".gran2u3l",
   ".grat2u3l",
   ".herk2u3l",
   "hierod2u3l",
   "homunk2u3l",
   "ins2u3l",
   ".instanb2u3l",
   ".ju3l",
   ".¼u3l",
   ".ku3l",
   ".kab2u3l",
   "kalend2u3l",
   "kalk2u2l1",
   "kapit2u3l",
   "kaps2u3l",
   "koag2u3l",
   ".kons2u3l",
   ".kop2u3l",
   "korpusk2u3l",
   ".kum2u3l",
   ".lu3l",
   ".liverp2u3l",
   ".mu3l",
   "mak2u3l",
   "manip2u3l",
   "matrik2u3l",
   ".mod2u3l",
   "molek2u3l",
   ".nu3l",
   ".neb2u3l",
   "ok2u3l",
   ".pu3l",
   ".paæ2u3l",
   "partik2u3l",
   ".pust2u3l",
   ".ru3l",
   "reg2u2l1",
   "retik2u3l",
   ".ruk2u3l",
   ".sim2u3l",
   "skrup2u3l",
   "somnamb2u3l",
   "speg2u3l",
   ".spek2u3l",
   ".stim2u3l",
   ".tab2u3l",
   "tarant2u3l",
   ".tru3l",
   "tuberk2u3l",
   "turb2u3l",
   ".ul2u3l",
   ".uv2u3l",
   ".vi4st2ul",
   "1u2l1ar",
   "2u3l2ari",
   "2u3l2ard",
   ".pedik2u3l2ar",
   "1u2ma.",
   "1u2m1aj.",
   "1u2m1ajn.",
   "1u2m3an.",
   "1u2mo.",
   "1u2m1oj.",
   "1u2m1ojn.",
   "1u2m1on.",
   "1u2me.",
   "1u2m1as.",
   "1u2mi.",
   "1u2m1is.",
   "1u2m3os.",
   "1u2mu.",
   "1u2m1us.",
   "1u2m3ec",
   ".alb2u3m",
   ".bu3m",
   ".opid2u3m",
   "referend2u3m",
   ".fu3m",
   "parf2u3m",
   ".gu3m",
   ".hu3m",
   ".kuk2u3m",
   ".luk2u3m",
   ".lu3m",
   "vol2u3m",
   "pl2u3m",
   ".stern2u3m",
   ".pu3m",
   ".ser2u3m",
   ".gru3m",
   ".kvor2u3m",
   ".tru3m",
   ".su3m",
   ".res2u3m",
   "kons2u3m",
   "opos2u3m",
   "bi5t2u3m",
   ".kost2u3m",
   ".vi4a3",
   "vi5a4nd",
   "vi5atik",
   ".vi2c1",
   ".vi3c2ia",
   ".vi3c2io",
   ".vi2r1",
   "vir2g",
   "vir3genr",
   "vir2us",
   "vi3r2ulent",
   "1a2fabl",
   "1a2gra",
   "1a2kr",
   ".an2a3k",
   "kv2a3kr",
   "1a2per",
   "p2a3per",
   "1a2va1r",
   "4ologi",
   "4ografi",
   "2fik",
   "3fiks",
   "4b1c",
   "4b1b2",
   "4b1d",
   "4b1f",
   "4b1g",
   "4b1h4",
   "4b1j2",
   "4b1k",
   "b1l",
   "b2lov",
   "b2lek",
   "b2lok",
   "b2lu",
   "4b1m",
   "4b1n",
   "4b1p",
   "a2b1r",
   "4b1s",
   "4b1s2k",
   "b1s2t",
   "4b1t",
   "4b1v",
   "4b1z",
   "4b1æ",
   "4b1ø",
   "4b1¼",
   "2b1þ2",
   "4c1b",
   "4c1c2",
   "4c1æ",
   "4c1d",
   "4c1f",
   "4c1g",
   "4c1ø",
   "4c1h4",
   "t5c2h",
   "4c1j2",
   "4c1¼",
   "4c1k",
   "4c1l",
   "4c1m",
   "4c1n",
   "4c1p2",
   "4c1r",
   "2c1s2",
   "4c1þ",
   "4c1t",
   "4c1v",
   "4c1z",
   "4æ1b",
   "4æ1c",
   "4æ1d",
   "4æ1f",
   "2æ1g2",
   "4æ1h4",
   "4æ1k",
   "4æ1l2",
   "4æ1m",
   "4æ1n",
   "4æ1p",
   "4æ1s",
   "4æ1t",
   "4æ1v",
   "4æ1z",
   "4æ1æ",
   "2æ1ø2",
   "4æ1¼",
   "2æ1þ2",
   "4d1b",
   "4d1c",
   "4d1d2",
   "4d1f",
   "4d1g",
   "4d1h4",
   "4d1j2",
   "4d1k",
   "4d1l4",
   "4d1m",
   "4d1n2",
   "4d1p",
   "1a2d1re2s1",
   "4d3s2",
   "4d1t",
   "4d1v",
   "d1z",
   "4d1æ",
   "4d1ø",
   "4d1¼",
   "4d1þ2",
   "1e2ben",
   "1e2d2z",
   "1e2gal",
   "1e2le1g2an3t",
   "4f1b",
   "4f1c",
   "4f1æ",
   "4f1d",
   "4f1f2",
   "4f1g",
   "4f1ø",
   "4f1h4",
   "2f1j2",
   "2f1¼",
   "2f3k",
   "4f1m",
   "4f1n",
   "4f1p",
   "4f1s4",
   "4f1þ4",
   "2f1t",
   "4f1v",
   "4f1z",
   "4g1b",
   "4g1c",
   "4g1æ",
   "2g1d2",
   "4g1f",
   "4g1g2",
   "4g1ø",
   "4g1h4",
   "4g1j2",
   "4g1¼",
   "4g1k",
   "2g1m",
   "4g1n",
   "4g1p",
   "4g1s",
   "4g1þ",
   "4g1t",
   "g1v",
   "4g1z",
   "2ø1b2",
   "4ø1c",
   "4ø1d",
   "4ø1f",
   "4ø1g",
   "4ø1h4",
   "4ø1j2",
   "4ø1k",
   "4ø1l",
   "4ø1m",
   "4ø1n",
   "4ø1p",
   "4ø1r",
   "4ø1s",
   "4ø1t",
   "4ø1v",
   "4ø1z",
   "4ø1æ",
   "4ø1ø",
   "4ø1¼",
   "4ø1þ",
   "4h1æ",
   "4h1ø",
   "4h1¼",
   "4h1þ",
   "4¶1b",
   "4¶1c",
   "4¶1d",
   "4¶1f",
   "4¶1g",
   "4¶1h4",
   "4¶1j2",
   "4¶1k",
   "4¶1m",
   "4¶1n",
   "4¶1p",
   "2¶1s2",
   "4¶1t",
   "4¶1v",
   "4¶1z",
   "4¶1æ",
   "4¶1ø",
   "4¶1¼",
   "4¶1þ",
   "4j1b",
   "4j1c",
   "4j1d",
   "4j1f",
   "4j1g",
   "4j1h4",
   "4j1k",
   "4j1l",
   "4j1m",
   "4j1n",
   "4j1p",
   "4j1r",
   "2j1s2",
   "4j2s3t",
   "4j1t",
   "4j1v",
   "4j1z",
   "4j1æ",
   "4j1ø",
   "4j1¼",
   "4j1þ",
   "2jis.",
   "4¼1b",
   "4¼1c",
   "4¼1d",
   "4¼1f",
   "4¼1g",
   "4¼1h4",
   "4¼1j2",
   "4¼1k",
   "4¼1l",
   "4¼1m",
   "4¼1n",
   "4¼1p",
   "4¼1s",
   "4¼1t",
   "4¼1v",
   "4¼1z",
   "4¼1æ",
   "4¼1ø",
   "4¼1¼",
   "4¼1þ",
   "4k1b2",
   "4k1c",
   "4k1d",
   "4k1f",
   "4k1g",
   "4k1h4",
   "4k1j2",
   "4k3k2",
   "r2k1l",
   "4k1m",
   "2k1n",
   "3k2nab",
   "3k2ned",
   "4k1p",
   "4k1s",
   "k2s1t2r",
   "4k1t",
   "k1v",
   "4k1z",
   "4k1æ",
   "4k1ø",
   "4k1¼",
   "4k1þ2",
   "4l1b",
   "4l1c",
   "4l1d",
   "4l1f",
   "4l1g",
   "4l1h4",
   "2l3¶2",
   "4l1j2",
   "4l1k",
   "4l1l2",
   "4l1m",
   "4l1n",
   "4l3p",
   ".hel4p1",
   "4l1r4",
   "4l1s2",
   "l4s3l",
   "4l1t",
   "4l1v",
   "4l1z",
   "4l1æ",
   "4l1ø",
   "4l1¼",
   "4l5þ2",
   "4m1b",
   "mb2l2",
   "4m1c",
   "4m1d",
   "2m3f2",
   "m4f3k",
   "4m1g",
   "4m1h4",
   "4m1j2",
   "4m3k",
   "4m1l",
   "4m3m2",
   "4m1n",
   "4m1p",
   "4m1r",
   "4m1s2",
   "4m1t",
   "4m1v",
   "4m1z",
   "4m1æ",
   "4m1ø",
   "4m1¼",
   "4m1þ",
   "mul2t1",
   "mult2e",
   "mul2t3eg",
   "mul3ta",
   "mul3te.",
   "mul3to",
   "mul4t3obl",
   "mul3t2ipl",
   "4n1b",
   "4n1c",
   "4n1æ",
   "4n1d",
   "4n1f",
   "4n1g",
   "4n1ø",
   "4n1h4",
   "2n1j",
   "4n1¼",
   "4n1k",
   "n2kv",
   "4n1l2",
   "2n1m",
   "4n1n",
   "4n1p2",
   "4n1r",
   "4n1s2",
   "4n1þ2",
   "4n1t",
   "4n1v2",
   "4n1z",
   "n2s3t2r",
   ".nor2d1",
   "nor2d1a2z",
   "1o2kup",
   "1o2por1tun",
   ".okciden2t1",
   ".orien2t1",
   "orien2t1a2z",
   "4p1b2",
   "4p1c2",
   "4p1d2",
   "2p1f2",
   "4p1g2",
   "4p1h4",
   "2p1j2",
   "2p1k2",
   "2p1m2",
   "p1n2",
   "2p1p2",
   "2p1s2",
   "2p1t",
   "4p1v2",
   "4p1z2",
   "4p1æ2",
   "4p1ø2",
   "4p1¼2",
   "2p1þ2",
   "4r1b",
   "4r1c",
   "4r1d",
   "r2d1r",
   "4r1f",
   "2r1g",
   "zor2g",
   "bur2g",
   "4r1h4",
   "4r1¶4",
   "4r1j2",
   "4r1k",
   "4r1l2",
   "4r1m",
   "4r1n",
   "4r1p",
   "4r1r4",
   "4r1s2",
   "r2s3f",
   "r2s3m",
   "r2s3r",
   "4r1t",
   "2r1v",
   "2r1z",
   "2r1æ",
   "2r1ø",
   "2r1¼",
   "2r1þ2",
   "r2þ3j",
   "4s3b2",
   "s1c",
   "s2ci",
   "4s1æ",
   "4s1d",
   "s1f",
   "2s1g2",
   "4s1ø",
   "4s1h4",
   "4s1j2",
   "4s1¼",
   "s1k",
   "s2krib",
   "2s1l",
   "3s2lab",
   "3s2lalom",
   "3s2lang",
   "3s2lav",
   "5s4led",
   "3s2lip",
   "3s2lovak",
   "3s2loven",
   "3s2lup",
   "is1la2m3",
   "rs3l",
   "n4s3l",
   "2s1m",
   "3s2merald",
   "5s4mirg",
   "4s1n",
   "5s2nuf",
   "s1p",
   "s2p2e3c",
   "2spre",
   "2s1r2",
   "4s3s2",
   "4s3þ2",
   "s1t",
   "3s2tu1d",
   "1s2trek",
   "s1v",
   ".su2d1a2f",
   ".su2d1a2m",
   ".su2d1a2zi",
   ".su2d1eýr",
   ".su2d1aý",
   ".su2d1r",
   "4þ1b",
   "2þ1c2",
   "2þ1d2",
   "4þ1f",
   "2þ1g2",
   "4þ1h4",
   "4þ1k",
   ".þm2",
   "þ1m",
   "þ1n",
   "þ2nur",
   "þ1p",
   "þ2pin",
   "4þ1s",
   "þ1t",
   "1þ2tejn",
   "þ1v",
   "þ2vel",
   "þ2veb",
   "4þ1z",
   "2þ1æ2",
   "4þ1ø",
   "4þ1¼",
   "4þ1þ2",
   ".þte2l1",
   "4t1b",
   "4t1c",
   "4t1d",
   "4t1f",
   "2stf",
   "4t1g",
   "4t1h4",
   "4t1j2",
   "4t1k",
   "2t1l2",
   "4t1m",
   "4t1n",
   "4st1n",
   "4t1p2",
   "4t3s2",
   "4t1t",
   "4t1v",
   "4t1z",
   "4t1æ",
   "4t1ø",
   "4t1¼",
   "4t1þ2",
   "4ý1",
   "ýa2",
   "ýe2",
   "ýi2",
   "ýo2",
   "ýu2",
   "4v3b2",
   "4v1c2",
   "4v1d",
   "4v1f",
   "4v1g",
   "4v1h4",
   "2v1j2",
   "inter3v2ju",
   "4v1k2",
   "4v1l",
   "4v1m",
   "4v1n",
   "4v1p",
   "2v1r2",
   "4v1s2",
   "4v1t",
   "4v1v2",
   "4v1z",
   "4v1æ2",
   "4v1ø2",
   "4v1¼2",
   "4v1þ2",
   "4z1b",
   "4z1c2",
   "4z1d",
   "4z1f4",
   "4z1g",
   "4z1h4",
   "4z1j2",
   "4z1k",
   "4z1l",
   "4z1m",
   "4z1n",
   "4z1p",
   "4z1r",
   "4z1s",
   "4z1t",
   "4z1v",
   "4z1æ",
   "4z1ø",
   "4z1¼",
   "4z1þ",
   ".re2sp.",
   "1a2dmin",
   "3afe23",
   "1a2kv",
   "3a4ranø",
   "a2nali",
   "1a2f3rik",
   "1a2merik",
   "1a2kir1",
   "har2a3kir",
   "ap1l",
   "p2lek",
   "a2spekt",
   ".aý2d",
   ".aý3dac",
   "bil2d1r",
   ".bi2o",
   ".bu2þ",
   ".cen2t",
   "cen3t2r",
   "daý2r",
   "de2k1o2k",
   "de2k1u2n",
   ".dra4t1",
   "3e2kz",
   "1e2lemen2t1",
   "3e2senc",
   "1e2sprim",
   "2k3e2rar",
   "4m3e2rar",
   "2s3e2rar",
   "e2st",
   "1e2taø",
   ".fi2þ1",
   "1a2fiþ",
   "fo2j",
   ".fra2z1",
   "fra3z2eo",
   ".fre2þ",
   "gra2n2d1",
   "gran3d2io",
   ".¼e4t1",
   "komuni2k1",
   "laý2dind",
   "laý2d2a3t",
   "le2ø",
   "o2fic",
   "3o4lea",
   "3o4lei",
   "3o4leo",
   "nap4o5leo",
   "laý2t1le4g",
   "lo2n2g1",
   "lon3g2itud",
   "1o2rel",
   "1o2dor",
   "on2d1r",
   "oli2v",
   "paro2l3",
   ".pa2s",
   "pa3ser",
   "pa3sa3ø",
   ".pu2þ",
   ".re2ø",
   "re3øim",
   "re3øust",
   "ri2æ",
   "sa2ø",
   ".sen2t2em",
   "sent3emo",
   "sinjo2r3",
   ".su2æ3i2nf",
   "sove4t1u2ni",
   "þi2p1",
   ".vo2j1",
   ".vo3j2aø",
   "vor2t1",
   "vort2od",
   "vort2op",
   "a2lie",
   "sek2s1eksc",
   ".unu2a",
   "unu3a2nim",
   "u2e3nask",
   "se2kvinber",
   "skra2p1",
   "skva2m1",
   "ta2g1l2",
   "tolst2oj.",
   "1u2nuo",
   "j2u2n",
   "u2z",
   "ku3z",
   "mu3z",
   "ilu3zi",
   "klu3z",
   "kru3z",
   "lin2g2v1uz",
   ".vi2þ",
   ".vi2v1",
   "2ipov",
   "viza2ø1",
   "zo2o",
   ".or5t2ho",
   "1s2c2h",
   ".kalo3c2say",
   ".warin5g2hi2en",
}

local function eo_ordinal (n, _)
   if n == nil then
      n = ""
   end
   local a, h
   h = SILE.settings:get("languages.eo.ordinal.hyphenbefore") and "-" or ""
   a = h .. (SILE.settings:get("languages.eo.ordinal.raisedsuffix") and "ª" or "a")
   return n .. a
end

-- Copied from en.lua
local function digits (n)
   local i, ret = -1
   return function ()
      i, ret = i + 1, n % 10
      if n > 0 then
         n = math.floor(n / 10)
         return i, ret
      end
   end
end

-- Rezultas la vorton de la postulata nombra parametro
-- Returns the Esperanto name of the required number argument
local eo_string = function (num, _)
   local words = { "unu", "du", "tri", "kvar", "kvin", "ses", "sep", "ok", "naŭ", [0] = "" }
   local levels = { "mil", "miliono", "miliardo", [0] = "" }
   local ten = "dek"
   local hundred = "cent"
   for i = 2, 8, 1 do
      table.insert(levels, 2 + i, words[i] .. "iliono")
      table.insert(levels, 2 + i + 1, words[i] .. "iliardo")
   end

   local level = false
   local function getname (pos, dig) --"stateful, but effective." ~ en_string
      level = level or (pos % 3 == 0)
      if dig == 0 then
         return ""
      end
      local dig_name
      if dig == 1 and pos ~= 0 then
         dig_name = ""
      else
         dig_name = words[dig]
      end
      local name = (pos % 3 == 2 and dig_name .. " " .. hundred .. " " or dig_name .. " ")
         .. (pos % 3 == 1 and ten .. " " or "")
      if level then
         name, level =
            name
               .. levels[math.floor(pos / 3)]
               .. ((dig > 1 and pos > 5) and "j" or "")
               .. (pos > 5 and " kaj" or "")
               .. " ",
            false
      end
      return name
   end

   local vword = ""

   for i, v in digits(num) do
      vword = getname(i, v) .. vword
   end

   vword = vword:gsub(" kaj $", "")
   vword = vword:match("^%s*(.*%S)") or ""

   return num == 0 and "nul" or vword
end

return {
   init = function ()
      SILE.hyphenator.languages.eo = hyphenator

      SU.formatNumber.eo = {
         string = eo_string,
         ordinal = eo_ordinal,
      }

      SILE.settings:declare({
         parameter = "languages.eo.ordinal.raisedsuffix",
         type = "boolean",
         default = false,
         help = "Whether to use “ª” or “a” as Esperanto ordinal suffix",
      })
      SILE.settings:declare({
         parameter = "languages.eo.ordinal.hyphenbefore",
         type = "boolean",
         default = false,
         help = "Whether to put a hyphen (-) before Esperanto ordinal suffix",
      })

      SILE.registerCommand("book:chapter:post:eo", function ()
         SILE.typesetter:typeset(eo_ordinal())
         SILE.call("medskip", {})
      end, nil, nil, true)
   end,
}
