/**
 * wrapper around Map<string, T> for case insensitive file systems
 */
export declare class FileMap<T> implements Iterable<[string, T]> {
    private getCanonicalFileName;
    private readonly map;
    constructor(useCaseSensitiveFileNames?: boolean);
    get(filePath: string): T | undefined;
    set(filePath: string, value: T): Map<string, T>;
    has(filePath: string): boolean;
    delete(filePath: string): boolean;
    /**
     * Returns an iterable of key, value pairs for every entry in the map.
     * In case insensitive file system the key in the key-value pairs is in lowercase
     */
    entries(): IterableIterator<[string, T]>;
    /**
     *
     * @param callbackfn In case insensitive file system the key parameter for the callback is in lowercase
     */
    forEach(callbackfn: (value: T, key: string) => void): void;
    values(): IterableIterator<T>;
    clear(): void;
    /**
     * Returns an iterable of values in the map.
     * In case insensitive file system the key is in lowercase
     */
    keys(): IterableIterator<string>;
    get size(): number;
    [Symbol.iterator](): Iterator<[string, T]>;
}
export declare class FileSet implements Iterable<string> {
    private getCanonicalFileName;
    private readonly set;
    constructor(useCaseSensitiveFileNames?: boolean);
    add(filePath: string): void;
    has(filePath: string): boolean;
    delete(filePath: string): boolean;
    clear(): void;
    [Symbol.iterator](): Iterator<string>;
}
