"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSelectionRange = getSelectionRange;
const estree_walker_1 = require("estree-walker");
const vscode_languageserver_1 = require("vscode-languageserver");
const documents_1 = require("../../../lib/documents");
async function getSelectionRange(svelteDoc, position) {
    const { script, style, moduleScript } = svelteDoc;
    const { ast: { html } } = await svelteDoc.getCompiled();
    const transpiled = await svelteDoc.getTranspiled();
    const content = transpiled.getText();
    const offset = (0, documents_1.offsetAt)(transpiled.getGeneratedPosition(position), content);
    const embedded = [script, style, moduleScript];
    for (const info of embedded) {
        if ((0, documents_1.isInTag)(position, info)) {
            // let other plugins do it
            return null;
        }
    }
    let nearest = html;
    let result;
    (0, estree_walker_1.walk)(html, {
        enter(node, parent) {
            if (!parent) {
                // keep looking
                return;
            }
            if (!('start' in node && 'end' in node)) {
                this.skip();
                return;
            }
            const { start, end } = node;
            const isWithin = start <= offset && end >= offset;
            if (!isWithin) {
                this.skip();
                return;
            }
            if (nearest === parent) {
                nearest = node;
                result = createSelectionRange(node, result);
            }
        }
    });
    return result ? (0, documents_1.mapSelectionRangeToParent)(transpiled, result) : null;
    function createSelectionRange(node, parent) {
        const range = (0, documents_1.toRange)(content, node.start, node.end);
        return vscode_languageserver_1.SelectionRange.create(range, parent);
    }
}
//# sourceMappingURL=getSelectionRanges.js.map