import { ProjectService } from 'typescript-auto-import-cache/out/5_0/projectService';
import ts from 'typescript';
import { ExportInfoMap } from 'typescript-auto-import-cache/out/5_0/exportInfoMap';
import { ModuleSpecifierCache } from 'typescript-auto-import-cache/out/5_0/moduleSpecifierCache';
import { SymlinkCache } from 'typescript-auto-import-cache/out/5_0/symlinkCache';
import { ProjectPackageJsonInfo } from 'typescript-auto-import-cache/out/5_0/packageJsonCache';
export { ProjectService };
declare module 'typescript' {
    interface LanguageServiceHost {
        /** @internal */ getCachedExportInfoMap?(): ExportInfoMap;
        /** @internal */ getModuleSpecifierCache?(): ModuleSpecifierCache;
        /** @internal */ getGlobalTypingsCacheLocation?(): string | undefined;
        /** @internal */ getSymlinkCache?(files: readonly ts.SourceFile[]): SymlinkCache;
        /** @internal */ getPackageJsonsVisibleToFile?(fileName: string, rootDir?: string): readonly ProjectPackageJsonInfo[];
        /** @internal */ getPackageJsonAutoImportProvider?(): ts.Program | undefined;
        /** @internal */ useSourceOfProjectReferenceRedirect?(): boolean;
    }
}
export declare function createProjectService(system: ts.System, hostConfiguration: {
    preferences: ts.UserPreferences;
}): {
    serverMode: ts.LanguageServiceMode;
    host: ts.System;
    currentDirectory: any;
    toCanonicalFileName: any;
    toPath(fileName: string): any;
    getExecutingFilePath(): any;
    getNormalizedAbsolutePath(fileName: string): any;
    packageJsonCache: import("typescript-auto-import-cache/out/5_0/packageJsonCache").PackageJsonCache;
    getPackageJsonsVisibleToFile(fileName: string, rootDir?: string): readonly ProjectPackageJsonInfo[];
    includePackageJsonAutoImports(): import("typescript-auto-import-cache/out/5_0/projectService").PackageJsonAutoImportPreference;
    fileExists(fileName: ts.server.NormalizedPath): boolean;
} | undefined;
export declare function createProject(host: ts.LanguageServiceHost, createLanguageService: (host: ts.LanguageServiceHost) => ts.LanguageService, options: {
    projectService: ProjectService;
    compilerOptions: ts.CompilerOptions;
    currentDirectory: string;
}): {
    dirty: boolean;
    hostProject: any;
    languageServiceEnabled: boolean;
    languageService: ts.LanguageService | undefined;
    projectService: {
        serverMode: import("typescript" /** @internal */).LanguageServiceMode;
        host: import("typescript").System;
        currentDirectory: any;
        toCanonicalFileName: any;
        toPath(fileName: string): any;
        getExecutingFilePath(): any;
        getNormalizedAbsolutePath(fileName: string): any;
        packageJsonCache: import("typescript-auto-import-cache/out/5_0/packageJsonCache").PackageJsonCache;
        getPackageJsonsVisibleToFile(fileName: string, rootDir?: string | undefined): readonly ProjectPackageJsonInfo[];
        includePackageJsonAutoImports(): import("typescript-auto-import-cache/out/5_0/projectService").PackageJsonAutoImportPreference;
        fileExists(fileName: import("typescript").server.NormalizedPath): boolean;
    };
    getCanonicalFileName: any;
    exportMapCache: ExportInfoMap | undefined;
    getCachedExportInfoMap(): any;
    clearCachedExportInfoMap(): void;
    moduleSpecifierCache: import("typescript-auto-import-cache/out/5_0/moduleSpecifierCache").ModuleSpecifierCache;
    getModuleSpecifierCache(): import("typescript-auto-import-cache/out/5_0/moduleSpecifierCache").ModuleSpecifierCache;
    compilerOptions: ts.CompilerOptions;
    getCompilationSettings(): ts.CompilerOptions;
    getCompilerOptions(): ts.CompilerOptions;
    program: ts.Program | undefined;
    getCurrentProgram(): ts.Program | undefined;
    currentDirectory: any;
    getCurrentDirectory(): string;
    symlinks: SymlinkCache | undefined;
    getSymlinkCache(): SymlinkCache;
    packageJsonsForAutoImport: Set<string> | undefined;
    getPackageJsonsForAutoImport(rootDir?: string): readonly ProjectPackageJsonInfo[];
    getPackageJsonsVisibleToFile(fileName: string, rootDir?: string): readonly ProjectPackageJsonInfo[];
    getModuleResolutionHostForAutoImportProvider(): ts.ModuleResolutionHost;
    autoImportProviderHost: false | {
        getCurrentProgram(): ts.Program | undefined;
        isEmpty(): boolean;
        close(): void;
        markAsDirty(): void;
    } | undefined;
    getPackageJsonAutoImportProvider(): ts.Program | undefined;
    includePackageJsonAutoImports(): import("typescript-auto-import-cache/out/5_0/projectService").PackageJsonAutoImportPreference;
    close(): void;
    log(_message: string): void;
    sendPerformanceEvent(_kind: ts.PerformanceEvent["kind"], _durationMs: number): void;
    toPath(fileName: string): any;
    getGlobalTypingsCacheLocation(): undefined;
    useSourceOfProjectReferenceRedirect(): boolean;
    onAutoImportProviderSettingsChanged(): void;
} | undefined;
