"use strict";
// abstracting the typescript-auto-import-cache package to support our use case
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createProjectService = createProjectService;
exports.createProject = createProject;
const projectService_1 = require("typescript-auto-import-cache/out/5_0/projectService");
const project_1 = require("typescript-auto-import-cache/out/5_0/project");
const project_2 = require("typescript-auto-import-cache/out/5_3/project");
const project_3 = require("typescript-auto-import-cache/out/5_5/project");
const typescript_1 = __importDefault(require("typescript"));
function createProjectService(system, hostConfiguration) {
    const version = typescript_1.default.version.split('.');
    const major = parseInt(version[0]);
    if (major < 5) {
        return undefined;
    }
    const projectService = (0, projectService_1.createProjectService)(typescript_1.default, system, system.getCurrentDirectory(), hostConfiguration, typescript_1.default.LanguageServiceMode.Semantic);
    return projectService;
}
function createProject(host, createLanguageService, options) {
    const version = typescript_1.default.version.split('.');
    const major = parseInt(version[0]);
    const minor = parseInt(version[1]);
    if (major < 5) {
        return undefined;
    }
    const factory = minor < 3 ? project_1.createProject : minor < 5 ? project_2.createProject : project_3.createProject;
    const project = factory(typescript_1.default, host, createLanguageService, options);
    const proxyMethods = [
        'getCachedExportInfoMap',
        'getModuleSpecifierCache',
        'getGlobalTypingsCacheLocation',
        'getSymlinkCache',
        'getPackageJsonsVisibleToFile',
        'getPackageJsonAutoImportProvider',
        'includePackageJsonAutoImports',
        'useSourceOfProjectReferenceRedirect'
    ];
    proxyMethods.forEach((key) => (host[key] = project[key].bind(project)));
    if (host.log) {
        project.log = host.log.bind(host);
    }
    return project;
}
//# sourceMappingURL=serviceCache.js.map