"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSvelteSys = createSvelteSys;
const utils_1 = require("./utils");
const fileCollection_1 = require("../../lib/documents/fileCollection");
/**
 * This should only be accessed by TS svelte module resolution.
 */
function createSvelteSys(tsSystem) {
    const fileExistsCache = new fileCollection_1.FileMap();
    function svelteFileExists(path) {
        if ((0, utils_1.isVirtualSvelteFilePath)(path)) {
            const sveltePath = (0, utils_1.toRealSvelteFilePath)(path);
            const sveltePathExists = fileExistsCache.get(sveltePath) ?? tsSystem.fileExists(sveltePath);
            fileExistsCache.set(sveltePath, sveltePathExists);
            return sveltePathExists;
        }
        else {
            return false;
        }
    }
    const svelteSys = {
        ...tsSystem,
        svelteFileExists,
        fileExists(path) {
            // We need to check both .svelte and .svelte.ts/js because that's how Svelte 5 will likely mark files with runes in them
            const sveltePathExists = svelteFileExists(path);
            const exists = sveltePathExists || (fileExistsCache.get(path) ?? tsSystem.fileExists(path));
            fileExistsCache.set(path, exists);
            return exists;
        },
        readFile(path) {
            // No getSnapshot here, because TS will very rarely call this and only for files that are not in the project
            return tsSystem.readFile(svelteFileExists(path) ? (0, utils_1.toRealSvelteFilePath)(path) : path);
        },
        readDirectory(path, extensions, exclude, include, depth) {
            const extensionsWithSvelte = extensions ? [...extensions, '.svelte'] : undefined;
            return tsSystem.readDirectory(path, extensionsWithSvelte, exclude, include, depth);
        },
        deleteFile(path) {
            // assumption: never a foo.svelte.ts file next to a foo.svelte file
            fileExistsCache.delete((0, utils_1.ensureRealSvelteFilePath)(path));
            fileExistsCache.delete(path);
            return tsSystem.deleteFile?.(path);
        },
        deleteFromCache(path) {
            // assumption: never a foo.svelte.ts file next to a foo.svelte file
            fileExistsCache.delete((0, utils_1.ensureRealSvelteFilePath)(path));
            fileExistsCache.delete(path);
        }
    };
    if (tsSystem.realpath) {
        const realpath = tsSystem.realpath;
        svelteSys.realpath = function (path) {
            if (svelteFileExists(path)) {
                return realpath((0, utils_1.toRealSvelteFilePath)(path)) + '.ts';
            }
            return realpath(path);
        };
    }
    return svelteSys;
}
//# sourceMappingURL=svelte-sys.js.map