"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const path = __importStar(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const vscode_languageserver_1 = require("vscode-languageserver");
const documents_1 = require("../../../../src/lib/documents");
const ls_config_1 = require("../../../../src/ls-config");
const FindFileReferencesProvider_1 = require("../../../../src/plugins/typescript/features/FindFileReferencesProvider");
const LSAndTSDocResolver_1 = require("../../../../src/plugins/typescript/LSAndTSDocResolver");
const utils_1 = require("../../../../src/utils");
const test_utils_1 = require("../test-utils");
const testDir = path.join(__dirname, '..');
describe('FindFileReferencesProvider', function () {
    (0, test_utils_1.serviceWarmup)(this, testDir);
    function getFullPath(filename) {
        return path.join(testDir, 'testfiles', filename);
    }
    function getUri(filename) {
        const filePath = path.join(testDir, 'testfiles', filename);
        return (0, utils_1.pathToUrl)(filePath);
    }
    function setup(filename) {
        const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
        const lsConfigManager = new ls_config_1.LSConfigManager();
        const lsAndTsDocResolver = new LSAndTSDocResolver_1.LSAndTSDocResolver(docManager, [(0, utils_1.pathToUrl)(testDir)], lsConfigManager);
        const provider = new FindFileReferencesProvider_1.FindFileReferencesProviderImpl(lsAndTsDocResolver);
        const document = openDoc(filename);
        return { provider, document, openDoc };
        function openDoc(filename) {
            const filePath = getFullPath(filename);
            const doc = docManager.openClientDocument({
                uri: (0, utils_1.pathToUrl)(filePath),
                text: typescript_1.default.sys.readFile(filePath) || ''
            });
            return doc;
        }
    }
    it('finds file references', async function () {
        const { provider, document, openDoc } = setup('find-file-references-child.svelte');
        //Make known all the associated files
        openDoc('find-file-references-parent.svelte');
        const results = await provider.fileReferences(document.uri.toString());
        const expectedResults = [
            vscode_languageserver_1.Location.create(getUri('find-file-references-parent.svelte'), vscode_languageserver_1.Range.create(vscode_languageserver_1.Position.create(1, 37), vscode_languageserver_1.Position.create(1, 72)))
        ];
        assert.deepStrictEqual(results, expectedResults);
    });
});
//# sourceMappingURL=FindFileReferencesProvider.test.js.map