"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const path = __importStar(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const vscode_languageserver_1 = require("vscode-languageserver");
const documents_1 = require("../../../../src/lib/documents");
const ls_config_1 = require("../../../../src/ls-config");
const HoverProvider_1 = require("../../../../src/plugins/typescript/features/HoverProvider");
const LSAndTSDocResolver_1 = require("../../../../src/plugins/typescript/LSAndTSDocResolver");
const service_1 = require("../../../../src/plugins/typescript/service");
const utils_1 = require("../../../../src/utils");
const test_utils_1 = require("../test-utils");
const testDir = path.join(__dirname, '..');
const hoverTestDir = path.join(testDir, 'testfiles', 'hover');
describe('HoverProvider', function () {
    (0, test_utils_1.serviceWarmup)(this, hoverTestDir, (0, utils_1.pathToUrl)(testDir));
    function getFullPath(filename) {
        return path.join(hoverTestDir, filename);
    }
    function setup(filename) {
        const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
        const lsConfigManager = new ls_config_1.LSConfigManager();
        const lsAndTsDocResolver = new LSAndTSDocResolver_1.LSAndTSDocResolver(docManager, [testDir], lsConfigManager);
        const provider = new HoverProvider_1.HoverProviderImpl(lsAndTsDocResolver);
        const document = openDoc(filename);
        return { provider, document };
        function openDoc(filename) {
            const filePath = getFullPath(filename);
            const doc = docManager.openClientDocument({
                uri: (0, utils_1.pathToUrl)(filePath),
                text: typescript_1.default.sys.readFile(filePath) || ''
            });
            return doc;
        }
    }
    it('provides basic hover info when no docstring exists', async () => {
        const { provider, document } = setup('hoverinfo.svelte');
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(6, 10)), {
            contents: '```typescript\nconst withoutDocs: true\n```',
            range: {
                start: {
                    character: 10,
                    line: 6
                },
                end: {
                    character: 21,
                    line: 6
                }
            }
        });
    });
    it('provides formatted hover info when a docstring exists', async () => {
        const { provider, document } = setup('hoverinfo.svelte');
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(4, 10)), {
            contents: '```typescript\nconst withDocs: true\n```\n---\nDocumentation string',
            range: {
                start: {
                    character: 10,
                    line: 4
                },
                end: {
                    character: 18,
                    line: 4
                }
            }
        });
    });
    it('provides formatted hover info for component events', async () => {
        const { provider, document } = setup('hoverinfo.svelte');
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(12, 26)), {
            contents: '```typescript\nabc: MouseEvent\n```\nTEST\n```ts\nconst abc: boolean = true;\n```'
        });
    });
    it('provides formatted hover info for jsDoc tags', async () => {
        const { provider, document } = setup('hoverinfo.svelte');
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(9, 10)), {
            contents: '```typescript\nconst withJsDocTag: true\n```\n---\n\n\n*@author* — foo ',
            range: {
                start: {
                    character: 10,
                    line: 9
                },
                end: {
                    character: 22,
                    line: 9
                }
            }
        });
    });
    it('provides hover info for $store access', async () => {
        const { provider, document } = setup('hover-$store.svelte');
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(3, 5)), {
            contents: '```typescript\nlet $b: string | {\n    a: boolean | string;\n}\n```',
            range: {
                end: {
                    character: 6,
                    line: 3
                },
                start: {
                    character: 4,
                    line: 3
                }
            }
        });
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(5, 9)), {
            contents: '```typescript\nlet $b: string\n```',
            range: {
                end: {
                    character: 10,
                    line: 5
                },
                start: {
                    character: 8,
                    line: 5
                }
            }
        });
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(7, 4)), {
            contents: '```typescript\nconst b: Writable<string | {\n    a: boolean | string;\n}>\n```',
            range: {
                end: {
                    character: 5,
                    line: 7
                },
                start: {
                    character: 4,
                    line: 7
                }
            }
        });
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(10, 2)), {
            contents: '```typescript\nlet $b: string | {\n    a: boolean | string;\n}\n```',
            range: {
                end: {
                    character: 3,
                    line: 10
                },
                start: {
                    character: 1,
                    line: 10
                }
            }
        });
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(12, 6)), {
            contents: '```typescript\nlet $b: string\n```',
            range: {
                end: {
                    character: 7,
                    line: 12
                },
                start: {
                    character: 5,
                    line: 12
                }
            }
        });
        assert.deepStrictEqual(await provider.doHover(document, vscode_languageserver_1.Position.create(14, 1)), {
            contents: '```typescript\nconst b: Writable<string | {\n    a: boolean | string;\n}>\n```',
            range: {
                end: {
                    character: 2,
                    line: 14
                },
                start: {
                    character: 1,
                    line: 14
                }
            }
        });
    });
    // Hacky, but it works. Needed due to testing both new and old transformation
    after(() => {
        (0, service_1.__resetCache)();
    });
});
//# sourceMappingURL=HoverProvider.test.js.map