// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32s3.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

//go:build esp && esp32s3

// 32-bit MCU & 2.4 GHz Wi-Fi & Bluetooth 5 (LE)
//
//	Copyright 2023 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32-S3"
	CPU          = "Xtensa LX7"
	FPUPresent   = true
	NVICPrioBits = 0
)

// Interrupt numbers.
const (
	// Interrupt Controller (Core 0)
	IRQ_WIFI_MAC = 0

	// Interrupt Controller (Core 0)
	IRQ_WIFI_NMI = 1

	// Interrupt Controller (Core 0)
	IRQ_WIFI_PWR = 2

	// Interrupt Controller (Core 0)
	IRQ_WIFI_BB = 3

	// Interrupt Controller (Core 0)
	IRQ_BT_MAC = 4

	// Interrupt Controller (Core 0)
	IRQ_BT_BB = 5

	// Interrupt Controller (Core 0)
	IRQ_BT_BB_NMI = 6

	// Interrupt Controller (Core 0)
	IRQ_RWBT = 7

	// Interrupt Controller (Core 0)
	IRQ_RWBLE = 8

	// Interrupt Controller (Core 0)
	IRQ_RWBT_NMI = 9

	// Interrupt Controller (Core 0)
	IRQ_RWBLE_NMI = 10

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C_MASTER = 11

	// Interrupt Controller (Core 0)
	IRQ_SLC0 = 12

	// Interrupt Controller (Core 0)
	IRQ_SLC1 = 13

	// Universal Host Controller Interface 0
	IRQ_UHCI0 = 14

	// Universal Host Controller Interface 1
	IRQ_UHCI1 = 15

	// General Purpose Input/Output
	IRQ_GPIO = 16

	// General Purpose Input/Output
	IRQ_GPIO_NMI = 17

	// General Purpose Input/Output
	IRQ_GPIO_INTR_2 = 18

	// General Purpose Input/Output
	IRQ_GPIO_NMI_2 = 19

	// SPI (Serial Peripheral Interface) Controller 1
	IRQ_SPI1 = 20

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI2 = 21

	// SPI (Serial Peripheral Interface) Controller 3
	IRQ_SPI3 = 22

	// Camera/LCD Controller
	IRQ_LCD_CAM = 24

	// I2S (Inter-IC Sound) Controller 0
	IRQ_I2S0 = 25

	// I2S (Inter-IC Sound) Controller 1
	IRQ_I2S1 = 26

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	IRQ_UART0 = 27

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	IRQ_UART1 = 28

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 2
	IRQ_UART2 = 29

	// Interrupt Controller (Core 0)
	IRQ_SDIO_HOST = 30

	// Motor Control Pulse-Width Modulation 0
	IRQ_MCPWM0 = 31

	// Motor Control Pulse-Width Modulation 1
	IRQ_MCPWM1 = 32

	// LED Control PWM (Pulse Width Modulation)
	IRQ_LEDC = 35

	// eFuse Controller
	IRQ_EFUSE = 36

	// Two-Wire Automotive Interface
	IRQ_TWAI0 = 37

	// USB OTG (On-The-Go)
	IRQ_USB = 38

	// Real-Time Clock Control
	IRQ_RTC_CORE = 39

	// Remote Control
	IRQ_RMT = 40

	// Pulse Count Controller
	IRQ_PCNT = 41

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C_EXT0 = 42

	// I2C (Inter-Integrated Circuit) Controller 1
	IRQ_I2C_EXT1 = 43

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI2_DMA = 44

	// SPI (Serial Peripheral Interface) Controller 3
	IRQ_SPI3_DMA = 45

	// Interrupt Controller (Core 0)
	IRQ_WDT = 47

	// LED Control PWM (Pulse Width Modulation)
	IRQ_TIMER1 = 48

	// LED Control PWM (Pulse Width Modulation)
	IRQ_TIMER2 = 49

	// Timer Group 0
	IRQ_TG0_T0_LEVEL = 50

	// Timer Group 0
	IRQ_TG0_T1_LEVEL = 51

	// Timer Group 0
	IRQ_TG0_WDT_LEVEL = 52

	// Timer Group 1
	IRQ_TG1_T0_LEVEL = 53

	// Timer Group 1
	IRQ_TG1_T1_LEVEL = 54

	// Timer Group 1
	IRQ_TG1_WDT_LEVEL = 55

	// Interrupt Controller (Core 0)
	IRQ_CACHE_IA = 56

	// System Timer
	IRQ_SYSTIMER_TARGET0 = 57

	// System Timer
	IRQ_SYSTIMER_TARGET1 = 58

	// System Timer
	IRQ_SYSTIMER_TARGET2 = 59

	// SPI (Serial Peripheral Interface) Controller 0
	IRQ_SPI_MEM_REJECT_CACHE = 60

	// Interrupt Controller (Core 0)
	IRQ_DCACHE_PRELOAD0 = 61

	// Interrupt Controller (Core 0)
	IRQ_ICACHE_PRELOAD0 = 62

	// Interrupt Controller (Core 0)
	IRQ_DCACHE_SYNC0 = 63

	// Interrupt Controller (Core 0)
	IRQ_ICACHE_SYNC0 = 64

	// SAR (Successive Approximation Register) Analog-to-Digital Converter
	IRQ_APB_ADC = 65

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_IN_CH0 = 66

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_IN_CH1 = 67

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_IN_CH2 = 68

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_IN_CH3 = 69

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_IN_CH4 = 70

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_OUT_CH0 = 71

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_OUT_CH1 = 72

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_OUT_CH2 = 73

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_OUT_CH3 = 74

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_OUT_CH4 = 75

	// RSA (Rivest Shamir Adleman) Accelerator
	IRQ_RSA = 76

	// SHA (Secure Hash Algorithm) Accelerator
	IRQ_SHA = 77

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR0 = 79

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR1 = 80

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR2 = 81

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR3 = 82

	// Debug Assist
	IRQ_ASSIST_DEBUG = 83

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_APBPERI_PMS = 84

	// Interrupt Controller (Core 0)
	IRQ_CORE0_IRAM0_PMS = 85

	// Interrupt Controller (Core 0)
	IRQ_CORE0_DRAM0_PMS = 86

	// Interrupt Controller (Core 0)
	IRQ_CORE0_PIF_PMS = 87

	// Interrupt Controller (Core 0)
	IRQ_CORE0_PIF_PMS_SIZE = 88

	// Interrupt Controller (Core 1)
	IRQ_CORE1_IRAM0_PMS = 89

	// Interrupt Controller (Core 1)
	IRQ_CORE1_DRAM0_PMS = 90

	// Interrupt Controller (Core 1)
	IRQ_CORE1_PIF_PMS = 91

	// Interrupt Controller (Core 1)
	IRQ_CORE1_PIF_PMS_SIZE = 92

	// DMA (Direct Memory Access) Controller
	IRQ_BACKUP_PMS_VIOLATE = 93

	// Interrupt Controller (Core 0)
	IRQ_CACHE_CORE0_ACS = 94

	// Interrupt Controller (Core 1)
	IRQ_CACHE_CORE1_ACS = 95

	// Full-speed USB Serial/JTAG Controller
	IRQ_USB_DEVICE = 96

	// PERI_BACKUP Peripheral
	IRQ_PERI_BACKUP = 97

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_EXTMEM_REJECT = 98

	// Highest interrupt number on this device.
	IRQ_max = 98
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_WIFI_MAC:
		callHandlers(IRQ_WIFI_MAC)
	case IRQ_WIFI_NMI:
		callHandlers(IRQ_WIFI_NMI)
	case IRQ_WIFI_PWR:
		callHandlers(IRQ_WIFI_PWR)
	case IRQ_WIFI_BB:
		callHandlers(IRQ_WIFI_BB)
	case IRQ_BT_MAC:
		callHandlers(IRQ_BT_MAC)
	case IRQ_BT_BB:
		callHandlers(IRQ_BT_BB)
	case IRQ_BT_BB_NMI:
		callHandlers(IRQ_BT_BB_NMI)
	case IRQ_RWBT:
		callHandlers(IRQ_RWBT)
	case IRQ_RWBLE:
		callHandlers(IRQ_RWBLE)
	case IRQ_RWBT_NMI:
		callHandlers(IRQ_RWBT_NMI)
	case IRQ_RWBLE_NMI:
		callHandlers(IRQ_RWBLE_NMI)
	case IRQ_I2C_MASTER:
		callHandlers(IRQ_I2C_MASTER)
	case IRQ_SLC0:
		callHandlers(IRQ_SLC0)
	case IRQ_SLC1:
		callHandlers(IRQ_SLC1)
	case IRQ_UHCI0:
		callHandlers(IRQ_UHCI0)
	case IRQ_UHCI1:
		callHandlers(IRQ_UHCI1)
	case IRQ_GPIO:
		callHandlers(IRQ_GPIO)
	case IRQ_GPIO_NMI:
		callHandlers(IRQ_GPIO_NMI)
	case IRQ_GPIO_INTR_2:
		callHandlers(IRQ_GPIO_INTR_2)
	case IRQ_GPIO_NMI_2:
		callHandlers(IRQ_GPIO_NMI_2)
	case IRQ_SPI1:
		callHandlers(IRQ_SPI1)
	case IRQ_SPI2:
		callHandlers(IRQ_SPI2)
	case IRQ_SPI3:
		callHandlers(IRQ_SPI3)
	case IRQ_LCD_CAM:
		callHandlers(IRQ_LCD_CAM)
	case IRQ_I2S0:
		callHandlers(IRQ_I2S0)
	case IRQ_I2S1:
		callHandlers(IRQ_I2S1)
	case IRQ_UART0:
		callHandlers(IRQ_UART0)
	case IRQ_UART1:
		callHandlers(IRQ_UART1)
	case IRQ_UART2:
		callHandlers(IRQ_UART2)
	case IRQ_SDIO_HOST:
		callHandlers(IRQ_SDIO_HOST)
	case IRQ_MCPWM0:
		callHandlers(IRQ_MCPWM0)
	case IRQ_MCPWM1:
		callHandlers(IRQ_MCPWM1)
	case IRQ_LEDC:
		callHandlers(IRQ_LEDC)
	case IRQ_EFUSE:
		callHandlers(IRQ_EFUSE)
	case IRQ_TWAI0:
		callHandlers(IRQ_TWAI0)
	case IRQ_USB:
		callHandlers(IRQ_USB)
	case IRQ_RTC_CORE:
		callHandlers(IRQ_RTC_CORE)
	case IRQ_RMT:
		callHandlers(IRQ_RMT)
	case IRQ_PCNT:
		callHandlers(IRQ_PCNT)
	case IRQ_I2C_EXT0:
		callHandlers(IRQ_I2C_EXT0)
	case IRQ_I2C_EXT1:
		callHandlers(IRQ_I2C_EXT1)
	case IRQ_SPI2_DMA:
		callHandlers(IRQ_SPI2_DMA)
	case IRQ_SPI3_DMA:
		callHandlers(IRQ_SPI3_DMA)
	case IRQ_WDT:
		callHandlers(IRQ_WDT)
	case IRQ_TIMER1:
		callHandlers(IRQ_TIMER1)
	case IRQ_TIMER2:
		callHandlers(IRQ_TIMER2)
	case IRQ_TG0_T0_LEVEL:
		callHandlers(IRQ_TG0_T0_LEVEL)
	case IRQ_TG0_T1_LEVEL:
		callHandlers(IRQ_TG0_T1_LEVEL)
	case IRQ_TG0_WDT_LEVEL:
		callHandlers(IRQ_TG0_WDT_LEVEL)
	case IRQ_TG1_T0_LEVEL:
		callHandlers(IRQ_TG1_T0_LEVEL)
	case IRQ_TG1_T1_LEVEL:
		callHandlers(IRQ_TG1_T1_LEVEL)
	case IRQ_TG1_WDT_LEVEL:
		callHandlers(IRQ_TG1_WDT_LEVEL)
	case IRQ_CACHE_IA:
		callHandlers(IRQ_CACHE_IA)
	case IRQ_SYSTIMER_TARGET0:
		callHandlers(IRQ_SYSTIMER_TARGET0)
	case IRQ_SYSTIMER_TARGET1:
		callHandlers(IRQ_SYSTIMER_TARGET1)
	case IRQ_SYSTIMER_TARGET2:
		callHandlers(IRQ_SYSTIMER_TARGET2)
	case IRQ_SPI_MEM_REJECT_CACHE:
		callHandlers(IRQ_SPI_MEM_REJECT_CACHE)
	case IRQ_DCACHE_PRELOAD0:
		callHandlers(IRQ_DCACHE_PRELOAD0)
	case IRQ_ICACHE_PRELOAD0:
		callHandlers(IRQ_ICACHE_PRELOAD0)
	case IRQ_DCACHE_SYNC0:
		callHandlers(IRQ_DCACHE_SYNC0)
	case IRQ_ICACHE_SYNC0:
		callHandlers(IRQ_ICACHE_SYNC0)
	case IRQ_APB_ADC:
		callHandlers(IRQ_APB_ADC)
	case IRQ_DMA_IN_CH0:
		callHandlers(IRQ_DMA_IN_CH0)
	case IRQ_DMA_IN_CH1:
		callHandlers(IRQ_DMA_IN_CH1)
	case IRQ_DMA_IN_CH2:
		callHandlers(IRQ_DMA_IN_CH2)
	case IRQ_DMA_IN_CH3:
		callHandlers(IRQ_DMA_IN_CH3)
	case IRQ_DMA_IN_CH4:
		callHandlers(IRQ_DMA_IN_CH4)
	case IRQ_DMA_OUT_CH0:
		callHandlers(IRQ_DMA_OUT_CH0)
	case IRQ_DMA_OUT_CH1:
		callHandlers(IRQ_DMA_OUT_CH1)
	case IRQ_DMA_OUT_CH2:
		callHandlers(IRQ_DMA_OUT_CH2)
	case IRQ_DMA_OUT_CH3:
		callHandlers(IRQ_DMA_OUT_CH3)
	case IRQ_DMA_OUT_CH4:
		callHandlers(IRQ_DMA_OUT_CH4)
	case IRQ_RSA:
		callHandlers(IRQ_RSA)
	case IRQ_SHA:
		callHandlers(IRQ_SHA)
	case IRQ_FROM_CPU_INTR0:
		callHandlers(IRQ_FROM_CPU_INTR0)
	case IRQ_FROM_CPU_INTR1:
		callHandlers(IRQ_FROM_CPU_INTR1)
	case IRQ_FROM_CPU_INTR2:
		callHandlers(IRQ_FROM_CPU_INTR2)
	case IRQ_FROM_CPU_INTR3:
		callHandlers(IRQ_FROM_CPU_INTR3)
	case IRQ_ASSIST_DEBUG:
		callHandlers(IRQ_ASSIST_DEBUG)
	case IRQ_DMA_APBPERI_PMS:
		callHandlers(IRQ_DMA_APBPERI_PMS)
	case IRQ_CORE0_IRAM0_PMS:
		callHandlers(IRQ_CORE0_IRAM0_PMS)
	case IRQ_CORE0_DRAM0_PMS:
		callHandlers(IRQ_CORE0_DRAM0_PMS)
	case IRQ_CORE0_PIF_PMS:
		callHandlers(IRQ_CORE0_PIF_PMS)
	case IRQ_CORE0_PIF_PMS_SIZE:
		callHandlers(IRQ_CORE0_PIF_PMS_SIZE)
	case IRQ_CORE1_IRAM0_PMS:
		callHandlers(IRQ_CORE1_IRAM0_PMS)
	case IRQ_CORE1_DRAM0_PMS:
		callHandlers(IRQ_CORE1_DRAM0_PMS)
	case IRQ_CORE1_PIF_PMS:
		callHandlers(IRQ_CORE1_PIF_PMS)
	case IRQ_CORE1_PIF_PMS_SIZE:
		callHandlers(IRQ_CORE1_PIF_PMS_SIZE)
	case IRQ_BACKUP_PMS_VIOLATE:
		callHandlers(IRQ_BACKUP_PMS_VIOLATE)
	case IRQ_CACHE_CORE0_ACS:
		callHandlers(IRQ_CACHE_CORE0_ACS)
	case IRQ_CACHE_CORE1_ACS:
		callHandlers(IRQ_CACHE_CORE1_ACS)
	case IRQ_USB_DEVICE:
		callHandlers(IRQ_USB_DEVICE)
	case IRQ_PERI_BACKUP:
		callHandlers(IRQ_PERI_BACKUP)
	case IRQ_DMA_EXTMEM_REJECT:
		callHandlers(IRQ_DMA_EXTMEM_REJECT)
	}
}

// Peripherals.
var (
	// AES (Advanced Encryption Standard) Accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x6003a000)))

	// APB (Advanced Peripheral Bus) Controller
	APB_CTRL = (*APB_CTRL_Type)(unsafe.Pointer(uintptr(0x60026000)))

	// SAR (Successive Approximation Register) Analog-to-Digital Converter
	APB_SARADC = (*APB_SARADC_Type)(unsafe.Pointer(uintptr(0x60040000)))

	// BB Peripheral
	BB = (*BB_Type)(unsafe.Pointer(uintptr(0x6001d000)))

	// Debug Assist
	ASSIST_DEBUG = (*DEBUG_ASSIST_Type)(unsafe.Pointer(uintptr(0x600ce000)))

	// DMA (Direct Memory Access) Controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x6003f000)))

	// Digital Signature
	DS = (*DS_Type)(unsafe.Pointer(uintptr(0x6003d000)))

	// eFuse Controller
	EFUSE = (*EFUSE_Type)(unsafe.Pointer(uintptr(0x60007000)))

	// External Memory
	EXTMEM = (*EXTMEM_Type)(unsafe.Pointer(uintptr(0x600c4000)))

	// General Purpose Input/Output
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x60004000)))

	// Sigma-Delta Modulation
	GPIO_SD = (*GPIOSD_Type)(unsafe.Pointer(uintptr(0x60004f00)))

	// HMAC (Hash-based Message Authentication Code) Accelerator
	HMAC = (*HMAC_Type)(unsafe.Pointer(uintptr(0x6003e000)))

	// I2C (Inter-Integrated Circuit) Controller 0
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x60013000)))

	// I2S (Inter-IC Sound) Controller 0
	I2S0 = (*I2S_Type)(unsafe.Pointer(uintptr(0x6000f000)))

	// I2S (Inter-IC Sound) Controller 1
	I2S1 = (*I2S1_Type)(unsafe.Pointer(uintptr(0x6002d000)))

	// Interrupt Controller (Core 0)
	INTERRUPT_CORE0 = (*INTERRUPT_CORE0_Type)(unsafe.Pointer(uintptr(0x600c2000)))

	// Interrupt Controller (Core 1)
	INTERRUPT_CORE1 = (*INTERRUPT_CORE1_Type)(unsafe.Pointer(uintptr(0x600c2000)))

	// Input/Output Multiplexer
	IO_MUX = (*IO_MUX_Type)(unsafe.Pointer(uintptr(0x60009000)))

	// Camera/LCD Controller
	LCD_CAM = (*LCD_CAM_Type)(unsafe.Pointer(uintptr(0x60041000)))

	// LED Control PWM (Pulse Width Modulation)
	LEDC = (*LEDC_Type)(unsafe.Pointer(uintptr(0x60019000)))

	// Pulse Count Controller
	PCNT = (*PCNT_Type)(unsafe.Pointer(uintptr(0x60017000)))

	// PERI_BACKUP Peripheral
	PERI_BACKUP = (*PERI_BACKUP_Type)(unsafe.Pointer(uintptr(0x6002a000)))

	// Motor Control Pulse-Width Modulation 0
	MCPWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x6001e000)))

	// Remote Control
	RMT = (*RMT_Type)(unsafe.Pointer(uintptr(0x60016000)))

	// Hardware Random Number Generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x60034f6c)))

	// RSA (Rivest Shamir Adleman) Accelerator
	RSA = (*RSA_Type)(unsafe.Pointer(uintptr(0x6003c000)))

	// Real-Time Clock Control
	RTC_CNTL = (*RTC_CNTL_Type)(unsafe.Pointer(uintptr(0x60008000)))

	// Low-power I2C (Inter-Integrated Circuit) Controller
	RTC_I2C = (*RTC_I2C_Type)(unsafe.Pointer(uintptr(0x60008c00)))

	// Low-power Input/Output
	RTC_IO = (*RTC_IO_Type)(unsafe.Pointer(uintptr(0x60008400)))

	// SD/MMC Host Controller
	SDHOST = (*SDHOST_Type)(unsafe.Pointer(uintptr(0x60028000)))

	// SENS Peripheral
	SENS = (*SENS_Type)(unsafe.Pointer(uintptr(0x60008800)))

	// SENSITIVE Peripheral
	SENSITIVE = (*SENSITIVE_Type)(unsafe.Pointer(uintptr(0x600c1000)))

	// SHA (Secure Hash Algorithm) Accelerator
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0x6003b000)))

	// SPI (Serial Peripheral Interface) Controller 0
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x60003000)))

	// SPI (Serial Peripheral Interface) Controller 1
	SPI1 = (*SPI1_Type)(unsafe.Pointer(uintptr(0x60002000)))

	// SPI (Serial Peripheral Interface) Controller 2
	SPI2 = (*SPI2_Type)(unsafe.Pointer(uintptr(0x60024000)))

	// SPI (Serial Peripheral Interface) Controller 3
	SPI3 = (*SPI2_Type)(unsafe.Pointer(uintptr(0x60025000)))

	// System Configuration Registers
	SYSTEM = (*SYSTEM_Type)(unsafe.Pointer(uintptr(0x600c0000)))

	// System Timer
	SYSTIMER = (*SYSTIMER_Type)(unsafe.Pointer(uintptr(0x60023000)))

	// Timer Group 0
	TIMG0 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x6001f000)))

	// Two-Wire Automotive Interface
	TWAI0 = (*TWAI_Type)(unsafe.Pointer(uintptr(0x6002b000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x60000000)))

	// Universal Host Controller Interface 0
	UHCI0 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x60014000)))

	// USB OTG (On-The-Go)
	USB0 = (*USB_Type)(unsafe.Pointer(uintptr(0x60080000)))

	// Full-speed USB Serial/JTAG Controller
	USB_DEVICE = (*USB_DEVICE_Type)(unsafe.Pointer(uintptr(0x60038000)))

	// USB_WRAP Peripheral
	USB_WRAP = (*USB_WRAP_Type)(unsafe.Pointer(uintptr(0x60039000)))

	// WCL Peripheral
	WCL = (*WCL_Type)(unsafe.Pointer(uintptr(0x600d0000)))

	// XTS-AES-128 Flash Encryption
	XTS_AES = (*XTS_AES_Type)(unsafe.Pointer(uintptr(0x600cc000)))

	// I2C (Inter-Integrated Circuit) Controller 1
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x60027000)))

	// Motor Control Pulse-Width Modulation 1
	MCPWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x6002c000)))

	// Timer Group 1
	TIMG1 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x60020000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x60010000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 2
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x6002e000)))

	// Universal Host Controller Interface 1
	UHCI1 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x6000c000)))
)

// AES (Advanced Encryption Standard) Accelerator
type AES_Type struct {
	KEY_0             volatile.Register32 // 0x0
	KEY_1             volatile.Register32 // 0x4
	KEY_2             volatile.Register32 // 0x8
	KEY_3             volatile.Register32 // 0xC
	KEY_4             volatile.Register32 // 0x10
	KEY_5             volatile.Register32 // 0x14
	KEY_6             volatile.Register32 // 0x18
	KEY_7             volatile.Register32 // 0x1C
	TEXT_IN_0         volatile.Register32 // 0x20
	TEXT_IN_1         volatile.Register32 // 0x24
	TEXT_IN_2         volatile.Register32 // 0x28
	TEXT_IN_3         volatile.Register32 // 0x2C
	TEXT_OUT_0        volatile.Register32 // 0x30
	TEXT_OUT_1        volatile.Register32 // 0x34
	TEXT_OUT_2        volatile.Register32 // 0x38
	TEXT_OUT_3        volatile.Register32 // 0x3C
	MODE              volatile.Register32 // 0x40
	_                 [4]byte
	TRIGGER           volatile.Register32    // 0x48
	STATE             volatile.Register32    // 0x4C
	IV_MEM            [16]volatile.Register8 // 0x50
	H_MEM             [16]volatile.Register8 // 0x60
	J0_MEM            [16]volatile.Register8 // 0x70
	T0_MEM            [16]volatile.Register8 // 0x80
	DMA_ENABLE        volatile.Register32    // 0x90
	BLOCK_MODE        volatile.Register32    // 0x94
	BLOCK_NUM         volatile.Register32    // 0x98
	INC_SEL           volatile.Register32    // 0x9C
	AAD_BLOCK_NUM     volatile.Register32    // 0xA0
	REMAINDER_BIT_NUM volatile.Register32    // 0xA4
	CONTINUE          volatile.Register32    // 0xA8
	INT_CLR           volatile.Register32    // 0xAC
	INT_ENA           volatile.Register32    // 0xB0
	DATE              volatile.Register32    // 0xB4
	DMA_EXIT          volatile.Register32    // 0xB8
}

// AES.KEY_0: AES key register %s
func (o *AES_Type) SetKEY_0(value uint32) {
	volatile.StoreUint32(&o.KEY_0.Reg, value)
}
func (o *AES_Type) GetKEY_0() uint32 {
	return volatile.LoadUint32(&o.KEY_0.Reg)
}

// AES.KEY_1: AES key register %s
func (o *AES_Type) SetKEY_1(value uint32) {
	volatile.StoreUint32(&o.KEY_1.Reg, value)
}
func (o *AES_Type) GetKEY_1() uint32 {
	return volatile.LoadUint32(&o.KEY_1.Reg)
}

// AES.KEY_2: AES key register %s
func (o *AES_Type) SetKEY_2(value uint32) {
	volatile.StoreUint32(&o.KEY_2.Reg, value)
}
func (o *AES_Type) GetKEY_2() uint32 {
	return volatile.LoadUint32(&o.KEY_2.Reg)
}

// AES.KEY_3: AES key register %s
func (o *AES_Type) SetKEY_3(value uint32) {
	volatile.StoreUint32(&o.KEY_3.Reg, value)
}
func (o *AES_Type) GetKEY_3() uint32 {
	return volatile.LoadUint32(&o.KEY_3.Reg)
}

// AES.KEY_4: AES key register %s
func (o *AES_Type) SetKEY_4(value uint32) {
	volatile.StoreUint32(&o.KEY_4.Reg, value)
}
func (o *AES_Type) GetKEY_4() uint32 {
	return volatile.LoadUint32(&o.KEY_4.Reg)
}

// AES.KEY_5: AES key register %s
func (o *AES_Type) SetKEY_5(value uint32) {
	volatile.StoreUint32(&o.KEY_5.Reg, value)
}
func (o *AES_Type) GetKEY_5() uint32 {
	return volatile.LoadUint32(&o.KEY_5.Reg)
}

// AES.KEY_6: AES key register %s
func (o *AES_Type) SetKEY_6(value uint32) {
	volatile.StoreUint32(&o.KEY_6.Reg, value)
}
func (o *AES_Type) GetKEY_6() uint32 {
	return volatile.LoadUint32(&o.KEY_6.Reg)
}

// AES.KEY_7: AES key register %s
func (o *AES_Type) SetKEY_7(value uint32) {
	volatile.StoreUint32(&o.KEY_7.Reg, value)
}
func (o *AES_Type) GetKEY_7() uint32 {
	return volatile.LoadUint32(&o.KEY_7.Reg)
}

// AES.TEXT_IN_0: Source data register %s
func (o *AES_Type) SetTEXT_IN_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_0.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_0.Reg)
}

// AES.TEXT_IN_1: Source data register %s
func (o *AES_Type) SetTEXT_IN_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_1.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_1.Reg)
}

// AES.TEXT_IN_2: Source data register %s
func (o *AES_Type) SetTEXT_IN_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_2.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_2.Reg)
}

// AES.TEXT_IN_3: Source data register %s
func (o *AES_Type) SetTEXT_IN_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_3.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_3.Reg)
}

// AES.TEXT_OUT_0: Result data register %s
func (o *AES_Type) SetTEXT_OUT_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_0.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_0.Reg)
}

// AES.TEXT_OUT_1: Result data register %s
func (o *AES_Type) SetTEXT_OUT_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_1.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_1.Reg)
}

// AES.TEXT_OUT_2: Result data register %s
func (o *AES_Type) SetTEXT_OUT_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_2.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_2.Reg)
}

// AES.TEXT_OUT_3: Result data register %s
func (o *AES_Type) SetTEXT_OUT_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_3.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_3.Reg)
}

// AES.MODE: AES Mode register
func (o *AES_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x7
}

// AES.TRIGGER: AES trigger register
func (o *AES_Type) SetTRIGGER(value uint32) {
	volatile.StoreUint32(&o.TRIGGER.Reg, volatile.LoadUint32(&o.TRIGGER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetTRIGGER() uint32 {
	return volatile.LoadUint32(&o.TRIGGER.Reg) & 0x1
}

// AES.STATE: AES state register
func (o *AES_Type) SetSTATE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x3)|value)
}
func (o *AES_Type) GetSTATE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x3
}

// AES.DMA_ENABLE: AES accelerator working mode register
func (o *AES_Type) SetDMA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA_ENABLE.Reg, volatile.LoadUint32(&o.DMA_ENABLE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DMA_ENABLE.Reg) & 0x1
}

// AES.BLOCK_MODE: AES cipher block mode register
func (o *AES_Type) SetBLOCK_MODE(value uint32) {
	volatile.StoreUint32(&o.BLOCK_MODE.Reg, volatile.LoadUint32(&o.BLOCK_MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetBLOCK_MODE() uint32 {
	return volatile.LoadUint32(&o.BLOCK_MODE.Reg) & 0x7
}

// AES.BLOCK_NUM: AES block number register
func (o *AES_Type) SetBLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetBLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.BLOCK_NUM.Reg)
}

// AES.INC_SEL: Standard incrementing function configure register
func (o *AES_Type) SetINC_SEL(value uint32) {
	volatile.StoreUint32(&o.INC_SEL.Reg, volatile.LoadUint32(&o.INC_SEL.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINC_SEL() uint32 {
	return volatile.LoadUint32(&o.INC_SEL.Reg) & 0x1
}

// AES.AAD_BLOCK_NUM: Additional Authential Data block number register
func (o *AES_Type) SetAAD_BLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.AAD_BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetAAD_BLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.AAD_BLOCK_NUM.Reg)
}

// AES.REMAINDER_BIT_NUM: AES remainder bit number register
func (o *AES_Type) SetREMAINDER_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.REMAINDER_BIT_NUM.Reg, volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg)&^(0x7f)|value)
}
func (o *AES_Type) GetREMAINDER_BIT_NUM() uint32 {
	return volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg) & 0x7f
}

// AES.CONTINUE: AES continue register
func (o *AES_Type) SetCONTINUE(value uint32) {
	volatile.StoreUint32(&o.CONTINUE.Reg, volatile.LoadUint32(&o.CONTINUE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCONTINUE() uint32 {
	return volatile.LoadUint32(&o.CONTINUE.Reg) & 0x1
}

// AES.INT_CLR: AES Interrupt clear register
func (o *AES_Type) SetINT_CLR_INT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_CLR_INT_CLEAR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}

// AES.INT_ENA: DMA-AES Interrupt enable register
func (o *AES_Type) SetINT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}

// AES.DATE: AES version control register
func (o *AES_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *AES_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// AES.DMA_EXIT: AES-DMA exit config
func (o *AES_Type) SetDMA_EXIT(value uint32) {
	volatile.StoreUint32(&o.DMA_EXIT.Reg, volatile.LoadUint32(&o.DMA_EXIT.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_EXIT() uint32 {
	return volatile.LoadUint32(&o.DMA_EXIT.Reg) & 0x1
}

// APB (Advanced Peripheral Bus) Controller
type APB_CTRL_Type struct {
	SYSCLK_CONF              volatile.Register32 // 0x0
	TICK_CONF                volatile.Register32 // 0x4
	CLK_OUT_EN               volatile.Register32 // 0x8
	WIFI_BB_CFG              volatile.Register32 // 0xC
	WIFI_BB_CFG_2            volatile.Register32 // 0x10
	WIFI_CLK_EN              volatile.Register32 // 0x14
	WIFI_RST_EN              volatile.Register32 // 0x18
	HOST_INF_SEL             volatile.Register32 // 0x1C
	EXT_MEM_PMS_LOCK         volatile.Register32 // 0x20
	EXT_MEM_WRITEBACK_BYPASS volatile.Register32 // 0x24
	FLASH_ACE0_ATTR          volatile.Register32 // 0x28
	FLASH_ACE1_ATTR          volatile.Register32 // 0x2C
	FLASH_ACE2_ATTR          volatile.Register32 // 0x30
	FLASH_ACE3_ATTR          volatile.Register32 // 0x34
	FLASH_ACE0_ADDR          volatile.Register32 // 0x38
	FLASH_ACE1_ADDR          volatile.Register32 // 0x3C
	FLASH_ACE2_ADDR          volatile.Register32 // 0x40
	FLASH_ACE3_ADDR          volatile.Register32 // 0x44
	FLASH_ACE0_SIZE          volatile.Register32 // 0x48
	FLASH_ACE1_SIZE          volatile.Register32 // 0x4C
	FLASH_ACE2_SIZE          volatile.Register32 // 0x50
	FLASH_ACE3_SIZE          volatile.Register32 // 0x54
	SRAM_ACE0_ATTR           volatile.Register32 // 0x58
	SRAM_ACE1_ATTR           volatile.Register32 // 0x5C
	SRAM_ACE2_ATTR           volatile.Register32 // 0x60
	SRAM_ACE3_ATTR           volatile.Register32 // 0x64
	SRAM_ACE0_ADDR           volatile.Register32 // 0x68
	SRAM_ACE1_ADDR           volatile.Register32 // 0x6C
	SRAM_ACE2_ADDR           volatile.Register32 // 0x70
	SRAM_ACE3_ADDR           volatile.Register32 // 0x74
	SRAM_ACE0_SIZE           volatile.Register32 // 0x78
	SRAM_ACE1_SIZE           volatile.Register32 // 0x7C
	SRAM_ACE2_SIZE           volatile.Register32 // 0x80
	SRAM_ACE3_SIZE           volatile.Register32 // 0x84
	SPI_MEM_PMS_CTRL         volatile.Register32 // 0x88
	SPI_MEM_REJECT_ADDR      volatile.Register32 // 0x8C
	SDIO_CTRL                volatile.Register32 // 0x90
	REDCY_SIG0               volatile.Register32 // 0x94
	REDCY_SIG1               volatile.Register32 // 0x98
	FRONT_END_MEM_PD         volatile.Register32 // 0x9C
	SPI_MEM_ECC_CTRL         volatile.Register32 // 0xA0
	_                        [4]byte
	CLKGATE_FORCE_ON         volatile.Register32 // 0xA8
	MEM_POWER_DOWN           volatile.Register32 // 0xAC
	MEM_POWER_UP             volatile.Register32 // 0xB0
	RETENTION_CTRL           volatile.Register32 // 0xB4
	RETENTION_CTRL1          volatile.Register32 // 0xB8
	RETENTION_CTRL2          volatile.Register32 // 0xBC
	RETENTION_CTRL3          volatile.Register32 // 0xC0
	RETENTION_CTRL4          volatile.Register32 // 0xC4
	RETENTION_CTRL5          volatile.Register32 // 0xC8
	_                        [816]byte
	DATE                     volatile.Register32 // 0x3FC
}

// APB_CTRL.SYSCLK_CONF: ******* Description ***********
func (o *APB_CTRL_Type) SetSYSCLK_CONF_PRE_DIV_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x3ff)|value)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_PRE_DIV_CNT() uint32 {
	return volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x3ff
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_CLK_320M_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x400)|value<<10)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_CLK_320M_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x400) >> 10
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x800)|value<<11)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x800) >> 11
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_RST_TICK_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_RST_TICK_CNT() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x1000) >> 12
}

// APB_CTRL.TICK_CONF: ******* Description ***********
func (o *APB_CTRL_Type) SetTICK_CONF_XTAL_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetTICK_CONF_XTAL_TICK_NUM() uint32 {
	return volatile.LoadUint32(&o.TICK_CONF.Reg) & 0xff
}
func (o *APB_CTRL_Type) SetTICK_CONF_CK8M_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0xff00)|value<<8)
}
func (o *APB_CTRL_Type) GetTICK_CONF_CK8M_TICK_NUM() uint32 {
	return (volatile.LoadUint32(&o.TICK_CONF.Reg) & 0xff00) >> 8
}
func (o *APB_CTRL_Type) SetTICK_CONF_TICK_ENABLE(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *APB_CTRL_Type) GetTICK_CONF_TICK_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.TICK_CONF.Reg) & 0x10000) >> 16
}

// APB_CTRL.CLK_OUT_EN: ******* Description ***********
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK20_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK20_OEN() uint32 {
	return volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK22_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK22_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK44_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x4)|value<<2)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK44_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x4) >> 2
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_BB_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x8)|value<<3)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_BB_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x8) >> 3
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK80_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x10)|value<<4)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK80_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x10) >> 4
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK160_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x20)|value<<5)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK160_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x20) >> 5
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_320M_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x40)|value<<6)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_320M_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x40) >> 6
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_ADC_INF_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x80)|value<<7)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_ADC_INF_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x80) >> 7
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_DAC_CPU_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x100)|value<<8)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_DAC_CPU_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x100) >> 8
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK40X_BB_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x200)|value<<9)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK40X_BB_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x200) >> 9
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_XTAL_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x400)|value<<10)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_XTAL_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x400) >> 10
}

// APB_CTRL.WIFI_BB_CFG: ******* Description ***********
func (o *APB_CTRL_Type) SetWIFI_BB_CFG(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_CFG.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_BB_CFG() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_CFG.Reg)
}

// APB_CTRL.WIFI_BB_CFG_2: ******* Description ***********
func (o *APB_CTRL_Type) SetWIFI_BB_CFG_2(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_CFG_2.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_BB_CFG_2() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_CFG_2.Reg)
}

// APB_CTRL.WIFI_CLK_EN: ******* Description ***********
func (o *APB_CTRL_Type) SetWIFI_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_CLK_EN.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.WIFI_CLK_EN.Reg)
}

// APB_CTRL.WIFI_RST_EN: ******* Description ***********
func (o *APB_CTRL_Type) SetWIFI_RST_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_RST_EN.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_RST_EN() uint32 {
	return volatile.LoadUint32(&o.WIFI_RST_EN.Reg)
}

// APB_CTRL.HOST_INF_SEL: ******* Description ***********
func (o *APB_CTRL_Type) SetHOST_INF_SEL_PERI_IO_SWAP(value uint32) {
	volatile.StoreUint32(&o.HOST_INF_SEL.Reg, volatile.LoadUint32(&o.HOST_INF_SEL.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetHOST_INF_SEL_PERI_IO_SWAP() uint32 {
	return volatile.LoadUint32(&o.HOST_INF_SEL.Reg) & 0xff
}

// APB_CTRL.EXT_MEM_PMS_LOCK: ******* Description ***********
func (o *APB_CTRL_Type) SetEXT_MEM_PMS_LOCK(value uint32) {
	volatile.StoreUint32(&o.EXT_MEM_PMS_LOCK.Reg, volatile.LoadUint32(&o.EXT_MEM_PMS_LOCK.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetEXT_MEM_PMS_LOCK() uint32 {
	return volatile.LoadUint32(&o.EXT_MEM_PMS_LOCK.Reg) & 0x1
}

// APB_CTRL.EXT_MEM_WRITEBACK_BYPASS: ******* Description ***********
func (o *APB_CTRL_Type) SetEXT_MEM_WRITEBACK_BYPASS_WRITEBACK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.EXT_MEM_WRITEBACK_BYPASS.Reg, volatile.LoadUint32(&o.EXT_MEM_WRITEBACK_BYPASS.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetEXT_MEM_WRITEBACK_BYPASS_WRITEBACK_BYPASS() uint32 {
	return volatile.LoadUint32(&o.EXT_MEM_WRITEBACK_BYPASS.Reg) & 0x1
}

// APB_CTRL.FLASH_ACE0_ATTR: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE0_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE0_ATTR.Reg)&^(0x1ff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_ATTR.Reg) & 0x1ff
}

// APB_CTRL.FLASH_ACE1_ATTR: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE1_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE1_ATTR.Reg)&^(0x1ff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_ATTR.Reg) & 0x1ff
}

// APB_CTRL.FLASH_ACE2_ATTR: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE2_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE2_ATTR.Reg)&^(0x1ff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_ATTR.Reg) & 0x1ff
}

// APB_CTRL.FLASH_ACE3_ATTR: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE3_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE3_ATTR.Reg)&^(0x1ff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_ATTR.Reg) & 0x1ff
}

// APB_CTRL.FLASH_ACE0_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE0_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE1_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE1_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE2_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE2_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE3_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE3_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE0_SIZE: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE0_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE0_SIZE.Reg)&^(0xffff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_SIZE.Reg) & 0xffff
}

// APB_CTRL.FLASH_ACE1_SIZE: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE1_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE1_SIZE.Reg)&^(0xffff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_SIZE.Reg) & 0xffff
}

// APB_CTRL.FLASH_ACE2_SIZE: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE2_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE2_SIZE.Reg)&^(0xffff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_SIZE.Reg) & 0xffff
}

// APB_CTRL.FLASH_ACE3_SIZE: ******* Description ***********
func (o *APB_CTRL_Type) SetFLASH_ACE3_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE3_SIZE.Reg)&^(0xffff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_SIZE.Reg) & 0xffff
}

// APB_CTRL.SRAM_ACE0_ATTR: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE0_ATTR(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE0_ATTR.Reg, volatile.LoadUint32(&o.SRAM_ACE0_ATTR.Reg)&^(0x1ff)|value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE0_ATTR() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE0_ATTR.Reg) & 0x1ff
}

// APB_CTRL.SRAM_ACE1_ATTR: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE1_ATTR(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE1_ATTR.Reg, volatile.LoadUint32(&o.SRAM_ACE1_ATTR.Reg)&^(0x1ff)|value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE1_ATTR() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE1_ATTR.Reg) & 0x1ff
}

// APB_CTRL.SRAM_ACE2_ATTR: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE2_ATTR(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE2_ATTR.Reg, volatile.LoadUint32(&o.SRAM_ACE2_ATTR.Reg)&^(0x1ff)|value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE2_ATTR() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE2_ATTR.Reg) & 0x1ff
}

// APB_CTRL.SRAM_ACE3_ATTR: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE3_ATTR(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE3_ATTR.Reg, volatile.LoadUint32(&o.SRAM_ACE3_ATTR.Reg)&^(0x1ff)|value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE3_ATTR() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE3_ATTR.Reg) & 0x1ff
}

// APB_CTRL.SRAM_ACE0_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE0_ADDR(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE0_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE0_ADDR() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE0_ADDR.Reg)
}

// APB_CTRL.SRAM_ACE1_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE1_ADDR(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE1_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE1_ADDR() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE1_ADDR.Reg)
}

// APB_CTRL.SRAM_ACE2_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE2_ADDR(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE2_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE2_ADDR() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE2_ADDR.Reg)
}

// APB_CTRL.SRAM_ACE3_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE3_ADDR(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE3_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE3_ADDR() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE3_ADDR.Reg)
}

// APB_CTRL.SRAM_ACE0_SIZE: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE0_SIZE(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE0_SIZE.Reg, volatile.LoadUint32(&o.SRAM_ACE0_SIZE.Reg)&^(0xffff)|value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE0_SIZE() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE0_SIZE.Reg) & 0xffff
}

// APB_CTRL.SRAM_ACE1_SIZE: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE1_SIZE(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE1_SIZE.Reg, volatile.LoadUint32(&o.SRAM_ACE1_SIZE.Reg)&^(0xffff)|value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE1_SIZE() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE1_SIZE.Reg) & 0xffff
}

// APB_CTRL.SRAM_ACE2_SIZE: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE2_SIZE(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE2_SIZE.Reg, volatile.LoadUint32(&o.SRAM_ACE2_SIZE.Reg)&^(0xffff)|value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE2_SIZE() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE2_SIZE.Reg) & 0xffff
}

// APB_CTRL.SRAM_ACE3_SIZE: ******* Description ***********
func (o *APB_CTRL_Type) SetSRAM_ACE3_SIZE(value uint32) {
	volatile.StoreUint32(&o.SRAM_ACE3_SIZE.Reg, volatile.LoadUint32(&o.SRAM_ACE3_SIZE.Reg)&^(0xffff)|value)
}
func (o *APB_CTRL_Type) GetSRAM_ACE3_SIZE() uint32 {
	return volatile.LoadUint32(&o.SRAM_ACE3_SIZE.Reg) & 0xffff
}

// APB_CTRL.SPI_MEM_PMS_CTRL: ******* Description ***********
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT() uint32 {
	return volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CDE(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x7c)|value<<2)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CDE() uint32 {
	return (volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x7c) >> 2
}

// APB_CTRL.SPI_MEM_REJECT_ADDR: ******* Description ***********
func (o *APB_CTRL_Type) SetSPI_MEM_REJECT_ADDR(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_REJECT_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetSPI_MEM_REJECT_ADDR() uint32 {
	return volatile.LoadUint32(&o.SPI_MEM_REJECT_ADDR.Reg)
}

// APB_CTRL.SDIO_CTRL: ******* Description ***********
func (o *APB_CTRL_Type) SetSDIO_CTRL_SDIO_WIN_ACCESS_EN(value uint32) {
	volatile.StoreUint32(&o.SDIO_CTRL.Reg, volatile.LoadUint32(&o.SDIO_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetSDIO_CTRL_SDIO_WIN_ACCESS_EN() uint32 {
	return volatile.LoadUint32(&o.SDIO_CTRL.Reg) & 0x1
}

// APB_CTRL.REDCY_SIG0: ******* Description ***********
func (o *APB_CTRL_Type) SetREDCY_SIG0(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG0.Reg, volatile.LoadUint32(&o.REDCY_SIG0.Reg)&^(0x7fffffff)|value)
}
func (o *APB_CTRL_Type) GetREDCY_SIG0() uint32 {
	return volatile.LoadUint32(&o.REDCY_SIG0.Reg) & 0x7fffffff
}
func (o *APB_CTRL_Type) SetREDCY_SIG0_REDCY_ANDOR(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG0.Reg, volatile.LoadUint32(&o.REDCY_SIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetREDCY_SIG0_REDCY_ANDOR() uint32 {
	return (volatile.LoadUint32(&o.REDCY_SIG0.Reg) & 0x80000000) >> 31
}

// APB_CTRL.REDCY_SIG1: ******* Description ***********
func (o *APB_CTRL_Type) SetREDCY_SIG1(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG1.Reg, volatile.LoadUint32(&o.REDCY_SIG1.Reg)&^(0x7fffffff)|value)
}
func (o *APB_CTRL_Type) GetREDCY_SIG1() uint32 {
	return volatile.LoadUint32(&o.REDCY_SIG1.Reg) & 0x7fffffff
}
func (o *APB_CTRL_Type) SetREDCY_SIG1_REDCY_NANDOR(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG1.Reg, volatile.LoadUint32(&o.REDCY_SIG1.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetREDCY_SIG1_REDCY_NANDOR() uint32 {
	return (volatile.LoadUint32(&o.REDCY_SIG1.Reg) & 0x80000000) >> 31
}

// APB_CTRL.FRONT_END_MEM_PD: ******* Description ***********
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_AGC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_AGC_MEM_FORCE_PU() uint32 {
	return volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_AGC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_AGC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x4)|value<<2)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x4) >> 2
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x8)|value<<3)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x8) >> 3
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_DC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x10)|value<<4)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_DC_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x10) >> 4
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_DC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x20)|value<<5)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_DC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x20) >> 5
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_FREQ_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x40)|value<<6)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_FREQ_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x40) >> 6
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_FREQ_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x80)|value<<7)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_FREQ_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x80) >> 7
}

// APB_CTRL.SPI_MEM_ECC_CTRL: ******* Description ***********
func (o *APB_CTRL_Type) SetSPI_MEM_ECC_CTRL_FLASH_PAGE_SIZE(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_ECC_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_ECC_CTRL.Reg)&^(0xc0000)|value<<18)
}
func (o *APB_CTRL_Type) GetSPI_MEM_ECC_CTRL_FLASH_PAGE_SIZE() uint32 {
	return (volatile.LoadUint32(&o.SPI_MEM_ECC_CTRL.Reg) & 0xc0000) >> 18
}
func (o *APB_CTRL_Type) SetSPI_MEM_ECC_CTRL_SRAM_PAGE_SIZE(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_ECC_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_ECC_CTRL.Reg)&^(0x300000)|value<<20)
}
func (o *APB_CTRL_Type) GetSPI_MEM_ECC_CTRL_SRAM_PAGE_SIZE() uint32 {
	return (volatile.LoadUint32(&o.SPI_MEM_ECC_CTRL.Reg) & 0x300000) >> 20
}

// APB_CTRL.CLKGATE_FORCE_ON: ******* Description ***********
func (o *APB_CTRL_Type) SetCLKGATE_FORCE_ON_ROM_CLKGATE_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLKGATE_FORCE_ON.Reg, volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg)&^(0x7)|value)
}
func (o *APB_CTRL_Type) GetCLKGATE_FORCE_ON_ROM_CLKGATE_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg) & 0x7
}
func (o *APB_CTRL_Type) SetCLKGATE_FORCE_ON_SRAM_CLKGATE_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLKGATE_FORCE_ON.Reg, volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg)&^(0x3ff8)|value<<3)
}
func (o *APB_CTRL_Type) GetCLKGATE_FORCE_ON_SRAM_CLKGATE_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg) & 0x3ff8) >> 3
}

// APB_CTRL.MEM_POWER_DOWN: ******* Description ***********
func (o *APB_CTRL_Type) SetMEM_POWER_DOWN_ROM_POWER_DOWN(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_DOWN.Reg, volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg)&^(0x7)|value)
}
func (o *APB_CTRL_Type) GetMEM_POWER_DOWN_ROM_POWER_DOWN() uint32 {
	return volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg) & 0x7
}
func (o *APB_CTRL_Type) SetMEM_POWER_DOWN_SRAM_POWER_DOWN(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_DOWN.Reg, volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg)&^(0x3ff8)|value<<3)
}
func (o *APB_CTRL_Type) GetMEM_POWER_DOWN_SRAM_POWER_DOWN() uint32 {
	return (volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg) & 0x3ff8) >> 3
}

// APB_CTRL.MEM_POWER_UP: ******* Description ***********
func (o *APB_CTRL_Type) SetMEM_POWER_UP_ROM_POWER_UP(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_UP.Reg, volatile.LoadUint32(&o.MEM_POWER_UP.Reg)&^(0x7)|value)
}
func (o *APB_CTRL_Type) GetMEM_POWER_UP_ROM_POWER_UP() uint32 {
	return volatile.LoadUint32(&o.MEM_POWER_UP.Reg) & 0x7
}
func (o *APB_CTRL_Type) SetMEM_POWER_UP_SRAM_POWER_UP(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_UP.Reg, volatile.LoadUint32(&o.MEM_POWER_UP.Reg)&^(0x3ff8)|value<<3)
}
func (o *APB_CTRL_Type) GetMEM_POWER_UP_SRAM_POWER_UP() uint32 {
	return (volatile.LoadUint32(&o.MEM_POWER_UP.Reg) & 0x3ff8) >> 3
}

// APB_CTRL.RETENTION_CTRL: ******* Description ***********
func (o *APB_CTRL_Type) SetRETENTION_CTRL_RETENTION_CPU_LINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RETENTION_CTRL.Reg)&^(0x7ffffff)|value)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL_RETENTION_CPU_LINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.RETENTION_CTRL.Reg) & 0x7ffffff
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL_NOBYPASS_CPU_ISO_RST(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RETENTION_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL_NOBYPASS_CPU_ISO_RST() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL.Reg) & 0x8000000) >> 27
}

// APB_CTRL.RETENTION_CTRL1: ******* Description ***********
func (o *APB_CTRL_Type) SetRETENTION_CTRL1_RETENTION_TAG_LINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL1.Reg, volatile.LoadUint32(&o.RETENTION_CTRL1.Reg)&^(0x7ffffff)|value)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL1_RETENTION_TAG_LINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.RETENTION_CTRL1.Reg) & 0x7ffffff
}

// APB_CTRL.RETENTION_CTRL2: ******* Description ***********
func (o *APB_CTRL_Type) SetRETENTION_CTRL2_RET_ICACHE_SIZE(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL2.Reg, volatile.LoadUint32(&o.RETENTION_CTRL2.Reg)&^(0xff0)|value<<4)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL2_RET_ICACHE_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL2.Reg) & 0xff0) >> 4
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL2_RET_ICACHE_VLD_SIZE(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL2.Reg, volatile.LoadUint32(&o.RETENTION_CTRL2.Reg)&^(0x1fe000)|value<<13)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL2_RET_ICACHE_VLD_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL2.Reg) & 0x1fe000) >> 13
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL2_RET_ICACHE_START_POINT(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL2.Reg, volatile.LoadUint32(&o.RETENTION_CTRL2.Reg)&^(0x3fc00000)|value<<22)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL2_RET_ICACHE_START_POINT() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL2.Reg) & 0x3fc00000) >> 22
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL2_RET_ICACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL2.Reg, volatile.LoadUint32(&o.RETENTION_CTRL2.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL2_RET_ICACHE_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL2.Reg) & 0x80000000) >> 31
}

// APB_CTRL.RETENTION_CTRL3: ******* Description ***********
func (o *APB_CTRL_Type) SetRETENTION_CTRL3_RET_DCACHE_SIZE(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL3.Reg, volatile.LoadUint32(&o.RETENTION_CTRL3.Reg)&^(0x1ff0)|value<<4)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL3_RET_DCACHE_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL3.Reg) & 0x1ff0) >> 4
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL3_RET_DCACHE_VLD_SIZE(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL3.Reg, volatile.LoadUint32(&o.RETENTION_CTRL3.Reg)&^(0x3fe000)|value<<13)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL3_RET_DCACHE_VLD_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL3.Reg) & 0x3fe000) >> 13
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL3_RET_DCACHE_START_POINT(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL3.Reg, volatile.LoadUint32(&o.RETENTION_CTRL3.Reg)&^(0x7fc00000)|value<<22)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL3_RET_DCACHE_START_POINT() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL3.Reg) & 0x7fc00000) >> 22
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL3_RET_DCACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL3.Reg, volatile.LoadUint32(&o.RETENTION_CTRL3.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL3_RET_DCACHE_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL3.Reg) & 0x80000000) >> 31
}

// APB_CTRL.RETENTION_CTRL4: ******* Description ***********
func (o *APB_CTRL_Type) SetRETENTION_CTRL4(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL4.Reg, value)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL4() uint32 {
	return volatile.LoadUint32(&o.RETENTION_CTRL4.Reg)
}

// APB_CTRL.RETENTION_CTRL5: ******* Description ***********
func (o *APB_CTRL_Type) SetRETENTION_CTRL5_RETENTION_DISABLE(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL5.Reg, volatile.LoadUint32(&o.RETENTION_CTRL5.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL5_RETENTION_DISABLE() uint32 {
	return volatile.LoadUint32(&o.RETENTION_CTRL5.Reg) & 0x1
}

// APB_CTRL.DATE: ******* Description ***********
func (o *APB_CTRL_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *APB_CTRL_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// SAR (Successive Approximation Register) Analog-to-Digital Converter
type APB_SARADC_Type struct {
	CTRL                    volatile.Register32 // 0x0
	CTRL2                   volatile.Register32 // 0x4
	FILTER_CTRL1            volatile.Register32 // 0x8
	FSM_WAIT                volatile.Register32 // 0xC
	SAR1_STATUS             volatile.Register32 // 0x10
	SAR2_STATUS             volatile.Register32 // 0x14
	SAR1_PATT_TAB1          volatile.Register32 // 0x18
	SAR1_PATT_TAB2          volatile.Register32 // 0x1C
	SAR1_PATT_TAB3          volatile.Register32 // 0x20
	SAR1_PATT_TAB4          volatile.Register32 // 0x24
	SAR2_PATT_TAB1          volatile.Register32 // 0x28
	SAR2_PATT_TAB2          volatile.Register32 // 0x2C
	SAR2_PATT_TAB3          volatile.Register32 // 0x30
	SAR2_PATT_TAB4          volatile.Register32 // 0x34
	ARB_CTRL                volatile.Register32 // 0x38
	FILTER_CTRL0            volatile.Register32 // 0x3C
	APB_SARADC1_DATA_STATUS volatile.Register32 // 0x40
	THRES0_CTRL             volatile.Register32 // 0x44
	THRES1_CTRL             volatile.Register32 // 0x48
	_                       [12]byte
	THRES_CTRL              volatile.Register32 // 0x58
	INT_ENA                 volatile.Register32 // 0x5C
	INT_RAW                 volatile.Register32 // 0x60
	INT_ST                  volatile.Register32 // 0x64
	INT_CLR                 volatile.Register32 // 0x68
	DMA_CONF                volatile.Register32 // 0x6C
	CLKM_CONF               volatile.Register32 // 0x70
	_                       [4]byte
	APB_SARADC2_DATA_STATUS volatile.Register32 // 0x78
	_                       [896]byte
	APB_CTRL_DATE           volatile.Register32 // 0x3FC
}

// APB_SARADC.CTRL: configure apb saradc controller
func (o *APB_SARADC_Type) SetCTRL_SARADC_START_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_START_FORCE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_START(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_START() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_WORK_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x18)|value<<3)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_WORK_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x18) >> 3
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_CLK_GATED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_CLK_GATED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f80)|value<<7)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x7f80) >> 7
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR1_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x78000)|value<<15)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR1_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x78000) >> 15
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR2_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x780000)|value<<19)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR2_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x780000) >> 19
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR1_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR1_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR2_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR2_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_DATA_SAR_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_DATA_SAR_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_DATA_TO_I2S(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_DATA_TO_I2S() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_XPD_SAR_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x18000000)|value<<27)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_XPD_SAR_FORCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x18000000) >> 27
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_WAIT_ARB_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_WAIT_ARB_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0000000) >> 30
}

// APB_SARADC.CTRL2: configure apb saradc controller
func (o *APB_SARADC_Type) SetCTRL2_SARADC_MEAS_NUM_LIMIT(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_MEAS_NUM_LIMIT() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_MAX_MEAS_NUM(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1fe)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_MAX_MEAS_NUM() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1fe) >> 1
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_SAR1_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x200)|value<<9)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_SAR1_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x200) >> 9
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_SAR2_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x400)|value<<10)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_SAR2_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x400) >> 10
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x800)|value<<11)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x800) >> 11
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_TARGET(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xfff000)|value<<12)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_TARGET() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xfff000) >> 12
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1000000)|value<<24)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1000000) >> 24
}

// APB_SARADC.FILTER_CTRL1: configure saradc filter
func (o *APB_SARADC_Type) SetFILTER_CTRL1_FILTER_FACTOR1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0x1c000000)|value<<26)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL1_FILTER_FACTOR1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0x1c000000) >> 26
}
func (o *APB_SARADC_Type) SetFILTER_CTRL1_FILTER_FACTOR0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0xe0000000)|value<<29)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL1_FILTER_FACTOR0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0xe0000000) >> 29
}

// APB_SARADC.FSM_WAIT: configure apb saradc fsm
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_RSTB_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff00)|value<<8)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_RSTB_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff00) >> 8
}
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_STANDBY_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff0000)|value<<16)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_STANDBY_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff0000) >> 16
}

// APB_SARADC.SAR1_STATUS: saradc1 status for debug
func (o *APB_SARADC_Type) SetSAR1_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR1_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR1_STATUS.Reg)
}

// APB_SARADC.SAR2_STATUS: saradc2 status for debug
func (o *APB_SARADC_Type) SetSAR2_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR2_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR2_STATUS.Reg)
}

// APB_SARADC.SAR1_PATT_TAB1: configure apb saradc pattern table
func (o *APB_SARADC_Type) SetSAR1_PATT_TAB1_SARADC_SAR1_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB1.Reg, volatile.LoadUint32(&o.SAR1_PATT_TAB1.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR1_PATT_TAB1_SARADC_SAR1_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB1.Reg) & 0xffffff
}

// APB_SARADC.SAR1_PATT_TAB2: configure apb saradc pattern table
func (o *APB_SARADC_Type) SetSAR1_PATT_TAB2_SARADC_SAR1_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB2.Reg, volatile.LoadUint32(&o.SAR1_PATT_TAB2.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR1_PATT_TAB2_SARADC_SAR1_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB2.Reg) & 0xffffff
}

// APB_SARADC.SAR1_PATT_TAB3: configure apb saradc pattern table
func (o *APB_SARADC_Type) SetSAR1_PATT_TAB3_SARADC_SAR1_PATT_TAB3(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB3.Reg, volatile.LoadUint32(&o.SAR1_PATT_TAB3.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR1_PATT_TAB3_SARADC_SAR1_PATT_TAB3() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB3.Reg) & 0xffffff
}

// APB_SARADC.SAR1_PATT_TAB4: configure apb saradc pattern table
func (o *APB_SARADC_Type) SetSAR1_PATT_TAB4_SARADC_SAR1_PATT_TAB4(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB4.Reg, volatile.LoadUint32(&o.SAR1_PATT_TAB4.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR1_PATT_TAB4_SARADC_SAR1_PATT_TAB4() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB4.Reg) & 0xffffff
}

// APB_SARADC.SAR2_PATT_TAB1: configure apb saradc pattern table
func (o *APB_SARADC_Type) SetSAR2_PATT_TAB1_SARADC_SAR2_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB1.Reg, volatile.LoadUint32(&o.SAR2_PATT_TAB1.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR2_PATT_TAB1_SARADC_SAR2_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB1.Reg) & 0xffffff
}

// APB_SARADC.SAR2_PATT_TAB2: configure apb saradc pattern table
func (o *APB_SARADC_Type) SetSAR2_PATT_TAB2_SARADC_SAR2_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB2.Reg, volatile.LoadUint32(&o.SAR2_PATT_TAB2.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR2_PATT_TAB2_SARADC_SAR2_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB2.Reg) & 0xffffff
}

// APB_SARADC.SAR2_PATT_TAB3: configure apb saradc pattern table
func (o *APB_SARADC_Type) SetSAR2_PATT_TAB3_SARADC_SAR2_PATT_TAB3(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB3.Reg, volatile.LoadUint32(&o.SAR2_PATT_TAB3.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR2_PATT_TAB3_SARADC_SAR2_PATT_TAB3() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB3.Reg) & 0xffffff
}

// APB_SARADC.SAR2_PATT_TAB4: configure apb saradc pattern table
func (o *APB_SARADC_Type) SetSAR2_PATT_TAB4_SARADC_SAR2_PATT_TAB4(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB4.Reg, volatile.LoadUint32(&o.SAR2_PATT_TAB4.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR2_PATT_TAB4_SARADC_SAR2_PATT_TAB4() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB4.Reg) & 0xffffff
}

// APB_SARADC.ARB_CTRL: configure apb saradc arbit
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_APB_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_APB_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x4) >> 2
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_RTC_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_RTC_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x8) >> 3
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_WIFI_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_WIFI_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x10) >> 4
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_GRANT_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_GRANT_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x20) >> 5
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_APB_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_APB_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc0) >> 6
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_RTC_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_RTC_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x300) >> 8
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_WIFI_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_WIFI_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc00) >> 10
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_FIX_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_FIX_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x1000) >> 12
}

// APB_SARADC.FILTER_CTRL0: configure apb saradc arbit
func (o *APB_SARADC_Type) SetFILTER_CTRL0_FILTER_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x7c000)|value<<14)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_FILTER_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x7c000) >> 14
}
func (o *APB_SARADC_Type) SetFILTER_CTRL0_FILTER_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0xf80000)|value<<19)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_FILTER_CHANNEL0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0xf80000) >> 19
}
func (o *APB_SARADC_Type) SetFILTER_CTRL0_FILTER_RESET(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_FILTER_RESET() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x80000000) >> 31
}

// APB_SARADC.APB_SARADC1_DATA_STATUS: get apb saradc sample data
func (o *APB_SARADC_Type) SetAPB_SARADC1_DATA_STATUS_APB_SARADC1_DATA(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC1_DATA_STATUS.Reg, volatile.LoadUint32(&o.APB_SARADC1_DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetAPB_SARADC1_DATA_STATUS_APB_SARADC1_DATA() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC1_DATA_STATUS.Reg) & 0x1ffff
}

// APB_SARADC.THRES0_CTRL: configure apb saradc thres monitor
func (o *APB_SARADC_Type) SetTHRES0_CTRL_THRES0_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x1f)|value)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_THRES0_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x1f
}
func (o *APB_SARADC_Type) SetTHRES0_CTRL_THRES0_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_THRES0_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *APB_SARADC_Type) SetTHRES0_CTRL_THRES0_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_THRES0_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x7ffc0000) >> 18
}

// APB_SARADC.THRES1_CTRL: configure apb saradc thres monitor
func (o *APB_SARADC_Type) SetTHRES1_CTRL_THRES1_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x1f)|value)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_THRES1_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x1f
}
func (o *APB_SARADC_Type) SetTHRES1_CTRL_THRES1_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_THRES1_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *APB_SARADC_Type) SetTHRES1_CTRL_THRES1_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_THRES1_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x7ffc0000) >> 18
}

// APB_SARADC.THRES_CTRL: configure thres monitor enable
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES_ALL_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES_ALL_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES3_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES3_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES2_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES2_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES1_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES1_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES0_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES0_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ENA: enable interrupt
func (o *APB_SARADC_Type) SetINT_ENA_THRES1_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_ENA_THRES1_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_ENA_THRES0_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_ENA_THRES0_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_ENA_THRES1_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ENA_THRES1_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ENA_THRES0_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ENA_THRES0_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC2_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC2_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC1_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC1_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_RAW: raw of interrupt
func (o *APB_SARADC_Type) SetINT_RAW_THRES1_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_RAW_THRES1_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_RAW_THRES0_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_RAW_THRES0_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_RAW_THRES1_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_RAW_THRES1_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_RAW_THRES0_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_RAW_THRES0_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC2_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC2_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC1_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC1_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ST: state of interrupt
func (o *APB_SARADC_Type) SetINT_ST_THRES1_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_ST_THRES1_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_ST_THRES0_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_ST_THRES0_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_ST_THRES1_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ST_THRES1_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ST_THRES0_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ST_THRES0_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC2_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC2_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC1_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC1_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_CLR: clear interrupt
func (o *APB_SARADC_Type) SetINT_CLR_THRES1_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_CLR_THRES1_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_CLR_THRES0_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_CLR_THRES0_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_CLR_THRES1_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_CLR_THRES1_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_CLR_THRES0_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_CLR_THRES0_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC2_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC2_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC1_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC1_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// APB_SARADC.DMA_CONF: configure apb saradc dma
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_EOF_NUM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0xffff)|value)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_EOF_NUM() uint32 {
	return volatile.LoadUint32(&o.DMA_CONF.Reg) & 0xffff
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_RESET_FSM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_RESET_FSM() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_TRANS(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_TRANS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x80000000) >> 31
}

// APB_SARADC.CLKM_CONF: configure apb saradc clock
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x3f00) >> 8
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xfc000) >> 14
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x100000) >> 20
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x600000)|value<<21)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x600000) >> 21
}

// APB_SARADC.APB_SARADC2_DATA_STATUS: get apb saradc2 sample data
func (o *APB_SARADC_Type) SetAPB_SARADC2_DATA_STATUS_APB_SARADC2_DATA(value uint32) {
	volatile.StoreUint32(&o.APB_SARADC2_DATA_STATUS.Reg, volatile.LoadUint32(&o.APB_SARADC2_DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetAPB_SARADC2_DATA_STATUS_APB_SARADC2_DATA() uint32 {
	return volatile.LoadUint32(&o.APB_SARADC2_DATA_STATUS.Reg) & 0x1ffff
}

// APB_SARADC.APB_CTRL_DATE: version
func (o *APB_SARADC_Type) SetAPB_CTRL_DATE(value uint32) {
	volatile.StoreUint32(&o.APB_CTRL_DATE.Reg, value)
}
func (o *APB_SARADC_Type) GetAPB_CTRL_DATE() uint32 {
	return volatile.LoadUint32(&o.APB_CTRL_DATE.Reg)
}

// BB Peripheral
type BB_Type struct {
	_         [84]byte
	BBPD_CTRL volatile.Register32 // 0x54
}

// BB.BBPD_CTRL: Baseband control register
func (o *BB_Type) SetBBPD_CTRL_DC_EST_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x1)|value)
}
func (o *BB_Type) GetBBPD_CTRL_DC_EST_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x1
}
func (o *BB_Type) SetBBPD_CTRL_DC_EST_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *BB_Type) GetBBPD_CTRL_DC_EST_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x2) >> 1
}
func (o *BB_Type) SetBBPD_CTRL_FFT_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *BB_Type) GetBBPD_CTRL_FFT_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x4) >> 2
}
func (o *BB_Type) SetBBPD_CTRL_FFT_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *BB_Type) GetBBPD_CTRL_FFT_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x8) >> 3
}

// Debug Assist
type DEBUG_ASSIST_Type struct {
	CORE_0_MONTR_ENA                       volatile.Register32 // 0x0
	CORE_0_INTR_RAW                        volatile.Register32 // 0x4
	CORE_0_INTR_ENA                        volatile.Register32 // 0x8
	CORE_0_INTR_CLR                        volatile.Register32 // 0xC
	CORE_0_AREA_DRAM0_0_MIN                volatile.Register32 // 0x10
	CORE_0_AREA_DRAM0_0_MAX                volatile.Register32 // 0x14
	CORE_0_AREA_DRAM0_1_MIN                volatile.Register32 // 0x18
	CORE_0_AREA_DRAM0_1_MAX                volatile.Register32 // 0x1C
	CORE_0_AREA_PIF_0_MIN                  volatile.Register32 // 0x20
	CORE_0_AREA_PIF_0_MAX                  volatile.Register32 // 0x24
	CORE_0_AREA_PIF_1_MIN                  volatile.Register32 // 0x28
	CORE_0_AREA_PIF_1_MAX                  volatile.Register32 // 0x2C
	CORE_0_AREA_SP                         volatile.Register32 // 0x30
	CORE_0_AREA_PC                         volatile.Register32 // 0x34
	CORE_0_SP_UNSTABLE                     volatile.Register32 // 0x38
	CORE_0_SP_MIN                          volatile.Register32 // 0x3C
	CORE_0_SP_MAX                          volatile.Register32 // 0x40
	CORE_0_SP_PC                           volatile.Register32 // 0x44
	CORE_0_RCD_PDEBUGENABLE                volatile.Register32 // 0x48
	CORE_0_RCD_RECORDING                   volatile.Register32 // 0x4C
	CORE_0_RCD_PDEBUGINST                  volatile.Register32 // 0x50
	CORE_0_RCD_PDEBUGSTATUS                volatile.Register32 // 0x54
	CORE_0_RCD_PDEBUGDATA                  volatile.Register32 // 0x58
	CORE_0_RCD_PDEBUGPC                    volatile.Register32 // 0x5C
	CORE_0_RCD_PDEBUGLS0STAT               volatile.Register32 // 0x60
	CORE_0_RCD_PDEBUGLS0ADDR               volatile.Register32 // 0x64
	CORE_0_RCD_PDEBUGLS0DATA               volatile.Register32 // 0x68
	CORE_0_RCD_SP                          volatile.Register32 // 0x6C
	CORE_0_IRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x70
	CORE_0_IRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x74
	CORE_0_DRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x78
	CORE_0_DRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x7C
	CORE_0_DRAM0_EXCEPTION_MONITOR_2       volatile.Register32 // 0x80
	CORE_0_DRAM0_EXCEPTION_MONITOR_3       volatile.Register32 // 0x84
	CORE_0_DRAM0_EXCEPTION_MONITOR_4       volatile.Register32 // 0x88
	CORE_0_DRAM0_EXCEPTION_MONITOR_5       volatile.Register32 // 0x8C
	CORE_1_MONTR_ENA                       volatile.Register32 // 0x90
	CORE_1_INTR_RAW                        volatile.Register32 // 0x94
	CORE_1_INTR_ENA                        volatile.Register32 // 0x98
	CORE_1_INTR_CLR                        volatile.Register32 // 0x9C
	CORE_1_AREA_DRAM0_0_MIN                volatile.Register32 // 0xA0
	CORE_1_AREA_DRAM0_0_MAX                volatile.Register32 // 0xA4
	CORE_1_AREA_DRAM0_1_MIN                volatile.Register32 // 0xA8
	CORE_1_AREA_DRAM0_1_MAX                volatile.Register32 // 0xAC
	CORE_1_AREA_PIF_0_MIN                  volatile.Register32 // 0xB0
	CORE_1_AREA_PIF_0_MAX                  volatile.Register32 // 0xB4
	CORE_1_AREA_PIF_1_MIN                  volatile.Register32 // 0xB8
	CORE_1_AREA_PIF_1_MAX                  volatile.Register32 // 0xBC
	CORE_1_AREA_PC                         volatile.Register32 // 0xC0
	CORE_1_AREA_SP                         volatile.Register32 // 0xC4
	CORE_1_SP_UNSTABLE                     volatile.Register32 // 0xC8
	CORE_1_SP_MIN                          volatile.Register32 // 0xCC
	CORE_1_SP_MAX                          volatile.Register32 // 0xD0
	CORE_1_SP_PC                           volatile.Register32 // 0xD4
	CORE_1_RCD_PDEBUGENABLE                volatile.Register32 // 0xD8
	CORE_1_RCD_RECORDING                   volatile.Register32 // 0xDC
	CORE_1_RCD_PDEBUGINST                  volatile.Register32 // 0xE0
	CORE_1_RCD_PDEBUGSTATUS                volatile.Register32 // 0xE4
	CORE_1_RCD_PDEBUGDATA                  volatile.Register32 // 0xE8
	CORE_1_RCD_PDEBUGPC                    volatile.Register32 // 0xEC
	CORE_1_RCD_PDEBUGLS0STAT               volatile.Register32 // 0xF0
	CORE_1_RCD_PDEBUGLS0ADDR               volatile.Register32 // 0xF4
	CORE_1_RCD_PDEBUGLS0DATA               volatile.Register32 // 0xF8
	CORE_1_RCD_SP                          volatile.Register32 // 0xFC
	CORE_1_IRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x100
	CORE_1_IRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x104
	CORE_1_DRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x108
	CORE_1_DRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x10C
	CORE_1_DRAM0_EXCEPTION_MONITOR_2       volatile.Register32 // 0x110
	CORE_1_DRAM0_EXCEPTION_MONITOR_3       volatile.Register32 // 0x114
	CORE_1_DRAM0_EXCEPTION_MONITOR_4       volatile.Register32 // 0x118
	CORE_1_DRAM0_EXCEPTION_MONITOR_5       volatile.Register32 // 0x11C
	CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0 volatile.Register32 // 0x120
	CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1 volatile.Register32 // 0x124
	LOG_SETTING                            volatile.Register32 // 0x128
	LOG_DATA_0                             volatile.Register32 // 0x12C
	LOG_DATA_1                             volatile.Register32 // 0x130
	LOG_DATA_2                             volatile.Register32 // 0x134
	LOG_DATA_3                             volatile.Register32 // 0x138
	LOG_DATA_MASK                          volatile.Register32 // 0x13C
	LOG_MIN                                volatile.Register32 // 0x140
	LOG_MAX                                volatile.Register32 // 0x144
	LOG_MEM_START                          volatile.Register32 // 0x148
	LOG_MEM_END                            volatile.Register32 // 0x14C
	LOG_MEM_WRITING_ADDR                   volatile.Register32 // 0x150
	LOG_MEM_FULL_FLAG                      volatile.Register32 // 0x154
	_                                      [164]byte
	DATE                                   volatile.Register32 // 0x1FC
}

// DEBUG_ASSIST.CORE_0_MONTR_ENA: core0 monitor enable configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_RD_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x1
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x2) >> 1
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x4) >> 2
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x8) >> 3
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_0_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x10) >> 4
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x20) >> 5
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x40) >> 6
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x80) >> 7
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MIN_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MIN_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x100) >> 8
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MAX_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MAX_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x200) >> 9
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x400) >> 10
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_MONTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_MONTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x800) >> 11
}

// DEBUG_ASSIST.CORE_0_INTR_RAW: core0 monitor interrupt status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_RD_RAW() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x1
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x2)|value<<1)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x2) >> 1
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x4)|value<<2)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x4) >> 2
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x8)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x8) >> 3
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x10)|value<<4)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x10) >> 4
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x20)|value<<5)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x20) >> 5
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x40) >> 6
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x80)|value<<7)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x80) >> 7
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x100)|value<<8)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x100) >> 8
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x200)|value<<9)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x200) >> 9
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_IRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x400)|value<<10)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_IRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x400) >> 10
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_RAW_CORE_0_DRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x800)|value<<11)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_RAW_CORE_0_DRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x800) >> 11
}

// DEBUG_ASSIST.CORE_0_INTR_ENA: core0 monitor interrupt enable register
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_RD_INTR_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x1
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x2) >> 1
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x4) >> 2
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x8) >> 3
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x10) >> 4
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x20) >> 5
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x40) >> 6
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x80) >> 7
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x100) >> 8
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x200) >> 9
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x400) >> 10
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x800) >> 11
}

// DEBUG_ASSIST.CORE_0_INTR_CLR: core0 monitor interrupt clr register
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_RD_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x1
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x2)|value<<1)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x2) >> 1
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x4)|value<<2)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x4) >> 2
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x8)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x8) >> 3
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x10)|value<<4)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x10) >> 4
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x20)|value<<5)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x20) >> 5
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x40) >> 6
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x80)|value<<7)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x80) >> 7
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x100)|value<<8)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x100) >> 8
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x200)|value<<9)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x200) >> 9
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_IRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x400)|value<<10)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_IRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x400) >> 10
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_INTR_CLR_CORE_0_DRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x800)|value<<11)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_INTR_CLR_CORE_0_DRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x800) >> 11
}

// DEBUG_ASSIST.CORE_0_AREA_DRAM0_0_MIN: core0 dram0 region0 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_DRAM0_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_0_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_DRAM0_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_0_MIN.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_DRAM0_0_MAX: core0 dram0 region0 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_DRAM0_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_0_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_DRAM0_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_0_MAX.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_DRAM0_1_MIN: core0 dram0 region1 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_DRAM0_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_1_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_DRAM0_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_1_MIN.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_DRAM0_1_MAX: core0 dram0 region1 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_DRAM0_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_1_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_DRAM0_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_1_MAX.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_PIF_0_MIN: core0 PIF region0 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_PIF_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_0_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_PIF_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_0_MIN.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_PIF_0_MAX: core0 PIF region0 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_PIF_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_0_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_PIF_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_0_MAX.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_PIF_1_MIN: core0 PIF region1 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_PIF_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_1_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_PIF_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_1_MIN.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_PIF_1_MAX: core0 PIF region1 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_PIF_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_1_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_PIF_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_1_MAX.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_SP: core0 area sp status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_SP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_SP.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_SP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_SP.Reg)
}

// DEBUG_ASSIST.CORE_0_AREA_PC: core0 area pc status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_AREA_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PC.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_AREA_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PC.Reg)
}

// DEBUG_ASSIST.CORE_0_SP_UNSTABLE: core0 sp unstable configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_SP_UNSTABLE(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_UNSTABLE.Reg, volatile.LoadUint32(&o.CORE_0_SP_UNSTABLE.Reg)&^(0xff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_SP_UNSTABLE() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_UNSTABLE.Reg) & 0xff
}

// DEBUG_ASSIST.CORE_0_SP_MIN: core0 sp region configuration regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_SP_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_SP_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MIN.Reg)
}

// DEBUG_ASSIST.CORE_0_SP_MAX: core0 sp region configuration regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_SP_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_SP_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MAX.Reg)
}

// DEBUG_ASSIST.CORE_0_SP_PC: core0 sp pc status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_SP_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_PC.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_SP_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_PC.Reg)
}

// DEBUG_ASSIST.CORE_0_RCD_PDEBUGENABLE: core0 pdebug configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_PDEBUGENABLE(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGENABLE.Reg, volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGENABLE.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_PDEBUGENABLE() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGENABLE.Reg) & 0x1
}

// DEBUG_ASSIST.CORE_0_RCD_RECORDING: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_RECORDING(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_RECORDING.Reg, volatile.LoadUint32(&o.CORE_0_RCD_RECORDING.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_RECORDING() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_RECORDING.Reg) & 0x1
}

// DEBUG_ASSIST.CORE_0_RCD_PDEBUGINST: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_PDEBUGINST(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGINST.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_PDEBUGINST() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGINST.Reg)
}

// DEBUG_ASSIST.CORE_0_RCD_PDEBUGSTATUS: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_PDEBUGSTATUS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGSTATUS.Reg, volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGSTATUS.Reg)&^(0xff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_PDEBUGSTATUS() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGSTATUS.Reg) & 0xff
}

// DEBUG_ASSIST.CORE_0_RCD_PDEBUGDATA: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_PDEBUGDATA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGDATA.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_PDEBUGDATA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGDATA.Reg)
}

// DEBUG_ASSIST.CORE_0_RCD_PDEBUGPC: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGPC.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGPC.Reg)
}

// DEBUG_ASSIST.CORE_0_RCD_PDEBUGLS0STAT: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_PDEBUGLS0STAT(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGLS0STAT.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_PDEBUGLS0STAT() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGLS0STAT.Reg)
}

// DEBUG_ASSIST.CORE_0_RCD_PDEBUGLS0ADDR: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_PDEBUGLS0ADDR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGLS0ADDR.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_PDEBUGLS0ADDR() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGLS0ADDR.Reg)
}

// DEBUG_ASSIST.CORE_0_RCD_PDEBUGLS0DATA: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_PDEBUGLS0DATA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGLS0DATA.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_PDEBUGLS0DATA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGLS0DATA.Reg)
}

// DEBUG_ASSIST.CORE_0_RCD_SP: core0 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_0_RCD_SP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_SP.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_RCD_SP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_SP.Reg)
}

// DEBUG_ASSIST.CORE_0_IRAM0_EXCEPTION_MONITOR_0: core0 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xffffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0xffffff
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1000000)|value<<24)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1000000) >> 24
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_LOADSTORE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x2000000)|value<<25)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_LOADSTORE_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x2000000) >> 25
}

// DEBUG_ASSIST.CORE_0_IRAM0_EXCEPTION_MONITOR_1: core0 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffffff
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x1000000)|value<<24)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x1000000) >> 24
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_LOADSTORE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x2000000)|value<<25)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_LOADSTORE_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x2000000) >> 25
}

// DEBUG_ASSIST.CORE_0_DRAM0_EXCEPTION_MONITOR_0: core0 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x3fffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x3fffff
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x400000)|value<<22)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x400000) >> 22
}

// DEBUG_ASSIST.CORE_0_DRAM0_EXCEPTION_MONITOR_1: core0 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_1_CORE_0_DRAM0_RECORDING_BYTEEN_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_1_CORE_0_DRAM0_RECORDING_BYTEEN_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffff
}

// DEBUG_ASSIST.CORE_0_DRAM0_EXCEPTION_MONITOR_2: core0 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_2(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_2() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg)
}

// DEBUG_ASSIST.CORE_0_DRAM0_EXCEPTION_MONITOR_3: core0 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_3_CORE_0_DRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg)&^(0x3fffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_3_CORE_0_DRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg) & 0x3fffff
}
func (o *DEBUG_ASSIST_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_3_CORE_0_DRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg)&^(0x400000)|value<<22)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_3_CORE_0_DRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg) & 0x400000) >> 22
}

// DEBUG_ASSIST.CORE_0_DRAM0_EXCEPTION_MONITOR_4: core0 bus busy configuration regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_4_CORE_0_DRAM0_RECORDING_BYTEEN_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_4.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_4.Reg)&^(0xffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_4_CORE_0_DRAM0_RECORDING_BYTEEN_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_4.Reg) & 0xffff
}

// DEBUG_ASSIST.CORE_0_DRAM0_EXCEPTION_MONITOR_5: core0 bus busy configuration regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_5(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_5.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_5() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_5.Reg)
}

// DEBUG_ASSIST.CORE_1_MONTR_ENA: Core1 monitor enable configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_AREA_DRAM0_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_AREA_DRAM0_0_RD_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x1
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_AREA_DRAM0_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_AREA_DRAM0_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x2) >> 1
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_AREA_DRAM0_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_AREA_DRAM0_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x4) >> 2
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_AREA_DRAM0_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_AREA_DRAM0_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x8) >> 3
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_AREA_PIF_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_AREA_PIF_0_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x10) >> 4
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_AREA_PIF_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_AREA_PIF_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x20) >> 5
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_AREA_PIF_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_AREA_PIF_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x40) >> 6
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_AREA_PIF_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_AREA_PIF_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x80) >> 7
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_SP_SPILL_MIN_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_SP_SPILL_MIN_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x100) >> 8
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_SP_SPILL_MAX_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_SP_SPILL_MAX_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x200) >> 9
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_IRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_IRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x400) >> 10
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_MONTR_ENA_CORE_1_DRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_MONTR_ENA_CORE_1_DRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_MONTR_ENA.Reg) & 0x800) >> 11
}

// DEBUG_ASSIST.CORE_1_INTR_RAW: Core1 monitor interrupt status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_0_RD_RAW() uint32 {
	return volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x1
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x2)|value<<1)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x2) >> 1
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x4)|value<<2)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x4) >> 2
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x8)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x8) >> 3
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_PIF_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x10)|value<<4)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_PIF_0_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x10) >> 4
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_PIF_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x20)|value<<5)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_PIF_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x20) >> 5
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_PIF_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_PIF_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x40) >> 6
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_PIF_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x80)|value<<7)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_PIF_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x80) >> 7
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_SP_SPILL_MIN_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x100)|value<<8)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_SP_SPILL_MIN_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x100) >> 8
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_SP_SPILL_MAX_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x200)|value<<9)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_SP_SPILL_MAX_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x200) >> 9
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_IRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x400)|value<<10)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_IRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x400) >> 10
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_RAW_CORE_1_DRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x800)|value<<11)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_RAW_CORE_1_DRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x800) >> 11
}

// DEBUG_ASSIST.CORE_1_INTR_ENA: Core1 monitor interrupt enable register
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_0_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_0_RD_INTR_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x1
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_0_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_0_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x2) >> 1
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_1_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_1_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x4) >> 2
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_1_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_1_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x8) >> 3
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_PIF_0_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_PIF_0_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x10) >> 4
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_PIF_0_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_PIF_0_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x20) >> 5
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_PIF_1_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_PIF_1_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x40) >> 6
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_PIF_1_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_PIF_1_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x80) >> 7
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_SP_SPILL_MIN_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_SP_SPILL_MIN_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x100) >> 8
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_SP_SPILL_MAX_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_SP_SPILL_MAX_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x200) >> 9
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_IRAM0_EXCEPTION_MONITOR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_IRAM0_EXCEPTION_MONITOR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x400) >> 10
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_ENA_CORE_1_DRAM0_EXCEPTION_MONITOR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_ENA_CORE_1_DRAM0_EXCEPTION_MONITOR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x800) >> 11
}

// DEBUG_ASSIST.CORE_1_INTR_CLR: Core1 monitor interrupt clr register
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_0_RD_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x1
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x2)|value<<1)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x2) >> 1
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x4)|value<<2)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x4) >> 2
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x8)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x8) >> 3
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_PIF_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x10)|value<<4)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_PIF_0_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x10) >> 4
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_PIF_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x20)|value<<5)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_PIF_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x20) >> 5
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_PIF_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_PIF_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x40) >> 6
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_PIF_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x80)|value<<7)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_PIF_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x80) >> 7
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_SP_SPILL_MIN_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x100)|value<<8)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_SP_SPILL_MIN_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x100) >> 8
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_SP_SPILL_MAX_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x200)|value<<9)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_SP_SPILL_MAX_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x200) >> 9
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_IRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x400)|value<<10)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_IRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x400) >> 10
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_INTR_CLR_CORE_1_DRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x800)|value<<11)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_INTR_CLR_CORE_1_DRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x800) >> 11
}

// DEBUG_ASSIST.CORE_1_AREA_DRAM0_0_MIN: Core1 dram0 region0 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_DRAM0_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_DRAM0_0_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_DRAM0_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_DRAM0_0_MIN.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_DRAM0_0_MAX: Core1 dram0 region0 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_DRAM0_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_DRAM0_0_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_DRAM0_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_DRAM0_0_MAX.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_DRAM0_1_MIN: Core1 dram0 region1 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_DRAM0_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_DRAM0_1_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_DRAM0_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_DRAM0_1_MIN.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_DRAM0_1_MAX: Core1 dram0 region1 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_DRAM0_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_DRAM0_1_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_DRAM0_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_DRAM0_1_MAX.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_PIF_0_MIN: Core1 PIF region0 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_PIF_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PIF_0_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_PIF_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PIF_0_MIN.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_PIF_0_MAX: Core1 PIF region0 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_PIF_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PIF_0_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_PIF_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PIF_0_MAX.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_PIF_1_MIN: Core1 PIF region1 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_PIF_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PIF_1_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_PIF_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PIF_1_MIN.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_PIF_1_MAX: Core1 PIF region1 addr configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_PIF_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PIF_1_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_PIF_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PIF_1_MAX.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_PC: Core1 area sp status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PC.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PC.Reg)
}

// DEBUG_ASSIST.CORE_1_AREA_SP: Core1 area pc status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_AREA_SP(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_SP.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_AREA_SP() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_SP.Reg)
}

// DEBUG_ASSIST.CORE_1_SP_UNSTABLE: Core1 sp unstable configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_SP_UNSTABLE(value uint32) {
	volatile.StoreUint32(&o.CORE_1_SP_UNSTABLE.Reg, volatile.LoadUint32(&o.CORE_1_SP_UNSTABLE.Reg)&^(0xff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_SP_UNSTABLE() uint32 {
	return volatile.LoadUint32(&o.CORE_1_SP_UNSTABLE.Reg) & 0xff
}

// DEBUG_ASSIST.CORE_1_SP_MIN: Core1 sp region configuration regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_SP_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_SP_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_SP_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_SP_MIN.Reg)
}

// DEBUG_ASSIST.CORE_1_SP_MAX: Core1 sp region configuration regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_SP_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_SP_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_SP_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_SP_MAX.Reg)
}

// DEBUG_ASSIST.CORE_1_SP_PC: Core1 sp pc status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_SP_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_1_SP_PC.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_SP_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_1_SP_PC.Reg)
}

// DEBUG_ASSIST.CORE_1_RCD_PDEBUGENABLE: Core1 pdebug configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_PDEBUGENABLE(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGENABLE.Reg, volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGENABLE.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_PDEBUGENABLE() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGENABLE.Reg) & 0x1
}

// DEBUG_ASSIST.CORE_1_RCD_RECORDING: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_RECORDING(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_RECORDING.Reg, volatile.LoadUint32(&o.CORE_1_RCD_RECORDING.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_RECORDING() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_RECORDING.Reg) & 0x1
}

// DEBUG_ASSIST.CORE_1_RCD_PDEBUGINST: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_PDEBUGINST(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGINST.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_PDEBUGINST() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGINST.Reg)
}

// DEBUG_ASSIST.CORE_1_RCD_PDEBUGSTATUS: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_PDEBUGSTATUS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGSTATUS.Reg, volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGSTATUS.Reg)&^(0xff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_PDEBUGSTATUS() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGSTATUS.Reg) & 0xff
}

// DEBUG_ASSIST.CORE_1_RCD_PDEBUGDATA: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_PDEBUGDATA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGDATA.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_PDEBUGDATA() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGDATA.Reg)
}

// DEBUG_ASSIST.CORE_1_RCD_PDEBUGPC: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGPC.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGPC.Reg)
}

// DEBUG_ASSIST.CORE_1_RCD_PDEBUGLS0STAT: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_PDEBUGLS0STAT(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGLS0STAT.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_PDEBUGLS0STAT() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGLS0STAT.Reg)
}

// DEBUG_ASSIST.CORE_1_RCD_PDEBUGLS0ADDR: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_PDEBUGLS0ADDR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGLS0ADDR.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_PDEBUGLS0ADDR() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGLS0ADDR.Reg)
}

// DEBUG_ASSIST.CORE_1_RCD_PDEBUGLS0DATA: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_PDEBUGLS0DATA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGLS0DATA.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_PDEBUGLS0DATA() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGLS0DATA.Reg)
}

// DEBUG_ASSIST.CORE_1_RCD_SP: Core1 pdebug status register
func (o *DEBUG_ASSIST_Type) SetCORE_1_RCD_SP(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_SP.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_RCD_SP() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_SP.Reg)
}

// DEBUG_ASSIST.CORE_1_IRAM0_EXCEPTION_MONITOR_0: Core1 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xffffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0xffffff
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1000000)|value<<24)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1000000) >> 24
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_LOADSTORE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x2000000)|value<<25)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_LOADSTORE_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x2000000) >> 25
}

// DEBUG_ASSIST.CORE_1_IRAM0_EXCEPTION_MONITOR_1: Core1 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffffff
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x1000000)|value<<24)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x1000000) >> 24
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_LOADSTORE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x2000000)|value<<25)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_LOADSTORE_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x2000000) >> 25
}

// DEBUG_ASSIST.CORE_1_DRAM0_EXCEPTION_MONITOR_0: Core1 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_0_CORE_1_DRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x3fffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_0_CORE_1_DRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x3fffff
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_0_CORE_1_DRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x400000)|value<<22)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_0_CORE_1_DRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x400000) >> 22
}

// DEBUG_ASSIST.CORE_1_DRAM0_EXCEPTION_MONITOR_1: Core1 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_1_CORE_1_DRAM0_RECORDING_BYTEEN_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_1_CORE_1_DRAM0_RECORDING_BYTEEN_0() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffff
}

// DEBUG_ASSIST.CORE_1_DRAM0_EXCEPTION_MONITOR_2: Core1 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_2(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_2.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_2() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_2.Reg)
}

// DEBUG_ASSIST.CORE_1_DRAM0_EXCEPTION_MONITOR_3: Core1 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_3_CORE_1_DRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg)&^(0x3fffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_3_CORE_1_DRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg) & 0x3fffff
}
func (o *DEBUG_ASSIST_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_3_CORE_1_DRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg)&^(0x400000)|value<<22)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_3_CORE_1_DRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg) & 0x400000) >> 22
}

// DEBUG_ASSIST.CORE_1_DRAM0_EXCEPTION_MONITOR_4: Core1 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_4_CORE_1_DRAM0_RECORDING_BYTEEN_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_4.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_4.Reg)&^(0xffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_4_CORE_1_DRAM0_RECORDING_BYTEEN_1() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_4.Reg) & 0xffff
}

// DEBUG_ASSIST.CORE_1_DRAM0_EXCEPTION_MONITOR_5: Core1 bus busy status regsiter
func (o *DEBUG_ASSIST_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_5(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_5.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_5() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_5.Reg)
}

// DEBUG_ASSIST.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0: bus busy configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xfffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_0() uint32 {
	return volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0xfffff
}

// DEBUG_ASSIST.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1: bus busy configuration register
func (o *DEBUG_ASSIST_Type) SetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xfffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_1() uint32 {
	return volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg) & 0xfffff
}

// DEBUG_ASSIST.LOG_SETTING: log set register
func (o *DEBUG_ASSIST_Type) SetLOG_SETTING_LOG_ENA(value uint32) {
	volatile.StoreUint32(&o.LOG_SETTING.Reg, volatile.LoadUint32(&o.LOG_SETTING.Reg)&^(0x7)|value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_SETTING_LOG_ENA() uint32 {
	return volatile.LoadUint32(&o.LOG_SETTING.Reg) & 0x7
}
func (o *DEBUG_ASSIST_Type) SetLOG_SETTING_LOG_MODE(value uint32) {
	volatile.StoreUint32(&o.LOG_SETTING.Reg, volatile.LoadUint32(&o.LOG_SETTING.Reg)&^(0x38)|value<<3)
}
func (o *DEBUG_ASSIST_Type) GetLOG_SETTING_LOG_MODE() uint32 {
	return (volatile.LoadUint32(&o.LOG_SETTING.Reg) & 0x38) >> 3
}
func (o *DEBUG_ASSIST_Type) SetLOG_SETTING_LOG_MEM_LOOP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.LOG_SETTING.Reg, volatile.LoadUint32(&o.LOG_SETTING.Reg)&^(0x40)|value<<6)
}
func (o *DEBUG_ASSIST_Type) GetLOG_SETTING_LOG_MEM_LOOP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.LOG_SETTING.Reg) & 0x40) >> 6
}

// DEBUG_ASSIST.LOG_DATA_0: log check data register
func (o *DEBUG_ASSIST_Type) SetLOG_DATA_0(value uint32) {
	volatile.StoreUint32(&o.LOG_DATA_0.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_DATA_0() uint32 {
	return volatile.LoadUint32(&o.LOG_DATA_0.Reg)
}

// DEBUG_ASSIST.LOG_DATA_1: log check data register
func (o *DEBUG_ASSIST_Type) SetLOG_DATA_1(value uint32) {
	volatile.StoreUint32(&o.LOG_DATA_1.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_DATA_1() uint32 {
	return volatile.LoadUint32(&o.LOG_DATA_1.Reg)
}

// DEBUG_ASSIST.LOG_DATA_2: log check data register
func (o *DEBUG_ASSIST_Type) SetLOG_DATA_2(value uint32) {
	volatile.StoreUint32(&o.LOG_DATA_2.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_DATA_2() uint32 {
	return volatile.LoadUint32(&o.LOG_DATA_2.Reg)
}

// DEBUG_ASSIST.LOG_DATA_3: log check data register
func (o *DEBUG_ASSIST_Type) SetLOG_DATA_3(value uint32) {
	volatile.StoreUint32(&o.LOG_DATA_3.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_DATA_3() uint32 {
	return volatile.LoadUint32(&o.LOG_DATA_3.Reg)
}

// DEBUG_ASSIST.LOG_DATA_MASK: log check data mask register
func (o *DEBUG_ASSIST_Type) SetLOG_DATA_MASK_LOG_DATA_SIZE(value uint32) {
	volatile.StoreUint32(&o.LOG_DATA_MASK.Reg, volatile.LoadUint32(&o.LOG_DATA_MASK.Reg)&^(0xffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_DATA_MASK_LOG_DATA_SIZE() uint32 {
	return volatile.LoadUint32(&o.LOG_DATA_MASK.Reg) & 0xffff
}

// DEBUG_ASSIST.LOG_MIN: log check region configuration register
func (o *DEBUG_ASSIST_Type) SetLOG_MIN(value uint32) {
	volatile.StoreUint32(&o.LOG_MIN.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_MIN() uint32 {
	return volatile.LoadUint32(&o.LOG_MIN.Reg)
}

// DEBUG_ASSIST.LOG_MAX: log check region configuration register
func (o *DEBUG_ASSIST_Type) SetLOG_MAX(value uint32) {
	volatile.StoreUint32(&o.LOG_MAX.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_MAX() uint32 {
	return volatile.LoadUint32(&o.LOG_MAX.Reg)
}

// DEBUG_ASSIST.LOG_MEM_START: log mem region configuration register
func (o *DEBUG_ASSIST_Type) SetLOG_MEM_START(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_START.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_MEM_START() uint32 {
	return volatile.LoadUint32(&o.LOG_MEM_START.Reg)
}

// DEBUG_ASSIST.LOG_MEM_END: log mem region configuration register
func (o *DEBUG_ASSIST_Type) SetLOG_MEM_END(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_END.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_MEM_END() uint32 {
	return volatile.LoadUint32(&o.LOG_MEM_END.Reg)
}

// DEBUG_ASSIST.LOG_MEM_WRITING_ADDR: log mem addr status register
func (o *DEBUG_ASSIST_Type) SetLOG_MEM_WRITING_ADDR(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_WRITING_ADDR.Reg, value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_MEM_WRITING_ADDR() uint32 {
	return volatile.LoadUint32(&o.LOG_MEM_WRITING_ADDR.Reg)
}

// DEBUG_ASSIST.LOG_MEM_FULL_FLAG: log mem status register
func (o *DEBUG_ASSIST_Type) SetLOG_MEM_FULL_FLAG(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_FULL_FLAG.Reg, volatile.LoadUint32(&o.LOG_MEM_FULL_FLAG.Reg)&^(0x1)|value)
}
func (o *DEBUG_ASSIST_Type) GetLOG_MEM_FULL_FLAG() uint32 {
	return volatile.LoadUint32(&o.LOG_MEM_FULL_FLAG.Reg) & 0x1
}

// DEBUG_ASSIST.DATE: version register
func (o *DEBUG_ASSIST_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *DEBUG_ASSIST_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// DMA (Direct Memory Access) Controller
type DMA_Type struct {
	IN_CONF0_CH0             volatile.Register32 // 0x0
	IN_CONF1_CH0             volatile.Register32 // 0x4
	IN_INT_RAW_CH0           volatile.Register32 // 0x8
	IN_INT_ST_CH0            volatile.Register32 // 0xC
	IN_INT_ENA_CH0           volatile.Register32 // 0x10
	IN_INT_CLR_CH0           volatile.Register32 // 0x14
	INFIFO_STATUS_CH0        volatile.Register32 // 0x18
	IN_POP_CH0               volatile.Register32 // 0x1C
	IN_LINK_CH0              volatile.Register32 // 0x20
	IN_STATE_CH0             volatile.Register32 // 0x24
	IN_SUC_EOF_DES_ADDR_CH0  volatile.Register32 // 0x28
	IN_ERR_EOF_DES_ADDR_CH0  volatile.Register32 // 0x2C
	IN_DSCR_CH0              volatile.Register32 // 0x30
	IN_DSCR_BF0_CH0          volatile.Register32 // 0x34
	IN_DSCR_BF1_CH0          volatile.Register32 // 0x38
	IN_WIGHT_CH0             volatile.Register32 // 0x3C
	_                        [4]byte
	IN_PRI_CH0               volatile.Register32 // 0x44
	IN_PERI_SEL_CH0          volatile.Register32 // 0x48
	_                        [20]byte
	OUT_CONF0_CH0            volatile.Register32 // 0x60
	OUT_CONF1_CH0            volatile.Register32 // 0x64
	OUT_INT_RAW_CH0          volatile.Register32 // 0x68
	OUT_INT_ST_CH0           volatile.Register32 // 0x6C
	OUT_INT_ENA_CH0          volatile.Register32 // 0x70
	OUT_INT_CLR_CH0          volatile.Register32 // 0x74
	OUTFIFO_STATUS_CH0       volatile.Register32 // 0x78
	OUT_PUSH_CH0             volatile.Register32 // 0x7C
	OUT_LINK_CH0             volatile.Register32 // 0x80
	OUT_STATE_CH0            volatile.Register32 // 0x84
	OUT_EOF_DES_ADDR_CH0     volatile.Register32 // 0x88
	OUT_EOF_BFR_DES_ADDR_CH0 volatile.Register32 // 0x8C
	OUT_DSCR_CH0             volatile.Register32 // 0x90
	OUT_DSCR_BF0_CH0         volatile.Register32 // 0x94
	OUT_DSCR_BF1_CH0         volatile.Register32 // 0x98
	OUT_WIGHT_CH0            volatile.Register32 // 0x9C
	_                        [4]byte
	OUT_PRI_CH0              volatile.Register32 // 0xA4
	OUT_PERI_SEL_CH0         volatile.Register32 // 0xA8
	_                        [20]byte
	IN_CONF0_CH1             volatile.Register32 // 0xC0
	IN_CONF1_CH1             volatile.Register32 // 0xC4
	IN_INT_RAW_CH1           volatile.Register32 // 0xC8
	IN_INT_ST_CH1            volatile.Register32 // 0xCC
	IN_INT_ENA_CH1           volatile.Register32 // 0xD0
	IN_INT_CLR_CH1           volatile.Register32 // 0xD4
	INFIFO_STATUS_CH1        volatile.Register32 // 0xD8
	IN_POP_CH1               volatile.Register32 // 0xDC
	IN_LINK_CH1              volatile.Register32 // 0xE0
	IN_STATE_CH1             volatile.Register32 // 0xE4
	IN_SUC_EOF_DES_ADDR_CH1  volatile.Register32 // 0xE8
	IN_ERR_EOF_DES_ADDR_CH1  volatile.Register32 // 0xEC
	IN_DSCR_CH1              volatile.Register32 // 0xF0
	IN_DSCR_BF0_CH1          volatile.Register32 // 0xF4
	IN_DSCR_BF1_CH1          volatile.Register32 // 0xF8
	IN_WIGHT_CH1             volatile.Register32 // 0xFC
	_                        [4]byte
	IN_PRI_CH1               volatile.Register32 // 0x104
	IN_PERI_SEL_CH1          volatile.Register32 // 0x108
	_                        [20]byte
	OUT_CONF0_CH1            volatile.Register32 // 0x120
	OUT_CONF1_CH1            volatile.Register32 // 0x124
	OUT_INT_RAW_CH1          volatile.Register32 // 0x128
	OUT_INT_ST_CH1           volatile.Register32 // 0x12C
	OUT_INT_ENA_CH1          volatile.Register32 // 0x130
	OUT_INT_CLR_CH1          volatile.Register32 // 0x134
	OUTFIFO_STATUS_CH1       volatile.Register32 // 0x138
	OUT_PUSH_CH1             volatile.Register32 // 0x13C
	OUT_LINK_CH1             volatile.Register32 // 0x140
	OUT_STATE_CH1            volatile.Register32 // 0x144
	OUT_EOF_DES_ADDR_CH1     volatile.Register32 // 0x148
	OUT_EOF_BFR_DES_ADDR_CH1 volatile.Register32 // 0x14C
	OUT_DSCR_CH1             volatile.Register32 // 0x150
	OUT_DSCR_BF0_CH1         volatile.Register32 // 0x154
	OUT_DSCR_BF1_CH1         volatile.Register32 // 0x158
	OUT_WIGHT_CH1            volatile.Register32 // 0x15C
	_                        [4]byte
	OUT_PRI_CH1              volatile.Register32 // 0x164
	OUT_PERI_SEL_CH1         volatile.Register32 // 0x168
	_                        [20]byte
	IN_CONF0_CH2             volatile.Register32 // 0x180
	IN_CONF1_CH2             volatile.Register32 // 0x184
	IN_INT_RAW_CH2           volatile.Register32 // 0x188
	IN_INT_ST_CH2            volatile.Register32 // 0x18C
	IN_INT_ENA_CH2           volatile.Register32 // 0x190
	IN_INT_CLR_CH2           volatile.Register32 // 0x194
	INFIFO_STATUS_CH2        volatile.Register32 // 0x198
	IN_POP_CH2               volatile.Register32 // 0x19C
	IN_LINK_CH2              volatile.Register32 // 0x1A0
	IN_STATE_CH2             volatile.Register32 // 0x1A4
	IN_SUC_EOF_DES_ADDR_CH2  volatile.Register32 // 0x1A8
	IN_ERR_EOF_DES_ADDR_CH2  volatile.Register32 // 0x1AC
	IN_DSCR_CH2              volatile.Register32 // 0x1B0
	IN_DSCR_BF0_CH2          volatile.Register32 // 0x1B4
	IN_DSCR_BF1_CH2          volatile.Register32 // 0x1B8
	IN_WIGHT_CH2             volatile.Register32 // 0x1BC
	_                        [4]byte
	IN_PRI_CH2               volatile.Register32 // 0x1C4
	IN_PERI_SEL_CH2          volatile.Register32 // 0x1C8
	_                        [20]byte
	OUT_CONF0_CH2            volatile.Register32 // 0x1E0
	OUT_CONF1_CH2            volatile.Register32 // 0x1E4
	OUT_INT_RAW_CH2          volatile.Register32 // 0x1E8
	OUT_INT_ST_CH2           volatile.Register32 // 0x1EC
	OUT_INT_ENA_CH2          volatile.Register32 // 0x1F0
	OUT_INT_CLR_CH2          volatile.Register32 // 0x1F4
	OUTFIFO_STATUS_CH2       volatile.Register32 // 0x1F8
	OUT_PUSH_CH2             volatile.Register32 // 0x1FC
	OUT_LINK_CH2             volatile.Register32 // 0x200
	OUT_STATE_CH2            volatile.Register32 // 0x204
	OUT_EOF_DES_ADDR_CH2     volatile.Register32 // 0x208
	OUT_EOF_BFR_DES_ADDR_CH2 volatile.Register32 // 0x20C
	OUT_DSCR_CH2             volatile.Register32 // 0x210
	OUT_DSCR_BF0_CH2         volatile.Register32 // 0x214
	OUT_DSCR_BF1_CH2         volatile.Register32 // 0x218
	OUT_WIGHT_CH2            volatile.Register32 // 0x21C
	_                        [4]byte
	OUT_PRI_CH2              volatile.Register32 // 0x224
	OUT_PERI_SEL_CH2         volatile.Register32 // 0x228
	_                        [20]byte
	IN_CONF0_CH3             volatile.Register32 // 0x240
	IN_CONF1_CH3             volatile.Register32 // 0x244
	IN_INT_RAW_CH3           volatile.Register32 // 0x248
	IN_INT_ST_CH3            volatile.Register32 // 0x24C
	IN_INT_ENA_CH3           volatile.Register32 // 0x250
	IN_INT_CLR_CH3           volatile.Register32 // 0x254
	INFIFO_STATUS_CH3        volatile.Register32 // 0x258
	IN_POP_CH3               volatile.Register32 // 0x25C
	IN_LINK_CH3              volatile.Register32 // 0x260
	IN_STATE_CH3             volatile.Register32 // 0x264
	IN_SUC_EOF_DES_ADDR_CH3  volatile.Register32 // 0x268
	IN_ERR_EOF_DES_ADDR_CH3  volatile.Register32 // 0x26C
	IN_DSCR_CH3              volatile.Register32 // 0x270
	IN_DSCR_BF0_CH3          volatile.Register32 // 0x274
	IN_DSCR_BF1_CH3          volatile.Register32 // 0x278
	IN_WIGHT_CH3             volatile.Register32 // 0x27C
	_                        [4]byte
	IN_PRI_CH3               volatile.Register32 // 0x284
	IN_PERI_SEL_CH3          volatile.Register32 // 0x288
	_                        [20]byte
	OUT_CONF0_CH3            volatile.Register32 // 0x2A0
	OUT_CONF1_CH3            volatile.Register32 // 0x2A4
	OUT_INT_RAW_CH3          volatile.Register32 // 0x2A8
	OUT_INT_ST_CH3           volatile.Register32 // 0x2AC
	OUT_INT_ENA_CH3          volatile.Register32 // 0x2B0
	OUT_INT_CLR_CH3          volatile.Register32 // 0x2B4
	OUTFIFO_STATUS_CH3       volatile.Register32 // 0x2B8
	OUT_PUSH_CH3             volatile.Register32 // 0x2BC
	OUT_LINK_CH3             volatile.Register32 // 0x2C0
	OUT_STATE_CH3            volatile.Register32 // 0x2C4
	OUT_EOF_DES_ADDR_CH3     volatile.Register32 // 0x2C8
	OUT_EOF_BFR_DES_ADDR_CH3 volatile.Register32 // 0x2CC
	OUT_DSCR_CH3             volatile.Register32 // 0x2D0
	OUT_DSCR_BF0_CH3         volatile.Register32 // 0x2D4
	OUT_DSCR_BF1_CH3         volatile.Register32 // 0x2D8
	OUT_WIGHT_CH3            volatile.Register32 // 0x2DC
	_                        [4]byte
	OUT_PRI_CH3              volatile.Register32 // 0x2E4
	OUT_PERI_SEL_CH3         volatile.Register32 // 0x2E8
	_                        [20]byte
	IN_CONF0_CH4             volatile.Register32 // 0x300
	IN_CONF1_CH4             volatile.Register32 // 0x304
	IN_INT_RAW_CH4           volatile.Register32 // 0x308
	IN_INT_ST_CH4            volatile.Register32 // 0x30C
	IN_INT_ENA_CH4           volatile.Register32 // 0x310
	IN_INT_CLR_CH4           volatile.Register32 // 0x314
	INFIFO_STATUS_CH4        volatile.Register32 // 0x318
	IN_POP_CH4               volatile.Register32 // 0x31C
	IN_LINK_CH4              volatile.Register32 // 0x320
	IN_STATE_CH4             volatile.Register32 // 0x324
	IN_SUC_EOF_DES_ADDR_CH4  volatile.Register32 // 0x328
	IN_ERR_EOF_DES_ADDR_CH4  volatile.Register32 // 0x32C
	IN_DSCR_CH4              volatile.Register32 // 0x330
	IN_DSCR_BF0_CH4          volatile.Register32 // 0x334
	IN_DSCR_BF1_CH4          volatile.Register32 // 0x338
	IN_WIGHT_CH4             volatile.Register32 // 0x33C
	_                        [4]byte
	IN_PRI_CH4               volatile.Register32 // 0x344
	IN_PERI_SEL_CH4          volatile.Register32 // 0x348
	_                        [20]byte
	OUT_CONF0_CH4            volatile.Register32 // 0x360
	OUT_CONF1_CH4            volatile.Register32 // 0x364
	OUT_INT_RAW_CH4          volatile.Register32 // 0x368
	OUT_INT_ST_CH4           volatile.Register32 // 0x36C
	OUT_INT_ENA_CH4          volatile.Register32 // 0x370
	OUT_INT_CLR_CH4          volatile.Register32 // 0x374
	OUTFIFO_STATUS_CH4       volatile.Register32 // 0x378
	OUT_PUSH_CH4             volatile.Register32 // 0x37C
	OUT_LINK_CH4             volatile.Register32 // 0x380
	OUT_STATE_CH4            volatile.Register32 // 0x384
	OUT_EOF_DES_ADDR_CH4     volatile.Register32 // 0x388
	OUT_EOF_BFR_DES_ADDR_CH4 volatile.Register32 // 0x38C
	OUT_DSCR_CH4             volatile.Register32 // 0x390
	OUT_DSCR_BF0_CH4         volatile.Register32 // 0x394
	OUT_DSCR_BF1_CH4         volatile.Register32 // 0x398
	OUT_WIGHT_CH4            volatile.Register32 // 0x39C
	_                        [4]byte
	OUT_PRI_CH4              volatile.Register32 // 0x3A4
	OUT_PERI_SEL_CH4         volatile.Register32 // 0x3A8
	_                        [20]byte
	AHB_TEST                 volatile.Register32 // 0x3C0
	PD_CONF                  volatile.Register32 // 0x3C4
	MISC_CONF                volatile.Register32 // 0x3C8
	IN_SRAM_SIZE_CH0         volatile.Register32 // 0x3CC
	OUT_SRAM_SIZE_CH0        volatile.Register32 // 0x3D0
	IN_SRAM_SIZE_CH1         volatile.Register32 // 0x3D4
	OUT_SRAM_SIZE_CH1        volatile.Register32 // 0x3D8
	IN_SRAM_SIZE_CH2         volatile.Register32 // 0x3DC
	OUT_SRAM_SIZE_CH2        volatile.Register32 // 0x3E0
	IN_SRAM_SIZE_CH3         volatile.Register32 // 0x3E4
	OUT_SRAM_SIZE_CH3        volatile.Register32 // 0x3E8
	IN_SRAM_SIZE_CH4         volatile.Register32 // 0x3EC
	OUT_SRAM_SIZE_CH4        volatile.Register32 // 0x3F0
	EXTMEM_REJECT_ADDR       volatile.Register32 // 0x3F4
	EXTMEM_REJECT_ST         volatile.Register32 // 0x3F8
	EXTMEM_REJECT_INT_RAW    volatile.Register32 // 0x3FC
	EXTMEM_REJECT_INT_ST     volatile.Register32 // 0x400
	EXTMEM_REJECT_INT_ENA    volatile.Register32 // 0x404
	EXTMEM_REJECT_INT_CLR    volatile.Register32 // 0x408
	DATE                     volatile.Register32 // 0x40C
}

// DMA.IN_CONF0_CH0: Configure 0 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF0_CH0_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH0_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH0_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH0_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH0_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH0: Configure 1 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF1_CH0_DMA_INFIFO_FULL_THRS(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH0.Reg, volatile.LoadUint32(&o.IN_CONF1_CH0.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_CONF1_CH0_DMA_INFIFO_FULL_THRS() uint32 {
	return volatile.LoadUint32(&o.IN_CONF1_CH0.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_CONF1_CH0_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH0.Reg, volatile.LoadUint32(&o.IN_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH0_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIN_CONF1_CH0_IN_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH0.Reg, volatile.LoadUint32(&o.IN_CONF1_CH0.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetIN_CONF1_CH0_IN_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH0.Reg) & 0x6000) >> 13
}

// DMA.IN_INT_RAW_CH0: Raw status interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ST_CH0: Masked interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ST_CH0_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ST_CH0_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ST_CH0_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ST_CH0_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ST_CH0_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ENA_CH0: Interrupt enable bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x200) >> 9
}

// DMA.IN_INT_CLR_CH0: Interrupt clear bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_DMA_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_DMA_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x200) >> 9
}

// DMA.INFIFO_STATUS_CH0: Receive FIFO status of Rx channel 0
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0xfc0)|value<<6)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0xfc0) >> 6
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x7f000)|value<<12)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x7f000) >> 12
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0xf80000)|value<<19)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0xf80000) >> 19
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x10000000) >> 28
}

// DMA.IN_POP_CH0: Pop control register of Rx channel 0
func (o *DMA_Type) SetIN_POP_CH0_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH0_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH0_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH0_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH0: Link descriptor configure and control register of Rx channel 0
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH0: Receive status of Rx channel 0
func (o *DMA_Type) SetIN_STATE_CH0_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH0_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH0_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH0_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH0_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH0_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH0: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH0: Inlink descriptor address when errors occur of Rx channel 0
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg)
}

// DMA.IN_DSCR_CH0: Current inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH0.Reg)
}

// DMA.IN_DSCR_BF0_CH0: The last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH0.Reg)
}

// DMA.IN_DSCR_BF1_CH0: The second-to-last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH0.Reg)
}

// DMA.IN_WIGHT_CH0: Weight register of Rx channel 0
func (o *DMA_Type) SetIN_WIGHT_CH0_RX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.IN_WIGHT_CH0.Reg, volatile.LoadUint32(&o.IN_WIGHT_CH0.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetIN_WIGHT_CH0_RX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.IN_WIGHT_CH0.Reg) & 0xf00) >> 8
}

// DMA.IN_PRI_CH0: Priority register of Rx channel 0
func (o *DMA_Type) SetIN_PRI_CH0_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH0.Reg, volatile.LoadUint32(&o.IN_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH0_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH0.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH0: Peripheral selection of Rx channel 0
func (o *DMA_Type) SetIN_PERI_SEL_CH0_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH0_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH0: Configure 0 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH0: Configure 1 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF1_CH0_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH0_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetOUT_CONF1_CH0_OUT_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetOUT_CONF1_CH0_OUT_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg) & 0x6000) >> 13
}

// DMA.OUT_INT_RAW_CH0: Raw status interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ST_CH0: Masked interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ENA_CH0: Interrupt enable bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_CLR_CH0: Interrupt clear bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x80) >> 7
}

// DMA.OUTFIFO_STATUS_CH0: Transmit FIFO status of Tx channel 0
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x7c0)|value<<6)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x7c0) >> 6
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x3f800)|value<<11)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x3f800) >> 11
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x7c0000)|value<<18)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x7c0000) >> 18
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH0: Push control register of Rx channel 0
func (o *DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH0: Link descriptor configure and control register of Tx channel 0
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH0: Transmit status of Tx channel 0
func (o *DMA_Type) SetOUT_STATE_CH0_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH0_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH0_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH0: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH0: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg)
}

// DMA.OUT_DSCR_CH0: Current inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH0.Reg)
}

// DMA.OUT_DSCR_BF0_CH0: The last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH0.Reg)
}

// DMA.OUT_DSCR_BF1_CH0: The second-to-last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH0.Reg)
}

// DMA.OUT_WIGHT_CH0: Weight register of Rx channel 0
func (o *DMA_Type) SetOUT_WIGHT_CH0_TX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.OUT_WIGHT_CH0.Reg, volatile.LoadUint32(&o.OUT_WIGHT_CH0.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetOUT_WIGHT_CH0_TX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.OUT_WIGHT_CH0.Reg) & 0xf00) >> 8
}

// DMA.OUT_PRI_CH0: Priority register of Tx channel 0.
func (o *DMA_Type) SetOUT_PRI_CH0_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH0.Reg, volatile.LoadUint32(&o.OUT_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH0_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH0.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH0: Peripheral selection of Tx channel 0
func (o *DMA_Type) SetOUT_PERI_SEL_CH0_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH0_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg) & 0x3f
}

// DMA.IN_CONF0_CH1: Configure 0 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF0_CH1_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH1_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH1_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH1_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH1_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH1_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH1_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH1: Configure 1 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF1_CH1_DMA_INFIFO_FULL_THRS(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH1.Reg, volatile.LoadUint32(&o.IN_CONF1_CH1.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_CONF1_CH1_DMA_INFIFO_FULL_THRS() uint32 {
	return volatile.LoadUint32(&o.IN_CONF1_CH1.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_CONF1_CH1_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH1.Reg, volatile.LoadUint32(&o.IN_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH1_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH1.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIN_CONF1_CH1_IN_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH1.Reg, volatile.LoadUint32(&o.IN_CONF1_CH1.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetIN_CONF1_CH1_IN_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH1.Reg) & 0x6000) >> 13
}

// DMA.IN_INT_RAW_CH1: Raw status interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ST_CH1: Masked interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ST_CH1_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ST_CH1_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ST_CH1_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ST_CH1_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ST_CH1_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ENA_CH1: Interrupt enable bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x200) >> 9
}

// DMA.IN_INT_CLR_CH1: Interrupt clear bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_DMA_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_DMA_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x200) >> 9
}

// DMA.INFIFO_STATUS_CH1: Receive FIFO status of Rx channel 0
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0xfc0)|value<<6)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0xfc0) >> 6
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x7f000)|value<<12)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x7f000) >> 12
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0xf80000)|value<<19)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0xf80000) >> 19
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x10000000) >> 28
}

// DMA.IN_POP_CH1: Pop control register of Rx channel 0
func (o *DMA_Type) SetIN_POP_CH1_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH1_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH1_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH1_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH1: Link descriptor configure and control register of Rx channel 0
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH1: Receive status of Rx channel 0
func (o *DMA_Type) SetIN_STATE_CH1_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH1_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH1_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH1_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH1_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH1_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH1: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH1: Inlink descriptor address when errors occur of Rx channel 0
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg)
}

// DMA.IN_DSCR_CH1: Current inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH1.Reg)
}

// DMA.IN_DSCR_BF0_CH1: The last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH1.Reg)
}

// DMA.IN_DSCR_BF1_CH1: The second-to-last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH1.Reg)
}

// DMA.IN_WIGHT_CH1: Weight register of Rx channel 0
func (o *DMA_Type) SetIN_WIGHT_CH1_RX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.IN_WIGHT_CH1.Reg, volatile.LoadUint32(&o.IN_WIGHT_CH1.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetIN_WIGHT_CH1_RX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.IN_WIGHT_CH1.Reg) & 0xf00) >> 8
}

// DMA.IN_PRI_CH1: Priority register of Rx channel 0
func (o *DMA_Type) SetIN_PRI_CH1_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH1.Reg, volatile.LoadUint32(&o.IN_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH1_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH1.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH1: Peripheral selection of Rx channel 0
func (o *DMA_Type) SetIN_PERI_SEL_CH1_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH1_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH1: Configure 0 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH1: Configure 1 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF1_CH1_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH1_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetOUT_CONF1_CH1_OUT_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetOUT_CONF1_CH1_OUT_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg) & 0x6000) >> 13
}

// DMA.OUT_INT_RAW_CH1: Raw status interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ST_CH1: Masked interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ENA_CH1: Interrupt enable bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_CLR_CH1: Interrupt clear bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x80) >> 7
}

// DMA.OUTFIFO_STATUS_CH1: Transmit FIFO status of Tx channel 0
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x7c0)|value<<6)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x7c0) >> 6
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x3f800)|value<<11)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x3f800) >> 11
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x7c0000)|value<<18)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x7c0000) >> 18
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH1: Push control register of Rx channel 0
func (o *DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH1: Link descriptor configure and control register of Tx channel 0
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH1: Transmit status of Tx channel 0
func (o *DMA_Type) SetOUT_STATE_CH1_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH1_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH1_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH1_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH1_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH1_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH1: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH1: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg)
}

// DMA.OUT_DSCR_CH1: Current inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH1.Reg)
}

// DMA.OUT_DSCR_BF0_CH1: The last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH1.Reg)
}

// DMA.OUT_DSCR_BF1_CH1: The second-to-last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH1.Reg)
}

// DMA.OUT_WIGHT_CH1: Weight register of Rx channel 0
func (o *DMA_Type) SetOUT_WIGHT_CH1_TX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.OUT_WIGHT_CH1.Reg, volatile.LoadUint32(&o.OUT_WIGHT_CH1.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetOUT_WIGHT_CH1_TX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.OUT_WIGHT_CH1.Reg) & 0xf00) >> 8
}

// DMA.OUT_PRI_CH1: Priority register of Tx channel 0.
func (o *DMA_Type) SetOUT_PRI_CH1_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH1.Reg, volatile.LoadUint32(&o.OUT_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH1_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH1.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH1: Peripheral selection of Tx channel 0
func (o *DMA_Type) SetOUT_PERI_SEL_CH1_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH1_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg) & 0x3f
}

// DMA.IN_CONF0_CH2: Configure 0 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF0_CH2_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH2_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH2_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH2_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH2_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH2_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH2_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH2: Configure 1 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF1_CH2_DMA_INFIFO_FULL_THRS(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH2.Reg, volatile.LoadUint32(&o.IN_CONF1_CH2.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_CONF1_CH2_DMA_INFIFO_FULL_THRS() uint32 {
	return volatile.LoadUint32(&o.IN_CONF1_CH2.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_CONF1_CH2_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH2.Reg, volatile.LoadUint32(&o.IN_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH2_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH2.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIN_CONF1_CH2_IN_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH2.Reg, volatile.LoadUint32(&o.IN_CONF1_CH2.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetIN_CONF1_CH2_IN_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH2.Reg) & 0x6000) >> 13
}

// DMA.IN_INT_RAW_CH2: Raw status interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ST_CH2: Masked interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ST_CH2_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ST_CH2_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ST_CH2_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ST_CH2_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ST_CH2_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ENA_CH2: Interrupt enable bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x200) >> 9
}

// DMA.IN_INT_CLR_CH2: Interrupt clear bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_DMA_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_DMA_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x200) >> 9
}

// DMA.INFIFO_STATUS_CH2: Receive FIFO status of Rx channel 0
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0xfc0)|value<<6)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0xfc0) >> 6
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x7f000)|value<<12)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x7f000) >> 12
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0xf80000)|value<<19)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0xf80000) >> 19
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x10000000) >> 28
}

// DMA.IN_POP_CH2: Pop control register of Rx channel 0
func (o *DMA_Type) SetIN_POP_CH2_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH2_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH2_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH2_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH2: Link descriptor configure and control register of Rx channel 0
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH2: Receive status of Rx channel 0
func (o *DMA_Type) SetIN_STATE_CH2_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH2_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH2_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH2_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH2_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH2_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH2: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH2: Inlink descriptor address when errors occur of Rx channel 0
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg)
}

// DMA.IN_DSCR_CH2: Current inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH2.Reg)
}

// DMA.IN_DSCR_BF0_CH2: The last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH2.Reg)
}

// DMA.IN_DSCR_BF1_CH2: The second-to-last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH2.Reg)
}

// DMA.IN_WIGHT_CH2: Weight register of Rx channel 0
func (o *DMA_Type) SetIN_WIGHT_CH2_RX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.IN_WIGHT_CH2.Reg, volatile.LoadUint32(&o.IN_WIGHT_CH2.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetIN_WIGHT_CH2_RX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.IN_WIGHT_CH2.Reg) & 0xf00) >> 8
}

// DMA.IN_PRI_CH2: Priority register of Rx channel 0
func (o *DMA_Type) SetIN_PRI_CH2_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH2.Reg, volatile.LoadUint32(&o.IN_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH2_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH2.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH2: Peripheral selection of Rx channel 0
func (o *DMA_Type) SetIN_PERI_SEL_CH2_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH2_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH2: Configure 0 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH2: Configure 1 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF1_CH2_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH2_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetOUT_CONF1_CH2_OUT_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetOUT_CONF1_CH2_OUT_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg) & 0x6000) >> 13
}

// DMA.OUT_INT_RAW_CH2: Raw status interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ST_CH2: Masked interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ENA_CH2: Interrupt enable bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_CLR_CH2: Interrupt clear bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x80) >> 7
}

// DMA.OUTFIFO_STATUS_CH2: Transmit FIFO status of Tx channel 0
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x7c0)|value<<6)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x7c0) >> 6
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x3f800)|value<<11)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x3f800) >> 11
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x7c0000)|value<<18)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x7c0000) >> 18
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH2: Push control register of Rx channel 0
func (o *DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH2: Link descriptor configure and control register of Tx channel 0
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH2: Transmit status of Tx channel 0
func (o *DMA_Type) SetOUT_STATE_CH2_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH2_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH2_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH2_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH2_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH2_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH2: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH2: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg)
}

// DMA.OUT_DSCR_CH2: Current inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH2.Reg)
}

// DMA.OUT_DSCR_BF0_CH2: The last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH2.Reg)
}

// DMA.OUT_DSCR_BF1_CH2: The second-to-last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH2.Reg)
}

// DMA.OUT_WIGHT_CH2: Weight register of Rx channel 0
func (o *DMA_Type) SetOUT_WIGHT_CH2_TX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.OUT_WIGHT_CH2.Reg, volatile.LoadUint32(&o.OUT_WIGHT_CH2.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetOUT_WIGHT_CH2_TX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.OUT_WIGHT_CH2.Reg) & 0xf00) >> 8
}

// DMA.OUT_PRI_CH2: Priority register of Tx channel 0.
func (o *DMA_Type) SetOUT_PRI_CH2_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH2.Reg, volatile.LoadUint32(&o.OUT_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH2_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH2.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH2: Peripheral selection of Tx channel 0
func (o *DMA_Type) SetOUT_PERI_SEL_CH2_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH2_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg) & 0x3f
}

// DMA.IN_CONF0_CH3: Configure 0 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF0_CH3_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH3.Reg, volatile.LoadUint32(&o.IN_CONF0_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH3_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH3_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH3.Reg, volatile.LoadUint32(&o.IN_CONF0_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH3_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH3_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH3.Reg, volatile.LoadUint32(&o.IN_CONF0_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH3_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH3_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH3.Reg, volatile.LoadUint32(&o.IN_CONF0_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH3_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH3_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH3.Reg, volatile.LoadUint32(&o.IN_CONF0_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH3_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH3.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH3: Configure 1 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF1_CH3_DMA_INFIFO_FULL_THRS(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH3.Reg, volatile.LoadUint32(&o.IN_CONF1_CH3.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_CONF1_CH3_DMA_INFIFO_FULL_THRS() uint32 {
	return volatile.LoadUint32(&o.IN_CONF1_CH3.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_CONF1_CH3_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH3.Reg, volatile.LoadUint32(&o.IN_CONF1_CH3.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH3_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH3.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIN_CONF1_CH3_IN_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH3.Reg, volatile.LoadUint32(&o.IN_CONF1_CH3.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetIN_CONF1_CH3_IN_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH3.Reg) & 0x6000) >> 13
}

// DMA.IN_INT_RAW_CH3: Raw status interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_RAW_CH3_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_RAW_CH3_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_RAW_CH3_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH3.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ST_CH3: Masked interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_ST_CH3_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ST_CH3_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ST_CH3_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ST_CH3_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ST_CH3_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ST_CH3_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ST_CH3_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ST_CH3_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ST_CH3_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ST_CH3_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ST_CH3_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH3.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ENA_CH3: Interrupt enable bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_ENA_CH3_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ENA_CH3_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ENA_CH3_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH3.Reg) & 0x200) >> 9
}

// DMA.IN_INT_CLR_CH3: Interrupt clear bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_CLR_CH3_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_DMA_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_DMA_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_CLR_CH3_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_CLR_CH3_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH3.Reg) & 0x200) >> 9
}

// DMA.INFIFO_STATUS_CH3: Receive FIFO status of Rx channel 0
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0xfc0)|value<<6)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0xfc0) >> 6
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x7f000)|value<<12)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x7f000) >> 12
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_INFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0xf80000)|value<<19)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_INFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0xf80000) >> 19
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_IN_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_IN_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_IN_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_IN_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_IN_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_IN_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_IN_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_IN_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetINFIFO_STATUS_CH3_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH3_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH3.Reg) & 0x10000000) >> 28
}

// DMA.IN_POP_CH3: Pop control register of Rx channel 0
func (o *DMA_Type) SetIN_POP_CH3_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH3.Reg, volatile.LoadUint32(&o.IN_POP_CH3.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH3_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH3.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH3_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH3.Reg, volatile.LoadUint32(&o.IN_POP_CH3.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH3_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH3.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH3: Link descriptor configure and control register of Rx channel 0
func (o *DMA_Type) SetIN_LINK_CH3_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH3.Reg, volatile.LoadUint32(&o.IN_LINK_CH3.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH3_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH3.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH3_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH3.Reg, volatile.LoadUint32(&o.IN_LINK_CH3.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH3_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH3.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH3_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH3.Reg, volatile.LoadUint32(&o.IN_LINK_CH3.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH3_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH3.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH3_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH3.Reg, volatile.LoadUint32(&o.IN_LINK_CH3.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH3_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH3.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH3_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH3.Reg, volatile.LoadUint32(&o.IN_LINK_CH3.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH3_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH3.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH3_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH3.Reg, volatile.LoadUint32(&o.IN_LINK_CH3.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH3_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH3.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH3: Receive status of Rx channel 0
func (o *DMA_Type) SetIN_STATE_CH3_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH3.Reg, volatile.LoadUint32(&o.IN_STATE_CH3.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH3_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH3.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH3_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH3.Reg, volatile.LoadUint32(&o.IN_STATE_CH3.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH3_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH3.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH3_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH3.Reg, volatile.LoadUint32(&o.IN_STATE_CH3.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH3_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH3.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH3: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH3(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH3.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH3() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH3.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH3: Inlink descriptor address when errors occur of Rx channel 0
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH3(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH3.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH3() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH3.Reg)
}

// DMA.IN_DSCR_CH3: Current inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_CH3(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH3.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH3() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH3.Reg)
}

// DMA.IN_DSCR_BF0_CH3: The last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF0_CH3(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH3.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH3() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH3.Reg)
}

// DMA.IN_DSCR_BF1_CH3: The second-to-last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF1_CH3(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH3.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH3() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH3.Reg)
}

// DMA.IN_WIGHT_CH3: Weight register of Rx channel 0
func (o *DMA_Type) SetIN_WIGHT_CH3_RX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.IN_WIGHT_CH3.Reg, volatile.LoadUint32(&o.IN_WIGHT_CH3.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetIN_WIGHT_CH3_RX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.IN_WIGHT_CH3.Reg) & 0xf00) >> 8
}

// DMA.IN_PRI_CH3: Priority register of Rx channel 0
func (o *DMA_Type) SetIN_PRI_CH3_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH3.Reg, volatile.LoadUint32(&o.IN_PRI_CH3.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH3_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH3.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH3: Peripheral selection of Rx channel 0
func (o *DMA_Type) SetIN_PERI_SEL_CH3_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH3.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH3.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH3_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH3.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH3: Configure 0 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF0_CH3_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH3.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH3_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH3_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH3.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH3_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH3_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH3.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH3_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH3_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH3.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH3_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH3_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH3.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH3_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH3_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH3.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH3_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH3.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH3: Configure 1 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF1_CH3_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH3.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH3.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH3_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH3.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetOUT_CONF1_CH3_OUT_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH3.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH3.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetOUT_CONF1_CH3_OUT_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH3.Reg) & 0x6000) >> 13
}

// DMA.OUT_INT_RAW_CH3: Raw status interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_RAW_CH3_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH3_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH3_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH3_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH3_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH3_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_RAW_CH3_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH3_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_RAW_CH3_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH3_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_RAW_CH3_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH3_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_RAW_CH3_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH3_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_RAW_CH3_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH3_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH3.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ST_CH3: Masked interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ST_CH3_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ST_CH3_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ST_CH3_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ST_CH3_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ST_CH3_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ST_CH3_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ST_CH3_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ST_CH3_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ST_CH3_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ST_CH3_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ST_CH3_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ST_CH3_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ST_CH3_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ST_CH3_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ST_CH3_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ST_CH3_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH3.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ENA_CH3: Interrupt enable bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ENA_CH3_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH3_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH3_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH3_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH3_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH3_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ENA_CH3_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH3_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ENA_CH3_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH3_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ENA_CH3_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH3_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ENA_CH3_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH3_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ENA_CH3_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH3_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH3.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_CLR_CH3: Interrupt clear bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_CLR_CH3_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH3_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH3_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH3_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH3_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH3_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_CLR_CH3_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH3_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_CLR_CH3_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH3_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_CLR_CH3_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH3_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_CLR_CH3_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH3_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_CLR_CH3_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH3.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH3_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH3.Reg) & 0x80) >> 7
}

// DMA.OUTFIFO_STATUS_CH3: Transmit FIFO status of Tx channel 0
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x7c0)|value<<6)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x7c0) >> 6
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x3f800)|value<<11)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x3f800) >> 11
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUTFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x7c0000)|value<<18)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUTFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x7c0000) >> 18
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUT_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUT_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUT_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUT_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUT_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUT_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH3_OUT_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH3.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH3_OUT_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH3.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH3: Push control register of Rx channel 0
func (o *DMA_Type) SetOUT_PUSH_CH3_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH3.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH3.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH3_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH3.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH3_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH3.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH3.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH3_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH3.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH3: Link descriptor configure and control register of Tx channel 0
func (o *DMA_Type) SetOUT_LINK_CH3_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH3.Reg, volatile.LoadUint32(&o.OUT_LINK_CH3.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH3_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH3.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH3_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH3.Reg, volatile.LoadUint32(&o.OUT_LINK_CH3.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH3_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH3.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH3_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH3.Reg, volatile.LoadUint32(&o.OUT_LINK_CH3.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH3_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH3.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH3_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH3.Reg, volatile.LoadUint32(&o.OUT_LINK_CH3.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH3_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH3.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH3_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH3.Reg, volatile.LoadUint32(&o.OUT_LINK_CH3.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH3_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH3.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH3: Transmit status of Tx channel 0
func (o *DMA_Type) SetOUT_STATE_CH3_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH3.Reg, volatile.LoadUint32(&o.OUT_STATE_CH3.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH3_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH3.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH3_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH3.Reg, volatile.LoadUint32(&o.OUT_STATE_CH3.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH3_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH3.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH3_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH3.Reg, volatile.LoadUint32(&o.OUT_STATE_CH3.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH3_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH3.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH3: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH3(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH3.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH3() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH3.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH3: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH3(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH3.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH3() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH3.Reg)
}

// DMA.OUT_DSCR_CH3: Current inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_CH3(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH3.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH3() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH3.Reg)
}

// DMA.OUT_DSCR_BF0_CH3: The last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF0_CH3(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH3.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH3() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH3.Reg)
}

// DMA.OUT_DSCR_BF1_CH3: The second-to-last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF1_CH3(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH3.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH3() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH3.Reg)
}

// DMA.OUT_WIGHT_CH3: Weight register of Rx channel 0
func (o *DMA_Type) SetOUT_WIGHT_CH3_TX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.OUT_WIGHT_CH3.Reg, volatile.LoadUint32(&o.OUT_WIGHT_CH3.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetOUT_WIGHT_CH3_TX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.OUT_WIGHT_CH3.Reg) & 0xf00) >> 8
}

// DMA.OUT_PRI_CH3: Priority register of Tx channel 0.
func (o *DMA_Type) SetOUT_PRI_CH3_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH3.Reg, volatile.LoadUint32(&o.OUT_PRI_CH3.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH3_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH3.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH3: Peripheral selection of Tx channel 0
func (o *DMA_Type) SetOUT_PERI_SEL_CH3_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH3.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH3.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH3_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH3.Reg) & 0x3f
}

// DMA.IN_CONF0_CH4: Configure 0 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF0_CH4_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH4.Reg, volatile.LoadUint32(&o.IN_CONF0_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH4_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH4_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH4.Reg, volatile.LoadUint32(&o.IN_CONF0_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH4_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH4_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH4.Reg, volatile.LoadUint32(&o.IN_CONF0_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH4_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH4_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH4.Reg, volatile.LoadUint32(&o.IN_CONF0_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH4_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH4_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH4.Reg, volatile.LoadUint32(&o.IN_CONF0_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH4_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH4.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH4: Configure 1 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF1_CH4_DMA_INFIFO_FULL_THRS(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH4.Reg, volatile.LoadUint32(&o.IN_CONF1_CH4.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_CONF1_CH4_DMA_INFIFO_FULL_THRS() uint32 {
	return volatile.LoadUint32(&o.IN_CONF1_CH4.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_CONF1_CH4_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH4.Reg, volatile.LoadUint32(&o.IN_CONF1_CH4.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH4_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH4.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIN_CONF1_CH4_IN_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH4.Reg, volatile.LoadUint32(&o.IN_CONF1_CH4.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetIN_CONF1_CH4_IN_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH4.Reg) & 0x6000) >> 13
}

// DMA.IN_INT_RAW_CH4: Raw status interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_RAW_CH4_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_RAW_CH4_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_RAW_CH4_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH4.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ST_CH4: Masked interrupt of Rx channel 0
func (o *DMA_Type) SetIN_INT_ST_CH4_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ST_CH4_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ST_CH4_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ST_CH4_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ST_CH4_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ST_CH4_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ST_CH4_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ST_CH4_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ST_CH4_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ST_CH4_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ST_CH4_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH4.Reg) & 0x200) >> 9
}

// DMA.IN_INT_ENA_CH4: Interrupt enable bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_ENA_CH4_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_ENA_CH4_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_ENA_CH4_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH4.Reg) & 0x200) >> 9
}

// DMA.IN_INT_CLR_CH4: Interrupt clear bits of Rx channel 0
func (o *DMA_Type) SetIN_INT_CLR_CH4_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_DMA_INFIFO_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_DMA_INFIFO_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_INFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_INFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_INFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_INFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_INFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_INFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIN_INT_CLR_CH4_INFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIN_INT_CLR_CH4_INFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH4.Reg) & 0x200) >> 9
}

// DMA.INFIFO_STATUS_CH4: Receive FIFO status of Rx channel 0
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0xfc0)|value<<6)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0xfc0) >> 6
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x7f000)|value<<12)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x7f000) >> 12
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_INFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0xf80000)|value<<19)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_INFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0xf80000) >> 19
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_IN_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_IN_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_IN_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_IN_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_IN_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_IN_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_IN_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_IN_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetINFIFO_STATUS_CH4_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH4_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH4.Reg) & 0x10000000) >> 28
}

// DMA.IN_POP_CH4: Pop control register of Rx channel 0
func (o *DMA_Type) SetIN_POP_CH4_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH4.Reg, volatile.LoadUint32(&o.IN_POP_CH4.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH4_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH4.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH4_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH4.Reg, volatile.LoadUint32(&o.IN_POP_CH4.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH4_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH4.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH4: Link descriptor configure and control register of Rx channel 0
func (o *DMA_Type) SetIN_LINK_CH4_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH4.Reg, volatile.LoadUint32(&o.IN_LINK_CH4.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH4_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH4.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH4_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH4.Reg, volatile.LoadUint32(&o.IN_LINK_CH4.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH4_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH4.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH4_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH4.Reg, volatile.LoadUint32(&o.IN_LINK_CH4.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH4_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH4.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH4_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH4.Reg, volatile.LoadUint32(&o.IN_LINK_CH4.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH4_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH4.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH4_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH4.Reg, volatile.LoadUint32(&o.IN_LINK_CH4.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH4_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH4.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH4_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH4.Reg, volatile.LoadUint32(&o.IN_LINK_CH4.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH4_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH4.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH4: Receive status of Rx channel 0
func (o *DMA_Type) SetIN_STATE_CH4_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH4.Reg, volatile.LoadUint32(&o.IN_STATE_CH4.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH4_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH4.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH4_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH4.Reg, volatile.LoadUint32(&o.IN_STATE_CH4.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH4_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH4.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH4_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH4.Reg, volatile.LoadUint32(&o.IN_STATE_CH4.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH4_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH4.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH4: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH4(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH4.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH4() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH4.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH4: Inlink descriptor address when errors occur of Rx channel 0
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH4(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH4.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH4() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH4.Reg)
}

// DMA.IN_DSCR_CH4: Current inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_CH4(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH4.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH4() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH4.Reg)
}

// DMA.IN_DSCR_BF0_CH4: The last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF0_CH4(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH4.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH4() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH4.Reg)
}

// DMA.IN_DSCR_BF1_CH4: The second-to-last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF1_CH4(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH4.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH4() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH4.Reg)
}

// DMA.IN_WIGHT_CH4: Weight register of Rx channel 0
func (o *DMA_Type) SetIN_WIGHT_CH4_RX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.IN_WIGHT_CH4.Reg, volatile.LoadUint32(&o.IN_WIGHT_CH4.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetIN_WIGHT_CH4_RX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.IN_WIGHT_CH4.Reg) & 0xf00) >> 8
}

// DMA.IN_PRI_CH4: Priority register of Rx channel 0
func (o *DMA_Type) SetIN_PRI_CH4_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH4.Reg, volatile.LoadUint32(&o.IN_PRI_CH4.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH4_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH4.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH4: Peripheral selection of Rx channel 0
func (o *DMA_Type) SetIN_PERI_SEL_CH4_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH4.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH4.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH4_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH4.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH4: Configure 0 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF0_CH4_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH4.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH4_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH4_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH4.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH4_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH4_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH4.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH4_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH4_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH4.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH4_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH4_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH4.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH4_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH4_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH4.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH4_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH4.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH4: Configure 1 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF1_CH4_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH4.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH4.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH4_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH4.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetOUT_CONF1_CH4_OUT_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH4.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH4.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetOUT_CONF1_CH4_OUT_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH4.Reg) & 0x6000) >> 13
}

// DMA.OUT_INT_RAW_CH4: Raw status interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_RAW_CH4_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH4_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH4_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH4_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH4_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH4_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_RAW_CH4_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH4_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_RAW_CH4_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH4_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_RAW_CH4_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH4_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_RAW_CH4_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH4_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_RAW_CH4_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH4_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH4.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ST_CH4: Masked interrupt of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ST_CH4_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ST_CH4_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ST_CH4_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ST_CH4_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ST_CH4_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ST_CH4_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ST_CH4_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ST_CH4_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ST_CH4_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ST_CH4_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ST_CH4_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ST_CH4_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ST_CH4_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ST_CH4_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ST_CH4_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ST_CH4_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH4.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_ENA_CH4: Interrupt enable bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_ENA_CH4_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH4_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH4_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH4_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH4_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH4_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ENA_CH4_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH4_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ENA_CH4_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH4_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ENA_CH4_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH4_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_ENA_CH4_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH4_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_ENA_CH4_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH4_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH4.Reg) & 0x80) >> 7
}

// DMA.OUT_INT_CLR_CH4: Interrupt clear bits of Tx channel 0
func (o *DMA_Type) SetOUT_INT_CLR_CH4_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH4_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH4_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH4_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH4_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH4_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_CLR_CH4_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH4_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_CLR_CH4_OUTFIFO_OVF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH4_OUTFIFO_OVF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_CLR_CH4_OUTFIFO_UDF_L1(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH4_OUTFIFO_UDF_L1() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_INT_CLR_CH4_OUTFIFO_OVF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH4_OUTFIFO_OVF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetOUT_INT_CLR_CH4_OUTFIFO_UDF_L3(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH4.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH4_OUTFIFO_UDF_L3() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH4.Reg) & 0x80) >> 7
}

// DMA.OUTFIFO_STATUS_CH4: Transmit FIFO status of Tx channel 0
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_FULL_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_FULL_L1() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_EMPTY_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_EMPTY_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_FULL_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_FULL_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_EMPTY_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_EMPTY_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_FULL_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_FULL_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_EMPTY_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_EMPTY_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_CNT_L1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x7c0)|value<<6)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_CNT_L1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x7c0) >> 6
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_CNT_L2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x3f800)|value<<11)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_CNT_L2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x3f800) >> 11
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUTFIFO_CNT_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x7c0000)|value<<18)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUTFIFO_CNT_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x7c0000) >> 18
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUT_REMAIN_UNDER_1B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUT_REMAIN_UNDER_1B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUT_REMAIN_UNDER_2B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUT_REMAIN_UNDER_2B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUT_REMAIN_UNDER_3B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUT_REMAIN_UNDER_3B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH4_OUT_REMAIN_UNDER_4B_L3(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH4.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH4_OUT_REMAIN_UNDER_4B_L3() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH4.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH4: Push control register of Rx channel 0
func (o *DMA_Type) SetOUT_PUSH_CH4_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH4.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH4.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH4_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH4.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH4_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH4.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH4.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH4_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH4.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH4: Link descriptor configure and control register of Tx channel 0
func (o *DMA_Type) SetOUT_LINK_CH4_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH4.Reg, volatile.LoadUint32(&o.OUT_LINK_CH4.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH4_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH4.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH4_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH4.Reg, volatile.LoadUint32(&o.OUT_LINK_CH4.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH4_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH4.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH4_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH4.Reg, volatile.LoadUint32(&o.OUT_LINK_CH4.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH4_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH4.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH4_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH4.Reg, volatile.LoadUint32(&o.OUT_LINK_CH4.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH4_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH4.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH4_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH4.Reg, volatile.LoadUint32(&o.OUT_LINK_CH4.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH4_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH4.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH4: Transmit status of Tx channel 0
func (o *DMA_Type) SetOUT_STATE_CH4_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH4.Reg, volatile.LoadUint32(&o.OUT_STATE_CH4.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH4_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH4.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH4_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH4.Reg, volatile.LoadUint32(&o.OUT_STATE_CH4.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH4_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH4.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH4_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH4.Reg, volatile.LoadUint32(&o.OUT_STATE_CH4.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH4_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH4.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH4: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH4(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH4.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH4() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH4.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH4: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH4(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH4.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH4() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH4.Reg)
}

// DMA.OUT_DSCR_CH4: Current inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_CH4(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH4.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH4() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH4.Reg)
}

// DMA.OUT_DSCR_BF0_CH4: The last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF0_CH4(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH4.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH4() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH4.Reg)
}

// DMA.OUT_DSCR_BF1_CH4: The second-to-last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF1_CH4(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH4.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH4() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH4.Reg)
}

// DMA.OUT_WIGHT_CH4: Weight register of Rx channel 0
func (o *DMA_Type) SetOUT_WIGHT_CH4_TX_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.OUT_WIGHT_CH4.Reg, volatile.LoadUint32(&o.OUT_WIGHT_CH4.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetOUT_WIGHT_CH4_TX_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.OUT_WIGHT_CH4.Reg) & 0xf00) >> 8
}

// DMA.OUT_PRI_CH4: Priority register of Tx channel 0.
func (o *DMA_Type) SetOUT_PRI_CH4_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH4.Reg, volatile.LoadUint32(&o.OUT_PRI_CH4.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH4_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH4.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH4: Peripheral selection of Tx channel 0
func (o *DMA_Type) SetOUT_PERI_SEL_CH4_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH4.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH4.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH4_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH4.Reg) & 0x3f
}

// DMA.AHB_TEST: reserved
func (o *DMA_Type) SetAHB_TEST_AHB_TESTMODE(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetAHB_TEST_AHB_TESTMODE() uint32 {
	return volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x7
}
func (o *DMA_Type) SetAHB_TEST_AHB_TESTADDR(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x30)|value<<4)
}
func (o *DMA_Type) GetAHB_TEST_AHB_TESTADDR() uint32 {
	return (volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x30) >> 4
}

// DMA.PD_CONF: reserved
func (o *DMA_Type) SetPD_CONF_DMA_RAM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetPD_CONF_DMA_RAM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetPD_CONF_DMA_RAM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetPD_CONF_DMA_RAM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetPD_CONF_DMA_RAM_CLK_FO(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetPD_CONF_DMA_RAM_CLK_FO() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x40) >> 6
}

// DMA.MISC_CONF: MISC register
func (o *DMA_Type) SetMISC_CONF_AHBM_RST_INTER(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetMISC_CONF_AHBM_RST_INTER() uint32 {
	return volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x1
}
func (o *DMA_Type) SetMISC_CONF_AHBM_RST_EXTER(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetMISC_CONF_AHBM_RST_EXTER() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetMISC_CONF_ARB_PRI_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetMISC_CONF_ARB_PRI_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetMISC_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetMISC_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x10) >> 4
}

// DMA.IN_SRAM_SIZE_CH0: Receive L2 FIFO depth of Rx channel 0
func (o *DMA_Type) SetIN_SRAM_SIZE_CH0_IN_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_SRAM_SIZE_CH0.Reg, volatile.LoadUint32(&o.IN_SRAM_SIZE_CH0.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetIN_SRAM_SIZE_CH0_IN_SIZE() uint32 {
	return volatile.LoadUint32(&o.IN_SRAM_SIZE_CH0.Reg) & 0x7f
}

// DMA.OUT_SRAM_SIZE_CH0: Transmit L2 FIFO depth of Tx channel 0
func (o *DMA_Type) SetOUT_SRAM_SIZE_CH0_OUT_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_SRAM_SIZE_CH0.Reg, volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH0.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetOUT_SRAM_SIZE_CH0_OUT_SIZE() uint32 {
	return volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH0.Reg) & 0x7f
}

// DMA.IN_SRAM_SIZE_CH1: Receive L2 FIFO depth of Rx channel 0
func (o *DMA_Type) SetIN_SRAM_SIZE_CH1_IN_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_SRAM_SIZE_CH1.Reg, volatile.LoadUint32(&o.IN_SRAM_SIZE_CH1.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetIN_SRAM_SIZE_CH1_IN_SIZE() uint32 {
	return volatile.LoadUint32(&o.IN_SRAM_SIZE_CH1.Reg) & 0x7f
}

// DMA.OUT_SRAM_SIZE_CH1: Transmit L2 FIFO depth of Tx channel 0
func (o *DMA_Type) SetOUT_SRAM_SIZE_CH1_OUT_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_SRAM_SIZE_CH1.Reg, volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH1.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetOUT_SRAM_SIZE_CH1_OUT_SIZE() uint32 {
	return volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH1.Reg) & 0x7f
}

// DMA.IN_SRAM_SIZE_CH2: Receive L2 FIFO depth of Rx channel 0
func (o *DMA_Type) SetIN_SRAM_SIZE_CH2_IN_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_SRAM_SIZE_CH2.Reg, volatile.LoadUint32(&o.IN_SRAM_SIZE_CH2.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetIN_SRAM_SIZE_CH2_IN_SIZE() uint32 {
	return volatile.LoadUint32(&o.IN_SRAM_SIZE_CH2.Reg) & 0x7f
}

// DMA.OUT_SRAM_SIZE_CH2: Transmit L2 FIFO depth of Tx channel 0
func (o *DMA_Type) SetOUT_SRAM_SIZE_CH2_OUT_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_SRAM_SIZE_CH2.Reg, volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH2.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetOUT_SRAM_SIZE_CH2_OUT_SIZE() uint32 {
	return volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH2.Reg) & 0x7f
}

// DMA.IN_SRAM_SIZE_CH3: Receive L2 FIFO depth of Rx channel 0
func (o *DMA_Type) SetIN_SRAM_SIZE_CH3_IN_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_SRAM_SIZE_CH3.Reg, volatile.LoadUint32(&o.IN_SRAM_SIZE_CH3.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetIN_SRAM_SIZE_CH3_IN_SIZE() uint32 {
	return volatile.LoadUint32(&o.IN_SRAM_SIZE_CH3.Reg) & 0x7f
}

// DMA.OUT_SRAM_SIZE_CH3: Transmit L2 FIFO depth of Tx channel 0
func (o *DMA_Type) SetOUT_SRAM_SIZE_CH3_OUT_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_SRAM_SIZE_CH3.Reg, volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH3.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetOUT_SRAM_SIZE_CH3_OUT_SIZE() uint32 {
	return volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH3.Reg) & 0x7f
}

// DMA.IN_SRAM_SIZE_CH4: Receive L2 FIFO depth of Rx channel 0
func (o *DMA_Type) SetIN_SRAM_SIZE_CH4_IN_SIZE(value uint32) {
	volatile.StoreUint32(&o.IN_SRAM_SIZE_CH4.Reg, volatile.LoadUint32(&o.IN_SRAM_SIZE_CH4.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetIN_SRAM_SIZE_CH4_IN_SIZE() uint32 {
	return volatile.LoadUint32(&o.IN_SRAM_SIZE_CH4.Reg) & 0x7f
}

// DMA.OUT_SRAM_SIZE_CH4: Transmit L2 FIFO depth of Tx channel 0
func (o *DMA_Type) SetOUT_SRAM_SIZE_CH4_OUT_SIZE(value uint32) {
	volatile.StoreUint32(&o.OUT_SRAM_SIZE_CH4.Reg, volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH4.Reg)&^(0x7f)|value)
}
func (o *DMA_Type) GetOUT_SRAM_SIZE_CH4_OUT_SIZE() uint32 {
	return volatile.LoadUint32(&o.OUT_SRAM_SIZE_CH4.Reg) & 0x7f
}

// DMA.EXTMEM_REJECT_ADDR: Reject address accessing external RAM
func (o *DMA_Type) SetEXTMEM_REJECT_ADDR(value uint32) {
	volatile.StoreUint32(&o.EXTMEM_REJECT_ADDR.Reg, value)
}
func (o *DMA_Type) GetEXTMEM_REJECT_ADDR() uint32 {
	return volatile.LoadUint32(&o.EXTMEM_REJECT_ADDR.Reg)
}

// DMA.EXTMEM_REJECT_ST: Reject status accessing external RAM
func (o *DMA_Type) SetEXTMEM_REJECT_ST_EXTMEM_REJECT_ATRR(value uint32) {
	volatile.StoreUint32(&o.EXTMEM_REJECT_ST.Reg, volatile.LoadUint32(&o.EXTMEM_REJECT_ST.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetEXTMEM_REJECT_ST_EXTMEM_REJECT_ATRR() uint32 {
	return volatile.LoadUint32(&o.EXTMEM_REJECT_ST.Reg) & 0x3
}
func (o *DMA_Type) SetEXTMEM_REJECT_ST_EXTMEM_REJECT_CHANNEL_NUM(value uint32) {
	volatile.StoreUint32(&o.EXTMEM_REJECT_ST.Reg, volatile.LoadUint32(&o.EXTMEM_REJECT_ST.Reg)&^(0x3c)|value<<2)
}
func (o *DMA_Type) GetEXTMEM_REJECT_ST_EXTMEM_REJECT_CHANNEL_NUM() uint32 {
	return (volatile.LoadUint32(&o.EXTMEM_REJECT_ST.Reg) & 0x3c) >> 2
}
func (o *DMA_Type) SetEXTMEM_REJECT_ST_EXTMEM_REJECT_PERI_NUM(value uint32) {
	volatile.StoreUint32(&o.EXTMEM_REJECT_ST.Reg, volatile.LoadUint32(&o.EXTMEM_REJECT_ST.Reg)&^(0xfc0)|value<<6)
}
func (o *DMA_Type) GetEXTMEM_REJECT_ST_EXTMEM_REJECT_PERI_NUM() uint32 {
	return (volatile.LoadUint32(&o.EXTMEM_REJECT_ST.Reg) & 0xfc0) >> 6
}

// DMA.EXTMEM_REJECT_INT_RAW: Raw interrupt status of external RAM permission
func (o *DMA_Type) SetEXTMEM_REJECT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.EXTMEM_REJECT_INT_RAW.Reg, volatile.LoadUint32(&o.EXTMEM_REJECT_INT_RAW.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEXTMEM_REJECT_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.EXTMEM_REJECT_INT_RAW.Reg) & 0x1
}

// DMA.EXTMEM_REJECT_INT_ST: Masked interrupt status of external RAM permission
func (o *DMA_Type) SetEXTMEM_REJECT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.EXTMEM_REJECT_INT_ST.Reg, volatile.LoadUint32(&o.EXTMEM_REJECT_INT_ST.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEXTMEM_REJECT_INT_ST() uint32 {
	return volatile.LoadUint32(&o.EXTMEM_REJECT_INT_ST.Reg) & 0x1
}

// DMA.EXTMEM_REJECT_INT_ENA: Interrupt enable bits of external RAM permission
func (o *DMA_Type) SetEXTMEM_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.EXTMEM_REJECT_INT_ENA.Reg, volatile.LoadUint32(&o.EXTMEM_REJECT_INT_ENA.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEXTMEM_REJECT_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.EXTMEM_REJECT_INT_ENA.Reg) & 0x1
}

// DMA.EXTMEM_REJECT_INT_CLR: Interrupt clear bits of external RAM permission
func (o *DMA_Type) SetEXTMEM_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.EXTMEM_REJECT_INT_CLR.Reg, volatile.LoadUint32(&o.EXTMEM_REJECT_INT_CLR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEXTMEM_REJECT_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.EXTMEM_REJECT_INT_CLR.Reg) & 0x1
}

// DMA.DATE: Version control register
func (o *DMA_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *DMA_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// Digital Signature
type DS_Type struct {
	C_MEM           [1584]volatile.Register8 // 0x0
	IV_0            volatile.Register32      // 0x630
	IV_1            volatile.Register32      // 0x634
	IV_2            volatile.Register32      // 0x638
	IV_3            volatile.Register32      // 0x63C
	_               [448]byte
	X_MEM           [512]volatile.Register8 // 0x800
	Z_MEM           [512]volatile.Register8 // 0xA00
	_               [512]byte
	SET_START       volatile.Register32 // 0xE00
	SET_ME          volatile.Register32 // 0xE04
	SET_FINISH      volatile.Register32 // 0xE08
	QUERY_BUSY      volatile.Register32 // 0xE0C
	QUERY_KEY_WRONG volatile.Register32 // 0xE10
	QUERY_CHECK     volatile.Register32 // 0xE14
	_               [8]byte
	DATE            volatile.Register32 // 0xE20
}

// DS.IV_0: IV block data
func (o *DS_Type) SetIV_0(value uint32) {
	volatile.StoreUint32(&o.IV_0.Reg, value)
}
func (o *DS_Type) GetIV_0() uint32 {
	return volatile.LoadUint32(&o.IV_0.Reg)
}

// DS.IV_1: IV block data
func (o *DS_Type) SetIV_1(value uint32) {
	volatile.StoreUint32(&o.IV_1.Reg, value)
}
func (o *DS_Type) GetIV_1() uint32 {
	return volatile.LoadUint32(&o.IV_1.Reg)
}

// DS.IV_2: IV block data
func (o *DS_Type) SetIV_2(value uint32) {
	volatile.StoreUint32(&o.IV_2.Reg, value)
}
func (o *DS_Type) GetIV_2() uint32 {
	return volatile.LoadUint32(&o.IV_2.Reg)
}

// DS.IV_3: IV block data
func (o *DS_Type) SetIV_3(value uint32) {
	volatile.StoreUint32(&o.IV_3.Reg, value)
}
func (o *DS_Type) GetIV_3() uint32 {
	return volatile.LoadUint32(&o.IV_3.Reg)
}

// DS.SET_START: Activates the DS peripheral
func (o *DS_Type) SetSET_START(value uint32) {
	volatile.StoreUint32(&o.SET_START.Reg, volatile.LoadUint32(&o.SET_START.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_START() uint32 {
	return volatile.LoadUint32(&o.SET_START.Reg) & 0x1
}

// DS.SET_ME: Starts DS operation
func (o *DS_Type) SetSET_ME(value uint32) {
	volatile.StoreUint32(&o.SET_ME.Reg, volatile.LoadUint32(&o.SET_ME.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_ME() uint32 {
	return volatile.LoadUint32(&o.SET_ME.Reg) & 0x1
}

// DS.SET_FINISH: Ends DS operation
func (o *DS_Type) SetSET_FINISH(value uint32) {
	volatile.StoreUint32(&o.SET_FINISH.Reg, volatile.LoadUint32(&o.SET_FINISH.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_FINISH() uint32 {
	return volatile.LoadUint32(&o.SET_FINISH.Reg) & 0x1
}

// DS.QUERY_BUSY: Status of the DS perihperal
func (o *DS_Type) SetQUERY_BUSY(value uint32) {
	volatile.StoreUint32(&o.QUERY_BUSY.Reg, volatile.LoadUint32(&o.QUERY_BUSY.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetQUERY_BUSY() uint32 {
	return volatile.LoadUint32(&o.QUERY_BUSY.Reg) & 0x1
}

// DS.QUERY_KEY_WRONG: Checks the reason why DS_KEY is not ready
func (o *DS_Type) SetQUERY_KEY_WRONG(value uint32) {
	volatile.StoreUint32(&o.QUERY_KEY_WRONG.Reg, volatile.LoadUint32(&o.QUERY_KEY_WRONG.Reg)&^(0xf)|value)
}
func (o *DS_Type) GetQUERY_KEY_WRONG() uint32 {
	return volatile.LoadUint32(&o.QUERY_KEY_WRONG.Reg) & 0xf
}

// DS.QUERY_CHECK: Queries DS check result
func (o *DS_Type) SetQUERY_CHECK_MD_ERROR(value uint32) {
	volatile.StoreUint32(&o.QUERY_CHECK.Reg, volatile.LoadUint32(&o.QUERY_CHECK.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetQUERY_CHECK_MD_ERROR() uint32 {
	return volatile.LoadUint32(&o.QUERY_CHECK.Reg) & 0x1
}
func (o *DS_Type) SetQUERY_CHECK_PADDING_BAD(value uint32) {
	volatile.StoreUint32(&o.QUERY_CHECK.Reg, volatile.LoadUint32(&o.QUERY_CHECK.Reg)&^(0x2)|value<<1)
}
func (o *DS_Type) GetQUERY_CHECK_PADDING_BAD() uint32 {
	return (volatile.LoadUint32(&o.QUERY_CHECK.Reg) & 0x2) >> 1
}

// DS.DATE: DS version control register
func (o *DS_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *DS_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// eFuse Controller
type EFUSE_Type struct {
	PGM_DATA0          volatile.Register32 // 0x0
	PGM_DATA1          volatile.Register32 // 0x4
	PGM_DATA2          volatile.Register32 // 0x8
	PGM_DATA3          volatile.Register32 // 0xC
	PGM_DATA4          volatile.Register32 // 0x10
	PGM_DATA5          volatile.Register32 // 0x14
	PGM_DATA6          volatile.Register32 // 0x18
	PGM_DATA7          volatile.Register32 // 0x1C
	PGM_CHECK_VALUE0   volatile.Register32 // 0x20
	PGM_CHECK_VALUE1   volatile.Register32 // 0x24
	PGM_CHECK_VALUE2   volatile.Register32 // 0x28
	RD_WR_DIS          volatile.Register32 // 0x2C
	RD_REPEAT_DATA0    volatile.Register32 // 0x30
	RD_REPEAT_DATA1    volatile.Register32 // 0x34
	RD_REPEAT_DATA2    volatile.Register32 // 0x38
	RD_REPEAT_DATA3    volatile.Register32 // 0x3C
	RD_REPEAT_DATA4    volatile.Register32 // 0x40
	RD_MAC_SPI_SYS_0   volatile.Register32 // 0x44
	RD_MAC_SPI_SYS_1   volatile.Register32 // 0x48
	RD_MAC_SPI_SYS_2   volatile.Register32 // 0x4C
	RD_MAC_SPI_SYS_3   volatile.Register32 // 0x50
	RD_MAC_SPI_SYS_4   volatile.Register32 // 0x54
	RD_MAC_SPI_SYS_5   volatile.Register32 // 0x58
	RD_SYS_PART1_DATA0 volatile.Register32 // 0x5C
	RD_SYS_PART1_DATA1 volatile.Register32 // 0x60
	RD_SYS_PART1_DATA2 volatile.Register32 // 0x64
	RD_SYS_PART1_DATA3 volatile.Register32 // 0x68
	RD_SYS_PART1_DATA4 volatile.Register32 // 0x6C
	RD_SYS_PART1_DATA5 volatile.Register32 // 0x70
	RD_SYS_PART1_DATA6 volatile.Register32 // 0x74
	RD_SYS_PART1_DATA7 volatile.Register32 // 0x78
	RD_USR_DATA0       volatile.Register32 // 0x7C
	RD_USR_DATA1       volatile.Register32 // 0x80
	RD_USR_DATA2       volatile.Register32 // 0x84
	RD_USR_DATA3       volatile.Register32 // 0x88
	RD_USR_DATA4       volatile.Register32 // 0x8C
	RD_USR_DATA5       volatile.Register32 // 0x90
	RD_USR_DATA6       volatile.Register32 // 0x94
	RD_USR_DATA7       volatile.Register32 // 0x98
	RD_KEY0_DATA0      volatile.Register32 // 0x9C
	RD_KEY0_DATA1      volatile.Register32 // 0xA0
	RD_KEY0_DATA2      volatile.Register32 // 0xA4
	RD_KEY0_DATA3      volatile.Register32 // 0xA8
	RD_KEY0_DATA4      volatile.Register32 // 0xAC
	RD_KEY0_DATA5      volatile.Register32 // 0xB0
	RD_KEY0_DATA6      volatile.Register32 // 0xB4
	RD_KEY0_DATA7      volatile.Register32 // 0xB8
	RD_KEY1_DATA0      volatile.Register32 // 0xBC
	RD_KEY1_DATA1      volatile.Register32 // 0xC0
	RD_KEY1_DATA2      volatile.Register32 // 0xC4
	RD_KEY1_DATA3      volatile.Register32 // 0xC8
	RD_KEY1_DATA4      volatile.Register32 // 0xCC
	RD_KEY1_DATA5      volatile.Register32 // 0xD0
	RD_KEY1_DATA6      volatile.Register32 // 0xD4
	RD_KEY1_DATA7      volatile.Register32 // 0xD8
	RD_KEY2_DATA0      volatile.Register32 // 0xDC
	RD_KEY2_DATA1      volatile.Register32 // 0xE0
	RD_KEY2_DATA2      volatile.Register32 // 0xE4
	RD_KEY2_DATA3      volatile.Register32 // 0xE8
	RD_KEY2_DATA4      volatile.Register32 // 0xEC
	RD_KEY2_DATA5      volatile.Register32 // 0xF0
	RD_KEY2_DATA6      volatile.Register32 // 0xF4
	RD_KEY2_DATA7      volatile.Register32 // 0xF8
	RD_KEY3_DATA0      volatile.Register32 // 0xFC
	RD_KEY3_DATA1      volatile.Register32 // 0x100
	RD_KEY3_DATA2      volatile.Register32 // 0x104
	RD_KEY3_DATA3      volatile.Register32 // 0x108
	RD_KEY3_DATA4      volatile.Register32 // 0x10C
	RD_KEY3_DATA5      volatile.Register32 // 0x110
	RD_KEY3_DATA6      volatile.Register32 // 0x114
	RD_KEY3_DATA7      volatile.Register32 // 0x118
	RD_KEY4_DATA0      volatile.Register32 // 0x11C
	RD_KEY4_DATA1      volatile.Register32 // 0x120
	RD_KEY4_DATA2      volatile.Register32 // 0x124
	RD_KEY4_DATA3      volatile.Register32 // 0x128
	RD_KEY4_DATA4      volatile.Register32 // 0x12C
	RD_KEY4_DATA5      volatile.Register32 // 0x130
	RD_KEY4_DATA6      volatile.Register32 // 0x134
	RD_KEY4_DATA7      volatile.Register32 // 0x138
	RD_KEY5_DATA0      volatile.Register32 // 0x13C
	RD_KEY5_DATA1      volatile.Register32 // 0x140
	RD_KEY5_DATA2      volatile.Register32 // 0x144
	RD_KEY5_DATA3      volatile.Register32 // 0x148
	RD_KEY5_DATA4      volatile.Register32 // 0x14C
	RD_KEY5_DATA5      volatile.Register32 // 0x150
	RD_KEY5_DATA6      volatile.Register32 // 0x154
	RD_KEY5_DATA7      volatile.Register32 // 0x158
	RD_SYS_PART2_DATA0 volatile.Register32 // 0x15C
	RD_SYS_PART2_DATA1 volatile.Register32 // 0x160
	RD_SYS_PART2_DATA2 volatile.Register32 // 0x164
	RD_SYS_PART2_DATA3 volatile.Register32 // 0x168
	RD_SYS_PART2_DATA4 volatile.Register32 // 0x16C
	RD_SYS_PART2_DATA5 volatile.Register32 // 0x170
	RD_SYS_PART2_DATA6 volatile.Register32 // 0x174
	RD_SYS_PART2_DATA7 volatile.Register32 // 0x178
	RD_REPEAT_ERR0     volatile.Register32 // 0x17C
	RD_REPEAT_ERR1     volatile.Register32 // 0x180
	RD_REPEAT_ERR2     volatile.Register32 // 0x184
	RD_REPEAT_ERR3     volatile.Register32 // 0x188
	_                  [4]byte
	RD_REPEAT_ERR4     volatile.Register32 // 0x190
	_                  [44]byte
	RD_RS_ERR0         volatile.Register32 // 0x1C0
	RD_RS_ERR1         volatile.Register32 // 0x1C4
	CLK                volatile.Register32 // 0x1C8
	CONF               volatile.Register32 // 0x1CC
	STATUS             volatile.Register32 // 0x1D0
	CMD                volatile.Register32 // 0x1D4
	INT_RAW            volatile.Register32 // 0x1D8
	INT_ST             volatile.Register32 // 0x1DC
	INT_ENA            volatile.Register32 // 0x1E0
	INT_CLR            volatile.Register32 // 0x1E4
	DAC_CONF           volatile.Register32 // 0x1E8
	RD_TIM_CONF        volatile.Register32 // 0x1EC
	_                  [4]byte
	WR_TIM_CONF1       volatile.Register32 // 0x1F4
	WR_TIM_CONF2       volatile.Register32 // 0x1F8
	DATE               volatile.Register32 // 0x1FC
}

// EFUSE.PGM_DATA0: Register 0 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA0(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA0() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA0.Reg)
}

// EFUSE.PGM_DATA1: Register 1 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA1(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA1() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA1.Reg)
}

// EFUSE.PGM_DATA2: Register 2 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA2(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA2() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA2.Reg)
}

// EFUSE.PGM_DATA3: Register 3 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA3(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA3() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA3.Reg)
}

// EFUSE.PGM_DATA4: Register 4 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA4(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA4() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA4.Reg)
}

// EFUSE.PGM_DATA5: Register 5 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA5(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA5() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA5.Reg)
}

// EFUSE.PGM_DATA6: Register 6 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA6(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA6() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA6.Reg)
}

// EFUSE.PGM_DATA7: Register 7 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA7(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA7() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA7.Reg)
}

// EFUSE.PGM_CHECK_VALUE0: Register 0 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE0(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE0() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE0.Reg)
}

// EFUSE.PGM_CHECK_VALUE1: Register 1 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE1(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE1() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE1.Reg)
}

// EFUSE.PGM_CHECK_VALUE2: Register 2 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE2(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE2() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE2.Reg)
}

// EFUSE.RD_WR_DIS: BLOCK0 data register 0.
func (o *EFUSE_Type) SetRD_WR_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_WR_DIS.Reg, value)
}
func (o *EFUSE_Type) GetRD_WR_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_WR_DIS.Reg)
}

// EFUSE.RD_REPEAT_DATA0: BLOCK0 data register 1.
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RD_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RD_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x7f
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_RTC_RAM_BOOT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_RTC_RAM_BOOT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DCACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DCACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_DCACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_DCACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_FORCE_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_FORCE_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_USB(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_USB() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_CAN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_CAN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_APP_CPU(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_APP_CPU() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_SOFT_DIS_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_SOFT_DIS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_PAD_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_PAD_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_DREFH(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x600000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_DREFH() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x600000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_DREFL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_DREFL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_EXCHG_PINS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_EXCHG_PINS() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_EXT_PHY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_EXT_PHY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_BTLC_GPIO_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x18000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_BTLC_GPIO_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x18000000) >> 27
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_VDD_SPI_MODECURLIM(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x20000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_VDD_SPI_MODECURLIM() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x20000000) >> 29
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_VDD_SPI_DREFH(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_VDD_SPI_DREFH() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_DATA1: BLOCK0 data register 2.
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_DREFM(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x3)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_DREFM() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x3
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_DREFL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xc)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_DREFL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xc) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_XPD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_XPD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_TIEH(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_TIEH() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_FORCE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_FORCE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_EN_INIT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_EN_INIT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_ENCURLIM(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_ENCURLIM() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_DCURLIM(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xe00)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_DCURLIM() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xe00) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_INIT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x3000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_INIT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x3000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_DCAP(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_DCAP() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_WDT_DELAY_SEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_WDT_DELAY_SEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SPI_BOOT_CRYPT_CNT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x1c0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SPI_BOOT_CRYPT_CNT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x1c0000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_KEY_PURPOSE_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xf000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_KEY_PURPOSE_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xf000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_KEY_PURPOSE_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_KEY_PURPOSE_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_DATA2: BLOCK0 data register 3.
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_2() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_3(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_3() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_4(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf00)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_4() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf00) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_5(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_5() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_RPT4_RESERVED0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_RPT4_RESERVED0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_SECURE_BOOT_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_SECURE_BOOT_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_SECURE_BOOT_AGGRESSIVE_REVOKE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_SECURE_BOOT_AGGRESSIVE_REVOKE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_DIS_USB_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_DIS_USB_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_DIS_USB_DEVICE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_DIS_USB_DEVICE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_STRAP_JTAG_SEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x1000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_STRAP_JTAG_SEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x1000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_USB_PHY_SEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_USB_PHY_SEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_POWER_GLITCH_DSENSE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xc000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_POWER_GLITCH_DSENSE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xc000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_FLASH_TPUW(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_FLASH_TPUW() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_DATA3: BLOCK0 data register 4.
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_DOWNLOAD_MODE() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x1
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_LEGACY_SPI_BOOT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_LEGACY_SPI_BOOT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_UART_PRINT_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_UART_PRINT_CHANNEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_ECC_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_ECC_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_USB_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_USB_DOWNLOAD_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_ENABLE_SECURITY_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_ENABLE_SECURITY_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_UART_PRINT_CONTROL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xc0)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_UART_PRINT_CONTROL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xc0) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_PIN_POWER_SELECTION(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_PIN_POWER_SELECTION() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_TYPE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_PAGE_SIZE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xc00)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_PAGE_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xc00) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_ECC_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_ECC_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FORCE_SEND_RESUME(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FORCE_SEND_RESUME() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_SECURE_VERSION(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x3fffc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_SECURE_VERSION() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x3fffc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_POWERGLITCH_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x40000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_POWERGLITCH_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x40000000) >> 30
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x80000000)|value<<31)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x80000000) >> 31
}

// EFUSE.RD_REPEAT_DATA4: BLOCK0 data register 5.
func (o *EFUSE_Type) SetRD_REPEAT_DATA4_RPT4_RESERVED2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA4.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA4_RPT4_RESERVED2() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg) & 0xffffff
}

// EFUSE.RD_MAC_SPI_SYS_0: BLOCK1 data register 0.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_0.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_0() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_0.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_1: BLOCK1 data register 1.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_1_MAC_1(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_1.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_1_MAC_1() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_1_SPI_PAD_CONF_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_1.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_1_SPI_PAD_CONF_0() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg) & 0xffff0000) >> 16
}

// EFUSE.RD_MAC_SPI_SYS_2: BLOCK1 data register 2.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_2(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_2.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_2() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_2.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_3: BLOCK1 data register 3.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_3_SPI_PAD_CONF_2(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_3.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg)&^(0x3ffff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_3_SPI_PAD_CONF_2() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg) & 0x3ffff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_3_SYS_DATA_PART0_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_3.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg)&^(0xfffc0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_3_SYS_DATA_PART0_0() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg) & 0xfffc0000) >> 18
}

// EFUSE.RD_MAC_SPI_SYS_4: BLOCK1 data register 4.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_4(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_4.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_4() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_4.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_5: BLOCK1 data register 5.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_5(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_5.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_5() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_5.Reg)
}

// EFUSE.RD_SYS_PART1_DATA0: Register 0 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA0.Reg)
}

// EFUSE.RD_SYS_PART1_DATA1: Register 1 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA1.Reg)
}

// EFUSE.RD_SYS_PART1_DATA2: Register 2 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA2.Reg)
}

// EFUSE.RD_SYS_PART1_DATA3: Register 3 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA3.Reg)
}

// EFUSE.RD_SYS_PART1_DATA4: Register 4 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA4.Reg)
}

// EFUSE.RD_SYS_PART1_DATA5: Register 5 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA5.Reg)
}

// EFUSE.RD_SYS_PART1_DATA6: Register 6 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA6.Reg)
}

// EFUSE.RD_SYS_PART1_DATA7: Register 7 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA7.Reg)
}

// EFUSE.RD_USR_DATA0: Register 0 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA0.Reg)
}

// EFUSE.RD_USR_DATA1: Register 1 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA1.Reg)
}

// EFUSE.RD_USR_DATA2: Register 2 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA2.Reg)
}

// EFUSE.RD_USR_DATA3: Register 3 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA3.Reg)
}

// EFUSE.RD_USR_DATA4: Register 4 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA4.Reg)
}

// EFUSE.RD_USR_DATA5: Register 5 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA5.Reg)
}

// EFUSE.RD_USR_DATA6: Register 6 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA6.Reg)
}

// EFUSE.RD_USR_DATA7: Register 7 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA7.Reg)
}

// EFUSE.RD_KEY0_DATA0: Register 0 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA0.Reg)
}

// EFUSE.RD_KEY0_DATA1: Register 1 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA1.Reg)
}

// EFUSE.RD_KEY0_DATA2: Register 2 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA2.Reg)
}

// EFUSE.RD_KEY0_DATA3: Register 3 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA3.Reg)
}

// EFUSE.RD_KEY0_DATA4: Register 4 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA4.Reg)
}

// EFUSE.RD_KEY0_DATA5: Register 5 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA5.Reg)
}

// EFUSE.RD_KEY0_DATA6: Register 6 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA6.Reg)
}

// EFUSE.RD_KEY0_DATA7: Register 7 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA7.Reg)
}

// EFUSE.RD_KEY1_DATA0: Register 0 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA0.Reg)
}

// EFUSE.RD_KEY1_DATA1: Register 1 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA1.Reg)
}

// EFUSE.RD_KEY1_DATA2: Register 2 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA2.Reg)
}

// EFUSE.RD_KEY1_DATA3: Register 3 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA3.Reg)
}

// EFUSE.RD_KEY1_DATA4: Register 4 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA4.Reg)
}

// EFUSE.RD_KEY1_DATA5: Register 5 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA5.Reg)
}

// EFUSE.RD_KEY1_DATA6: Register 6 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA6.Reg)
}

// EFUSE.RD_KEY1_DATA7: Register 7 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA7.Reg)
}

// EFUSE.RD_KEY2_DATA0: Register 0 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA0.Reg)
}

// EFUSE.RD_KEY2_DATA1: Register 1 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA1.Reg)
}

// EFUSE.RD_KEY2_DATA2: Register 2 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA2.Reg)
}

// EFUSE.RD_KEY2_DATA3: Register 3 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA3.Reg)
}

// EFUSE.RD_KEY2_DATA4: Register 4 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA4.Reg)
}

// EFUSE.RD_KEY2_DATA5: Register 5 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA5.Reg)
}

// EFUSE.RD_KEY2_DATA6: Register 6 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA6.Reg)
}

// EFUSE.RD_KEY2_DATA7: Register 7 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA7.Reg)
}

// EFUSE.RD_KEY3_DATA0: Register 0 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA0.Reg)
}

// EFUSE.RD_KEY3_DATA1: Register 1 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA1.Reg)
}

// EFUSE.RD_KEY3_DATA2: Register 2 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA2.Reg)
}

// EFUSE.RD_KEY3_DATA3: Register 3 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA3.Reg)
}

// EFUSE.RD_KEY3_DATA4: Register 4 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA4.Reg)
}

// EFUSE.RD_KEY3_DATA5: Register 5 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA5.Reg)
}

// EFUSE.RD_KEY3_DATA6: Register 6 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA6.Reg)
}

// EFUSE.RD_KEY3_DATA7: Register 7 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA7.Reg)
}

// EFUSE.RD_KEY4_DATA0: Register 0 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA0.Reg)
}

// EFUSE.RD_KEY4_DATA1: Register 1 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA1.Reg)
}

// EFUSE.RD_KEY4_DATA2: Register 2 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA2.Reg)
}

// EFUSE.RD_KEY4_DATA3: Register 3 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA3.Reg)
}

// EFUSE.RD_KEY4_DATA4: Register 4 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA4.Reg)
}

// EFUSE.RD_KEY4_DATA5: Register 5 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA5.Reg)
}

// EFUSE.RD_KEY4_DATA6: Register 6 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA6.Reg)
}

// EFUSE.RD_KEY4_DATA7: Register 7 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA7.Reg)
}

// EFUSE.RD_KEY5_DATA0: Register 0 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA0.Reg)
}

// EFUSE.RD_KEY5_DATA1: Register 1 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA1.Reg)
}

// EFUSE.RD_KEY5_DATA2: Register 2 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA2.Reg)
}

// EFUSE.RD_KEY5_DATA3: Register 3 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA3.Reg)
}

// EFUSE.RD_KEY5_DATA4: Register 4 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA4.Reg)
}

// EFUSE.RD_KEY5_DATA5: Register 5 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA5.Reg)
}

// EFUSE.RD_KEY5_DATA6: Register 6 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA6.Reg)
}

// EFUSE.RD_KEY5_DATA7: Register 7 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA7.Reg)
}

// EFUSE.RD_SYS_PART2_DATA0: Register 0 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA0.Reg)
}

// EFUSE.RD_SYS_PART2_DATA1: Register 1 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA1.Reg)
}

// EFUSE.RD_SYS_PART2_DATA2: Register 2 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA2.Reg)
}

// EFUSE.RD_SYS_PART2_DATA3: Register 3 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA3.Reg)
}

// EFUSE.RD_SYS_PART2_DATA4: Register 4 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA4.Reg)
}

// EFUSE.RD_SYS_PART2_DATA5: Register 5 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA5.Reg)
}

// EFUSE.RD_SYS_PART2_DATA6: Register 6 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA6.Reg)
}

// EFUSE.RD_SYS_PART2_DATA7: Register 7 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA7.Reg)
}

// EFUSE.RD_REPEAT_ERR0: Programming error record register 0 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RD_DIS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RD_DIS_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x7f
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_RTC_RAM_BOOT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_RTC_RAM_BOOT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DCACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DCACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_DCACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_DCACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_FORCE_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_FORCE_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_USB_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_USB_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_CAN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_CAN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_APP_CPU_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_APP_CPU_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_SOFT_DIS_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_SOFT_DIS_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_PAD_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_PAD_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_DREFH_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x600000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_DREFH_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x600000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_DREFL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x1800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_DREFL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x1800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_EXCHG_PINS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_EXCHG_PINS_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_EXT_PHY_ENABLE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x4000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_EXT_PHY_ENABLE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x4000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_BTLC_GPIO_ENABLE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x18000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_BTLC_GPIO_ENABLE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x18000000) >> 27
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_VDD_SPI_MODECURLIM_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x20000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_VDD_SPI_MODECURLIM_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x20000000) >> 29
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_VDD_SPI_DREFH_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_VDD_SPI_DREFH_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_ERR1: Programming error record register 1 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_DREFM_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x3)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_DREFM_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x3
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_DREFL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xc)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_DREFL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xc) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_XPD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_XPD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_TIEH_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_TIEH_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_FORCE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_FORCE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_EN_INIT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_EN_INIT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_ENCURLIM_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_ENCURLIM_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_DCURLIM_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xe00)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_DCURLIM_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xe00) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_INIT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x3000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_INIT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x3000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_DCAP_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_DCAP_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_WDT_DELAY_SEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_WDT_DELAY_SEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SPI_BOOT_CRYPT_CNT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SPI_BOOT_CRYPT_CNT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x1c0000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE2_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_KEY_PURPOSE_0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xf000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_KEY_PURPOSE_0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xf000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_KEY_PURPOSE_1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_KEY_PURPOSE_1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_ERR2: Programming error record register 2 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_2_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_3_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_3_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_4_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf00)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_4_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf00) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_5_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_5_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_RPT4_RESERVED0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_RPT4_RESERVED0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SECURE_BOOT_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SECURE_BOOT_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SECURE_BOOT_AGGRESSIVE_REVOKE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SECURE_BOOT_AGGRESSIVE_REVOKE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_DIS_USB_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_DIS_USB_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_DIS_USB_DEVICE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_DIS_USB_DEVICE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_STRAP_JTAG_SEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x1000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_STRAP_JTAG_SEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x1000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_USB_PHY_SEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_USB_PHY_SEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_POWER_GLITCH_DSENSE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xc000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_POWER_GLITCH_DSENSE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xc000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_FLASH_TPUW_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_FLASH_TPUW_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_ERR3: Programming error record register 3 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_DOWNLOAD_MODE_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x1
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_LEGACY_SPI_BOOT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_LEGACY_SPI_BOOT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_UART_PRINT_CHANNEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_UART_PRINT_CHANNEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_ECC_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_ECC_MODE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_USB_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_USB_DOWNLOAD_MODE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_ENABLE_SECURITY_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_ENABLE_SECURITY_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_UART_PRINT_CONTROL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc0)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_UART_PRINT_CONTROL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc0) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_PIN_POWER_SELECTION_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_PIN_POWER_SELECTION_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_TYPE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_TYPE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_PAGE_SIZE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc00)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_PAGE_SIZE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc00) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_ECC_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_ECC_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FORCE_SEND_RESUME_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FORCE_SEND_RESUME_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_SECURE_VERSION_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x3fffc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_SECURE_VERSION_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x3fffc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_POWERGLITCH_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x40000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_POWERGLITCH_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x40000000) >> 30
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x80000000)|value<<31)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x80000000) >> 31
}

// EFUSE.RD_REPEAT_ERR4: Programming error record register 4 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR4_RPT4_RESERVED2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR4.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR4_RPT4_RESERVED2_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg) & 0xffffff
}

// EFUSE.RD_RS_ERR0: Programming error record register 0 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR0_MAC_SPI_8M_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_MAC_SPI_8M_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR0_MAC_SPI_8M_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_MAC_SPI_8M_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR0_SYS_PART1_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_SYS_PART1_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR0_SYS_PART1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_SYS_PART1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_RS_ERR0_USR_DATA_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x700)|value<<8)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_USR_DATA_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x700) >> 8
}
func (o *EFUSE_Type) SetRD_RS_ERR0_USR_DATA_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_USR_DATA_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY0_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7000)|value<<12)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY0_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7000) >> 12
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY0_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY0_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY1_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY1_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x700000)|value<<20)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x700000) >> 20
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY3_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY3_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7000000) >> 24
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY3_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY3_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8000000) >> 27
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY4_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY4_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70000000) >> 28
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY4_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80000000)|value<<31)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY4_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80000000) >> 31
}

// EFUSE.RD_RS_ERR1: Programming error record register 1 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR1_KEY5_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_KEY5_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR1_KEY5_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_KEY5_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR1_SYS_PART2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_SYS_PART2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR1_SYS_PART2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_SYS_PART2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x80) >> 7
}

// EFUSE.CLK: eFuse clcok configuration register.
func (o *EFUSE_Type) SetCLK_EFUSE_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCLK_EFUSE_MEM_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x1
}
func (o *EFUSE_Type) SetCLK_MEM_CLK_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCLK_MEM_CLK_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCLK_EFUSE_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetCLK_EFUSE_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x10000) >> 16
}

// EFUSE.CONF: eFuse operation mode configuraiton register
func (o *EFUSE_Type) SetCONF_OP_CODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetCONF_OP_CODE() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0xffff
}

// EFUSE.STATUS: eFuse status register.
func (o *EFUSE_Type) SetSTATUS_STATE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetSTATUS_STATE() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0xf
}
func (o *EFUSE_Type) SetSTATUS_OTP_LOAD_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetSTATUS_OTP_LOAD_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_C_SYNC2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_C_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetSTATUS_OTP_STROBE_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetSTATUS_OTP_STROBE_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetSTATUS_OTP_CSB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetSTATUS_OTP_CSB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetSTATUS_OTP_PGENB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetSTATUS_OTP_PGENB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_IS_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_IS_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetSTATUS_REPEAT_ERR_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3fc00)|value<<10)
}
func (o *EFUSE_Type) GetSTATUS_REPEAT_ERR_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x3fc00) >> 10
}

// EFUSE.CMD: eFuse command register.
func (o *EFUSE_Type) SetCMD_READ_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCMD_READ_CMD() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x1
}
func (o *EFUSE_Type) SetCMD_PGM_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCMD_PGM_CMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCMD_BLK_NUM(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3c)|value<<2)
}
func (o *EFUSE_Type) GetCMD_BLK_NUM() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x3c) >> 2
}

// EFUSE.INT_RAW: eFuse raw interrupt register.
func (o *EFUSE_Type) SetINT_RAW_READ_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_RAW_READ_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_RAW_PGM_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_RAW_PGM_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}

// EFUSE.INT_ST: eFuse interrupt status register.
func (o *EFUSE_Type) SetINT_ST_READ_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ST_READ_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ST_PGM_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ST_PGM_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}

// EFUSE.INT_ENA: eFuse interrupt enable register.
func (o *EFUSE_Type) SetINT_ENA_READ_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ENA_READ_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ENA_PGM_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ENA_PGM_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}

// EFUSE.INT_CLR: eFuse interrupt clear register.
func (o *EFUSE_Type) SetINT_CLR_READ_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_CLR_READ_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_CLR_PGM_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_CLR_PGM_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}

// EFUSE.DAC_CONF: Controls the eFuse programming voltage.
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_DIV() uint32 {
	return volatile.LoadUint32(&o.DAC_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_PAD_SEL(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_PAD_SEL() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_NUM(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x1fe00)|value<<9)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_NUM() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x1fe00) >> 9
}
func (o *EFUSE_Type) SetDAC_CONF_OE_CLR(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *EFUSE_Type) GetDAC_CONF_OE_CLR() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x20000) >> 17
}

// EFUSE.RD_TIM_CONF: Configures read timing parameters.
func (o *EFUSE_Type) SetRD_TIM_CONF_READ_INIT_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_READ_INIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff000000) >> 24
}

// EFUSE.WR_TIM_CONF1: Configurarion register 1 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF1_PWR_ON_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xffff00)|value<<8)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_PWR_ON_NUM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xffff00) >> 8
}

// EFUSE.WR_TIM_CONF2: Configurarion register 2 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF2_PWR_OFF_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF2.Reg, volatile.LoadUint32(&o.WR_TIM_CONF2.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF2_PWR_OFF_NUM() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF2.Reg) & 0xffff
}

// EFUSE.DATE: eFuse version register.
func (o *EFUSE_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *EFUSE_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// External Memory
type EXTMEM_Type struct {
	DCACHE_CTRL                          volatile.Register32 // 0x0
	DCACHE_CTRL1                         volatile.Register32 // 0x4
	DCACHE_TAG_POWER_CTRL                volatile.Register32 // 0x8
	DCACHE_PRELOCK_CTRL                  volatile.Register32 // 0xC
	DCACHE_PRELOCK_SCT0_ADDR             volatile.Register32 // 0x10
	DCACHE_PRELOCK_SCT1_ADDR             volatile.Register32 // 0x14
	DCACHE_PRELOCK_SCT_SIZE              volatile.Register32 // 0x18
	DCACHE_LOCK_CTRL                     volatile.Register32 // 0x1C
	DCACHE_LOCK_ADDR                     volatile.Register32 // 0x20
	DCACHE_LOCK_SIZE                     volatile.Register32 // 0x24
	DCACHE_SYNC_CTRL                     volatile.Register32 // 0x28
	DCACHE_SYNC_ADDR                     volatile.Register32 // 0x2C
	DCACHE_SYNC_SIZE                     volatile.Register32 // 0x30
	DCACHE_OCCUPY_CTRL                   volatile.Register32 // 0x34
	DCACHE_OCCUPY_ADDR                   volatile.Register32 // 0x38
	DCACHE_OCCUPY_SIZE                   volatile.Register32 // 0x3C
	DCACHE_PRELOAD_CTRL                  volatile.Register32 // 0x40
	DCACHE_PRELOAD_ADDR                  volatile.Register32 // 0x44
	DCACHE_PRELOAD_SIZE                  volatile.Register32 // 0x48
	DCACHE_AUTOLOAD_CTRL                 volatile.Register32 // 0x4C
	DCACHE_AUTOLOAD_SCT0_ADDR            volatile.Register32 // 0x50
	DCACHE_AUTOLOAD_SCT0_SIZE            volatile.Register32 // 0x54
	DCACHE_AUTOLOAD_SCT1_ADDR            volatile.Register32 // 0x58
	DCACHE_AUTOLOAD_SCT1_SIZE            volatile.Register32 // 0x5C
	ICACHE_CTRL                          volatile.Register32 // 0x60
	ICACHE_CTRL1                         volatile.Register32 // 0x64
	ICACHE_TAG_POWER_CTRL                volatile.Register32 // 0x68
	ICACHE_PRELOCK_CTRL                  volatile.Register32 // 0x6C
	ICACHE_PRELOCK_SCT0_ADDR             volatile.Register32 // 0x70
	ICACHE_PRELOCK_SCT1_ADDR             volatile.Register32 // 0x74
	ICACHE_PRELOCK_SCT_SIZE              volatile.Register32 // 0x78
	ICACHE_LOCK_CTRL                     volatile.Register32 // 0x7C
	ICACHE_LOCK_ADDR                     volatile.Register32 // 0x80
	ICACHE_LOCK_SIZE                     volatile.Register32 // 0x84
	ICACHE_SYNC_CTRL                     volatile.Register32 // 0x88
	ICACHE_SYNC_ADDR                     volatile.Register32 // 0x8C
	ICACHE_SYNC_SIZE                     volatile.Register32 // 0x90
	ICACHE_PRELOAD_CTRL                  volatile.Register32 // 0x94
	ICACHE_PRELOAD_ADDR                  volatile.Register32 // 0x98
	ICACHE_PRELOAD_SIZE                  volatile.Register32 // 0x9C
	ICACHE_AUTOLOAD_CTRL                 volatile.Register32 // 0xA0
	ICACHE_AUTOLOAD_SCT0_ADDR            volatile.Register32 // 0xA4
	ICACHE_AUTOLOAD_SCT0_SIZE            volatile.Register32 // 0xA8
	ICACHE_AUTOLOAD_SCT1_ADDR            volatile.Register32 // 0xAC
	ICACHE_AUTOLOAD_SCT1_SIZE            volatile.Register32 // 0xB0
	IBUS_TO_FLASH_START_VADDR            volatile.Register32 // 0xB4
	IBUS_TO_FLASH_END_VADDR              volatile.Register32 // 0xB8
	DBUS_TO_FLASH_START_VADDR            volatile.Register32 // 0xBC
	DBUS_TO_FLASH_END_VADDR              volatile.Register32 // 0xC0
	CACHE_ACS_CNT_CLR                    volatile.Register32 // 0xC4
	IBUS_ACS_MISS_CNT                    volatile.Register32 // 0xC8
	IBUS_ACS_CNT                         volatile.Register32 // 0xCC
	DBUS_ACS_FLASH_MISS_CNT              volatile.Register32 // 0xD0
	DBUS_ACS_SPIRAM_MISS_CNT             volatile.Register32 // 0xD4
	DBUS_ACS_CNT                         volatile.Register32 // 0xD8
	CACHE_ILG_INT_ENA                    volatile.Register32 // 0xDC
	CACHE_ILG_INT_CLR                    volatile.Register32 // 0xE0
	CACHE_ILG_INT_ST                     volatile.Register32 // 0xE4
	CORE0_ACS_CACHE_INT_ENA              volatile.Register32 // 0xE8
	CORE0_ACS_CACHE_INT_CLR              volatile.Register32 // 0xEC
	CORE0_ACS_CACHE_INT_ST               volatile.Register32 // 0xF0
	CORE1_ACS_CACHE_INT_ENA              volatile.Register32 // 0xF4
	CORE1_ACS_CACHE_INT_CLR              volatile.Register32 // 0xF8
	CORE1_ACS_CACHE_INT_ST               volatile.Register32 // 0xFC
	CORE0_DBUS_REJECT_ST                 volatile.Register32 // 0x100
	CORE0_DBUS_REJECT_VADDR              volatile.Register32 // 0x104
	CORE0_IBUS_REJECT_ST                 volatile.Register32 // 0x108
	CORE0_IBUS_REJECT_VADDR              volatile.Register32 // 0x10C
	CORE1_DBUS_REJECT_ST                 volatile.Register32 // 0x110
	CORE1_DBUS_REJECT_VADDR              volatile.Register32 // 0x114
	CORE1_IBUS_REJECT_ST                 volatile.Register32 // 0x118
	CORE1_IBUS_REJECT_VADDR              volatile.Register32 // 0x11C
	CACHE_MMU_FAULT_CONTENT              volatile.Register32 // 0x120
	CACHE_MMU_FAULT_VADDR                volatile.Register32 // 0x124
	CACHE_WRAP_AROUND_CTRL               volatile.Register32 // 0x128
	CACHE_MMU_POWER_CTRL                 volatile.Register32 // 0x12C
	CACHE_STATE                          volatile.Register32 // 0x130
	CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE volatile.Register32 // 0x134
	CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON   volatile.Register32 // 0x138
	CACHE_BRIDGE_ARBITER_CTRL            volatile.Register32 // 0x13C
	CACHE_PRELOAD_INT_CTRL               volatile.Register32 // 0x140
	CACHE_SYNC_INT_CTRL                  volatile.Register32 // 0x144
	CACHE_MMU_OWNER                      volatile.Register32 // 0x148
	CACHE_CONF_MISC                      volatile.Register32 // 0x14C
	DCACHE_FREEZE                        volatile.Register32 // 0x150
	ICACHE_FREEZE                        volatile.Register32 // 0x154
	ICACHE_ATOMIC_OPERATE_ENA            volatile.Register32 // 0x158
	DCACHE_ATOMIC_OPERATE_ENA            volatile.Register32 // 0x15C
	CACHE_REQUEST                        volatile.Register32 // 0x160
	CLOCK_GATE                           volatile.Register32 // 0x164
	_                                    [24]byte
	CACHE_TAG_OBJECT_CTRL                volatile.Register32 // 0x180
	CACHE_TAG_WAY_OBJECT                 volatile.Register32 // 0x184
	CACHE_VADDR                          volatile.Register32 // 0x188
	CACHE_TAG_CONTENT                    volatile.Register32 // 0x18C
	_                                    [620]byte
	DATE                                 volatile.Register32 // 0x3FC
}

// EXTMEM.DCACHE_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_CTRL_DCACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_CTRL_DCACHE_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DCACHE_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_CTRL_DCACHE_SIZE_MODE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetDCACHE_CTRL_DCACHE_SIZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetDCACHE_CTRL_DCACHE_BLOCKSIZE_MODE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *EXTMEM_Type) GetDCACHE_CTRL_DCACHE_BLOCKSIZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_CTRL.Reg) & 0x18) >> 3
}

// EXTMEM.DCACHE_CTRL1: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_CTRL1_DCACHE_SHUT_CORE0_BUS(value uint32) {
	volatile.StoreUint32(&o.DCACHE_CTRL1.Reg, volatile.LoadUint32(&o.DCACHE_CTRL1.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_CTRL1_DCACHE_SHUT_CORE0_BUS() uint32 {
	return volatile.LoadUint32(&o.DCACHE_CTRL1.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_CTRL1_DCACHE_SHUT_CORE1_BUS(value uint32) {
	volatile.StoreUint32(&o.DCACHE_CTRL1.Reg, volatile.LoadUint32(&o.DCACHE_CTRL1.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_CTRL1_DCACHE_SHUT_CORE1_BUS() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_CTRL1.Reg) & 0x2) >> 1
}

// EXTMEM.DCACHE_TAG_POWER_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_TAG_POWER_CTRL_DCACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.DCACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_TAG_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_TAG_POWER_CTRL_DCACHE_TAG_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.DCACHE_TAG_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_TAG_POWER_CTRL_DCACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DCACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_TAG_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_TAG_POWER_CTRL_DCACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_TAG_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetDCACHE_TAG_POWER_CTRL_DCACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DCACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_TAG_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetDCACHE_TAG_POWER_CTRL_DCACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_TAG_POWER_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.DCACHE_PRELOCK_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_PRELOCK_CTRL_DCACHE_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOCK_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_PRELOCK_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOCK_CTRL_DCACHE_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.DCACHE_PRELOCK_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_PRELOCK_CTRL_DCACHE_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOCK_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_PRELOCK_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOCK_CTRL_DCACHE_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_PRELOCK_CTRL.Reg) & 0x2) >> 1
}

// EXTMEM.DCACHE_PRELOCK_SCT0_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.DCACHE_PRELOCK_SCT0_ADDR.Reg)
}

// EXTMEM.DCACHE_PRELOCK_SCT1_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.DCACHE_PRELOCK_SCT1_ADDR.Reg)
}

// EXTMEM.DCACHE_PRELOCK_SCT_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_PRELOCK_SCT_SIZE_DCACHE_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.DCACHE_PRELOCK_SCT_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOCK_SCT_SIZE_DCACHE_PRELOCK_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.DCACHE_PRELOCK_SCT_SIZE.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetDCACHE_PRELOCK_SCT_SIZE_DCACHE_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.DCACHE_PRELOCK_SCT_SIZE.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOCK_SCT_SIZE_DCACHE_PRELOCK_SCT0_SIZE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_PRELOCK_SCT_SIZE.Reg) & 0xffff0000) >> 16
}

// EXTMEM.DCACHE_LOCK_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_LOCK_CTRL_DCACHE_LOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_LOCK_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_LOCK_CTRL_DCACHE_LOCK_ENA() uint32 {
	return volatile.LoadUint32(&o.DCACHE_LOCK_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_LOCK_CTRL_DCACHE_UNLOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_LOCK_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_LOCK_CTRL_DCACHE_UNLOCK_ENA() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_LOCK_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetDCACHE_LOCK_CTRL_DCACHE_LOCK_DONE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_LOCK_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetDCACHE_LOCK_CTRL_DCACHE_LOCK_DONE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_LOCK_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.DCACHE_LOCK_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_LOCK_ADDR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_LOCK_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDCACHE_LOCK_ADDR() uint32 {
	return volatile.LoadUint32(&o.DCACHE_LOCK_ADDR.Reg)
}

// EXTMEM.DCACHE_LOCK_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_LOCK_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_LOCK_SIZE.Reg, volatile.LoadUint32(&o.DCACHE_LOCK_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDCACHE_LOCK_SIZE() uint32 {
	return volatile.LoadUint32(&o.DCACHE_LOCK_SIZE.Reg) & 0xffff
}

// EXTMEM.DCACHE_SYNC_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_SYNC_CTRL_DCACHE_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_SYNC_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_SYNC_CTRL_DCACHE_INVALIDATE_ENA() uint32 {
	return volatile.LoadUint32(&o.DCACHE_SYNC_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_SYNC_CTRL_DCACHE_WRITEBACK_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_SYNC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_SYNC_CTRL_DCACHE_WRITEBACK_ENA() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_SYNC_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetDCACHE_SYNC_CTRL_DCACHE_CLEAN_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_SYNC_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetDCACHE_SYNC_CTRL_DCACHE_CLEAN_ENA() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_SYNC_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetDCACHE_SYNC_CTRL_DCACHE_SYNC_DONE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_SYNC_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetDCACHE_SYNC_CTRL_DCACHE_SYNC_DONE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_SYNC_CTRL.Reg) & 0x8) >> 3
}

// EXTMEM.DCACHE_SYNC_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_SYNC_ADDR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_SYNC_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDCACHE_SYNC_ADDR() uint32 {
	return volatile.LoadUint32(&o.DCACHE_SYNC_ADDR.Reg)
}

// EXTMEM.DCACHE_SYNC_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_SYNC_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_SYNC_SIZE.Reg, volatile.LoadUint32(&o.DCACHE_SYNC_SIZE.Reg)&^(0x7fffff)|value)
}
func (o *EXTMEM_Type) GetDCACHE_SYNC_SIZE() uint32 {
	return volatile.LoadUint32(&o.DCACHE_SYNC_SIZE.Reg) & 0x7fffff
}

// EXTMEM.DCACHE_OCCUPY_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_OCCUPY_CTRL_DCACHE_OCCUPY_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_OCCUPY_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_OCCUPY_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_OCCUPY_CTRL_DCACHE_OCCUPY_ENA() uint32 {
	return volatile.LoadUint32(&o.DCACHE_OCCUPY_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_OCCUPY_CTRL_DCACHE_OCCUPY_DONE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_OCCUPY_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_OCCUPY_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_OCCUPY_CTRL_DCACHE_OCCUPY_DONE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_OCCUPY_CTRL.Reg) & 0x2) >> 1
}

// EXTMEM.DCACHE_OCCUPY_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_OCCUPY_ADDR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_OCCUPY_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDCACHE_OCCUPY_ADDR() uint32 {
	return volatile.LoadUint32(&o.DCACHE_OCCUPY_ADDR.Reg)
}

// EXTMEM.DCACHE_OCCUPY_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_OCCUPY_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_OCCUPY_SIZE.Reg, volatile.LoadUint32(&o.DCACHE_OCCUPY_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDCACHE_OCCUPY_SIZE() uint32 {
	return volatile.LoadUint32(&o.DCACHE_OCCUPY_SIZE.Reg) & 0xffff
}

// EXTMEM.DCACHE_PRELOAD_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_PRELOAD_CTRL_DCACHE_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOAD_CTRL_DCACHE_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.DCACHE_PRELOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_PRELOAD_CTRL_DCACHE_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOAD_CTRL_DCACHE_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetDCACHE_PRELOAD_CTRL_DCACHE_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOAD_CTRL_DCACHE_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_PRELOAD_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.DCACHE_PRELOAD_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.DCACHE_PRELOAD_ADDR.Reg)
}

// EXTMEM.DCACHE_PRELOAD_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.DCACHE_PRELOAD_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDCACHE_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.DCACHE_PRELOAD_SIZE.Reg) & 0xffff
}

// EXTMEM.DCACHE_AUTOLOAD_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_SCT0_ENA() uint32 {
	return volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_ENA() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_RQST(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg)&^(0x60)|value<<5)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_RQST() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg) & 0x60) >> 5
}
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg)&^(0x180)|value<<7)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_SIZE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg) & 0x180) >> 7
}
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_BUFFER_CLEAR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_CTRL_DCACHE_AUTOLOAD_BUFFER_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}

// EXTMEM.DCACHE_AUTOLOAD_SCT0_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.DCACHE_AUTOLOAD_SCT0_ADDR.Reg)
}

// EXTMEM.DCACHE_AUTOLOAD_SCT0_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_SCT0_SIZE.Reg)&^(0x7ffffff)|value)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.DCACHE_AUTOLOAD_SCT0_SIZE.Reg) & 0x7ffffff
}

// EXTMEM.DCACHE_AUTOLOAD_SCT1_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.DCACHE_AUTOLOAD_SCT1_ADDR.Reg)
}

// EXTMEM.DCACHE_AUTOLOAD_SCT1_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.DCACHE_AUTOLOAD_SCT1_SIZE.Reg)&^(0x7ffffff)|value)
}
func (o *EXTMEM_Type) GetDCACHE_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.DCACHE_AUTOLOAD_SCT1_SIZE.Reg) & 0x7ffffff
}

// EXTMEM.ICACHE_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_CTRL_ICACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_CTRL_ICACHE_ENABLE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_CTRL_ICACHE_WAY_MODE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_CTRL_ICACHE_WAY_MODE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetICACHE_CTRL_ICACHE_SIZE_MODE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetICACHE_CTRL_ICACHE_SIZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetICACHE_CTRL_ICACHE_BLOCKSIZE_MODE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetICACHE_CTRL_ICACHE_BLOCKSIZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CTRL.Reg) & 0x8) >> 3
}

// EXTMEM.ICACHE_CTRL1: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_CTRL1_ICACHE_SHUT_CORE0_BUS(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL1.Reg, volatile.LoadUint32(&o.ICACHE_CTRL1.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_CTRL1_ICACHE_SHUT_CORE0_BUS() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CTRL1.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_CTRL1_ICACHE_SHUT_CORE1_BUS(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL1.Reg, volatile.LoadUint32(&o.ICACHE_CTRL1.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_CTRL1_ICACHE_SHUT_CORE1_BUS() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CTRL1.Reg) & 0x2) >> 1
}

// EXTMEM.ICACHE_TAG_POWER_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.ICACHE_PRELOCK_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_PRELOCK_CTRL_ICACHE_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOCK_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_PRELOCK_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_PRELOCK_CTRL_ICACHE_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOCK_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_PRELOCK_CTRL_ICACHE_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOCK_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_PRELOCK_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_PRELOCK_CTRL_ICACHE_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_PRELOCK_CTRL.Reg) & 0x2) >> 1
}

// EXTMEM.ICACHE_PRELOCK_SCT0_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetICACHE_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOCK_SCT0_ADDR.Reg)
}

// EXTMEM.ICACHE_PRELOCK_SCT1_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetICACHE_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOCK_SCT1_ADDR.Reg)
}

// EXTMEM.ICACHE_PRELOCK_SCT_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_PRELOCK_SCT_SIZE_ICACHE_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.ICACHE_PRELOCK_SCT_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetICACHE_PRELOCK_SCT_SIZE_ICACHE_PRELOCK_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOCK_SCT_SIZE.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetICACHE_PRELOCK_SCT_SIZE_ICACHE_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.ICACHE_PRELOCK_SCT_SIZE.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetICACHE_PRELOCK_SCT_SIZE_ICACHE_PRELOCK_SCT0_SIZE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_PRELOCK_SCT_SIZE.Reg) & 0xffff0000) >> 16
}

// EXTMEM.ICACHE_LOCK_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_LOCK_CTRL_ICACHE_LOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_LOCK_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_LOCK_CTRL_ICACHE_LOCK_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_LOCK_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_LOCK_CTRL_ICACHE_UNLOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_LOCK_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_LOCK_CTRL_ICACHE_UNLOCK_ENA() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_LOCK_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetICACHE_LOCK_CTRL_ICACHE_LOCK_DONE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_LOCK_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetICACHE_LOCK_CTRL_ICACHE_LOCK_DONE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_LOCK_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.ICACHE_LOCK_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_LOCK_ADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_LOCK_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetICACHE_LOCK_ADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_LOCK_ADDR.Reg)
}

// EXTMEM.ICACHE_LOCK_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_LOCK_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_LOCK_SIZE.Reg, volatile.LoadUint32(&o.ICACHE_LOCK_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetICACHE_LOCK_SIZE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_LOCK_SIZE.Reg) & 0xffff
}

// EXTMEM.ICACHE_SYNC_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_SYNC_CTRL_ICACHE_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_SYNC_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_SYNC_CTRL_ICACHE_INVALIDATE_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SYNC_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_SYNC_CTRL_ICACHE_SYNC_DONE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_SYNC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_SYNC_CTRL_ICACHE_SYNC_DONE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_SYNC_CTRL.Reg) & 0x2) >> 1
}

// EXTMEM.ICACHE_SYNC_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_SYNC_ADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetICACHE_SYNC_ADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SYNC_ADDR.Reg)
}

// EXTMEM.ICACHE_SYNC_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_SYNC_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_SIZE.Reg, volatile.LoadUint32(&o.ICACHE_SYNC_SIZE.Reg)&^(0x7fffff)|value)
}
func (o *EXTMEM_Type) GetICACHE_SYNC_SIZE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SYNC_SIZE.Reg) & 0x7fffff
}

// EXTMEM.ICACHE_PRELOAD_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_PRELOAD_CTRL_ICACHE_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_PRELOAD_CTRL_ICACHE_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_PRELOAD_CTRL_ICACHE_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_PRELOAD_CTRL_ICACHE_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetICACHE_PRELOAD_CTRL_ICACHE_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetICACHE_PRELOAD_CTRL_ICACHE_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_PRELOAD_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.ICACHE_PRELOAD_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetICACHE_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOAD_ADDR.Reg)
}

// EXTMEM.ICACHE_PRELOAD_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.ICACHE_PRELOAD_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetICACHE_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOAD_SIZE.Reg) & 0xffff
}

// EXTMEM.ICACHE_AUTOLOAD_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_SCT0_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_ENA() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_RQST(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg)&^(0x60)|value<<5)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_RQST() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg) & 0x60) >> 5
}
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg)&^(0x180)|value<<7)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_SIZE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg) & 0x180) >> 7
}
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_BUFFER_CLEAR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_CTRL_ICACHE_AUTOLOAD_BUFFER_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}

// EXTMEM.ICACHE_AUTOLOAD_SCT0_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_AUTOLOAD_SCT0_ADDR.Reg)
}

// EXTMEM.ICACHE_AUTOLOAD_SCT0_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_SCT0_SIZE.Reg)&^(0x7ffffff)|value)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_AUTOLOAD_SCT0_SIZE.Reg) & 0x7ffffff
}

// EXTMEM.ICACHE_AUTOLOAD_SCT1_ADDR: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_AUTOLOAD_SCT1_ADDR.Reg)
}

// EXTMEM.ICACHE_AUTOLOAD_SCT1_SIZE: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.ICACHE_AUTOLOAD_SCT1_SIZE.Reg)&^(0x7ffffff)|value)
}
func (o *EXTMEM_Type) GetICACHE_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_AUTOLOAD_SCT1_SIZE.Reg) & 0x7ffffff
}

// EXTMEM.IBUS_TO_FLASH_START_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetIBUS_TO_FLASH_START_VADDR(value uint32) {
	volatile.StoreUint32(&o.IBUS_TO_FLASH_START_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS_TO_FLASH_START_VADDR() uint32 {
	return volatile.LoadUint32(&o.IBUS_TO_FLASH_START_VADDR.Reg)
}

// EXTMEM.IBUS_TO_FLASH_END_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetIBUS_TO_FLASH_END_VADDR(value uint32) {
	volatile.StoreUint32(&o.IBUS_TO_FLASH_END_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS_TO_FLASH_END_VADDR() uint32 {
	return volatile.LoadUint32(&o.IBUS_TO_FLASH_END_VADDR.Reg)
}

// EXTMEM.DBUS_TO_FLASH_START_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDBUS_TO_FLASH_START_VADDR(value uint32) {
	volatile.StoreUint32(&o.DBUS_TO_FLASH_START_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS_TO_FLASH_START_VADDR() uint32 {
	return volatile.LoadUint32(&o.DBUS_TO_FLASH_START_VADDR.Reg)
}

// EXTMEM.DBUS_TO_FLASH_END_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetDBUS_TO_FLASH_END_VADDR(value uint32) {
	volatile.StoreUint32(&o.DBUS_TO_FLASH_END_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS_TO_FLASH_END_VADDR() uint32 {
	return volatile.LoadUint32(&o.DBUS_TO_FLASH_END_VADDR.Reg)
}

// EXTMEM.CACHE_ACS_CNT_CLR: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_ACS_CNT_CLR_DCACHE_ACS_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ACS_CNT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ACS_CNT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ACS_CNT_CLR_DCACHE_ACS_CNT_CLR() uint32 {
	return volatile.LoadUint32(&o.CACHE_ACS_CNT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ACS_CNT_CLR_ICACHE_ACS_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ACS_CNT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ACS_CNT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ACS_CNT_CLR_ICACHE_ACS_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ACS_CNT_CLR.Reg) & 0x2) >> 1
}

// EXTMEM.IBUS_ACS_MISS_CNT: ******* Description ***********
func (o *EXTMEM_Type) SetIBUS_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS_ACS_MISS_CNT.Reg)
}

// EXTMEM.IBUS_ACS_CNT: ******* Description ***********
func (o *EXTMEM_Type) SetIBUS_ACS_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS_ACS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS_ACS_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS_ACS_CNT.Reg)
}

// EXTMEM.DBUS_ACS_FLASH_MISS_CNT: ******* Description ***********
func (o *EXTMEM_Type) SetDBUS_ACS_FLASH_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS_ACS_FLASH_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS_ACS_FLASH_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS_ACS_FLASH_MISS_CNT.Reg)
}

// EXTMEM.DBUS_ACS_SPIRAM_MISS_CNT: ******* Description ***********
func (o *EXTMEM_Type) SetDBUS_ACS_SPIRAM_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS_ACS_SPIRAM_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS_ACS_SPIRAM_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS_ACS_SPIRAM_MISS_CNT.Reg)
}

// EXTMEM.DBUS_ACS_CNT: ******* Description ***********
func (o *EXTMEM_Type) SetDBUS_ACS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS_ACS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS_ACS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS_ACS_CNT.Reg)
}

// EXTMEM.CACHE_ILG_INT_ENA: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_ICACHE_SYNC_OP_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_ICACHE_SYNC_OP_FAULT_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_ICACHE_PRELOAD_OP_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_ICACHE_PRELOAD_OP_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_DCACHE_SYNC_OP_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_DCACHE_SYNC_OP_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_DCACHE_PRELOAD_OP_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_DCACHE_PRELOAD_OP_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_DCACHE_WRITE_FLASH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_DCACHE_WRITE_FLASH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_MMU_ENTRY_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_MMU_ENTRY_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_DCACHE_OCCUPY_EXC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_DCACHE_OCCUPY_EXC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_IBUS_CNT_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_IBUS_CNT_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_DBUS_CNT_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_DBUS_CNT_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x100) >> 8
}

// EXTMEM.CACHE_ILG_INT_CLR: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_ICACHE_SYNC_OP_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_ICACHE_SYNC_OP_FAULT_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_ICACHE_PRELOAD_OP_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_ICACHE_PRELOAD_OP_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_DCACHE_SYNC_OP_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_DCACHE_SYNC_OP_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_DCACHE_PRELOAD_OP_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_DCACHE_PRELOAD_OP_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_DCACHE_WRITE_FLASH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_DCACHE_WRITE_FLASH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_MMU_ENTRY_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_MMU_ENTRY_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_DCACHE_OCCUPY_EXC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_DCACHE_OCCUPY_EXC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_IBUS_CNT_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_IBUS_CNT_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_DBUS_CNT_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_DBUS_CNT_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x100) >> 8
}

// EXTMEM.CACHE_ILG_INT_ST: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_ICACHE_SYNC_OP_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_ICACHE_SYNC_OP_FAULT_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_ICACHE_PRELOAD_OP_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_ICACHE_PRELOAD_OP_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DCACHE_SYNC_OP_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DCACHE_SYNC_OP_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DCACHE_PRELOAD_OP_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DCACHE_PRELOAD_OP_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DCACHE_WRITE_FLASH_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DCACHE_WRITE_FLASH_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_MMU_ENTRY_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_MMU_ENTRY_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DCACHE_OCCUPY_EXC_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DCACHE_OCCUPY_EXC_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_IBUS_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_IBUS_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_IBUS_ACS_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_IBUS_ACS_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DBUS_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DBUS_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DBUS_ACS_FLASH_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DBUS_ACS_FLASH_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DBUS_ACS_SPIRAM_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DBUS_ACS_SPIRAM_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x800) >> 11
}

// EXTMEM.CORE0_ACS_CACHE_INT_ENA: ******* Description ***********
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_ACS_MSK_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_ACS_MSK_IC_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_WR_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_WR_IC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_ACS_MSK_DC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_ACS_MSK_DC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x10) >> 4
}

// EXTMEM.CORE0_ACS_CACHE_INT_CLR: ******* Description ***********
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_ACS_MSK_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_ACS_MSK_IC_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_WR_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_WR_IC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_ACS_MSK_DC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_ACS_MSK_DC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x10) >> 4
}

// EXTMEM.CORE0_ACS_CACHE_INT_ST: ******* Description ***********
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_ACS_MSK_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_ACS_MSK_ICACHE_ST() uint32 {
	return volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_WR_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_WR_ICACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_REJECT_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_REJECT_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_ACS_MSK_DCACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_ACS_MSK_DCACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_REJECT_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_REJECT_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x10) >> 4
}

// EXTMEM.CORE1_ACS_CACHE_INT_ENA: ******* Description ***********
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ENA_CORE1_IBUS_ACS_MSK_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ENA_CORE1_IBUS_ACS_MSK_IC_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ENA_CORE1_IBUS_WR_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ENA_CORE1_IBUS_WR_IC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ENA_CORE1_IBUS_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ENA_CORE1_IBUS_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ENA_CORE1_DBUS_ACS_MSK_DC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ENA_CORE1_DBUS_ACS_MSK_DC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ENA_CORE1_DBUS_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ENA_CORE1_DBUS_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ENA.Reg) & 0x10) >> 4
}

// EXTMEM.CORE1_ACS_CACHE_INT_CLR: ******* Description ***********
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_CLR_CORE1_IBUS_ACS_MSK_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_CLR_CORE1_IBUS_ACS_MSK_IC_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_CLR_CORE1_IBUS_WR_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_CLR_CORE1_IBUS_WR_IC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_CLR_CORE1_IBUS_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_CLR_CORE1_IBUS_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_CLR_CORE1_DBUS_ACS_MSK_DC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_CLR_CORE1_DBUS_ACS_MSK_DC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_CLR_CORE1_DBUS_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_CLR_CORE1_DBUS_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_CLR.Reg) & 0x10) >> 4
}

// EXTMEM.CORE1_ACS_CACHE_INT_ST: ******* Description ***********
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ST_CORE1_IBUS_ACS_MSK_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ST_CORE1_IBUS_ACS_MSK_ICACHE_ST() uint32 {
	return volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ST_CORE1_IBUS_WR_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ST_CORE1_IBUS_WR_ICACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ST_CORE1_IBUS_REJECT_ST(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ST_CORE1_IBUS_REJECT_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ST_CORE1_DBUS_ACS_MSK_DCACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ST_CORE1_DBUS_ACS_MSK_DCACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE1_ACS_CACHE_INT_ST_CORE1_DBUS_REJECT_ST(value uint32) {
	volatile.StoreUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE1_ACS_CACHE_INT_ST_CORE1_DBUS_REJECT_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE1_ACS_CACHE_INT_ST.Reg) & 0x10) >> 4
}

// EXTMEM.CORE0_DBUS_REJECT_ST: ******* Description ***********
func (o *EXTMEM_Type) SetCORE0_DBUS_REJECT_ST_CORE0_DBUS_TAG_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE0_DBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetCORE0_DBUS_REJECT_ST_CORE0_DBUS_TAG_ATTR() uint32 {
	return volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg) & 0x7
}
func (o *EXTMEM_Type) SetCORE0_DBUS_REJECT_ST_CORE0_DBUS_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE0_DBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg)&^(0x38)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_DBUS_REJECT_ST_CORE0_DBUS_ATTR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg) & 0x38) >> 3
}
func (o *EXTMEM_Type) SetCORE0_DBUS_REJECT_ST_CORE0_DBUS_WORLD(value uint32) {
	volatile.StoreUint32(&o.CORE0_DBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCORE0_DBUS_REJECT_ST_CORE0_DBUS_WORLD() uint32 {
	return (volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg) & 0x40) >> 6
}

// EXTMEM.CORE0_DBUS_REJECT_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetCORE0_DBUS_REJECT_VADDR(value uint32) {
	volatile.StoreUint32(&o.CORE0_DBUS_REJECT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCORE0_DBUS_REJECT_VADDR() uint32 {
	return volatile.LoadUint32(&o.CORE0_DBUS_REJECT_VADDR.Reg)
}

// EXTMEM.CORE0_IBUS_REJECT_ST: ******* Description ***********
func (o *EXTMEM_Type) SetCORE0_IBUS_REJECT_ST_CORE0_IBUS_TAG_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE0_IBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetCORE0_IBUS_REJECT_ST_CORE0_IBUS_TAG_ATTR() uint32 {
	return volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg) & 0x7
}
func (o *EXTMEM_Type) SetCORE0_IBUS_REJECT_ST_CORE0_IBUS_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE0_IBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg)&^(0x38)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_IBUS_REJECT_ST_CORE0_IBUS_ATTR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg) & 0x38) >> 3
}
func (o *EXTMEM_Type) SetCORE0_IBUS_REJECT_ST_CORE0_IBUS_WORLD(value uint32) {
	volatile.StoreUint32(&o.CORE0_IBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCORE0_IBUS_REJECT_ST_CORE0_IBUS_WORLD() uint32 {
	return (volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg) & 0x40) >> 6
}

// EXTMEM.CORE0_IBUS_REJECT_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetCORE0_IBUS_REJECT_VADDR(value uint32) {
	volatile.StoreUint32(&o.CORE0_IBUS_REJECT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCORE0_IBUS_REJECT_VADDR() uint32 {
	return volatile.LoadUint32(&o.CORE0_IBUS_REJECT_VADDR.Reg)
}

// EXTMEM.CORE1_DBUS_REJECT_ST: ******* Description ***********
func (o *EXTMEM_Type) SetCORE1_DBUS_REJECT_ST_CORE1_DBUS_TAG_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE1_DBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE1_DBUS_REJECT_ST.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetCORE1_DBUS_REJECT_ST_CORE1_DBUS_TAG_ATTR() uint32 {
	return volatile.LoadUint32(&o.CORE1_DBUS_REJECT_ST.Reg) & 0x7
}
func (o *EXTMEM_Type) SetCORE1_DBUS_REJECT_ST_CORE1_DBUS_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE1_DBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE1_DBUS_REJECT_ST.Reg)&^(0x38)|value<<3)
}
func (o *EXTMEM_Type) GetCORE1_DBUS_REJECT_ST_CORE1_DBUS_ATTR() uint32 {
	return (volatile.LoadUint32(&o.CORE1_DBUS_REJECT_ST.Reg) & 0x38) >> 3
}
func (o *EXTMEM_Type) SetCORE1_DBUS_REJECT_ST_CORE1_DBUS_WORLD(value uint32) {
	volatile.StoreUint32(&o.CORE1_DBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE1_DBUS_REJECT_ST.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCORE1_DBUS_REJECT_ST_CORE1_DBUS_WORLD() uint32 {
	return (volatile.LoadUint32(&o.CORE1_DBUS_REJECT_ST.Reg) & 0x40) >> 6
}

// EXTMEM.CORE1_DBUS_REJECT_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetCORE1_DBUS_REJECT_VADDR(value uint32) {
	volatile.StoreUint32(&o.CORE1_DBUS_REJECT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCORE1_DBUS_REJECT_VADDR() uint32 {
	return volatile.LoadUint32(&o.CORE1_DBUS_REJECT_VADDR.Reg)
}

// EXTMEM.CORE1_IBUS_REJECT_ST: ******* Description ***********
func (o *EXTMEM_Type) SetCORE1_IBUS_REJECT_ST_CORE1_IBUS_TAG_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE1_IBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE1_IBUS_REJECT_ST.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetCORE1_IBUS_REJECT_ST_CORE1_IBUS_TAG_ATTR() uint32 {
	return volatile.LoadUint32(&o.CORE1_IBUS_REJECT_ST.Reg) & 0x7
}
func (o *EXTMEM_Type) SetCORE1_IBUS_REJECT_ST_CORE1_IBUS_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE1_IBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE1_IBUS_REJECT_ST.Reg)&^(0x38)|value<<3)
}
func (o *EXTMEM_Type) GetCORE1_IBUS_REJECT_ST_CORE1_IBUS_ATTR() uint32 {
	return (volatile.LoadUint32(&o.CORE1_IBUS_REJECT_ST.Reg) & 0x38) >> 3
}
func (o *EXTMEM_Type) SetCORE1_IBUS_REJECT_ST_CORE1_IBUS_WORLD(value uint32) {
	volatile.StoreUint32(&o.CORE1_IBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE1_IBUS_REJECT_ST.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCORE1_IBUS_REJECT_ST_CORE1_IBUS_WORLD() uint32 {
	return (volatile.LoadUint32(&o.CORE1_IBUS_REJECT_ST.Reg) & 0x40) >> 6
}

// EXTMEM.CORE1_IBUS_REJECT_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetCORE1_IBUS_REJECT_VADDR(value uint32) {
	volatile.StoreUint32(&o.CORE1_IBUS_REJECT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCORE1_IBUS_REJECT_VADDR() uint32 {
	return volatile.LoadUint32(&o.CORE1_IBUS_REJECT_VADDR.Reg)
}

// EXTMEM.CACHE_MMU_FAULT_CONTENT: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_MMU_FAULT_CONTENT(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg, volatile.LoadUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetCACHE_MMU_FAULT_CONTENT() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetCACHE_MMU_FAULT_CONTENT_CACHE_MMU_FAULT_CODE(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg, volatile.LoadUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg)&^(0xf0000)|value<<16)
}
func (o *EXTMEM_Type) GetCACHE_MMU_FAULT_CONTENT_CACHE_MMU_FAULT_CODE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg) & 0xf0000) >> 16
}

// EXTMEM.CACHE_MMU_FAULT_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_MMU_FAULT_VADDR(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_FAULT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCACHE_MMU_FAULT_VADDR() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_FAULT_VADDR.Reg)
}

// EXTMEM.CACHE_WRAP_AROUND_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_WRAP_AROUND_CTRL_CACHE_FLASH_WRAP_AROUND(value uint32) {
	volatile.StoreUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_WRAP_AROUND_CTRL_CACHE_FLASH_WRAP_AROUND() uint32 {
	return volatile.LoadUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_WRAP_AROUND_CTRL_CACHE_SRAM_RD_WRAP_AROUND(value uint32) {
	volatile.StoreUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_WRAP_AROUND_CTRL_CACHE_SRAM_RD_WRAP_AROUND() uint32 {
	return (volatile.LoadUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg) & 0x2) >> 1
}

// EXTMEM.CACHE_MMU_POWER_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.CACHE_STATE: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_STATE_ICACHE_STATE(value uint32) {
	volatile.StoreUint32(&o.CACHE_STATE.Reg, volatile.LoadUint32(&o.CACHE_STATE.Reg)&^(0xfff)|value)
}
func (o *EXTMEM_Type) GetCACHE_STATE_ICACHE_STATE() uint32 {
	return volatile.LoadUint32(&o.CACHE_STATE.Reg) & 0xfff
}
func (o *EXTMEM_Type) SetCACHE_STATE_DCACHE_STATE(value uint32) {
	volatile.StoreUint32(&o.CACHE_STATE.Reg, volatile.LoadUint32(&o.CACHE_STATE.Reg)&^(0xfff000)|value<<12)
}
func (o *EXTMEM_Type) GetCACHE_STATE_DCACHE_STATE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_STATE.Reg) & 0xfff000) >> 12
}

// EXTMEM.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_DB_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_DB_ENCRYPT() uint32 {
	return volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_G0CB_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_G0CB_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg) & 0x2) >> 1
}

// EXTMEM.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_MANUAL_CRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_MANUAL_CRYPT() uint32 {
	return volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_AUTO_CRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_AUTO_CRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_CRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_CRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x4) >> 2
}

// EXTMEM.CACHE_BRIDGE_ARBITER_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_BRIDGE_ARBITER_CTRL_ALLOC_WB_HOLD_ARBITER(value uint32) {
	volatile.StoreUint32(&o.CACHE_BRIDGE_ARBITER_CTRL.Reg, volatile.LoadUint32(&o.CACHE_BRIDGE_ARBITER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_BRIDGE_ARBITER_CTRL_ALLOC_WB_HOLD_ARBITER() uint32 {
	return volatile.LoadUint32(&o.CACHE_BRIDGE_ARBITER_CTRL.Reg) & 0x1
}

// EXTMEM.CACHE_PRELOAD_INT_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_DCACHE_PRELOAD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_DCACHE_PRELOAD_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_DCACHE_PRELOAD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_DCACHE_PRELOAD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_DCACHE_PRELOAD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_DCACHE_PRELOAD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x20) >> 5
}

// EXTMEM.CACHE_SYNC_INT_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_DCACHE_SYNC_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_DCACHE_SYNC_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_DCACHE_SYNC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_DCACHE_SYNC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_DCACHE_SYNC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_DCACHE_SYNC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x20) >> 5
}

// EXTMEM.CACHE_MMU_OWNER: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_MMU_OWNER(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_OWNER.Reg, volatile.LoadUint32(&o.CACHE_MMU_OWNER.Reg)&^(0xffffff)|value)
}
func (o *EXTMEM_Type) GetCACHE_MMU_OWNER() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_OWNER.Reg) & 0xffffff
}

// EXTMEM.CACHE_CONF_MISC: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_CACHE_IGNORE_PRELOAD_MMU_ENTRY_FAULT(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_CACHE_IGNORE_PRELOAD_MMU_ENTRY_FAULT() uint32 {
	return volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_CACHE_IGNORE_SYNC_MMU_ENTRY_FAULT(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_CACHE_IGNORE_SYNC_MMU_ENTRY_FAULT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_CACHE_TRACE_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_CACHE_TRACE_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x4) >> 2
}

// EXTMEM.DCACHE_FREEZE: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_FREEZE_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_FREEZE.Reg, volatile.LoadUint32(&o.DCACHE_FREEZE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_FREEZE_ENA() uint32 {
	return volatile.LoadUint32(&o.DCACHE_FREEZE.Reg) & 0x1
}
func (o *EXTMEM_Type) SetDCACHE_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_FREEZE.Reg, volatile.LoadUint32(&o.DCACHE_FREEZE.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetDCACHE_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_FREEZE.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetDCACHE_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.DCACHE_FREEZE.Reg, volatile.LoadUint32(&o.DCACHE_FREEZE.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetDCACHE_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.DCACHE_FREEZE.Reg) & 0x4) >> 2
}

// EXTMEM.ICACHE_FREEZE: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_FREEZE_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_FREEZE.Reg, volatile.LoadUint32(&o.ICACHE_FREEZE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_FREEZE_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_FREEZE.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_FREEZE.Reg, volatile.LoadUint32(&o.ICACHE_FREEZE.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_FREEZE.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetICACHE_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_FREEZE.Reg, volatile.LoadUint32(&o.ICACHE_FREEZE.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetICACHE_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_FREEZE.Reg) & 0x4) >> 2
}

// EXTMEM.ICACHE_ATOMIC_OPERATE_ENA: ******* Description ***********
func (o *EXTMEM_Type) SetICACHE_ATOMIC_OPERATE_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_ATOMIC_OPERATE_ENA.Reg, volatile.LoadUint32(&o.ICACHE_ATOMIC_OPERATE_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_ATOMIC_OPERATE_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_ATOMIC_OPERATE_ENA.Reg) & 0x1
}

// EXTMEM.DCACHE_ATOMIC_OPERATE_ENA: ******* Description ***********
func (o *EXTMEM_Type) SetDCACHE_ATOMIC_OPERATE_ENA(value uint32) {
	volatile.StoreUint32(&o.DCACHE_ATOMIC_OPERATE_ENA.Reg, volatile.LoadUint32(&o.DCACHE_ATOMIC_OPERATE_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetDCACHE_ATOMIC_OPERATE_ENA() uint32 {
	return volatile.LoadUint32(&o.DCACHE_ATOMIC_OPERATE_ENA.Reg) & 0x1
}

// EXTMEM.CACHE_REQUEST: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_REQUEST_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CACHE_REQUEST.Reg, volatile.LoadUint32(&o.CACHE_REQUEST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_REQUEST_BYPASS() uint32 {
	return volatile.LoadUint32(&o.CACHE_REQUEST.Reg) & 0x1
}

// EXTMEM.CLOCK_GATE: ******* Description ***********
func (o *EXTMEM_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// EXTMEM.CACHE_TAG_OBJECT_CTRL: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_TAG_OBJECT_CTRL_ICACHE_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_TAG_OBJECT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_TAG_OBJECT_CTRL_ICACHE_TAG_OBJECT() uint32 {
	return volatile.LoadUint32(&o.CACHE_TAG_OBJECT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_TAG_OBJECT_CTRL_DCACHE_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_TAG_OBJECT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_TAG_OBJECT_CTRL_DCACHE_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_TAG_OBJECT_CTRL.Reg) & 0x2) >> 1
}

// EXTMEM.CACHE_TAG_WAY_OBJECT: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_TAG_WAY_OBJECT(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_WAY_OBJECT.Reg, volatile.LoadUint32(&o.CACHE_TAG_WAY_OBJECT.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetCACHE_TAG_WAY_OBJECT() uint32 {
	return volatile.LoadUint32(&o.CACHE_TAG_WAY_OBJECT.Reg) & 0x7
}

// EXTMEM.CACHE_VADDR: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_VADDR(value uint32) {
	volatile.StoreUint32(&o.CACHE_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCACHE_VADDR() uint32 {
	return volatile.LoadUint32(&o.CACHE_VADDR.Reg)
}

// EXTMEM.CACHE_TAG_CONTENT: ******* Description ***********
func (o *EXTMEM_Type) SetCACHE_TAG_CONTENT(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_CONTENT.Reg, value)
}
func (o *EXTMEM_Type) GetCACHE_TAG_CONTENT() uint32 {
	return volatile.LoadUint32(&o.CACHE_TAG_CONTENT.Reg)
}

// EXTMEM.DATE: ******* Description ***********
func (o *EXTMEM_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// General Purpose Input/Output
type GPIO_Type struct {
	BT_SELECT          volatile.Register32 // 0x0
	OUT                volatile.Register32 // 0x4
	OUT_W1TS           volatile.Register32 // 0x8
	OUT_W1TC           volatile.Register32 // 0xC
	OUT1               volatile.Register32 // 0x10
	OUT1_W1TS          volatile.Register32 // 0x14
	OUT1_W1TC          volatile.Register32 // 0x18
	SDIO_SELECT        volatile.Register32 // 0x1C
	ENABLE             volatile.Register32 // 0x20
	ENABLE_W1TS        volatile.Register32 // 0x24
	ENABLE_W1TC        volatile.Register32 // 0x28
	ENABLE1            volatile.Register32 // 0x2C
	ENABLE1_W1TS       volatile.Register32 // 0x30
	ENABLE1_W1TC       volatile.Register32 // 0x34
	STRAP              volatile.Register32 // 0x38
	IN                 volatile.Register32 // 0x3C
	IN1                volatile.Register32 // 0x40
	STATUS             volatile.Register32 // 0x44
	STATUS_W1TS        volatile.Register32 // 0x48
	STATUS_W1TC        volatile.Register32 // 0x4C
	STATUS1            volatile.Register32 // 0x50
	STATUS1_W1TS       volatile.Register32 // 0x54
	STATUS1_W1TC       volatile.Register32 // 0x58
	PCPU_INT           volatile.Register32 // 0x5C
	PCPU_NMI_INT       volatile.Register32 // 0x60
	CPUSDIO_INT        volatile.Register32 // 0x64
	PCPU_INT1          volatile.Register32 // 0x68
	PCPU_NMI_INT1      volatile.Register32 // 0x6C
	CPUSDIO_INT1       volatile.Register32 // 0x70
	PIN0               volatile.Register32 // 0x74
	PIN1               volatile.Register32 // 0x78
	PIN2               volatile.Register32 // 0x7C
	PIN3               volatile.Register32 // 0x80
	PIN4               volatile.Register32 // 0x84
	PIN5               volatile.Register32 // 0x88
	PIN6               volatile.Register32 // 0x8C
	PIN7               volatile.Register32 // 0x90
	PIN8               volatile.Register32 // 0x94
	PIN9               volatile.Register32 // 0x98
	PIN10              volatile.Register32 // 0x9C
	PIN11              volatile.Register32 // 0xA0
	PIN12              volatile.Register32 // 0xA4
	PIN13              volatile.Register32 // 0xA8
	PIN14              volatile.Register32 // 0xAC
	PIN15              volatile.Register32 // 0xB0
	PIN16              volatile.Register32 // 0xB4
	PIN17              volatile.Register32 // 0xB8
	PIN18              volatile.Register32 // 0xBC
	PIN19              volatile.Register32 // 0xC0
	PIN20              volatile.Register32 // 0xC4
	PIN21              volatile.Register32 // 0xC8
	PIN22              volatile.Register32 // 0xCC
	PIN23              volatile.Register32 // 0xD0
	PIN24              volatile.Register32 // 0xD4
	PIN25              volatile.Register32 // 0xD8
	PIN26              volatile.Register32 // 0xDC
	PIN27              volatile.Register32 // 0xE0
	PIN28              volatile.Register32 // 0xE4
	PIN29              volatile.Register32 // 0xE8
	PIN30              volatile.Register32 // 0xEC
	PIN31              volatile.Register32 // 0xF0
	PIN32              volatile.Register32 // 0xF4
	PIN33              volatile.Register32 // 0xF8
	PIN34              volatile.Register32 // 0xFC
	PIN35              volatile.Register32 // 0x100
	PIN36              volatile.Register32 // 0x104
	PIN37              volatile.Register32 // 0x108
	PIN38              volatile.Register32 // 0x10C
	PIN39              volatile.Register32 // 0x110
	PIN40              volatile.Register32 // 0x114
	PIN41              volatile.Register32 // 0x118
	PIN42              volatile.Register32 // 0x11C
	PIN43              volatile.Register32 // 0x120
	PIN44              volatile.Register32 // 0x124
	PIN45              volatile.Register32 // 0x128
	PIN46              volatile.Register32 // 0x12C
	PIN47              volatile.Register32 // 0x130
	PIN48              volatile.Register32 // 0x134
	PIN49              volatile.Register32 // 0x138
	PIN50              volatile.Register32 // 0x13C
	PIN51              volatile.Register32 // 0x140
	PIN52              volatile.Register32 // 0x144
	PIN53              volatile.Register32 // 0x148
	STATUS_NEXT        volatile.Register32 // 0x14C
	STATUS_NEXT1       volatile.Register32 // 0x150
	FUNC0_IN_SEL_CFG   volatile.Register32 // 0x154
	FUNC1_IN_SEL_CFG   volatile.Register32 // 0x158
	FUNC2_IN_SEL_CFG   volatile.Register32 // 0x15C
	FUNC3_IN_SEL_CFG   volatile.Register32 // 0x160
	FUNC4_IN_SEL_CFG   volatile.Register32 // 0x164
	FUNC5_IN_SEL_CFG   volatile.Register32 // 0x168
	FUNC6_IN_SEL_CFG   volatile.Register32 // 0x16C
	FUNC7_IN_SEL_CFG   volatile.Register32 // 0x170
	FUNC8_IN_SEL_CFG   volatile.Register32 // 0x174
	FUNC9_IN_SEL_CFG   volatile.Register32 // 0x178
	FUNC10_IN_SEL_CFG  volatile.Register32 // 0x17C
	FUNC11_IN_SEL_CFG  volatile.Register32 // 0x180
	FUNC12_IN_SEL_CFG  volatile.Register32 // 0x184
	FUNC13_IN_SEL_CFG  volatile.Register32 // 0x188
	FUNC14_IN_SEL_CFG  volatile.Register32 // 0x18C
	FUNC15_IN_SEL_CFG  volatile.Register32 // 0x190
	FUNC16_IN_SEL_CFG  volatile.Register32 // 0x194
	FUNC17_IN_SEL_CFG  volatile.Register32 // 0x198
	FUNC18_IN_SEL_CFG  volatile.Register32 // 0x19C
	FUNC19_IN_SEL_CFG  volatile.Register32 // 0x1A0
	FUNC20_IN_SEL_CFG  volatile.Register32 // 0x1A4
	FUNC21_IN_SEL_CFG  volatile.Register32 // 0x1A8
	FUNC22_IN_SEL_CFG  volatile.Register32 // 0x1AC
	FUNC23_IN_SEL_CFG  volatile.Register32 // 0x1B0
	FUNC24_IN_SEL_CFG  volatile.Register32 // 0x1B4
	FUNC25_IN_SEL_CFG  volatile.Register32 // 0x1B8
	FUNC26_IN_SEL_CFG  volatile.Register32 // 0x1BC
	FUNC27_IN_SEL_CFG  volatile.Register32 // 0x1C0
	FUNC28_IN_SEL_CFG  volatile.Register32 // 0x1C4
	FUNC29_IN_SEL_CFG  volatile.Register32 // 0x1C8
	FUNC30_IN_SEL_CFG  volatile.Register32 // 0x1CC
	FUNC31_IN_SEL_CFG  volatile.Register32 // 0x1D0
	FUNC32_IN_SEL_CFG  volatile.Register32 // 0x1D4
	FUNC33_IN_SEL_CFG  volatile.Register32 // 0x1D8
	FUNC34_IN_SEL_CFG  volatile.Register32 // 0x1DC
	FUNC35_IN_SEL_CFG  volatile.Register32 // 0x1E0
	FUNC36_IN_SEL_CFG  volatile.Register32 // 0x1E4
	FUNC37_IN_SEL_CFG  volatile.Register32 // 0x1E8
	FUNC38_IN_SEL_CFG  volatile.Register32 // 0x1EC
	FUNC39_IN_SEL_CFG  volatile.Register32 // 0x1F0
	FUNC40_IN_SEL_CFG  volatile.Register32 // 0x1F4
	FUNC41_IN_SEL_CFG  volatile.Register32 // 0x1F8
	FUNC42_IN_SEL_CFG  volatile.Register32 // 0x1FC
	FUNC43_IN_SEL_CFG  volatile.Register32 // 0x200
	FUNC44_IN_SEL_CFG  volatile.Register32 // 0x204
	FUNC45_IN_SEL_CFG  volatile.Register32 // 0x208
	FUNC46_IN_SEL_CFG  volatile.Register32 // 0x20C
	FUNC47_IN_SEL_CFG  volatile.Register32 // 0x210
	FUNC48_IN_SEL_CFG  volatile.Register32 // 0x214
	FUNC49_IN_SEL_CFG  volatile.Register32 // 0x218
	FUNC50_IN_SEL_CFG  volatile.Register32 // 0x21C
	FUNC51_IN_SEL_CFG  volatile.Register32 // 0x220
	FUNC52_IN_SEL_CFG  volatile.Register32 // 0x224
	FUNC53_IN_SEL_CFG  volatile.Register32 // 0x228
	FUNC54_IN_SEL_CFG  volatile.Register32 // 0x22C
	FUNC55_IN_SEL_CFG  volatile.Register32 // 0x230
	FUNC56_IN_SEL_CFG  volatile.Register32 // 0x234
	FUNC57_IN_SEL_CFG  volatile.Register32 // 0x238
	FUNC58_IN_SEL_CFG  volatile.Register32 // 0x23C
	FUNC59_IN_SEL_CFG  volatile.Register32 // 0x240
	FUNC60_IN_SEL_CFG  volatile.Register32 // 0x244
	FUNC61_IN_SEL_CFG  volatile.Register32 // 0x248
	FUNC62_IN_SEL_CFG  volatile.Register32 // 0x24C
	FUNC63_IN_SEL_CFG  volatile.Register32 // 0x250
	FUNC64_IN_SEL_CFG  volatile.Register32 // 0x254
	FUNC65_IN_SEL_CFG  volatile.Register32 // 0x258
	FUNC66_IN_SEL_CFG  volatile.Register32 // 0x25C
	FUNC67_IN_SEL_CFG  volatile.Register32 // 0x260
	FUNC68_IN_SEL_CFG  volatile.Register32 // 0x264
	FUNC69_IN_SEL_CFG  volatile.Register32 // 0x268
	FUNC70_IN_SEL_CFG  volatile.Register32 // 0x26C
	FUNC71_IN_SEL_CFG  volatile.Register32 // 0x270
	FUNC72_IN_SEL_CFG  volatile.Register32 // 0x274
	FUNC73_IN_SEL_CFG  volatile.Register32 // 0x278
	FUNC74_IN_SEL_CFG  volatile.Register32 // 0x27C
	FUNC75_IN_SEL_CFG  volatile.Register32 // 0x280
	FUNC76_IN_SEL_CFG  volatile.Register32 // 0x284
	FUNC77_IN_SEL_CFG  volatile.Register32 // 0x288
	FUNC78_IN_SEL_CFG  volatile.Register32 // 0x28C
	FUNC79_IN_SEL_CFG  volatile.Register32 // 0x290
	FUNC80_IN_SEL_CFG  volatile.Register32 // 0x294
	FUNC81_IN_SEL_CFG  volatile.Register32 // 0x298
	FUNC82_IN_SEL_CFG  volatile.Register32 // 0x29C
	FUNC83_IN_SEL_CFG  volatile.Register32 // 0x2A0
	FUNC84_IN_SEL_CFG  volatile.Register32 // 0x2A4
	FUNC85_IN_SEL_CFG  volatile.Register32 // 0x2A8
	FUNC86_IN_SEL_CFG  volatile.Register32 // 0x2AC
	FUNC87_IN_SEL_CFG  volatile.Register32 // 0x2B0
	FUNC88_IN_SEL_CFG  volatile.Register32 // 0x2B4
	FUNC89_IN_SEL_CFG  volatile.Register32 // 0x2B8
	FUNC90_IN_SEL_CFG  volatile.Register32 // 0x2BC
	FUNC91_IN_SEL_CFG  volatile.Register32 // 0x2C0
	FUNC92_IN_SEL_CFG  volatile.Register32 // 0x2C4
	FUNC93_IN_SEL_CFG  volatile.Register32 // 0x2C8
	FUNC94_IN_SEL_CFG  volatile.Register32 // 0x2CC
	FUNC95_IN_SEL_CFG  volatile.Register32 // 0x2D0
	FUNC96_IN_SEL_CFG  volatile.Register32 // 0x2D4
	FUNC97_IN_SEL_CFG  volatile.Register32 // 0x2D8
	FUNC98_IN_SEL_CFG  volatile.Register32 // 0x2DC
	FUNC99_IN_SEL_CFG  volatile.Register32 // 0x2E0
	FUNC100_IN_SEL_CFG volatile.Register32 // 0x2E4
	FUNC101_IN_SEL_CFG volatile.Register32 // 0x2E8
	FUNC102_IN_SEL_CFG volatile.Register32 // 0x2EC
	FUNC103_IN_SEL_CFG volatile.Register32 // 0x2F0
	FUNC104_IN_SEL_CFG volatile.Register32 // 0x2F4
	FUNC105_IN_SEL_CFG volatile.Register32 // 0x2F8
	FUNC106_IN_SEL_CFG volatile.Register32 // 0x2FC
	FUNC107_IN_SEL_CFG volatile.Register32 // 0x300
	FUNC108_IN_SEL_CFG volatile.Register32 // 0x304
	FUNC109_IN_SEL_CFG volatile.Register32 // 0x308
	FUNC110_IN_SEL_CFG volatile.Register32 // 0x30C
	FUNC111_IN_SEL_CFG volatile.Register32 // 0x310
	FUNC112_IN_SEL_CFG volatile.Register32 // 0x314
	FUNC113_IN_SEL_CFG volatile.Register32 // 0x318
	FUNC114_IN_SEL_CFG volatile.Register32 // 0x31C
	FUNC115_IN_SEL_CFG volatile.Register32 // 0x320
	FUNC116_IN_SEL_CFG volatile.Register32 // 0x324
	FUNC117_IN_SEL_CFG volatile.Register32 // 0x328
	FUNC118_IN_SEL_CFG volatile.Register32 // 0x32C
	FUNC119_IN_SEL_CFG volatile.Register32 // 0x330
	FUNC120_IN_SEL_CFG volatile.Register32 // 0x334
	FUNC121_IN_SEL_CFG volatile.Register32 // 0x338
	FUNC122_IN_SEL_CFG volatile.Register32 // 0x33C
	FUNC123_IN_SEL_CFG volatile.Register32 // 0x340
	FUNC124_IN_SEL_CFG volatile.Register32 // 0x344
	FUNC125_IN_SEL_CFG volatile.Register32 // 0x348
	FUNC126_IN_SEL_CFG volatile.Register32 // 0x34C
	FUNC127_IN_SEL_CFG volatile.Register32 // 0x350
	FUNC128_IN_SEL_CFG volatile.Register32 // 0x354
	FUNC129_IN_SEL_CFG volatile.Register32 // 0x358
	FUNC130_IN_SEL_CFG volatile.Register32 // 0x35C
	FUNC131_IN_SEL_CFG volatile.Register32 // 0x360
	FUNC132_IN_SEL_CFG volatile.Register32 // 0x364
	FUNC133_IN_SEL_CFG volatile.Register32 // 0x368
	FUNC134_IN_SEL_CFG volatile.Register32 // 0x36C
	FUNC135_IN_SEL_CFG volatile.Register32 // 0x370
	FUNC136_IN_SEL_CFG volatile.Register32 // 0x374
	FUNC137_IN_SEL_CFG volatile.Register32 // 0x378
	FUNC138_IN_SEL_CFG volatile.Register32 // 0x37C
	FUNC139_IN_SEL_CFG volatile.Register32 // 0x380
	FUNC140_IN_SEL_CFG volatile.Register32 // 0x384
	FUNC141_IN_SEL_CFG volatile.Register32 // 0x388
	FUNC142_IN_SEL_CFG volatile.Register32 // 0x38C
	FUNC143_IN_SEL_CFG volatile.Register32 // 0x390
	FUNC144_IN_SEL_CFG volatile.Register32 // 0x394
	FUNC145_IN_SEL_CFG volatile.Register32 // 0x398
	FUNC146_IN_SEL_CFG volatile.Register32 // 0x39C
	FUNC147_IN_SEL_CFG volatile.Register32 // 0x3A0
	FUNC148_IN_SEL_CFG volatile.Register32 // 0x3A4
	FUNC149_IN_SEL_CFG volatile.Register32 // 0x3A8
	FUNC150_IN_SEL_CFG volatile.Register32 // 0x3AC
	FUNC151_IN_SEL_CFG volatile.Register32 // 0x3B0
	FUNC152_IN_SEL_CFG volatile.Register32 // 0x3B4
	FUNC153_IN_SEL_CFG volatile.Register32 // 0x3B8
	FUNC154_IN_SEL_CFG volatile.Register32 // 0x3BC
	FUNC155_IN_SEL_CFG volatile.Register32 // 0x3C0
	FUNC156_IN_SEL_CFG volatile.Register32 // 0x3C4
	FUNC157_IN_SEL_CFG volatile.Register32 // 0x3C8
	FUNC158_IN_SEL_CFG volatile.Register32 // 0x3CC
	FUNC159_IN_SEL_CFG volatile.Register32 // 0x3D0
	FUNC160_IN_SEL_CFG volatile.Register32 // 0x3D4
	FUNC161_IN_SEL_CFG volatile.Register32 // 0x3D8
	FUNC162_IN_SEL_CFG volatile.Register32 // 0x3DC
	FUNC163_IN_SEL_CFG volatile.Register32 // 0x3E0
	FUNC164_IN_SEL_CFG volatile.Register32 // 0x3E4
	FUNC165_IN_SEL_CFG volatile.Register32 // 0x3E8
	FUNC166_IN_SEL_CFG volatile.Register32 // 0x3EC
	FUNC167_IN_SEL_CFG volatile.Register32 // 0x3F0
	FUNC168_IN_SEL_CFG volatile.Register32 // 0x3F4
	FUNC169_IN_SEL_CFG volatile.Register32 // 0x3F8
	FUNC170_IN_SEL_CFG volatile.Register32 // 0x3FC
	FUNC171_IN_SEL_CFG volatile.Register32 // 0x400
	FUNC172_IN_SEL_CFG volatile.Register32 // 0x404
	FUNC173_IN_SEL_CFG volatile.Register32 // 0x408
	FUNC174_IN_SEL_CFG volatile.Register32 // 0x40C
	FUNC175_IN_SEL_CFG volatile.Register32 // 0x410
	FUNC176_IN_SEL_CFG volatile.Register32 // 0x414
	FUNC177_IN_SEL_CFG volatile.Register32 // 0x418
	FUNC178_IN_SEL_CFG volatile.Register32 // 0x41C
	FUNC179_IN_SEL_CFG volatile.Register32 // 0x420
	FUNC180_IN_SEL_CFG volatile.Register32 // 0x424
	FUNC181_IN_SEL_CFG volatile.Register32 // 0x428
	FUNC182_IN_SEL_CFG volatile.Register32 // 0x42C
	FUNC183_IN_SEL_CFG volatile.Register32 // 0x430
	FUNC184_IN_SEL_CFG volatile.Register32 // 0x434
	FUNC185_IN_SEL_CFG volatile.Register32 // 0x438
	FUNC186_IN_SEL_CFG volatile.Register32 // 0x43C
	FUNC187_IN_SEL_CFG volatile.Register32 // 0x440
	FUNC188_IN_SEL_CFG volatile.Register32 // 0x444
	FUNC189_IN_SEL_CFG volatile.Register32 // 0x448
	FUNC190_IN_SEL_CFG volatile.Register32 // 0x44C
	FUNC191_IN_SEL_CFG volatile.Register32 // 0x450
	FUNC192_IN_SEL_CFG volatile.Register32 // 0x454
	FUNC193_IN_SEL_CFG volatile.Register32 // 0x458
	FUNC194_IN_SEL_CFG volatile.Register32 // 0x45C
	FUNC195_IN_SEL_CFG volatile.Register32 // 0x460
	FUNC196_IN_SEL_CFG volatile.Register32 // 0x464
	FUNC197_IN_SEL_CFG volatile.Register32 // 0x468
	FUNC198_IN_SEL_CFG volatile.Register32 // 0x46C
	FUNC199_IN_SEL_CFG volatile.Register32 // 0x470
	FUNC200_IN_SEL_CFG volatile.Register32 // 0x474
	FUNC201_IN_SEL_CFG volatile.Register32 // 0x478
	FUNC202_IN_SEL_CFG volatile.Register32 // 0x47C
	FUNC203_IN_SEL_CFG volatile.Register32 // 0x480
	FUNC204_IN_SEL_CFG volatile.Register32 // 0x484
	FUNC205_IN_SEL_CFG volatile.Register32 // 0x488
	FUNC206_IN_SEL_CFG volatile.Register32 // 0x48C
	FUNC207_IN_SEL_CFG volatile.Register32 // 0x490
	FUNC208_IN_SEL_CFG volatile.Register32 // 0x494
	FUNC209_IN_SEL_CFG volatile.Register32 // 0x498
	FUNC210_IN_SEL_CFG volatile.Register32 // 0x49C
	FUNC211_IN_SEL_CFG volatile.Register32 // 0x4A0
	FUNC212_IN_SEL_CFG volatile.Register32 // 0x4A4
	FUNC213_IN_SEL_CFG volatile.Register32 // 0x4A8
	FUNC214_IN_SEL_CFG volatile.Register32 // 0x4AC
	FUNC215_IN_SEL_CFG volatile.Register32 // 0x4B0
	FUNC216_IN_SEL_CFG volatile.Register32 // 0x4B4
	FUNC217_IN_SEL_CFG volatile.Register32 // 0x4B8
	FUNC218_IN_SEL_CFG volatile.Register32 // 0x4BC
	FUNC219_IN_SEL_CFG volatile.Register32 // 0x4C0
	FUNC220_IN_SEL_CFG volatile.Register32 // 0x4C4
	FUNC221_IN_SEL_CFG volatile.Register32 // 0x4C8
	FUNC222_IN_SEL_CFG volatile.Register32 // 0x4CC
	FUNC223_IN_SEL_CFG volatile.Register32 // 0x4D0
	FUNC224_IN_SEL_CFG volatile.Register32 // 0x4D4
	FUNC225_IN_SEL_CFG volatile.Register32 // 0x4D8
	FUNC226_IN_SEL_CFG volatile.Register32 // 0x4DC
	FUNC227_IN_SEL_CFG volatile.Register32 // 0x4E0
	FUNC228_IN_SEL_CFG volatile.Register32 // 0x4E4
	FUNC229_IN_SEL_CFG volatile.Register32 // 0x4E8
	FUNC230_IN_SEL_CFG volatile.Register32 // 0x4EC
	FUNC231_IN_SEL_CFG volatile.Register32 // 0x4F0
	FUNC232_IN_SEL_CFG volatile.Register32 // 0x4F4
	FUNC233_IN_SEL_CFG volatile.Register32 // 0x4F8
	FUNC234_IN_SEL_CFG volatile.Register32 // 0x4FC
	FUNC235_IN_SEL_CFG volatile.Register32 // 0x500
	FUNC236_IN_SEL_CFG volatile.Register32 // 0x504
	FUNC237_IN_SEL_CFG volatile.Register32 // 0x508
	FUNC238_IN_SEL_CFG volatile.Register32 // 0x50C
	FUNC239_IN_SEL_CFG volatile.Register32 // 0x510
	FUNC240_IN_SEL_CFG volatile.Register32 // 0x514
	FUNC241_IN_SEL_CFG volatile.Register32 // 0x518
	FUNC242_IN_SEL_CFG volatile.Register32 // 0x51C
	FUNC243_IN_SEL_CFG volatile.Register32 // 0x520
	FUNC244_IN_SEL_CFG volatile.Register32 // 0x524
	FUNC245_IN_SEL_CFG volatile.Register32 // 0x528
	FUNC246_IN_SEL_CFG volatile.Register32 // 0x52C
	FUNC247_IN_SEL_CFG volatile.Register32 // 0x530
	FUNC248_IN_SEL_CFG volatile.Register32 // 0x534
	FUNC249_IN_SEL_CFG volatile.Register32 // 0x538
	FUNC250_IN_SEL_CFG volatile.Register32 // 0x53C
	FUNC251_IN_SEL_CFG volatile.Register32 // 0x540
	FUNC252_IN_SEL_CFG volatile.Register32 // 0x544
	FUNC253_IN_SEL_CFG volatile.Register32 // 0x548
	FUNC254_IN_SEL_CFG volatile.Register32 // 0x54C
	FUNC255_IN_SEL_CFG volatile.Register32 // 0x550
	FUNC0_OUT_SEL_CFG  volatile.Register32 // 0x554
	FUNC1_OUT_SEL_CFG  volatile.Register32 // 0x558
	FUNC2_OUT_SEL_CFG  volatile.Register32 // 0x55C
	FUNC3_OUT_SEL_CFG  volatile.Register32 // 0x560
	FUNC4_OUT_SEL_CFG  volatile.Register32 // 0x564
	FUNC5_OUT_SEL_CFG  volatile.Register32 // 0x568
	FUNC6_OUT_SEL_CFG  volatile.Register32 // 0x56C
	FUNC7_OUT_SEL_CFG  volatile.Register32 // 0x570
	FUNC8_OUT_SEL_CFG  volatile.Register32 // 0x574
	FUNC9_OUT_SEL_CFG  volatile.Register32 // 0x578
	FUNC10_OUT_SEL_CFG volatile.Register32 // 0x57C
	FUNC11_OUT_SEL_CFG volatile.Register32 // 0x580
	FUNC12_OUT_SEL_CFG volatile.Register32 // 0x584
	FUNC13_OUT_SEL_CFG volatile.Register32 // 0x588
	FUNC14_OUT_SEL_CFG volatile.Register32 // 0x58C
	FUNC15_OUT_SEL_CFG volatile.Register32 // 0x590
	FUNC16_OUT_SEL_CFG volatile.Register32 // 0x594
	FUNC17_OUT_SEL_CFG volatile.Register32 // 0x598
	FUNC18_OUT_SEL_CFG volatile.Register32 // 0x59C
	FUNC19_OUT_SEL_CFG volatile.Register32 // 0x5A0
	FUNC20_OUT_SEL_CFG volatile.Register32 // 0x5A4
	FUNC21_OUT_SEL_CFG volatile.Register32 // 0x5A8
	FUNC22_OUT_SEL_CFG volatile.Register32 // 0x5AC
	FUNC23_OUT_SEL_CFG volatile.Register32 // 0x5B0
	FUNC24_OUT_SEL_CFG volatile.Register32 // 0x5B4
	FUNC25_OUT_SEL_CFG volatile.Register32 // 0x5B8
	FUNC26_OUT_SEL_CFG volatile.Register32 // 0x5BC
	FUNC27_OUT_SEL_CFG volatile.Register32 // 0x5C0
	FUNC28_OUT_SEL_CFG volatile.Register32 // 0x5C4
	FUNC29_OUT_SEL_CFG volatile.Register32 // 0x5C8
	FUNC30_OUT_SEL_CFG volatile.Register32 // 0x5CC
	FUNC31_OUT_SEL_CFG volatile.Register32 // 0x5D0
	FUNC32_OUT_SEL_CFG volatile.Register32 // 0x5D4
	FUNC33_OUT_SEL_CFG volatile.Register32 // 0x5D8
	FUNC34_OUT_SEL_CFG volatile.Register32 // 0x5DC
	FUNC35_OUT_SEL_CFG volatile.Register32 // 0x5E0
	FUNC36_OUT_SEL_CFG volatile.Register32 // 0x5E4
	FUNC37_OUT_SEL_CFG volatile.Register32 // 0x5E8
	FUNC38_OUT_SEL_CFG volatile.Register32 // 0x5EC
	FUNC39_OUT_SEL_CFG volatile.Register32 // 0x5F0
	FUNC40_OUT_SEL_CFG volatile.Register32 // 0x5F4
	FUNC41_OUT_SEL_CFG volatile.Register32 // 0x5F8
	FUNC42_OUT_SEL_CFG volatile.Register32 // 0x5FC
	FUNC43_OUT_SEL_CFG volatile.Register32 // 0x600
	FUNC44_OUT_SEL_CFG volatile.Register32 // 0x604
	FUNC45_OUT_SEL_CFG volatile.Register32 // 0x608
	FUNC46_OUT_SEL_CFG volatile.Register32 // 0x60C
	FUNC47_OUT_SEL_CFG volatile.Register32 // 0x610
	FUNC48_OUT_SEL_CFG volatile.Register32 // 0x614
	FUNC49_OUT_SEL_CFG volatile.Register32 // 0x618
	FUNC50_OUT_SEL_CFG volatile.Register32 // 0x61C
	FUNC51_OUT_SEL_CFG volatile.Register32 // 0x620
	FUNC52_OUT_SEL_CFG volatile.Register32 // 0x624
	FUNC53_OUT_SEL_CFG volatile.Register32 // 0x628
	CLOCK_GATE         volatile.Register32 // 0x62C
	_                  [204]byte
	REG_DATE           volatile.Register32 // 0x6FC
}

// GPIO.BT_SELECT: GPIO bit select register
func (o *GPIO_Type) SetBT_SELECT(value uint32) {
	volatile.StoreUint32(&o.BT_SELECT.Reg, value)
}
func (o *GPIO_Type) GetBT_SELECT() uint32 {
	return volatile.LoadUint32(&o.BT_SELECT.Reg)
}

// GPIO.OUT: GPIO output register for GPIO0-31
func (o *GPIO_Type) SetOUT(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, value)
}
func (o *GPIO_Type) GetOUT() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg)
}

// GPIO.OUT_W1TS: GPIO output set register for GPIO0-31
func (o *GPIO_Type) SetOUT_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TS.Reg, value)
}
func (o *GPIO_Type) GetOUT_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TS.Reg)
}

// GPIO.OUT_W1TC: GPIO output clear register for GPIO0-31
func (o *GPIO_Type) SetOUT_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TC.Reg, value)
}
func (o *GPIO_Type) GetOUT_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TC.Reg)
}

// GPIO.OUT1: GPIO output register for GPIO32-53
func (o *GPIO_Type) SetOUT1_DATA_ORIG(value uint32) {
	volatile.StoreUint32(&o.OUT1.Reg, volatile.LoadUint32(&o.OUT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetOUT1_DATA_ORIG() uint32 {
	return volatile.LoadUint32(&o.OUT1.Reg) & 0x3fffff
}

// GPIO.OUT1_W1TS: GPIO output set register for GPIO32-53
func (o *GPIO_Type) SetOUT1_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT1_W1TS.Reg, volatile.LoadUint32(&o.OUT1_W1TS.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetOUT1_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT1_W1TS.Reg) & 0x3fffff
}

// GPIO.OUT1_W1TC: GPIO output clear register for GPIO32-53
func (o *GPIO_Type) SetOUT1_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT1_W1TC.Reg, volatile.LoadUint32(&o.OUT1_W1TC.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetOUT1_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT1_W1TC.Reg) & 0x3fffff
}

// GPIO.SDIO_SELECT: GPIO sdio select register
func (o *GPIO_Type) SetSDIO_SELECT_SDIO_SEL(value uint32) {
	volatile.StoreUint32(&o.SDIO_SELECT.Reg, volatile.LoadUint32(&o.SDIO_SELECT.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSDIO_SELECT_SDIO_SEL() uint32 {
	return volatile.LoadUint32(&o.SDIO_SELECT.Reg) & 0xff
}

// GPIO.ENABLE: GPIO output enable register for GPIO0-31
func (o *GPIO_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, value)
}
func (o *GPIO_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg)
}

// GPIO.ENABLE_W1TS: GPIO output enable set register for GPIO0-31
func (o *GPIO_Type) SetENABLE_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TS.Reg, value)
}
func (o *GPIO_Type) GetENABLE_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TS.Reg)
}

// GPIO.ENABLE_W1TC: GPIO output enable clear register for GPIO0-31
func (o *GPIO_Type) SetENABLE_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TC.Reg, value)
}
func (o *GPIO_Type) GetENABLE_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TC.Reg)
}

// GPIO.ENABLE1: GPIO output enable register for GPIO32-53
func (o *GPIO_Type) SetENABLE1_DATA(value uint32) {
	volatile.StoreUint32(&o.ENABLE1.Reg, volatile.LoadUint32(&o.ENABLE1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetENABLE1_DATA() uint32 {
	return volatile.LoadUint32(&o.ENABLE1.Reg) & 0x3fffff
}

// GPIO.ENABLE1_W1TS: GPIO output enable set register for GPIO32-53
func (o *GPIO_Type) SetENABLE1_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE1_W1TS.Reg, volatile.LoadUint32(&o.ENABLE1_W1TS.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetENABLE1_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE1_W1TS.Reg) & 0x3fffff
}

// GPIO.ENABLE1_W1TC: GPIO output enable clear register for GPIO32-53
func (o *GPIO_Type) SetENABLE1_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE1_W1TC.Reg, volatile.LoadUint32(&o.ENABLE1_W1TC.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetENABLE1_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE1_W1TC.Reg) & 0x3fffff
}

// GPIO.STRAP: pad strapping register
func (o *GPIO_Type) SetSTRAP_STRAPPING(value uint32) {
	volatile.StoreUint32(&o.STRAP.Reg, volatile.LoadUint32(&o.STRAP.Reg)&^(0xffff)|value)
}
func (o *GPIO_Type) GetSTRAP_STRAPPING() uint32 {
	return volatile.LoadUint32(&o.STRAP.Reg) & 0xffff
}

// GPIO.IN: GPIO input register for GPIO0-31
func (o *GPIO_Type) SetIN(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, value)
}
func (o *GPIO_Type) GetIN() uint32 {
	return volatile.LoadUint32(&o.IN.Reg)
}

// GPIO.IN1: GPIO input register for GPIO32-53
func (o *GPIO_Type) SetIN1_DATA_NEXT(value uint32) {
	volatile.StoreUint32(&o.IN1.Reg, volatile.LoadUint32(&o.IN1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetIN1_DATA_NEXT() uint32 {
	return volatile.LoadUint32(&o.IN1.Reg) & 0x3fffff
}

// GPIO.STATUS: GPIO interrupt status register for GPIO0-31
func (o *GPIO_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, value)
}
func (o *GPIO_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg)
}

// GPIO.STATUS_W1TS: GPIO interrupt status set register for GPIO0-31
func (o *GPIO_Type) SetSTATUS_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TS.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TS.Reg)
}

// GPIO.STATUS_W1TC: GPIO interrupt status clear register for GPIO0-31
func (o *GPIO_Type) SetSTATUS_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TC.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TC.Reg)
}

// GPIO.STATUS1: GPIO interrupt status register for GPIO32-53
func (o *GPIO_Type) SetSTATUS1_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.STATUS1.Reg, volatile.LoadUint32(&o.STATUS1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetSTATUS1_INTERRUPT() uint32 {
	return volatile.LoadUint32(&o.STATUS1.Reg) & 0x3fffff
}

// GPIO.STATUS1_W1TS: GPIO interrupt status set register for GPIO32-53
func (o *GPIO_Type) SetSTATUS1_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS1_W1TS.Reg, volatile.LoadUint32(&o.STATUS1_W1TS.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetSTATUS1_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS1_W1TS.Reg) & 0x3fffff
}

// GPIO.STATUS1_W1TC: GPIO interrupt status clear register for GPIO32-53
func (o *GPIO_Type) SetSTATUS1_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS1_W1TC.Reg, volatile.LoadUint32(&o.STATUS1_W1TC.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetSTATUS1_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS1_W1TC.Reg) & 0x3fffff
}

// GPIO.PCPU_INT: GPIO PRO_CPU interrupt status register for GPIO0-31
func (o *GPIO_Type) SetPCPU_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT.Reg, value)
}
func (o *GPIO_Type) GetPCPU_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT.Reg)
}

// GPIO.PCPU_NMI_INT: GPIO PRO_CPU(not shielded) interrupt status register for GPIO0-31
func (o *GPIO_Type) SetPCPU_NMI_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT.Reg, value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT.Reg)
}

// GPIO.CPUSDIO_INT: GPIO CPUSDIO interrupt status register for GPIO0-31
func (o *GPIO_Type) SetCPUSDIO_INT(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT.Reg, value)
}
func (o *GPIO_Type) GetCPUSDIO_INT() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT.Reg)
}

// GPIO.PCPU_INT1: GPIO PRO_CPU interrupt status register for GPIO32-53
func (o *GPIO_Type) SetPCPU_INT1_PROCPU_INT1(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT1.Reg, volatile.LoadUint32(&o.PCPU_INT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetPCPU_INT1_PROCPU_INT1() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT1.Reg) & 0x3fffff
}

// GPIO.PCPU_NMI_INT1: GPIO PRO_CPU(not shielded) interrupt status register for GPIO32-53
func (o *GPIO_Type) SetPCPU_NMI_INT1_PROCPU_NMI_INT1(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT1.Reg, volatile.LoadUint32(&o.PCPU_NMI_INT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT1_PROCPU_NMI_INT1() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT1.Reg) & 0x3fffff
}

// GPIO.CPUSDIO_INT1: GPIO CPUSDIO interrupt status register for GPIO32-53
func (o *GPIO_Type) SetCPUSDIO_INT1_SDIO_INT1(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_SDIO_INT1() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0x3fffff
}

// GPIO.PIN0: GPIO pin configuration register
func (o *GPIO_Type) SetPIN0_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN0_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN0_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN0_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN0_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN0_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN0_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN0_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN0_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN0_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN0_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN0_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x3e000) >> 13
}

// GPIO.PIN1: GPIO pin configuration register
func (o *GPIO_Type) SetPIN1_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN1_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN1_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN1_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN1_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN1_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN1_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN1_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN1_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN1_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN1_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN1_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x3e000) >> 13
}

// GPIO.PIN2: GPIO pin configuration register
func (o *GPIO_Type) SetPIN2_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN2_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN2.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN2_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN2_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN2_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN2_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN2_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN2_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN2_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN2_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN2_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN2_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x3e000) >> 13
}

// GPIO.PIN3: GPIO pin configuration register
func (o *GPIO_Type) SetPIN3_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN3_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN3.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN3_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN3_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN3_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN3_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN3_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN3_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN3_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN3_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN3_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN3_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x3e000) >> 13
}

// GPIO.PIN4: GPIO pin configuration register
func (o *GPIO_Type) SetPIN4_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN4_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN4.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN4_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN4_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN4_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN4_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN4_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN4_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN4_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN4_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN4_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN4_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x3e000) >> 13
}

// GPIO.PIN5: GPIO pin configuration register
func (o *GPIO_Type) SetPIN5_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN5_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN5.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN5_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN5_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN5_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN5_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN5_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN5_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN5_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN5_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN5_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN5_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x3e000) >> 13
}

// GPIO.PIN6: GPIO pin configuration register
func (o *GPIO_Type) SetPIN6_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN6_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN6.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN6_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN6_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN6_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN6_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN6_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN6_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN6_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN6_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN6_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN6_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN6_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN6_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x3e000) >> 13
}

// GPIO.PIN7: GPIO pin configuration register
func (o *GPIO_Type) SetPIN7_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN7_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN7.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN7_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN7_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN7_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN7_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN7_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN7_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN7_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN7_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN7_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN7_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN7_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN7_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x3e000) >> 13
}

// GPIO.PIN8: GPIO pin configuration register
func (o *GPIO_Type) SetPIN8_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN8_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN8.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN8_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN8_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN8_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN8_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN8_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN8_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN8_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN8_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN8_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN8_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN8_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN8_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x3e000) >> 13
}

// GPIO.PIN9: GPIO pin configuration register
func (o *GPIO_Type) SetPIN9_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN9_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN9.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN9_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN9_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN9_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN9_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN9_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN9_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN9_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN9_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN9_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN9_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN9_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN9_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x3e000) >> 13
}

// GPIO.PIN10: GPIO pin configuration register
func (o *GPIO_Type) SetPIN10_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN10_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN10.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN10_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN10_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN10_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN10_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN10_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN10_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN10_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN10_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN10_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN10_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN10_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN10_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x3e000) >> 13
}

// GPIO.PIN11: GPIO pin configuration register
func (o *GPIO_Type) SetPIN11_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN11_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN11.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN11_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN11_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN11_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN11_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN11_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN11_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN11_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN11_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN11_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN11_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN11_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN11_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x3e000) >> 13
}

// GPIO.PIN12: GPIO pin configuration register
func (o *GPIO_Type) SetPIN12_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN12_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN12.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN12_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN12_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN12_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN12_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN12_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN12_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN12_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN12_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN12_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN12_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN12_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN12_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x3e000) >> 13
}

// GPIO.PIN13: GPIO pin configuration register
func (o *GPIO_Type) SetPIN13_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN13_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN13.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN13_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN13_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN13_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN13_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN13_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN13_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN13_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN13_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN13_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN13_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN13_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN13_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x3e000) >> 13
}

// GPIO.PIN14: GPIO pin configuration register
func (o *GPIO_Type) SetPIN14_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN14_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN14.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN14_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN14_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN14_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN14_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN14_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN14_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN14_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN14_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN14_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN14_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN14_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN14_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x3e000) >> 13
}

// GPIO.PIN15: GPIO pin configuration register
func (o *GPIO_Type) SetPIN15_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN15_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN15.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN15_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN15_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN15_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN15_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN15_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN15_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN15_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN15_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN15_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN15_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN15_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN15_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x3e000) >> 13
}

// GPIO.PIN16: GPIO pin configuration register
func (o *GPIO_Type) SetPIN16_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN16_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN16.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN16_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN16_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN16_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN16_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN16_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN16_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN16_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN16_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN16_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN16_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN16_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN16_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x3e000) >> 13
}

// GPIO.PIN17: GPIO pin configuration register
func (o *GPIO_Type) SetPIN17_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN17_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN17.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN17_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN17_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN17_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN17_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN17_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN17_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN17_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN17_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN17_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN17_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN17_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN17_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x3e000) >> 13
}

// GPIO.PIN18: GPIO pin configuration register
func (o *GPIO_Type) SetPIN18_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN18_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN18.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN18_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN18_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN18_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN18_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN18_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN18_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN18_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN18_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN18_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN18_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN18_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN18_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x3e000) >> 13
}

// GPIO.PIN19: GPIO pin configuration register
func (o *GPIO_Type) SetPIN19_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN19_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN19.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN19_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN19_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN19_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN19_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN19_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN19_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN19_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN19_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN19_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN19_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN19_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN19_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x3e000) >> 13
}

// GPIO.PIN20: GPIO pin configuration register
func (o *GPIO_Type) SetPIN20_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN20_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN20.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN20_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN20_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN20_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN20_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN20_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN20_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN20_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN20_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN20_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN20_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN20_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN20_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x3e000) >> 13
}

// GPIO.PIN21: GPIO pin configuration register
func (o *GPIO_Type) SetPIN21_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN21_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN21.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN21_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN21_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN21_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN21_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN21_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN21_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN21_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN21_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN21_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN21_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN21_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN21_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x3e000) >> 13
}

// GPIO.PIN22: GPIO pin configuration register
func (o *GPIO_Type) SetPIN22_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN22_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN22.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN22_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN22_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN22_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN22_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN22_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN22_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN22_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN22_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN22_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN22_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN22_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN22_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x3e000) >> 13
}

// GPIO.PIN23: GPIO pin configuration register
func (o *GPIO_Type) SetPIN23_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN23_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN23.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN23_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN23_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN23_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN23_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN23_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN23_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN23_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN23_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN23_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN23_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN23_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN23_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x3e000) >> 13
}

// GPIO.PIN24: GPIO pin configuration register
func (o *GPIO_Type) SetPIN24_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN24_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN24.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN24_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN24_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN24_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN24_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN24_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN24_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN24_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN24_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN24_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN24_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN24_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN24_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x3e000) >> 13
}

// GPIO.PIN25: GPIO pin configuration register
func (o *GPIO_Type) SetPIN25_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN25_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN25.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN25_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN25_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN25_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN25_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN25_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN25_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN25_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN25_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN25_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN25_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN25_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN25_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x3e000) >> 13
}

// GPIO.PIN26: GPIO pin configuration register
func (o *GPIO_Type) SetPIN26_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN26_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN26.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN26_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN26_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN26_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN26_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN26_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN26_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN26_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN26_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN26_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN26_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN26_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN26_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x3e000) >> 13
}

// GPIO.PIN27: GPIO pin configuration register
func (o *GPIO_Type) SetPIN27_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN27_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN27.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN27_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN27_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN27_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN27_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN27_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN27_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN27_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN27_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN27_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN27_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN27_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN27_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x3e000) >> 13
}

// GPIO.PIN28: GPIO pin configuration register
func (o *GPIO_Type) SetPIN28_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN28_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN28.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN28_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN28_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN28_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN28_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN28_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN28_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN28_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN28_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN28_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN28_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN28_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN28_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x3e000) >> 13
}

// GPIO.PIN29: GPIO pin configuration register
func (o *GPIO_Type) SetPIN29_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN29_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN29.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN29_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN29_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN29_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN29_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN29_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN29_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN29_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN29_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN29_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN29_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN29_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN29_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x3e000) >> 13
}

// GPIO.PIN30: GPIO pin configuration register
func (o *GPIO_Type) SetPIN30_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN30_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN30.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN30_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN30_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN30_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN30_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN30_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN30_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN30_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN30_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN30_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN30_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN30_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN30_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x3e000) >> 13
}

// GPIO.PIN31: GPIO pin configuration register
func (o *GPIO_Type) SetPIN31_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN31_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN31.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN31_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN31_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN31_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN31_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN31_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN31_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN31_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN31_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN31_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN31_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN31_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN31_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x3e000) >> 13
}

// GPIO.PIN32: GPIO pin configuration register
func (o *GPIO_Type) SetPIN32_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN32_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN32.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN32_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN32_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN32_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN32_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN32_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN32_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN32_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN32_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN32_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN32_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN32_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN32_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x3e000) >> 13
}

// GPIO.PIN33: GPIO pin configuration register
func (o *GPIO_Type) SetPIN33_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN33_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN33.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN33_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN33_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN33_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN33_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN33_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN33_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN33_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN33_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN33_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN33_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN33_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN33_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x3e000) >> 13
}

// GPIO.PIN34: GPIO pin configuration register
func (o *GPIO_Type) SetPIN34_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN34_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN34.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN34_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN34_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN34_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN34_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN34_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN34_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN34_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN34_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN34_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN34_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN34_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN34_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x3e000) >> 13
}

// GPIO.PIN35: GPIO pin configuration register
func (o *GPIO_Type) SetPIN35_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN35_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN35.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN35_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN35_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN35_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN35_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN35_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN35_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN35_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN35_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN35_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN35_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN35_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN35_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x3e000) >> 13
}

// GPIO.PIN36: GPIO pin configuration register
func (o *GPIO_Type) SetPIN36_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN36_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN36.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN36_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN36_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN36_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN36_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN36_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN36_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN36_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN36_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN36_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN36_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN36_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN36_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x3e000) >> 13
}

// GPIO.PIN37: GPIO pin configuration register
func (o *GPIO_Type) SetPIN37_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN37_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN37.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN37_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN37_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN37_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN37_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN37_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN37_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN37_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN37_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN37_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN37_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN37_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN37_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x3e000) >> 13
}

// GPIO.PIN38: GPIO pin configuration register
func (o *GPIO_Type) SetPIN38_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN38_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN38.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN38_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN38_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN38_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN38_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN38_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN38_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN38_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN38_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN38_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN38_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN38_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN38_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x3e000) >> 13
}

// GPIO.PIN39: GPIO pin configuration register
func (o *GPIO_Type) SetPIN39_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN39_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN39.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN39_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN39_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN39_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN39_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN39_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN39_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN39_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN39_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN39_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN39_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN39_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN39_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x3e000) >> 13
}

// GPIO.PIN40: GPIO pin configuration register
func (o *GPIO_Type) SetPIN40_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN40_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN40.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN40_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN40_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN40_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN40_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN40_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN40_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN40_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN40_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN40_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN40_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN40_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN40_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x3e000) >> 13
}

// GPIO.PIN41: GPIO pin configuration register
func (o *GPIO_Type) SetPIN41_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN41_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN41.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN41_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN41_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN41_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN41_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN41_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN41_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN41_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN41_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN41_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN41_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN41_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN41_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x3e000) >> 13
}

// GPIO.PIN42: GPIO pin configuration register
func (o *GPIO_Type) SetPIN42_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN42_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN42.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN42_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN42_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN42_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN42_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN42_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN42_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN42_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN42_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN42_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN42_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN42_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN42_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x3e000) >> 13
}

// GPIO.PIN43: GPIO pin configuration register
func (o *GPIO_Type) SetPIN43_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN43_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN43.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN43_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN43_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN43_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN43_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN43_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN43_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN43_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN43_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN43_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN43_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN43_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN43_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x3e000) >> 13
}

// GPIO.PIN44: GPIO pin configuration register
func (o *GPIO_Type) SetPIN44_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN44_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN44.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN44_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN44_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN44_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN44_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN44_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN44_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN44_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN44_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN44_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN44_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN44_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN44_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x3e000) >> 13
}

// GPIO.PIN45: GPIO pin configuration register
func (o *GPIO_Type) SetPIN45_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN45_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN45.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN45_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN45_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN45_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN45_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN45_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN45_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN45_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN45_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN45_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN45_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN45_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN45_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x3e000) >> 13
}

// GPIO.PIN46: GPIO pin configuration register
func (o *GPIO_Type) SetPIN46_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN46_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN46.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN46_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN46_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN46_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN46_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN46_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN46_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN46_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN46_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN46_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN46_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN46_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN46_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x3e000) >> 13
}

// GPIO.PIN47: GPIO pin configuration register
func (o *GPIO_Type) SetPIN47_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN47_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN47.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN47_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN47_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN47_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN47_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN47_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN47_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN47_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN47_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN47_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN47_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN47_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN47_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x3e000) >> 13
}

// GPIO.PIN48: GPIO pin configuration register
func (o *GPIO_Type) SetPIN48_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN48_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN48.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN48_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN48_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN48_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN48_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN48_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN48_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN48_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN48_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN48_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN48_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN48_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN48_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x3e000) >> 13
}

// GPIO.PIN49: GPIO pin configuration register
func (o *GPIO_Type) SetPIN49_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN49_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN49.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN49_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN49_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN49_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN49_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN49_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN49_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN49_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN49_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN49_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN49_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN49_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN49_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x3e000) >> 13
}

// GPIO.PIN50: GPIO pin configuration register
func (o *GPIO_Type) SetPIN50_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN50_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN50.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN50_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN50_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN50_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN50_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN50_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN50_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN50_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN50_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN50_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN50_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN50_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN50_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x3e000) >> 13
}

// GPIO.PIN51: GPIO pin configuration register
func (o *GPIO_Type) SetPIN51_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN51_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN51.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN51_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN51_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN51_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN51_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN51_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN51_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN51_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN51_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN51_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN51_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN51_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN51_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x3e000) >> 13
}

// GPIO.PIN52: GPIO pin configuration register
func (o *GPIO_Type) SetPIN52_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN52_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN52.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN52_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN52_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN52_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN52_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN52_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN52_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN52_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN52_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN52_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN52_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN52_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN52_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x3e000) >> 13
}

// GPIO.PIN53: GPIO pin configuration register
func (o *GPIO_Type) SetPIN53_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN53_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN53.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN53_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN53_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN53_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN53_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN53_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN53_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN53_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN53_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN53_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN53_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN53_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN53_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x3e000) >> 13
}

// GPIO.STATUS_NEXT: GPIO interrupt source register for GPIO0-31
func (o *GPIO_Type) SetSTATUS_NEXT(value uint32) {
	volatile.StoreUint32(&o.STATUS_NEXT.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_NEXT() uint32 {
	return volatile.LoadUint32(&o.STATUS_NEXT.Reg)
}

// GPIO.STATUS_NEXT1: GPIO interrupt source register for GPIO32-53
func (o *GPIO_Type) SetSTATUS_NEXT1_STATUS_INTERRUPT_NEXT1(value uint32) {
	volatile.StoreUint32(&o.STATUS_NEXT1.Reg, volatile.LoadUint32(&o.STATUS_NEXT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetSTATUS_NEXT1_STATUS_INTERRUPT_NEXT1() uint32 {
	return volatile.LoadUint32(&o.STATUS_NEXT1.Reg) & 0x3fffff
}

// GPIO.FUNC0_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC1_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC2_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC3_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC4_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC5_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC6_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC7_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC8_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC9_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC10_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC11_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC12_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC13_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC14_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC15_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC16_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC17_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC18_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC19_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC20_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC21_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC22_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC23_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC24_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC25_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC26_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC27_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC28_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC29_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC30_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC31_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC32_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC33_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC34_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC35_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC36_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC37_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC38_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC39_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC40_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC41_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC42_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC43_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC44_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC45_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC46_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC47_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC48_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC49_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC50_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC51_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC52_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC53_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC54_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC55_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC56_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC57_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC58_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC59_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC60_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC61_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC62_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC63_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC64_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC65_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC66_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC67_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC68_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC69_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC70_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC71_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC72_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC73_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC74_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC75_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC76_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC77_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC78_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC79_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC80_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC81_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC82_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC83_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC84_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC85_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC86_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC87_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC88_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC89_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC90_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC91_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC92_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC93_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC94_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC95_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC96_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC97_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC98_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC99_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC100_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC101_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC102_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC103_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC104_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC105_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC106_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC107_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC108_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC109_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC110_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC111_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC112_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC113_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC114_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC115_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC116_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC117_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC118_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC119_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC120_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC121_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC122_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC123_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC124_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC125_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC126_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC127_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC128_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC129_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC130_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC131_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC132_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC133_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC134_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC135_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC136_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC137_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC138_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC139_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC140_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC141_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC142_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC143_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC144_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC145_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC146_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC147_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC148_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC149_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC150_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC151_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC152_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC153_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC154_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC155_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC156_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC157_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC158_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC159_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC160_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC161_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC162_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC163_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC164_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC165_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC166_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC167_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC168_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC169_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC170_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC171_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC172_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC173_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC174_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC175_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC176_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC177_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC178_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC179_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC180_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC181_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC182_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC183_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC184_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC185_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC186_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC187_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC188_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC189_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC190_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC191_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC192_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC193_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC194_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC195_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC196_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC197_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC198_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC199_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC200_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC201_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC202_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC203_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC204_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC205_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC206_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC207_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC208_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC209_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC210_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC211_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC212_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC213_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC214_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC215_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC216_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC217_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC218_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC219_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC220_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC221_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC222_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC223_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC224_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC225_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC226_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC227_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC228_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC229_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC230_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC231_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC232_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC233_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC234_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC235_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC236_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC237_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC238_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC239_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC240_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC241_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC242_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC243_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC244_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC245_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC246_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC247_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC248_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC249_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC250_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC251_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC252_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC253_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC254_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC255_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC0_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC1_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC2_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC3_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC4_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC5_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC6_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC7_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC8_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC9_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_INV_SEL