/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.transport.SenderState;
import org.apache.catalina.tribes.util.StringManager;

public class MemberImpl
implements Member,
Externalizable {
    public static final transient byte[] TRIBES_MBR_BEGIN = new byte[]{84, 82, 73, 66, 69, 83, 45, 66, 1, 0};
    public static final transient byte[] TRIBES_MBR_END = new byte[]{84, 82, 73, 66, 69, 83, 45, 69, 1, 0};
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.membership");
    protected volatile byte[] host = new byte[0];
    protected volatile transient String hostname;
    protected volatile int port;
    protected volatile int udpPort = -1;
    protected volatile int securePort = -1;
    protected AtomicInteger msgCount = new AtomicInteger(0);
    protected volatile long memberAliveTime = 0L;
    protected transient long serviceStartTime;
    protected transient byte[] dataPkg = null;
    protected volatile byte[] uniqueId = new byte[16];
    protected volatile byte[] payload = new byte[0];
    protected volatile byte[] command = new byte[0];
    protected volatile byte[] domain = new byte[0];
    protected volatile boolean local = false;

    public MemberImpl() {
    }

    public MemberImpl(String string, int n, long l) throws IOException {
        this.setHostname(string);
        this.port = n;
        this.memberAliveTime = l;
    }

    public MemberImpl(String string, int n, long l, byte[] byArray) throws IOException {
        this(string, n, l);
        this.setPayload(byArray);
    }

    @Override
    public boolean isReady() {
        return SenderState.getSenderState(this).isReady();
    }

    @Override
    public boolean isSuspect() {
        return SenderState.getSenderState(this).isSuspect();
    }

    @Override
    public boolean isFailing() {
        return SenderState.getSenderState(this).isFailing();
    }

    protected void inc() {
        this.msgCount.incrementAndGet();
    }

    public byte[] getData() {
        return this.getData(true);
    }

    @Override
    public byte[] getData(boolean bl) {
        return this.getData(bl, false);
    }

    @Override
    public synchronized int getDataLength() {
        return TRIBES_MBR_BEGIN.length + 4 + 8 + 4 + 4 + 4 + 1 + this.host.length + 4 + this.command.length + 4 + this.domain.length + 16 + 4 + this.payload.length + TRIBES_MBR_END.length;
    }

    @Override
    public synchronized byte[] getData(boolean bl, boolean bl2) {
        if (bl2) {
            this.dataPkg = null;
        }
        if (this.dataPkg != null) {
            if (bl) {
                long l = System.currentTimeMillis() - this.getServiceStartTime();
                byte[] byArray = (byte[])this.dataPkg.clone();
                XByteBuffer.toBytes(l, byArray, TRIBES_MBR_BEGIN.length + 4);
                this.dataPkg = byArray;
            }
            return this.dataPkg;
        }
        long l = System.currentTimeMillis() - this.getServiceStartTime();
        byte[] byArray = new byte[this.getDataLength()];
        int n = this.getDataLength() - TRIBES_MBR_BEGIN.length - TRIBES_MBR_END.length - 4;
        int n2 = 0;
        System.arraycopy(TRIBES_MBR_BEGIN, 0, byArray, n2, TRIBES_MBR_BEGIN.length);
        XByteBuffer.toBytes(n, byArray, n2 += TRIBES_MBR_BEGIN.length);
        XByteBuffer.toBytes(l, byArray, n2 += 4);
        XByteBuffer.toBytes(this.port, byArray, n2 += 8);
        XByteBuffer.toBytes(this.securePort, byArray, n2 += 4);
        XByteBuffer.toBytes(this.udpPort, byArray, n2 += 4);
        n2 += 4;
        byArray[n2++] = (byte)this.host.length;
        System.arraycopy(this.host, 0, byArray, n2, this.host.length);
        XByteBuffer.toBytes(this.command.length, byArray, n2 += this.host.length);
        System.arraycopy(this.command, 0, byArray, n2 += 4, this.command.length);
        XByteBuffer.toBytes(this.domain.length, byArray, n2 += this.command.length);
        System.arraycopy(this.domain, 0, byArray, n2 += 4, this.domain.length);
        System.arraycopy(this.uniqueId, 0, byArray, n2 += this.domain.length, this.uniqueId.length);
        XByteBuffer.toBytes(this.payload.length, byArray, n2 += this.uniqueId.length);
        System.arraycopy(this.payload, 0, byArray, n2 += 4, this.payload.length);
        System.arraycopy(TRIBES_MBR_END, 0, byArray, n2 += this.payload.length, TRIBES_MBR_END.length);
        n2 += TRIBES_MBR_END.length;
        this.dataPkg = byArray;
        return byArray;
    }

    public static Member getMember(byte[] byArray, MemberImpl memberImpl) {
        return MemberImpl.getMember(byArray, 0, byArray.length, memberImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Member getMember(byte[] byArray, int n, int n2, MemberImpl memberImpl) {
        int n3 = n;
        if (XByteBuffer.firstIndexOf(byArray, n, TRIBES_MBR_BEGIN) != n3) {
            throw new IllegalArgumentException(sm.getString("memberImpl.invalid.package.begin", org.apache.catalina.tribes.util.Arrays.toString(TRIBES_MBR_BEGIN)));
        }
        if (n2 < TRIBES_MBR_BEGIN.length + 4) {
            throw new ArrayIndexOutOfBoundsException(sm.getString("memberImpl.package.small"));
        }
        int n4 = XByteBuffer.toInt(byArray, n3 += TRIBES_MBR_BEGIN.length);
        n3 += 4;
        if (n2 < n4 + 4 + TRIBES_MBR_BEGIN.length + TRIBES_MBR_END.length) {
            throw new ArrayIndexOutOfBoundsException(sm.getString("memberImpl.notEnough.bytes"));
        }
        int n5 = n3 + n4;
        if (XByteBuffer.firstIndexOf(byArray, n5, TRIBES_MBR_END) != n5) {
            throw new IllegalArgumentException(sm.getString("memberImpl.invalid.package.end", org.apache.catalina.tribes.util.Arrays.toString(TRIBES_MBR_END)));
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, n3, byArray2, 0, 8);
        byte[] byArray3 = new byte[4];
        System.arraycopy(byArray, n3 += 8, byArray3, 0, 4);
        byte[] byArray4 = new byte[4];
        System.arraycopy(byArray, n3 += 4, byArray4, 0, 4);
        byte[] byArray5 = new byte[4];
        System.arraycopy(byArray, n3 += 4, byArray5, 0, 4);
        n3 += 4;
        byte by = byArray[n3++];
        byte[] byArray6 = new byte[by];
        System.arraycopy(byArray, n3, byArray6, 0, by);
        int n6 = XByteBuffer.toInt(byArray, n3 += by);
        byte[] byArray7 = new byte[n6];
        System.arraycopy(byArray, n3 += 4, byArray7, 0, byArray7.length);
        int n7 = XByteBuffer.toInt(byArray, n3 += byArray7.length);
        byte[] byArray8 = new byte[n7];
        System.arraycopy(byArray, n3 += 4, byArray8, 0, byArray8.length);
        byte[] byArray9 = new byte[16];
        System.arraycopy(byArray, n3 += byArray8.length, byArray9, 0, 16);
        int n8 = XByteBuffer.toInt(byArray, n3 += 16);
        byte[] byArray10 = new byte[n8];
        System.arraycopy(byArray, n3 += 4, byArray10, 0, byArray10.length);
        n3 += byArray10.length;
        MemberImpl memberImpl2 = memberImpl;
        synchronized (memberImpl2) {
            memberImpl.setHost(byArray6);
            memberImpl.setPort(XByteBuffer.toInt(byArray3, 0));
            memberImpl.setSecurePort(XByteBuffer.toInt(byArray4, 0));
            memberImpl.setUdpPort(XByteBuffer.toInt(byArray5, 0));
            memberImpl.setMemberAliveTime(XByteBuffer.toLong(byArray2, 0));
            memberImpl.setUniqueId(byArray9);
            memberImpl.payload = byArray10;
            memberImpl.domain = byArray8;
            memberImpl.command = byArray7;
            memberImpl.dataPkg = new byte[n2];
            System.arraycopy(byArray, n, memberImpl.dataPkg, 0, n2);
        }
        return memberImpl;
    }

    public static Member getMember(byte[] byArray) {
        return MemberImpl.getMember(byArray, new MemberImpl());
    }

    public static Member getMember(byte[] byArray, int n, int n2) {
        return MemberImpl.getMember(byArray, n, n2, new MemberImpl());
    }

    @Override
    public String getName() {
        return "tcp://" + this.getHostname() + ":" + this.getPort();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public byte[] getHost() {
        return this.host;
    }

    public String getHostname() {
        if (this.hostname != null) {
            return this.hostname;
        }
        byte[] byArray = this.host;
        this.hostname = org.apache.catalina.tribes.util.Arrays.toString(byArray, 0, byArray.length, true);
        return this.hostname;
    }

    public int getMsgCount() {
        return this.msgCount.get();
    }

    @Override
    public long getMemberAliveTime() {
        return this.memberAliveTime;
    }

    public long getServiceStartTime() {
        return this.serviceStartTime;
    }

    @Override
    public byte[] getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public byte[] getCommand() {
        return this.command;
    }

    @Override
    public byte[] getDomain() {
        return this.domain;
    }

    @Override
    public int getSecurePort() {
        return this.securePort;
    }

    @Override
    public int getUdpPort() {
        return this.udpPort;
    }

    @Override
    public void setMemberAliveTime(long l) {
        this.memberAliveTime = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append('[');
        stringBuilder.append(this.getName()).append(',');
        stringBuilder.append(this.getHostname()).append(',');
        stringBuilder.append(this.port).append(", alive=");
        stringBuilder.append(this.memberAliveTime).append(", ");
        stringBuilder.append("securePort=").append(this.securePort).append(", ");
        stringBuilder.append("UDP Port=").append(this.udpPort).append(", ");
        stringBuilder.append("id=").append(MemberImpl.bToS(this.uniqueId)).append(", ");
        stringBuilder.append("payload=").append(MemberImpl.bToS(this.payload, 8)).append(", ");
        stringBuilder.append("command=").append(MemberImpl.bToS(this.command, 8)).append(", ");
        stringBuilder.append("domain=").append(MemberImpl.bToS(this.domain, 8));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String bToS(byte[] byArray) {
        return MemberImpl.bToS(byArray, byArray.length);
    }

    public static String bToS(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('{');
        for (int i = 0; byArray != null && i < byArray.length; ++i) {
            stringBuilder.append(String.valueOf(byArray[i])).append(' ');
            if (i != n) continue;
            stringBuilder.append("...(" + byArray.length + ")");
            break;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.getHost()[0] + this.getHost()[1] + this.getHost()[2] + this.getHost()[3];
    }

    public boolean equals(Object object) {
        if (object instanceof MemberImpl) {
            return Arrays.equals(this.getHost(), ((MemberImpl)object).getHost()) && this.getPort() == ((MemberImpl)object).getPort() && Arrays.equals(this.getUniqueId(), ((MemberImpl)object).getUniqueId());
        }
        return false;
    }

    public synchronized void setHost(byte[] byArray) {
        this.host = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHostname(String string) throws IOException {
        this.hostname = string;
        MemberImpl memberImpl = this;
        synchronized (memberImpl) {
            this.host = InetAddress.getByName(string).getAddress();
        }
    }

    public void setMsgCount(int n) {
        this.msgCount.set(n);
    }

    public synchronized void setPort(int n) {
        this.port = n;
        this.dataPkg = null;
    }

    public void setServiceStartTime(long l) {
        this.serviceStartTime = l;
    }

    public synchronized void setUniqueId(byte[] byArray) {
        this.uniqueId = byArray != null ? byArray : new byte[16];
        this.getData(true, true);
    }

    @Override
    public synchronized void setPayload(byte[] byArray) {
        long l = this.payload.length;
        long l2 = 0L;
        if (byArray != null) {
            l2 = byArray.length;
        }
        if (l2 > l && l2 - l + (long)this.getData(false, false).length > 65535L) {
            throw new IllegalArgumentException(sm.getString("memberImpl.large.payload"));
        }
        this.payload = byArray != null ? byArray : new byte[]{};
        this.getData(true, true);
    }

    @Override
    public synchronized void setCommand(byte[] byArray) {
        this.command = byArray != null ? byArray : new byte[]{};
        this.getData(true, true);
    }

    public synchronized void setDomain(byte[] byArray) {
        this.domain = byArray != null ? byArray : new byte[]{};
        this.getData(true, true);
    }

    public synchronized void setSecurePort(int n) {
        this.securePort = n;
        this.dataPkg = null;
    }

    public synchronized void setUdpPort(int n) {
        this.udpPort = n;
        this.dataPkg = null;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public void setLocal(boolean bl) {
        this.local = bl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray);
        MemberImpl.getMember(byArray, this);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray = this.getData();
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }
}

