/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.Response;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.res.StringManager;

public class ResponseFacade
implements HttpServletResponse {
    protected static final StringManager sm = StringManager.getManager(ResponseFacade.class);
    protected Response response = null;

    public ResponseFacade(Response response) {
        this.response = response;
    }

    public void clear() {
        this.response = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void finish() {
        this.checkFacade();
        this.response.setSuspended(true);
    }

    public boolean isFinished() {
        this.checkFacade();
        return this.response.isSuspended();
    }

    public long getContentWritten() {
        this.checkFacade();
        return this.response.getContentWritten();
    }

    public String getCharacterEncoding() {
        this.checkFacade();
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return this.response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return this.response.getWriter();
    }

    public void setContentLength(int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(n);
    }

    public void setContentLengthLong(long l) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLengthLong(l);
    }

    public void setContentType(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new SetContentTypePrivilegedAction(string));
        } else {
            this.response.setContentType(string);
        }
    }

    public void setBufferSize(int n) {
        this.checkCommitted("coyoteResponse.setBufferSize.ise");
        this.response.setBufferSize(n);
    }

    public int getBufferSize() {
        this.checkFacade();
        return this.response.getBufferSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flushBuffer() throws IOException {
        if (this.isFinished()) {
            return;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new FlushBufferPrivilegedAction(this.response));
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (!(exception instanceof IOException)) return;
                throw (IOException)exception;
            }
        } else {
            this.response.setAppCommitted(true);
            this.response.flushBuffer();
        }
    }

    public void resetBuffer() {
        this.checkCommitted("coyoteResponse.resetBuffer.ise");
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        this.checkFacade();
        return this.response.isAppCommitted();
    }

    public void reset() {
        this.checkCommitted("coyoteResponse.reset.ise");
        this.response.reset();
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(locale);
    }

    public Locale getLocale() {
        this.checkFacade();
        return this.response.getLocale();
    }

    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addCookie(cookie);
    }

    public boolean containsHeader(String string) {
        this.checkFacade();
        return this.response.containsHeader(string);
    }

    public String encodeURL(String string) {
        this.checkFacade();
        return this.response.encodeURL(string);
    }

    public String encodeRedirectURL(String string) {
        this.checkFacade();
        return this.response.encodeRedirectURL(string);
    }

    public void sendEarlyHints() {
        this.response.sendEarlyHints();
    }

    public String encodeUrl(String string) {
        this.checkFacade();
        return this.response.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        this.checkFacade();
        return this.response.encodeRedirectURL(string);
    }

    public void sendError(int n, String string) throws IOException {
        this.checkCommitted("coyoteResponse.sendError.ise");
        this.response.setAppCommitted(true);
        this.response.sendError(n, string);
    }

    public void sendError(int n) throws IOException {
        this.checkCommitted("coyoteResponse.sendError.ise");
        this.response.setAppCommitted(true);
        this.response.sendError(n);
    }

    public void sendRedirect(String string) throws IOException {
        this.checkCommitted("coyoteResponse.sendRedirect.ise");
        this.response.setAppCommitted(true);
        this.response.sendRedirect(string);
    }

    public void setDateHeader(String string, long l) {
        if (this.isCommitted()) {
            return;
        }
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new DateHeaderPrivilegedAction(string, l, false));
        } else {
            this.response.setDateHeader(string, l);
        }
    }

    public void addDateHeader(String string, long l) {
        if (this.isCommitted()) {
            return;
        }
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new DateHeaderPrivilegedAction(string, l, true));
        } else {
            this.response.addDateHeader(string, l);
        }
    }

    public void setHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(string, n);
    }

    public void addIntHeader(String string, int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(string, n);
    }

    public void setStatus(int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(n);
    }

    public void setStatus(int n, String string) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(n, string);
    }

    public String getContentType() {
        this.checkFacade();
        return this.response.getContentType();
    }

    public void setCharacterEncoding(String string) {
        this.checkFacade();
        this.response.setCharacterEncoding(string);
    }

    public int getStatus() {
        this.checkFacade();
        return this.response.getStatus();
    }

    public String getHeader(String string) {
        this.checkFacade();
        return this.response.getHeader(string);
    }

    public Collection<String> getHeaderNames() {
        this.checkFacade();
        return this.response.getHeaderNames();
    }

    public Collection<String> getHeaders(String string) {
        this.checkFacade();
        return this.response.getHeaders(string);
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.checkFacade();
        this.response.setTrailerFields(supplier);
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        this.checkFacade();
        return this.response.getTrailerFields();
    }

    private void checkFacade() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
    }

    private void checkCommitted(String string) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString(string));
        }
    }

    private final class SetContentTypePrivilegedAction
    implements PrivilegedAction<Void> {
        private final String contentType;

        SetContentTypePrivilegedAction(String string) {
            this.contentType = string;
        }

        @Override
        public Void run() {
            ResponseFacade.this.response.setContentType(this.contentType);
            return null;
        }
    }

    private static class FlushBufferPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private final Response response;

        FlushBufferPrivilegedAction(Response response) {
            this.response = response;
        }

        @Override
        public Void run() throws IOException {
            this.response.setAppCommitted(true);
            this.response.flushBuffer();
            return null;
        }
    }

    private final class DateHeaderPrivilegedAction
    implements PrivilegedAction<Void> {
        private final String name;
        private final long value;
        private final boolean add;

        DateHeaderPrivilegedAction(String string, long l, boolean bl) {
            this.name = string;
            this.value = l;
            this.add = bl;
        }

        @Override
        public Void run() {
            if (this.add) {
                ResponseFacade.this.response.addDateHeader(this.name, this.value);
            } else {
                ResponseFacade.this.response.setDateHeader(this.name, this.value);
            }
            return null;
        }
    }
}

