# Vulnerability Scanning
Trivy detects known vulnerabilities in software components that it finds in the scan target.

The following are supported:

- [OS packages](#os-packages)
- [Language-specific packages](#language-specific-packages)
- [Non-packaged software](#non-packaged-software)
- [Kubernetes components](#kubernetes)

## OS Packages
Trivy is capable of automatically detecting installed OS packages when scanning container images, VM images and running hosts.

!!! note
    Trivy doesn't support third-party/self-compiled packages/binaries, but official packages provided by vendors such as Red Hat and Debian.

### Supported OS
See [here](../coverage/os/index.md#supported-os) for the supported OSes.

### Data Sources

| OS                        | Source                                                       |
|---------------------------|--------------------------------------------------------------|
| Arch Linux                | [Vulnerable Issues][arch]                                    |
| Alpine Linux              | [secdb][alpine]                                              |
| Wolfi Linux               | [secdb][wolfi]                                               |
| Chainguard                | [secdb][chainguard]                                          |
| Amazon Linux              | [Amazon Linux Security Center][amazon]                       |
| Debian                    | [Security Bug Tracker][debian-tracker] / [OVAL][debian-oval] |
| Ubuntu                    | [Ubuntu CVE Tracker][ubuntu]                                 |
| RHEL/CentOS               | [OVAL][rhel-oval] / [Security Data][rhel-api]                |
| AlmaLinux                 | [AlmaLinux Product Errata][alma]                             |
| Rocky Linux               | [Rocky Linux UpdateInfo][rocky]                              |
| Oracle Linux              | [OVAL][oracle]                                               |
| Azure Linux (CBL-Mariner) | [OVAL][azure]                                                |
| OpenSUSE/SLES             | [CVRF][suse]                                                 |
| Photon OS                 | [Photon Security Advisory][photon]                           |

#### Data Source Selection
Trivy **only** consumes security advisories from the sources listed in the above table.

As for packages installed from OS package managers (`dpkg`, `yum`, `apk`, etc.), Trivy uses the advisory database from the appropriate **OS vendor**.

For example: for a python package installed from `yum` (Amazon linux), Trivy will only get advisories from [ALAS][amazon].
But for a python package installed from another source (e.g. `pip`), Trivy will get advisories from the `GitLab` and `GitHub` databases.

This advisory selection is essential to avoid getting false positives because OS vendors usually backport upstream fixes, and the fixed version can be different from the upstream fixed version.

#### Severity Selection
The severity is taken from the selected data source since the severity from vendors is more accurate.
Using CVE-2023-0464 as an example, while it is [rated as "HIGH" in NVD][nvd-CVE-2023-0464], Red Hat has marked its 'Impact' as ["Low"][redhat-CVE-2023-0464].
As a result, Trivy will display it as "Low".

The severity depends on the compile option, the default configuration, etc.
NVD doesn't know how the vendor distributes the software.
Red Hat evaluates the severity more accurately.
That's why Trivy prefers vendor scores over NVD.

If the data source does not provide a severity, the severity is determined based on the CVSS score as follows:

| Base Score Range | Severity |
| ---------------- | -------- |
| 0.1-3.9          | Low      |
| 4.0-6.9          | Medium   |
| 7.0-8.9          | High     |
| 9.0-10.0         | Critical |

If the CVSS score is also not provided, it falls back to [NVD][nvd].

NVD and some vendors may delay severity analysis, while other vendors, such as Red Hat, are able to quickly evaluate and announce the severity of vulnerabilities.
To avoid marking too many vulnerabilities as "UNKNOWN" severity, Trivy uses severity ratings from other vendors when the NVD information is not yet available.
The order of preference for vendor severity data can be found [here](https://github.com/aquasecurity/trivy-db/blob/79d0fbd1e246f3c77eef4b9826fe4bf65940b221/pkg/vulnsrc/vulnerability/vulnerability.go#L17-L19).

You can reference `SeveritySource` in the [JSON reporting format](../configuration/reporting.md#json) to see from where the severity is taken for a given vulnerability.

```shell
"SeveritySource": "debian",
```


In addition, you can see all the vendor severity ratings.

```json
"VendorSeverity": {
  "amazon": 2,
  "cbl-mariner": 4,
  "ghsa": 4,
  "nvd": 4,
  "photon": 4,
  "redhat": 2,
  "ubuntu": 2
}
```

Here is the severity mapping in Trivy:

| Number | Severity |
|:------:|----------|
|   0    | Unknown  |
|   1    | Low      |
|   2    | Medium   |
|   3    | High     |
|   4    | Critical |

If no vendor has a severity, the `UNKNOWN` severity will be used.

### Unfixed Vulnerabilities
The unfixed/unfixable vulnerabilities mean that the patch has not yet been provided on their distribution.
To hide unfixed/unfixable vulnerabilities, you can use the `--ignore-unfixed` flag.

## Language-specific Packages

### Supported Languages
See [here](../coverage/language/index.md#supported-languages) for the supported languages.

### Data Sources

| Language | Source                                              | Commercial Use | Delay[^1] |
|----------|-----------------------------------------------------|:--------------:|:---------:|
| PHP      | [PHP Security Advisories Database][php]             |       ✅        |     -     |
|          | [GitHub Advisory Database (Composer)][php-ghsa]     |       ✅        |     -     |
| Python   | [GitHub Advisory Database (pip)][python-ghsa]       |       ✅        |     -     |
|          | [Open Source Vulnerabilities (PyPI)][python-osv]    |       ✅        |     -     |
| Ruby     | [Ruby Advisory Database][ruby]                      |       ✅        |     -     |
|          | [GitHub Advisory Database (RubyGems)][ruby-ghsa]    |       ✅        |     -     |
| Node.js  | [Ecosystem Security Working Group][nodejs]          |       ✅        |     -     |
|          | [GitHub Advisory Database (npm)][nodejs-ghsa]       |       ✅        |     -     |
| Java     | [GitHub Advisory Database (Maven)][java-ghsa]       |       ✅        |     -     |
| Go       | [GitHub Advisory Database (Go)][go-ghsa]            |       ✅        |     -     |
|          | [Go Vulnerability Database][go-vulndb]              |       ✅        |     -     |
| Rust     | [Open Source Vulnerabilities (crates.io)][rust-osv] |       ✅        |     -     |
| .NET     | [GitHub Advisory Database (NuGet)][dotnet-ghsa]     |       ✅        |     -     |
| C/C++    | [GitLab Advisories Community][gitlab]               |       ✅        |  1 month  |
| Dart     | [GitHub Advisory Database (Pub)][pub-ghsa]          |       ✅        |     -     |
| Elixir   | [GitHub Advisory Database (Erlang)][erlang-ghsa]    |       ✅        |     -     |
| Swift    | [GitHub Advisory Database (Swift)][swift-ghsa]      |       ✅        |     -     |

[^1]: Intentional delay between vulnerability disclosure and registration in the DB

## Non-packaged software

If you have software that is not managed by a package manager, Trivy can still detect vulnerabilities in it in some cases:

- [Using SBOM from Sigstore Rekor](../supply-chain/attestation/rekor/#non-packaged-binaries)
- [Go Binaries with embedded module information](../coverage/language/golang/#go-binaries)
- [Rust Binaries with embedded information](../coverage/language/rust/#binaries)
- [SBOM embedded in container images](../supply-chain/container-image/#sbom-embedded-in-container-images)

## Kubernetes

Trivy can detect vulnerabilities in Kubernetes clusters and components by scanning a Kubernetes Cluster, or a KBOM (Kubernetes bill of Material). To learn more, see the [documentation for Kubernetes scanning](../target/kubernetes.md).

### Data Sources

| Vendor        | Source                                      |
| ------------- |---------------------------------------------|
| Kubernetes    | [Kubernetes Official CVE feed][k8s-cve][^1] |

[^1]: Some manual triage and correction has been made.

## Database
Trivy downloads [the vulnerability database](https://github.com/aquasecurity/trivy-db) every 6 hours.
Trivy uses two types of databases for vulnerability detection:

- Vulnerability Database
- Java Index Database

This page provides detailed information about these databases.

### Vulnerability Database
Trivy utilizes a database containing vulnerability information.
This database is built every six hours on [GitHub](https://github.com/aquasecurity/trivy-db) and is distributed via [GitHub Container registry (GHCR)](https://ghcr.io/aquasecurity/trivy-db).
The database is cached and updated as needed.
As Trivy updates the database automatically during execution, users don't need to be concerned about it.

For CLI flags related to the database, please refer to [this page](../configuration/db.md).

#### Private Hosting
If you host the database on your own OCI registry, you can specify a different repository with the `--db-repository` flag.
The default is `ghcr.io/aquasecurity/trivy-db`.

```shell
$ trivy image --db-repository YOUR_REPO YOUR_IMAGE
```

If authentication is required, it can be configured in the same way as for private images.
Please refer to [the documentation](../advanced/private-registries/index.md) for more details.

### Java Index Database
This database is only downloaded when scanning JAR files so that Trivy can identify the groupId, artifactId, and version of JAR files.
It is built once a day on [GitHub](https://github.com/aquasecurity/trivy-java-db) and distributed via [GitHub Container registry (GHCR)](https://ghcr.io/aquasecurity/trivy-java-db).
Like the vulnerability database, it is automatically downloaded and updated when needed, so users don't need to worry about it.

#### Private Hosting
If you host the database on your own OCI registry, you can specify a different repository with the `--java-db-repository` flag.
The default is `ghcr.io/aquasecurity/trivy-java-db`.

If authentication is required, you need to run `docker login YOUR_REGISTRY`.
Currently, specifying a username and password is not supported.

## Configuration
This section describes vulnerability-specific configuration.
Other common options are documented [here](../configuration/index.md).

### Enabling a Subset of Package Types

It's possible to only enable certain package types if you prefer.
You can do so by passing the `--pkg-types` option.
This flag takes a comma-separated list of package types.

Available values:

- os
    - Scan OS packages managed by the OS package manager (e.g. `dpkg`, `yum`, `apk`).
- library
    - Scan language-specific packages (e.g. packages installed by `pip`, `npm`, or `gem`).

```bash
$ trivy image --pkg-types os ruby:2.4.0
```


<details>
<summary>Result</summary>

```bash
2019-05-22T19:36:50.530+0200    [34mINFO[0m    Updating vulnerability database...
2019-05-22T19:36:51.681+0200    [34mINFO[0m    Detecting Alpine vulnerabilities...
2019-05-22T19:36:51.685+0200    [34mINFO[0m    Updating npm Security DB...
2019-05-22T19:36:52.389+0200    [34mINFO[0m    Detecting npm vulnerabilities...
2019-05-22T19:36:52.390+0200    [34mINFO[0m    Updating pipenv Security DB...
2019-05-22T19:36:53.406+0200    [34mINFO[0m    Detecting pipenv vulnerabilities...

ruby:2.4.0 (debian 8.7)
=======================
Total: 7 (UNKNOWN: 0, LOW: 1, MEDIUM: 1, HIGH: 3, CRITICAL: 2)

+---------+------------------+----------+-------------------+---------------+----------------------------------+
| LIBRARY | VULNERABILITY ID | SEVERITY | INSTALLED VERSION | FIXED VERSION |              TITLE               |
+---------+------------------+----------+-------------------+---------------+----------------------------------+
| curl    | CVE-2018-14618   | CRITICAL | 7.61.0-r0         | 7.61.1-r0     | curl: NTLM password overflow     |
|         |                  |          |                   |               | via integer overflow             |
+         +------------------+----------+                   +---------------+----------------------------------+
|         | CVE-2018-16839   | HIGH     |                   | 7.61.1-r1     | curl: Integer overflow leading   |
|         |                  |          |                   |               | to heap-based buffer overflow in |
|         |                  |          |                   |               | Curl_sasl_create_plain_message() |
+---------+------------------+----------+-------------------+---------------+----------------------------------+
| git     | CVE-2018-17456   | HIGH     | 2.15.2-r0         | 2.15.3-r0     | git: arbitrary code execution    |
|         |                  |          |                   |               | via .gitmodules                  |
+         +------------------+          +                   +               +----------------------------------+
|         | CVE-2018-19486   |          |                   |               | git: Improper handling of        |
|         |                  |          |                   |               | PATH allows for commands to be   |
|         |                  |          |                   |               | executed from...                 |
+---------+------------------+----------+-------------------+---------------+----------------------------------+
| libssh2 | CVE-2019-3855    | CRITICAL | 1.8.0-r2          | 1.8.1-r0      | libssh2: Integer overflow in     |
|         |                  |          |                   |               | transport read resulting in      |
|         |                  |          |                   |               | out of bounds write...           |
+---------+------------------+----------+-------------------+---------------+----------------------------------+
| sqlite  | CVE-2018-20346   | MEDIUM   | 3.21.0-r1         | 3.25.3-r0     | CVE-2018-20505 CVE-2018-20506    |
|         |                  |          |                   |               | sqlite: Multiple flaws in        |
|         |                  |          |                   |               | sqlite which can be triggered    |
|         |                  |          |                   |               | via...                           |
+---------+------------------+----------+-------------------+---------------+----------------------------------+
| tar     | CVE-2018-20482   | LOW      | 1.29-r1           | 1.31-r0       | tar: Infinite read loop in       |
|         |                  |          |                   |               | sparse_dump_region function in   |
|         |                  |          |                   |               | sparse.c                         |
+---------+------------------+----------+-------------------+---------------+----------------------------------+
```

</details>

!!! info
    This flag filters the packages themselves, so it also affects the `--list-all-pkgs` option and SBOM generation.

### Filtering by Package Relationships


Trivy supports filtering vulnerabilities based on the relationship of packages within a project.
This is achieved through the `--pkg-relationships` flag.
This feature allows you to focus on vulnerabilities in specific types of dependencies, such as only those in direct dependencies.

In Trivy, there are four types of package relationships:

1. `root`: The root package being scanned
2. `direct`: Direct dependencies of the root package
3. `indirect`: Transitive dependencies
4. `unknown`: Packages whose relationship cannot be determined

The available relationships may vary depending on the ecosystem.
To see which relationships are supported for a particular project, you can use the JSON output format and check the `Relationship` field:

```
$ trivy repo -f json --list-all-pkgs /path/to/project
```

To scan only the root package and its direct dependencies, you can use the flag as follows:

```
$ trivy repo --pkg-relationships root,direct /path/to/project
```

By default, all relationships are included in the scan.

!!! info
    This flag filters the packages themselves, so it also affects the `--list-all-pkgs` option and SBOM generation.

!!! warning
    As it may not provide a complete package list, `--pkg-relationships` cannot be used with `--dependency-tree`, `--vex` or SBOM generation.


[^1]: https://github.com/GoogleContainerTools/distroless

[nvd-CVE-2023-0464]: https://nvd.nist.gov/vuln/detail/CVE-2023-0464
[redhat-CVE-2023-0464]: https://access.redhat.com/security/cve/cve-2023-0464

[arch]: https://security.archlinux.org/
[alpine]: https://secdb.alpinelinux.org/
[wolfi]: https://packages.wolfi.dev/os/security.json
[chainguard]: https://packages.cgr.dev/chainguard/security.json
[amazon]: https://alas.aws.amazon.com/
[debian-tracker]: https://security-tracker.debian.org/tracker/
[debian-oval]: https://www.debian.org/security/oval/
[ubuntu]: https://ubuntu.com/security/cve
[rhel-oval]: https://www.redhat.com/security/data/oval/v2/
[rhel-api]: https://www.redhat.com/security/data/metrics/
[alma]: https://errata.almalinux.org/
[rocky]: https://download.rockylinux.org/pub/rocky/
[oracle]: https://linux.oracle.com/security/oval/
[suse]: http://ftp.suse.com/pub/projects/security/cvrf/
[photon]: https://packages.vmware.com/photon/photon_cve_metadata/
[azure]: https://github.com/microsoft/AzureLinuxVulnerabilityData/

[php-ghsa]: https://github.com/advisories?query=ecosystem%3Acomposer
[python-ghsa]: https://github.com/advisories?query=ecosystem%3Apip
[ruby-ghsa]: https://github.com/advisories?query=ecosystem%3Arubygems
[nodejs-ghsa]: https://github.com/advisories?query=ecosystem%3Anpm
[java-ghsa]: https://github.com/advisories?query=ecosystem%3Amaven
[dotnet-ghsa]: https://github.com/advisories?query=ecosystem%3Anuget
[pub-ghsa]: https://github.com/advisories?query=ecosystem%3Apub
[erlang-ghsa]: https://github.com/advisories?query=ecosystem%3Aerlang
[go-ghsa]: https://github.com/advisories?query=ecosystem%3Ago
[swift-ghsa]: https://github.com/advisories?query=ecosystem%3Aswift

[go-vulndb]: https://pkg.go.dev/vuln/
[php]: https://github.com/FriendsOfPHP/security-advisories
[ruby]: https://github.com/rubysec/ruby-advisory-db
[nodejs]: https://github.com/nodejs/security-wg
[gitlab]: https://gitlab.com/gitlab-org/advisories-community

[python-osv]: https://osv.dev/list?q=&ecosystem=PyPI
[rust-osv]: https://osv.dev/list?q=&ecosystem=crates.io

[nvd]: https://nvd.nist.gov/vuln

[k8s-cve]: https://kubernetes.io/docs/reference/issues-security/official-cve-feed/
