import type ts from 'typescript/lib/tsserverlibrary';
import { ConfigManager } from './config-manager';
import { Logger } from './logger';
import { SourceMapper } from './source-mapper';
export declare class SvelteSnapshot {
    private typescript;
    private fileName;
    private svelteCode;
    private mapper;
    private logger;
    readonly isTsFile: boolean;
    private scriptInfo?;
    private lineOffsets?;
    private convertInternalCodePositions;
    constructor(typescript: typeof ts, fileName: string, svelteCode: string, mapper: SourceMapper, logger: Logger, isTsFile: boolean);
    update(svelteCode: string, mapper: SourceMapper): void;
    getOriginalTextSpan(textSpan: ts.TextSpan): ts.TextSpan | null;
    getOriginalOffset(generatedOffset: number): number;
    getGeneratedTextSpan(textSpan: ts.TextSpan): ts.TextSpan | null;
    getGeneratedOffset(originalOffset: number): number;
    setAndPatchScriptInfo(scriptInfo: ts.server.ScriptInfo): void;
    /**
     * Get the line and character based on the offset
     * @param offset The index of the position
     */
    positionAt(offset: number): ts.LineAndCharacter;
    /**
     * Get the index of the line and character position
     * @param position Line and character position
     */
    offsetAt(position: ts.LineAndCharacter): number;
    private getLineOffsets;
    private clamp;
    private log;
    private debug;
    private toggleMappingMode;
    getText(): string;
    getOriginalText(): string;
}
export declare class SvelteSnapshotManager {
    private typescript;
    private projectService;
    private svelteOptions;
    private logger;
    private configManager;
    /** undefined if no node_modules with Svelte next to tsconfig.json */
    private svelteCompiler;
    private snapshots;
    constructor(typescript: typeof ts, projectService: ts.server.ProjectService, svelteOptions: {
        namespace: string;
    }, logger: Logger, configManager: ConfigManager, 
    /** undefined if no node_modules with Svelte next to tsconfig.json */
    svelteCompiler: typeof import('svelte/compiler') | undefined);
    get(fileName: string): SvelteSnapshot | undefined;
    create(fileName: string): SvelteSnapshot | undefined;
    private patchProjectServiceReadFile;
}
