# Privacy Policy

It should go without saying, but Vector takes the privacy of your data,
including how you use Vector, very seriously. Vector collects and routes some
of your most sensitive data, and therefore, Vector strives to be as transparent
as possible with our privacy efforts. This document clarifies how the Vector
project thinks about privacy now and in the future.

- [Vector Itself](#vector-itself)
  - [Downloads](#downloads)
  - [Phoning Home](#phoning-home)
- [Vector Website & Docs](#vector-website--docs)
- [Vector Community](#vector-community)
  - [Vector Repository](#vector-repository)
  - [Vector Chat](#vector-chat)

## Vector Itself

### Downloads

Vector uses AWS S3, GitHub assets, and Docker Hub to host release artifacts.
Vector does track download counts in aggregate. For GitHub, and Docker this data
is anonymous, but for AWS S3 IP addresses are logged. There is no way to disable
IP address tracking within the AWS S3 logs. If you are concerned about sharing
your IP address we recommend using a proxy, or downloading Vector from
a different channel.

### Phoning Home

Vector will not "phone home" or communicate with an external service that you
did not explicitly configure. This includes grey-area tactics such as version
checks, capturing diagnostic information, and sharing crash reports.

## Vector Website & Docs

The Vector website does collect various analytics. Aggregated analytics data is
derived from backend server logs which are anonymized. Vector uses
[Netlify analytics][netlify_analytics] for this.

## Vector Community

### Vector Repository

The Vector repository is hosted on GitHub. You can review their privacy policy
[here][github_pp]. Additionally, Vector will not attempt to mine information
about users that interact with Vector on GitHub. Vector team members will
occasionally reach out to active users offer help debugging or learn about
ways Vector can improve.

### Vector Chat

The Vector chat uses Discord; you can review their
privacy policy [here][discord_pp].

[github_pp]: https://help.github.com/en/github/site-policy/github-privacy-statement
[discord_pp]: https://discord.com/privacy/
[netlify_analytics]: https://www.netlify.com/products/analytics/
[vero_pp]: https://www.getvero.com/privacy/
