"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initialize = initialize;
const node_1 = require("@volar/language-server/node");
const language_core_1 = require("@vue/language-core");
const language_service_1 = require("@vue/language-service");
function initialize(server, params, ts, tsLocalized) {
    const watchingExtensions = new Set();
    let fileWatcher;
    return server.initialize(params, (0, node_1.createTypeScriptProject)(ts, tsLocalized, async ({ configFileName, sys, projectHost, uriConverter }) => {
        let compilerOptions;
        let vueCompilerOptions;
        if (configFileName) {
            let commandLine = (0, language_core_1.createParsedCommandLine)(ts, sys, configFileName);
            let sysVersion = sys.version;
            let newSysVersion = await sys.sync();
            while (sysVersion !== newSysVersion) {
                commandLine = (0, language_core_1.createParsedCommandLine)(ts, sys, configFileName);
                sysVersion = newSysVersion;
                newSysVersion = await sys.sync();
            }
            compilerOptions = commandLine.options;
            vueCompilerOptions = commandLine.vueOptions;
        }
        else {
            compilerOptions = ts.getDefaultCompilerOptions();
            vueCompilerOptions = (0, language_core_1.resolveVueCompilerOptions)({});
        }
        updateFileWatcher(vueCompilerOptions);
        return {
            languagePlugins: [(0, language_core_1.createVueLanguagePlugin)(ts, s => uriConverter.asFileName(s), () => projectHost.getProjectVersion?.() ?? '', fileName => {
                    const fileMap = new language_core_1.FileMap(sys.useCaseSensitiveFileNames ?? false);
                    for (const vueFileName of projectHost.getScriptFileNames() ?? []) {
                        fileMap.set(vueFileName, undefined);
                    }
                    return fileMap.has(fileName);
                }, compilerOptions, vueCompilerOptions)],
            setup({ project }) {
                project.vue = { compilerOptions: vueCompilerOptions };
            },
        };
    }), (0, language_service_1.getFullLanguageServicePlugins)(ts));
    function updateFileWatcher(vueCompilerOptions) {
        const extensions = [
            'js', 'cjs', 'mjs', 'ts', 'cts', 'mts', 'jsx', 'tsx', 'json',
            ...vueCompilerOptions.extensions.map(ext => ext.slice(1)),
            ...vueCompilerOptions.vitePressExtensions.map(ext => ext.slice(1)),
            ...vueCompilerOptions.petiteVueExtensions.map(ext => ext.slice(1)),
        ];
        const newExtensions = extensions.filter(ext => !watchingExtensions.has(ext));
        if (newExtensions.length) {
            for (const ext of newExtensions) {
                watchingExtensions.add(ext);
            }
            fileWatcher?.then(dispose => dispose.dispose());
            fileWatcher = server.watchFiles(['**/*.{' + [...watchingExtensions].join(',') + '}']);
        }
    }
}
//# sourceMappingURL=initialize.js.map