"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fs = void 0;
exports.createConnection = createConnection;
exports.createServer = createServer;
exports.loadTsdkByPath = loadTsdkByPath;
const language_service_1 = require("@volar/language-service");
const _fs = require("fs");
const vscode = require("vscode-languageserver/node");
const http_1 = require("./lib/schemaRequestHandlers/http");
const server_1 = require("./lib/server");
__exportStar(require("vscode-languageserver/node"), exports);
__exportStar(require("./index"), exports);
__exportStar(require("./lib/project/simpleProject"), exports);
__exportStar(require("./lib/project/typescriptProject"), exports);
__exportStar(require("./lib/server"), exports);
function createConnection() {
    return vscode.createConnection(vscode.ProposedFeatures.all);
}
function createServer(connection) {
    return (0, server_1.createServerBase)(connection, exports.fs);
}
exports.fs = {
    stat(uri) {
        if (uri.scheme === 'file') {
            try {
                const stats = _fs.statSync(uri.fsPath, { throwIfNoEntry: false });
                if (stats) {
                    return {
                        type: stats.isFile() ? language_service_1.FileType.File
                            : stats.isDirectory() ? language_service_1.FileType.Directory
                                : stats.isSymbolicLink() ? language_service_1.FileType.SymbolicLink
                                    : language_service_1.FileType.Unknown,
                        ctime: stats.ctimeMs,
                        mtime: stats.mtimeMs,
                        size: stats.size,
                    };
                }
            }
            catch {
                return undefined;
            }
        }
    },
    readFile(uri, encoding) {
        if (uri.scheme === 'file') {
            try {
                return _fs.readFileSync(uri.fsPath, { encoding: encoding ?? 'utf-8' });
            }
            catch {
                return undefined;
            }
        }
        if (uri.scheme === 'http' || uri.scheme === 'https') {
            return (0, http_1.default)(uri);
        }
    },
    readDirectory(uri) {
        if (uri.scheme === 'file') {
            try {
                const files = _fs.readdirSync(uri.fsPath, { withFileTypes: true });
                return files.map(file => {
                    return [file.name, file.isFile() ? language_service_1.FileType.File
                            : file.isDirectory() ? language_service_1.FileType.Directory
                                : file.isSymbolicLink() ? language_service_1.FileType.SymbolicLink
                                    : language_service_1.FileType.Unknown];
                });
            }
            catch {
                return [];
            }
        }
        return [];
    },
};
function loadTsdkByPath(tsdk, locale) {
    locale = locale?.toLowerCase();
    // webpack compatibility
    const _require = eval('require');
    return {
        typescript: loadLib(),
        diagnosticMessages: loadLocalizedDiagnosticMessages(),
    };
    function loadLib() {
        for (const name of ['./typescript.js', './tsserverlibrary.js']) {
            try {
                return _require(_require.resolve(name, { paths: [tsdk] }));
            }
            catch { }
        }
        // for bun
        for (const name of ['typescript.js', 'tsserverlibrary.js']) {
            try {
                return _require(tsdk + '/' + name);
            }
            catch { }
        }
        throw new Error(`Can't find typescript.js or tsserverlibrary.js in ${JSON.stringify(tsdk)}`);
    }
    function loadLocalizedDiagnosticMessages() {
        if (locale === 'en') {
            return;
        }
        try {
            const path = _require.resolve(`./${locale}/diagnosticMessages.generated.json`, { paths: [tsdk] });
            return _require(path);
        }
        catch { }
    }
}
//# sourceMappingURL=node.js.map