"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = register;
const cancellation_1 = require("../utils/cancellation");
function register(context) {
    return async (symbol, token = cancellation_1.NoneCancellationToken) => {
        const data = symbol.data;
        if (data) {
            const plugin = context.plugins[data.pluginIndex];
            if (!plugin[1].resolveWorkspaceSymbol) {
                return symbol;
            }
            Object.assign(symbol, data.original);
            symbol = await plugin[1].resolveWorkspaceSymbol(symbol, token);
        }
        return symbol;
    };
}
//# sourceMappingURL=resolveWorkspaceSymbol.js.map