// src/workers/kv/assets.worker.ts
import { SharedBindings } from "miniflare:shared";

// src/workers/kv/constants.ts
import { testRegExps } from "miniflare:shared";
var KVLimits = {
  MIN_CACHE_TTL: 60,
  MAX_LIST_KEYS: 1e3,
  MAX_KEY_SIZE: 512,
  MAX_VALUE_SIZE: 25 * 1024 * 1024,
  MAX_VALUE_SIZE_TEST: 1024,
  MAX_METADATA_SIZE: 1024
}, KVParams = {
  URL_ENCODED: "urlencoded",
  CACHE_TTL: "cache_ttl",
  EXPIRATION: "expiration",
  EXPIRATION_TTL: "expiration_ttl",
  LIST_LIMIT: "key_count_limit",
  LIST_PREFIX: "prefix",
  LIST_CURSOR: "cursor"
};

// src/workers/kv/assets.worker.ts
var assets_worker_default = {
  async fetch(request, env) {
    if (request.method !== "GET") {
      let message = `Cannot ${request.method.toLowerCase()}() with Workers Assets namespace`;
      return new Response(message, { status: 405, statusText: message });
    }
    let url = new URL(request.url), key = url.pathname.substring(1);
    url.searchParams.get(KVParams.URL_ENCODED)?.toLowerCase() === "true" && (key = decodeURIComponent(key));
    let blobsService = env[SharedBindings.MAYBE_SERVICE_BLOBS];
    return key === "" || key === "/" ? new Response("Not Found", {
      status: 404
    }) : blobsService.fetch(new URL(key, "http://placeholder"));
  }
};
export {
  assets_worker_default as default
};
//# sourceMappingURL=assets.worker.js.map
