"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.triggerAsyncId = exports.executionAsyncResource = exports.executionAsyncId = exports.createHook = exports.asyncWrapProviders = exports.AsyncHook = void 0;
class _AsyncHook {
  __unenv__ = true;
  _enabled = false;
  _callbacks = {};
  constructor(callbacks = {}) {
    this._callbacks = callbacks;
  }
  enable() {
    this._enabled = true;
    return this;
  }
  disable() {
    this._enabled = false;
    return this;
  }
  init(asyncId, type, triggerAsyncId2, resource) {
    if (this._enabled && this._callbacks.init) {
      this._callbacks.init(asyncId, type, triggerAsyncId2, resource);
    }
  }
  before(asyncId) {
    if (this._enabled && this._callbacks.before) {
      this._callbacks.before(asyncId);
    }
  }
  after(asyncId) {
    if (this._enabled && this._callbacks.after) {
      this._callbacks.after(asyncId);
    }
  }
  destroy(asyncId) {
    if (this._enabled && this._callbacks.destroy) {
      this._callbacks.destroy(asyncId);
    }
  }
  promiseResolve(asyncId) {
    if (this._enabled && this._callbacks.promiseResolve) {
      this._callbacks.promiseResolve(asyncId);
    }
  }
}
const AsyncHook = exports.AsyncHook = globalThis.AsyncHook || _AsyncHook;
const createHook = exports.createHook = function createHook2(callbacks) {
  const asyncHook = new _AsyncHook(callbacks);
  return asyncHook;
};
const executionAsyncId = exports.executionAsyncId = function executionAsyncId2() {
  return 0;
};
const executionAsyncResource = function () {
  return /* @__PURE__ */Object.create(null);
};
exports.executionAsyncResource = executionAsyncResource;
const triggerAsyncId = function () {
  return 0;
};
exports.triggerAsyncId = triggerAsyncId;
const asyncWrapProviders = exports.asyncWrapProviders = Object.assign( /* @__PURE__ */Object.create(null), {
  NONE: 0,
  DIRHANDLE: 1,
  DNSCHANNEL: 2,
  ELDHISTOGRAM: 3,
  FILEHANDLE: 4,
  FILEHANDLECLOSEREQ: 5,
  BLOBREADER: 6,
  FSEVENTWRAP: 7,
  FSREQCALLBACK: 8,
  FSREQPROMISE: 9,
  GETADDRINFOREQWRAP: 10,
  GETNAMEINFOREQWRAP: 11,
  HEAPSNAPSHOT: 12,
  HTTP2SESSION: 13,
  HTTP2STREAM: 14,
  HTTP2PING: 15,
  HTTP2SETTINGS: 16,
  HTTPINCOMINGMESSAGE: 17,
  HTTPCLIENTREQUEST: 18,
  JSSTREAM: 19,
  JSUDPWRAP: 20,
  MESSAGEPORT: 21,
  PIPECONNECTWRAP: 22,
  PIPESERVERWRAP: 23,
  PIPEWRAP: 24,
  PROCESSWRAP: 25,
  PROMISE: 26,
  QUERYWRAP: 27,
  QUIC_ENDPOINT: 28,
  QUIC_LOGSTREAM: 29,
  QUIC_PACKET: 30,
  QUIC_SESSION: 31,
  QUIC_STREAM: 32,
  QUIC_UDP: 33,
  SHUTDOWNWRAP: 34,
  SIGNALWRAP: 35,
  STATWATCHER: 36,
  STREAMPIPE: 37,
  TCPCONNECTWRAP: 38,
  TCPSERVERWRAP: 39,
  TCPWRAP: 40,
  TTYWRAP: 41,
  UDPSENDWRAP: 42,
  UDPWRAP: 43,
  SIGINTWATCHDOG: 44,
  WORKER: 45,
  WORKERHEAPSNAPSHOT: 46,
  WRITEWRAP: 47,
  ZLIB: 48,
  CHECKPRIMEREQUEST: 49,
  PBKDF2REQUEST: 50,
  KEYPAIRGENREQUEST: 51,
  KEYGENREQUEST: 52,
  KEYEXPORTREQUEST: 53,
  CIPHERREQUEST: 54,
  DERIVEBITSREQUEST: 55,
  HASHREQUEST: 56,
  RANDOMBYTESREQUEST: 57,
  RANDOMPRIMEREQUEST: 58,
  SCRYPTREQUEST: 59,
  SIGNREQUEST: 60,
  TLSWRAP: 61,
  VERIFYREQUEST: 62
});