"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Certificate", {
  enumerable: true,
  get: function () {
    return _index.Certificate;
  }
});
Object.defineProperty(exports, "Cipher", {
  enumerable: true,
  get: function () {
    return _index.Cipher;
  }
});
Object.defineProperty(exports, "Cipheriv", {
  enumerable: true,
  get: function () {
    return _index.Cipheriv;
  }
});
Object.defineProperty(exports, "Decipher", {
  enumerable: true,
  get: function () {
    return _index.Decipher;
  }
});
Object.defineProperty(exports, "Decipheriv", {
  enumerable: true,
  get: function () {
    return _index.Decipheriv;
  }
});
exports.DiffieHellmanGroup = exports.DiffieHellman = void 0;
Object.defineProperty(exports, "ECDH", {
  enumerable: true,
  get: function () {
    return _index.ECDH;
  }
});
exports.KeyObject = exports.Hmac = exports.Hash = void 0;
Object.defineProperty(exports, "Sign", {
  enumerable: true,
  get: function () {
    return _index.Sign;
  }
});
Object.defineProperty(exports, "Verify", {
  enumerable: true,
  get: function () {
    return _index.Verify;
  }
});
Object.defineProperty(exports, "X509Certificate", {
  enumerable: true,
  get: function () {
    return _index.X509Certificate;
  }
});
exports.checkPrimeSync = exports.checkPrime = void 0;
Object.defineProperty(exports, "constants", {
  enumerable: true,
  get: function () {
    return _index.constants;
  }
});
Object.defineProperty(exports, "createCipheriv", {
  enumerable: true,
  get: function () {
    return _index.createCipheriv;
  }
});
Object.defineProperty(exports, "createDecipheriv", {
  enumerable: true,
  get: function () {
    return _index.createDecipheriv;
  }
});
exports.createDiffieHellmanGroup = exports.createDiffieHellman = void 0;
Object.defineProperty(exports, "createECDH", {
  enumerable: true,
  get: function () {
    return _index.createECDH;
  }
});
exports.createSecretKey = exports.createPublicKey = exports.createPrivateKey = exports.createHmac = exports.createHash = void 0;
Object.defineProperty(exports, "createSign", {
  enumerable: true,
  get: function () {
    return _index.createSign;
  }
});
Object.defineProperty(exports, "createVerify", {
  enumerable: true,
  get: function () {
    return _index.createVerify;
  }
});

Object.defineProperty(exports, "diffieHellman", {
  enumerable: true,
  get: function () {
    return _index.diffieHellman;
  }
});
exports.generatePrimeSync = exports.generatePrime = exports.generateKeySync = exports.generateKeyPairSync = exports.generateKeyPair = exports.generateKey = void 0;
Object.defineProperty(exports, "getCipherInfo", {
  enumerable: true,
  get: function () {
    return _index.getCipherInfo;
  }
});
exports.getRandomValues = exports.getHashes = exports.getFips = exports.getDiffieHellman = exports.getCurves = exports.getCiphers = void 0;
Object.defineProperty(exports, "hash", {
  enumerable: true,
  get: function () {
    return _index.hash;
  }
});
exports.pbkdf2Sync = exports.pbkdf2 = exports.hkdfSync = exports.hkdf = void 0;
Object.defineProperty(exports, "privateDecrypt", {
  enumerable: true,
  get: function () {
    return _index.privateDecrypt;
  }
});
Object.defineProperty(exports, "privateEncrypt", {
  enumerable: true,
  get: function () {
    return _index.privateEncrypt;
  }
});
Object.defineProperty(exports, "publicDecrypt", {
  enumerable: true,
  get: function () {
    return _index.publicDecrypt;
  }
});
Object.defineProperty(exports, "publicEncrypt", {
  enumerable: true,
  get: function () {
    return _index.publicEncrypt;
  }
});
exports.randomUUID = exports.randomInt = exports.randomFillSync = exports.randomFill = exports.randomBytes = void 0;
Object.defineProperty(exports, "scrypt", {
  enumerable: true,
  get: function () {
    return _index.scrypt;
  }
});
Object.defineProperty(exports, "scryptSync", {
  enumerable: true,
  get: function () {
    return _index.scryptSync;
  }
});
exports.setFips = exports.setEngine = exports.secureHeapUsed = void 0;
Object.defineProperty(exports, "sign", {
  enumerable: true,
  get: function () {
    return _index.sign;
  }
});
exports.timingSafeEqual = exports.subtle = void 0;
Object.defineProperty(exports, "verify", {
  enumerable: true,
  get: function () {
    return _index.verify;
  }
});
exports.webcrypto = void 0;
var _index = require("./index.cjs");
const workerdCrypto = process.getBuiltinModule("node:crypto");
const {
  DiffieHellman,
  DiffieHellmanGroup,
  Hash,
  Hmac,
  KeyObject,
  checkPrime,
  checkPrimeSync,
  createDiffieHellman,
  createDiffieHellmanGroup,
  createHash,
  createHmac,
  createPrivateKey,
  createPublicKey,
  createSecretKey,
  generateKey,
  generateKeyPair,
  generateKeyPairSync,
  generateKeySync,
  generatePrime,
  generatePrimeSync,
  getCiphers,
  getCurves,
  getDiffieHellman,
  getFips,
  getHashes,
  getRandomValues,
  hkdf,
  hkdfSync,
  pbkdf2,
  pbkdf2Sync,
  randomBytes,
  randomFill,
  randomFillSync,
  randomInt,
  randomUUID,
  secureHeapUsed,
  setEngine,
  setFips,
  subtle,
  timingSafeEqual
} = workerdCrypto;
exports.timingSafeEqual = timingSafeEqual;
exports.subtle = subtle;
exports.setFips = setFips;
exports.setEngine = setEngine;
exports.secureHeapUsed = secureHeapUsed;
exports.randomUUID = randomUUID;
exports.randomInt = randomInt;
exports.randomFillSync = randomFillSync;
exports.randomFill = randomFill;
exports.randomBytes = randomBytes;
exports.pbkdf2Sync = pbkdf2Sync;
exports.pbkdf2 = pbkdf2;
exports.hkdfSync = hkdfSync;
exports.hkdf = hkdf;
exports.getRandomValues = getRandomValues;
exports.getHashes = getHashes;
exports.getFips = getFips;
exports.getDiffieHellman = getDiffieHellman;
exports.getCurves = getCurves;
exports.getCiphers = getCiphers;
exports.generatePrimeSync = generatePrimeSync;
exports.generatePrime = generatePrime;
exports.generateKeySync = generateKeySync;
exports.generateKeyPairSync = generateKeyPairSync;
exports.generateKeyPair = generateKeyPair;
exports.generateKey = generateKey;
exports.createSecretKey = createSecretKey;
exports.createPublicKey = createPublicKey;
exports.createPrivateKey = createPrivateKey;
exports.createHmac = createHmac;
exports.createHash = createHash;
exports.createDiffieHellmanGroup = createDiffieHellmanGroup;
exports.createDiffieHellman = createDiffieHellman;
exports.checkPrimeSync = checkPrimeSync;
exports.checkPrime = checkPrime;
exports.KeyObject = KeyObject;
exports.Hmac = Hmac;
exports.Hash = Hash;
exports.DiffieHellmanGroup = DiffieHellmanGroup;
exports.DiffieHellman = DiffieHellman;
const webcrypto = exports.webcrypto = {
  CryptoKey: _index.webcrypto.CryptoKey,
  getRandomValues: workerdCrypto.webcrypto.getRandomValues,
  randomUUID: workerdCrypto.webcrypto.randomUUID,
  subtle: workerdCrypto.webcrypto.subtle
};
const {
  fips
} = workerdCrypto;
module.exports = {
  /**
   * manually unroll unenv-polyfilled-symbols to make it tree-shakeable
   */
  Certificate: _index.Certificate,
  Cipher: _index.Cipher,
  // @ts-expect-error undocumented public API
  Cipheriv: _index.Cipheriv,
  Decipher: _index.Decipher,
  Decipheriv: _index.Decipheriv,
  ECDH: _index.ECDH,
  Sign: _index.Sign,
  Verify: _index.Verify,
  X509Certificate: _index.X509Certificate,
  constants: _index.constants,
  createCipheriv: _index.createCipheriv,
  createDecipheriv: _index.createDecipheriv,
  createECDH: _index.createECDH,
  createSign: _index.createSign,
  createVerify: _index.createVerify,
  diffieHellman: _index.diffieHellman,
  getCipherInfo: _index.getCipherInfo,
  hash: _index.hash,
  privateDecrypt: _index.privateDecrypt,
  privateEncrypt: _index.privateEncrypt,
  publicDecrypt: _index.publicDecrypt,
  publicEncrypt: _index.publicEncrypt,
  scrypt: _index.scrypt,
  scryptSync: _index.scryptSync,
  sign: _index.sign,
  verify: _index.verify,
  // default-only export from unenv
  createCipher: _index.createCipher,
  createDecipher: _index.createDecipher,
  pseudoRandomBytes: _index.pseudoRandomBytes,
  /**
   * manually unroll workerd-polyfilled-symbols to make it tree-shakeable
   */
  DiffieHellman,
  DiffieHellmanGroup,
  Hash,
  Hmac,
  KeyObject,
  checkPrime,
  checkPrimeSync,
  createDiffieHellman,
  createDiffieHellmanGroup,
  createHash,
  createHmac,
  createPrivateKey,
  createPublicKey,
  createSecretKey,
  generateKey,
  generateKeyPair,
  generateKeyPairSync,
  generateKeySync,
  generatePrime,
  generatePrimeSync,
  getCiphers,
  getCurves,
  getDiffieHellman,
  getFips,
  getHashes,
  getRandomValues,
  hkdf,
  hkdfSync,
  pbkdf2,
  pbkdf2Sync,
  randomBytes,
  randomFill,
  randomFillSync,
  randomInt,
  randomUUID,
  secureHeapUsed,
  setEngine,
  setFips,
  subtle,
  timingSafeEqual,
  // default-only export from workerd
  fips,
  // special-cased deep merged symbols
  webcrypto
};