"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChannels = exports.Channel = void 0;
var _utils = require("../../../_internal/utils.cjs");
const channels = {};
const getChannels = () => channels;
exports.getChannels = getChannels;
class Channel {
  __unenv__ = true;
  name;
  get hasSubscribers() {
    return this._subscribers.length > 0;
  }
  _subscribers;
  constructor(name) {
    this.name = name;
    this._subscribers = [];
    const channels2 = getChannels();
    channels2[name] = this;
  }
  subscribe(onMessage) {
    this._subscribers.push(onMessage);
  }
  unsubscribe(onMessage) {
    const index = this._subscribers.indexOf(onMessage);
    if (index === -1) return false;
    this._subscribers.splice(index, 1);
    return true;
  }
  publish(message) {
    for (const subscriber of this._subscribers) {
      subscriber(message, this.name);
    }
  }
  bindStore() {
    throw (0, _utils.createNotImplementedError)("Channel.bindStore");
  }
  unbindStore() {
    throw (0, _utils.createNotImplementedError)("Channel.unbindStore");
  }
  runStores() {
    throw (0, _utils.createNotImplementedError)("Channel.runStores");
  }
}
exports.Channel = Channel;