"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  Resolver: true,
  getDefaultResultOrder: true,
  getServers: true,
  lookup: true,
  lookupService: true,
  resolve: true,
  resolve4: true,
  resolve6: true,
  resolveAny: true,
  resolveCaa: true,
  resolveCname: true,
  resolveMx: true,
  resolveNaptr: true,
  resolveNs: true,
  resolvePtr: true,
  resolveSoa: true,
  resolveSrv: true,
  resolveTxt: true,
  reverse: true,
  setDefaultResultOrder: true,
  setServers: true
};
exports.setServers = exports.setDefaultResultOrder = exports.reverse = exports.resolveTxt = exports.resolveSrv = exports.resolveSoa = exports.resolvePtr = exports.resolveNs = exports.resolveNaptr = exports.resolveMx = exports.resolveCname = exports.resolveCaa = exports.resolveAny = exports.resolve6 = exports.resolve4 = exports.resolve = exports.lookupService = exports.lookup = exports.getServers = exports.getDefaultResultOrder = exports.default = exports.Resolver = void 0;
var _noop = _interopRequireDefault(require("../../../mock/noop.cjs"));
var _proxy = _interopRequireDefault(require("../../../mock/proxy.cjs"));
var _utils = require("../../../_internal/utils.cjs");
var constants = _interopRequireWildcard(require("../internal/constants.cjs"));
Object.keys(constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === constants[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return constants[key];
    }
  });
});
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const Resolver = exports.Resolver = _proxy.default.__createMock__("dns.Resolver");
const getDefaultResultOrder = () => "verbatim";
exports.getDefaultResultOrder = getDefaultResultOrder;
const getServers = () => [];
exports.getServers = getServers;
const lookup = exports.lookup = (0, _utils.notImplementedAsync)("dns.lookup");
const lookupService = exports.lookupService = (0, _utils.notImplementedAsync)("dns.lookupService");
const resolve = exports.resolve = (0, _utils.notImplementedAsync)("dns.resolve");
const resolve4 = exports.resolve4 = (0, _utils.notImplementedAsync)("dns.resolve4");
const resolve6 = exports.resolve6 = (0, _utils.notImplementedAsync)("dns.resolve6");
const resolveAny = exports.resolveAny = (0, _utils.notImplementedAsync)("dns.resolveAny");
const resolveCaa = exports.resolveCaa = (0, _utils.notImplementedAsync)("dns.resolveCaa");
const resolveCname = exports.resolveCname = (0, _utils.notImplementedAsync)("dns.resolveCname");
const resolveMx = exports.resolveMx = (0, _utils.notImplementedAsync)("dns.resolveMx");
const resolveNaptr = exports.resolveNaptr = (0, _utils.notImplementedAsync)("dns.resolveNaptr");
const resolveNs = exports.resolveNs = (0, _utils.notImplementedAsync)("dns.resolveNs");
const resolvePtr = exports.resolvePtr = (0, _utils.notImplementedAsync)("dns.resolvePtr");
const resolveSoa = exports.resolveSoa = (0, _utils.notImplementedAsync)("dns.resolveSoa");
const resolveSrv = exports.resolveSrv = (0, _utils.notImplementedAsync)("dns.resolveSrv");
const resolveTxt = exports.resolveTxt = (0, _utils.notImplementedAsync)("dns.resolveTxt");
const reverse = exports.reverse = (0, _utils.notImplemented)("dns.reverse");
const setDefaultResultOrder = exports.setDefaultResultOrder = _noop.default;
const setServers = exports.setServers = _noop.default;
module.exports = {
  ...constants,
  Resolver,
  getDefaultResultOrder,
  getServers,
  lookup,
  lookupService,
  resolve,
  resolve4,
  resolve6,
  resolveAny,
  resolveCaa,
  resolveCname,
  resolveMx,
  resolveNaptr,
  resolveNs,
  resolvePtr,
  resolveSoa,
  resolveSrv,
  resolveTxt,
  reverse,
  setDefaultResultOrder,
  setServers
};