"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writevSync = exports.writev = exports.writeSync = exports.writeFileSync = exports.writeFile = exports.write = exports.watchFile = exports.watch = exports.utimesSync = exports.utimes = exports.unwatchFile = exports.unlinkSync = exports.unlink = exports.truncateSync = exports.truncate = exports.symlinkSync = exports.symlink = exports.statfsSync = exports.statfs = exports.statSync = exports.stat = exports.rmdirSync = exports.rmdir = exports.rmSync = exports.rm = exports.renameSync = exports.rename = exports.realpathSync = exports.realpath = exports.readvSync = exports.readv = exports.readlinkSync = exports.readlink = exports.readdirSync = exports.readdir = exports.readSync = exports.readFileSync = exports.readFile = exports.read = exports.opendirSync = exports.opendir = exports.openSync = exports.openAsBlob = exports.open = exports.mkdtempSync = exports.mkdtemp = exports.mkdirSync = exports.mkdir = exports.lutimesSync = exports.lutimes = exports.lstatSync = exports.lstat = exports.linkSync = exports.link = exports.lchownSync = exports.lchown = exports.lchmodSync = exports.lchmod = exports.futimesSync = exports.futimes = exports.ftruncateSync = exports.ftruncate = exports.fsyncSync = exports.fsync = exports.fstatSync = exports.fstat = exports.fdatasyncSync = exports.fdatasync = exports.fchownSync = exports.fchown = exports.fchmodSync = exports.fchmod = exports.existsSync = exports.exists = exports.createWriteStream = exports.createReadStream = exports.cpSync = exports.cp = exports.copyFileSync = exports.copyFile = exports.closeSync = exports.close = exports.chownSync = exports.chown = exports.chmodSync = exports.chmod = exports.appendFileSync = exports.appendFile = exports.accessSync = exports.access = exports._toUnixTimestamp = void 0;
var _utils = require("../../../_internal/utils.cjs");
var fsp = _interopRequireWildcard(require("./promises.cjs"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function callbackify(fn) {
  const fnc = function (...args) {
    const cb = args.pop();
    fn().catch(error => cb(error)).then(val => cb(void 0, val));
  };
  fnc.__promisify__ = fn;
  fnc.native = fnc;
  return fnc;
}
const access = exports.access = callbackify(fsp.access);
const appendFile = exports.appendFile = callbackify(fsp.appendFile);
const chown = exports.chown = callbackify(fsp.chown);
const chmod = exports.chmod = callbackify(fsp.chmod);
const copyFile = exports.copyFile = callbackify(fsp.copyFile);
const cp = exports.cp = callbackify(fsp.cp);
const lchown = exports.lchown = callbackify(fsp.lchown);
const lchmod = exports.lchmod = callbackify(fsp.lchmod);
const link = exports.link = callbackify(fsp.link);
const lstat = exports.lstat = callbackify(fsp.lstat);
const lutimes = exports.lutimes = callbackify(fsp.lutimes);
const mkdir = exports.mkdir = callbackify(fsp.mkdir);
const mkdtemp = exports.mkdtemp = callbackify(fsp.mkdtemp);
const realpath = exports.realpath = callbackify(fsp.realpath);
const open = exports.open = callbackify(fsp.open);
const opendir = exports.opendir = callbackify(fsp.opendir);
const readdir = exports.readdir = callbackify(fsp.readdir);
const readFile = exports.readFile = callbackify(fsp.readFile);
const readlink = exports.readlink = callbackify(fsp.readlink);
const rename = exports.rename = callbackify(fsp.rename);
const rm = exports.rm = callbackify(fsp.rm);
const rmdir = exports.rmdir = callbackify(fsp.rmdir);
const stat = exports.stat = callbackify(fsp.stat);
const symlink = exports.symlink = callbackify(fsp.symlink);
const truncate = exports.truncate = callbackify(fsp.truncate);
const unlink = exports.unlink = callbackify(fsp.unlink);
const utimes = exports.utimes = callbackify(fsp.utimes);
const writeFile = exports.writeFile = callbackify(fsp.writeFile);
const statfs = exports.statfs = callbackify(fsp.statfs);
const close = exports.close = (0, _utils.notImplementedAsync)("fs.close");
const createReadStream = exports.createReadStream = (0, _utils.notImplementedAsync)("fs.createReadStream");
const createWriteStream = exports.createWriteStream = (0, _utils.notImplementedAsync)("fs.createWriteStream");
const exists = exports.exists = (0, _utils.notImplementedAsync)("fs.exists");
const fchown = exports.fchown = (0, _utils.notImplementedAsync)("fs.fchown");
const fchmod = exports.fchmod = (0, _utils.notImplementedAsync)("fs.fchmod");
const fdatasync = exports.fdatasync = (0, _utils.notImplementedAsync)("fs.fdatasync");
const fstat = exports.fstat = (0, _utils.notImplementedAsync)("fs.fstat");
const fsync = exports.fsync = (0, _utils.notImplementedAsync)("fs.fsync");
const ftruncate = exports.ftruncate = (0, _utils.notImplementedAsync)("fs.ftruncate");
const futimes = exports.futimes = (0, _utils.notImplementedAsync)("fs.futimes");
const lstatSync = exports.lstatSync = (0, _utils.notImplementedAsync)("fs.lstatSync");
const read = exports.read = (0, _utils.notImplementedAsync)("fs.read");
const readv = exports.readv = (0, _utils.notImplementedAsync)("fs.readv");
const realpathSync = exports.realpathSync = (0, _utils.notImplementedAsync)("fs.realpathSync");
const statSync = exports.statSync = (0, _utils.notImplementedAsync)("fs.statSync");
const unwatchFile = exports.unwatchFile = (0, _utils.notImplementedAsync)("fs.unwatchFile");
const watch = exports.watch = (0, _utils.notImplementedAsync)("fs.watch");
const watchFile = exports.watchFile = (0, _utils.notImplementedAsync)("fs.watchFile");
const write = exports.write = (0, _utils.notImplementedAsync)("fs.write");
const writev = exports.writev = (0, _utils.notImplementedAsync)("fs.writev");
const _toUnixTimestamp = exports._toUnixTimestamp = (0, _utils.notImplementedAsync)("fs._toUnixTimestamp");
const openAsBlob = exports.openAsBlob = (0, _utils.notImplementedAsync)("fs.openAsBlob");
const appendFileSync = exports.appendFileSync = (0, _utils.notImplemented)("fs.appendFileSync");
const accessSync = exports.accessSync = (0, _utils.notImplemented)("fs.accessSync");
const chownSync = exports.chownSync = (0, _utils.notImplemented)("fs.chownSync");
const chmodSync = exports.chmodSync = (0, _utils.notImplemented)("fs.chmodSync");
const closeSync = exports.closeSync = (0, _utils.notImplemented)("fs.closeSync");
const copyFileSync = exports.copyFileSync = (0, _utils.notImplemented)("fs.copyFileSync");
const cpSync = exports.cpSync = (0, _utils.notImplemented)("fs.cpSync");
const existsSync = () => false;
exports.existsSync = existsSync;
const fchownSync = exports.fchownSync = (0, _utils.notImplemented)("fs.fchownSync");
const fchmodSync = exports.fchmodSync = (0, _utils.notImplemented)("fs.fchmodSync");
const fdatasyncSync = exports.fdatasyncSync = (0, _utils.notImplemented)("fs.fdatasyncSync");
const fstatSync = exports.fstatSync = (0, _utils.notImplemented)("fs.fstatSync");
const fsyncSync = exports.fsyncSync = (0, _utils.notImplemented)("fs.fsyncSync");
const ftruncateSync = exports.ftruncateSync = (0, _utils.notImplemented)("fs.ftruncateSync");
const futimesSync = exports.futimesSync = (0, _utils.notImplemented)("fs.futimesSync");
const lchownSync = exports.lchownSync = (0, _utils.notImplemented)("fs.lchownSync");
const lchmodSync = exports.lchmodSync = (0, _utils.notImplemented)("fs.lchmodSync");
const linkSync = exports.linkSync = (0, _utils.notImplemented)("fs.linkSync");
const lutimesSync = exports.lutimesSync = (0, _utils.notImplemented)("fs.lutimesSync");
const mkdirSync = exports.mkdirSync = (0, _utils.notImplemented)("fs.mkdirSync");
const mkdtempSync = exports.mkdtempSync = (0, _utils.notImplemented)("fs.mkdtempSync");
const openSync = exports.openSync = (0, _utils.notImplemented)("fs.openSync");
const opendirSync = exports.opendirSync = (0, _utils.notImplemented)("fs.opendirSync");
const readdirSync = exports.readdirSync = (0, _utils.notImplemented)("fs.readdirSync");
const readSync = exports.readSync = (0, _utils.notImplemented)("fs.readSync");
const readvSync = exports.readvSync = (0, _utils.notImplemented)("fs.readvSync");
const readFileSync = exports.readFileSync = (0, _utils.notImplemented)("fs.readFileSync");
const readlinkSync = exports.readlinkSync = (0, _utils.notImplemented)("fs.readlinkSync");
const renameSync = exports.renameSync = (0, _utils.notImplemented)("fs.renameSync");
const rmSync = exports.rmSync = (0, _utils.notImplemented)("fs.rmSync");
const rmdirSync = exports.rmdirSync = (0, _utils.notImplemented)("fs.rmdirSync");
const symlinkSync = exports.symlinkSync = (0, _utils.notImplemented)("fs.symlinkSync");
const truncateSync = exports.truncateSync = (0, _utils.notImplemented)("fs.truncateSync");
const unlinkSync = exports.unlinkSync = (0, _utils.notImplemented)("fs.unlinkSync");
const utimesSync = exports.utimesSync = (0, _utils.notImplemented)("fs.utimesSync");
const writeFileSync = exports.writeFileSync = (0, _utils.notImplemented)("fs.writeFileSync");
const writeSync = exports.writeSync = (0, _utils.notImplemented)("fs.writeSync");
const writevSync = exports.writevSync = (0, _utils.notImplemented)("fs.writevSync");
const statfsSync = exports.statfsSync = (0, _utils.notImplemented)("fs.statfsSync");