"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connect = exports.Http2ServerResponse = exports.Http2ServerRequest = void 0;
Object.defineProperty(exports, "constants", {
  enumerable: true,
  get: function () {
    return _constants.constants;
  }
});
exports.sensitiveHeaders = exports.performServerHandshake = exports.getUnpackedSettings = exports.getPackedSettings = exports.getDefaultSettings = exports.default = exports.createServer = exports.createSecureServer = void 0;
var _proxy = _interopRequireDefault(require("../../mock/proxy.cjs"));
var _utils = require("../../_internal/utils.cjs");
var _constants = require("./internal/constants.cjs");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const createSecureServer = exports.createSecureServer = (0, _utils.notImplemented)("http2.createSecureServer");
const createServer = exports.createServer = (0, _utils.notImplemented)("http2.createServer");
const connect = exports.connect = (0, _utils.notImplemented)("http2.connect");
const performServerHandshake = exports.performServerHandshake = (0, _utils.notImplemented)("http2.performServerHandshake ");
const Http2ServerRequest = exports.Http2ServerRequest = _proxy.default.__createMock__("http2.Http2ServerRequest");
const Http2ServerResponse = exports.Http2ServerResponse = _proxy.default.__createMock__("http2.Http2ServerResponse");
const getDefaultSettings = function () {
  return /* @__PURE__ */Object.create({
    headerTableSize: 4096,
    enablePush: true,
    initialWindowSize: 65535,
    maxFrameSize: 16384,
    maxConcurrentStreams: 4294967295,
    maxHeaderSize: 65535,
    maxHeaderListSize: 65535,
    enableConnectProtocol: false
  });
};
exports.getDefaultSettings = getDefaultSettings;
const getPackedSettings = function () {
  return Buffer.from("");
};
exports.getPackedSettings = getPackedSettings;
const getUnpackedSettings = function () {
  return /* @__PURE__ */Object.create({});
};
exports.getUnpackedSettings = getUnpackedSettings;
const sensitiveHeaders = exports.sensitiveHeaders = Symbol("nodejs.http2.sensitiveHeaders");
module.exports = {
  constants: _constants.constants,
  createSecureServer,
  createServer,
  Http2ServerRequest,
  Http2ServerResponse,
  connect,
  getDefaultSettings,
  getPackedSettings,
  getUnpackedSettings,
  performServerHandshake,
  sensitiveHeaders
};