import mock from "../../mock/proxy.mjs";
import { notImplemented } from "../../_internal/utils.mjs";
import { constants } from "./internal/constants.mjs";
export { constants } from "./internal/constants.mjs";
export const createSecureServer = notImplemented("http2.createSecureServer");
export const createServer = notImplemented("http2.createServer");
export const connect = notImplemented("http2.connect");
export const performServerHandshake = notImplemented("http2.performServerHandshake ");
export const Http2ServerRequest = mock.__createMock__("http2.Http2ServerRequest");
export const Http2ServerResponse = mock.__createMock__("http2.Http2ServerResponse");
export const getDefaultSettings = function() {
  return /* @__PURE__ */ Object.create({
    headerTableSize: 4096,
    enablePush: true,
    initialWindowSize: 65535,
    maxFrameSize: 16384,
    maxConcurrentStreams: 4294967295,
    maxHeaderSize: 65535,
    maxHeaderListSize: 65535,
    enableConnectProtocol: false
  });
};
export const getPackedSettings = function() {
  return Buffer.from("");
};
export const getUnpackedSettings = function() {
  return /* @__PURE__ */ Object.create({});
};
export const sensitiveHeaders = Symbol(
  "nodejs.http2.sensitiveHeaders"
);
export default {
  constants,
  createSecureServer,
  createServer,
  Http2ServerRequest,
  Http2ServerResponse,
  connect,
  getDefaultSettings,
  getPackedSettings,
  getUnpackedSettings,
  performServerHandshake,
  sensitiveHeaders
};
