/// <reference types="node" />
import type perf_hooks from "node:perf_hooks";
export { constants } from "./internal/constants";
export * from "./internal/performance";
export declare const monitorEventLoopDelay: typeof perf_hooks.monitorEventLoopDelay;
export declare const createHistogram: typeof perf_hooks.createHistogram;
declare const _default: {
    Performance: {
        new (): {
            timerify<T extends (...params: any[]) => any>(_fn: T, _options?: any): T;
            readonly nodeTiming: perf_hooks.PerformanceNodeTiming;
            eventLoopUtilization(): perf_hooks.EventLoopUtilization;
            mark(name: string, options?: PerformanceMarkOptions | undefined): any;
            measure(measureName: string, startOrMeasureOptions?: string | PerformanceMeasureOptions | undefined, endMark?: string | undefined): any;
            readonly __unenv__: true;
            timeOrigin: number;
            eventCounts: EventCounts;
            _entries: PerformanceEntry[];
            _resourceTimingBufferSize: number;
            navigation: any;
            timing: any;
            onresourcetimingbufferfull: ((this: Performance, ev: Event) => any) | null;
            now(): number;
            clearMarks(markName?: string | undefined): void;
            clearMeasures(measureName?: string | undefined): void;
            clearResourceTimings(): void;
            getEntries(): perf_hooks.PerformanceEntry[];
            getEntriesByName(name: string, type?: string | undefined): perf_hooks.PerformanceEntry[];
            getEntriesByType(type: string): perf_hooks.PerformanceEntry[];
            setResourceTimingBufferSize(maxSize: number): void;
            toJSON(): any;
            addEventListener<K extends "resourcetimingbufferfull">(type: K, listener: (this: Performance, ev: PerformanceEventMap[K]) => any, options?: boolean | AddEventListenerOptions | undefined): void;
            addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions | undefined): void;
            removeEventListener<K_1 extends "resourcetimingbufferfull">(type: K_1, listener: (this: Performance, ev: PerformanceEventMap[K_1]) => any, options?: boolean | EventListenerOptions | undefined): void;
            removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions | undefined): void;
            dispatchEvent(event: Event): boolean;
        };
    };
    PerformanceEntry: any;
    PerformanceMark: any;
    PerformanceMeasure: any;
    PerformanceObserverEntryList: {
        new (): PerformanceObserverEntryList;
        prototype: PerformanceObserverEntryList;
    };
    PerformanceObserver: any;
    PerformanceResourceTiming: {
        new (): PerformanceResourceTiming;
        prototype: PerformanceResourceTiming;
    };
    constants: any;
    createHistogram: any;
    monitorEventLoopDelay: any;
    performance: perf_hooks.Performance;
};
export default _default;
