"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecordableHistogram = exports.IntervalHistogram = void 0;
var _utils = require("../../../_internal/utils.cjs");
class Histogram {
  min = 9223372036854776e3;
  max = 0;
  mean = Number.NaN;
  exceeds = 0;
  stddev = Number.NaN;
  count = 0;
  countBigInt = BigInt(0);
  exceedsBigInt = BigInt(0);
  maxBigInt = 0;
  minBigInt = BigInt(9223372036854775807n);
  percentiles = /* @__PURE__ */new Map();
  percentilesBigInt = /* @__PURE__ */new Map();
  percentileBigInt(_percentile) {
    throw (0, _utils.createNotImplementedError)("Histogram.percentileBigInt");
  }
  percentile(percentile) {
    return this.percentiles.get(percentile) ?? Number.NaN;
  }
  reset() {
    throw (0, _utils.createNotImplementedError)("Histogram.reset");
  }
}
class IntervalHistogram extends Histogram {
  enable() {
    return true;
  }
  disable() {
    return true;
  }
}
exports.IntervalHistogram = IntervalHistogram;
class RecordableHistogram extends Histogram {
  record(val) {
    throw (0, _utils.createNotImplementedError)("RecordableHistogram.record");
  }
  recordDelta() {
    throw (0, _utils.createNotImplementedError)("RecordableHistogram.recordDelta");
  }
  add(other) {
    throw (0, _utils.createNotImplementedError)("RecordableHistogram.add");
  }
}
exports.RecordableHistogram = RecordableHistogram;