import { createNotImplementedError } from "../../../_internal/utils.mjs";
import {
  _Performance,
  _PerformanceEntry,
  _PerformanceMark,
  _PerformanceMeasure,
  _PerformanceObserver
} from "../../../web/performance/index.mjs";
export {
  PerformanceResourceTiming,
  PerformanceObserverEntryList
} from "../../../web/performance/index.mjs";
export const Performance = class Performance2 extends _Performance {
  constructor() {
    super();
  }
  timerify(_fn, _options) {
    throw createNotImplementedError("Performance.timerify");
  }
  get nodeTiming() {
    return {};
  }
  eventLoopUtilization() {
    return {};
  }
  mark(name, options) {
    const entry = super.mark(name, options);
    return entry;
  }
  measure(measureName, startOrMeasureOptions, endMark) {
    const entry = super.measure(measureName, startOrMeasureOptions, endMark);
    return entry;
  }
};
export const performance = globalThis.performance ?? new Performance();
export const PerformanceMark = class PerformanceMark2 extends _PerformanceMark {
  constructor() {
    super(...arguments);
  }
  get duration() {
    return 0;
  }
};
export const PerformanceEntry = class PerformanceEntry2 extends _PerformanceEntry {
  entryType = "event";
  constructor() {
    super(...arguments);
  }
};
export const PerformanceMeasure = class PerformanceMeasure2 extends _PerformanceMeasure {
  constructor() {
    super(...arguments);
  }
};
export const PerformanceObserver = class PerformanceObserver2 extends _PerformanceObserver {
  constructor(callback) {
    super(callback);
  }
  observe(options) {
    throw createNotImplementedError("PerformanceObserver.observe");
  }
  bind(fn) {
    return fn;
  }
  runInAsyncScope(fn, thisArg, ...args) {
    return fn.call(thisArg, ...args);
  }
  asyncId() {
    return 0;
  }
  triggerAsyncId() {
    return 0;
  }
  emitDestroy() {
    return this;
  }
};
