"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unescapeBuffer = exports.unescape = exports.stringify = exports.parse = exports.escape = exports.encode = exports.default = exports.decode = void 0;
var _ufo = require("ufo");
const parse = function (obj, _sep, _eq, _options) {
  return (0, _ufo.parseQuery)(obj);
};
exports.parse = parse;
const decode = exports.decode = parse;
const stringify = function (obj, _sep, _eq, _options) {
  return (0, _ufo.stringifyQuery)(obj);
};
exports.stringify = stringify;
const encode = exports.encode = stringify;
let escape = exports.escape = encodeURIComponent;
let unescape = exports.unescape = decodeURIComponent;
const unescapeBuffer = function (str, _decodeSpaces) {
  return Buffer.from(unescape(str));
};
exports.unescapeBuffer = unescapeBuffer;
module.exports = {
  decode,
  encode,
  escape,
  parse,
  stringify,
  unescape,
  unescapeBuffer
};