"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeout = void 0;
class Timeout {
  constructor(callback, args) {
    if (typeof callback === "function") {
      callback(...args);
    }
  }
  ref() {
    return this;
  }
  unref() {
    return this;
  }
  hasRef() {
    return false;
  }
  refresh() {
    return this;
  }
  [Symbol.dispose]() {}
  [Symbol.toPrimitive]() {
    return 0;
  }
}
exports.Timeout = Timeout;