"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TLSSocket = void 0;
var _nodeNet = require("node:net");
var _utils = require("../../../_internal/utils.cjs");
class TLSSocket extends _nodeNet.Socket {
  authorized = false;
  encrypted = true;
  alpnProtocol = null;
  authorizationError = new Error("[unenv] TLSSocket.authorizationError is not implemented yet!");
  exportKeyingMaterial() {
    throw (0, _utils.createNotImplementedError)("TLSSocket.exportKeyingMaterial");
  }
  getCipher() {
    throw (0, _utils.createNotImplementedError)("TLSSocket.getCipher");
  }
  getPeerCertificate(_detailed) {
    throw (0, _utils.createNotImplementedError)("TLSSocket.getPeerCertificate");
  }
  getCertificate() {
    return null;
  }
  getEphemeralKeyInfo() {
    return null;
  }
  getFinished() {}
  getPeerFinished() {}
  getProtocol() {
    return null;
  }
  getSession() {}
  getSharedSigalgs() {
    return [];
  }
  getTLSTicket() {}
  isSessionReused() {
    return false;
  }
  renegotiate(options, callback) {
    if (typeof callback === "function") {
      callback(null);
    }
  }
  setMaxSendFragment(size) {
    return false;
  }
  disableRenegotiation() {}
  enableTrace() {}
  getPeerX509Certificate() {}
  getX509Certificate() {}
}
exports.TLSSocket = TLSSocket;