/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
import type tls from "node:tls";
import { Socket } from "node:net";
export declare class TLSSocket extends Socket implements tls.TLSSocket {
    authorized: boolean;
    encrypted: true;
    alpnProtocol: null;
    authorizationError: Error;
    exportKeyingMaterial(): Buffer;
    getCipher(): tls.CipherNameAndProtocol;
    getPeerCertificate(detailed: true): tls.DetailedPeerCertificate;
    getPeerCertificate(detailed?: false): tls.PeerCertificate;
    getPeerCertificate(detailed?: boolean): tls.PeerCertificate | tls.DetailedPeerCertificate;
    getCertificate(): null;
    getEphemeralKeyInfo(): null;
    getFinished(): undefined;
    getPeerFinished(): undefined;
    getProtocol(): null;
    getSession(): undefined;
    getSharedSigalgs(): never[];
    getTLSTicket(): undefined;
    isSessionReused(): boolean;
    renegotiate(options: {
        rejectUnauthorized?: boolean | undefined;
        requestCert?: boolean | undefined;
    }, callback: (err: Error | null) => void): undefined;
    setMaxSendFragment(size: number): boolean;
    disableRenegotiation(): void;
    enableTrace(): void;
    getPeerX509Certificate(): undefined;
    getX509Certificate(): undefined;
}
