export {
  _errnoException,
  _exceptionWithHostPort,
  getSystemErrorMap,
  getSystemErrorName,
  isArray,
  isBoolean,
  isBuffer,
  isDate,
  isDeepStrictEqual,
  isError,
  isFunction,
  isNull,
  isNullOrUndefined,
  isNumber,
  isObject,
  isPrimitive,
  isRegExp,
  isString,
  isSymbol,
  isUndefined,
  parseEnv,
  styleText
} from "./index.mjs";
import {
  _errnoException as _errnoException2,
  _exceptionWithHostPort as _exceptionWithHostPort2,
  getSystemErrorMap as getSystemErrorMap2,
  getSystemErrorName as getSystemErrorName2,
  isArray as isArray2,
  isBoolean as isBoolean2,
  isBuffer as isBuffer2,
  isDate as isDate2,
  isDeepStrictEqual as isDeepStrictEqual2,
  isError as isError2,
  isFunction as isFunction2,
  isNull as isNull2,
  isNullOrUndefined as isNullOrUndefined2,
  isNumber as isNumber2,
  isObject as isObject2,
  isPrimitive as isPrimitive2,
  isRegExp as isRegExp2,
  isString as isString2,
  isSymbol as isSymbol2,
  isUndefined as isUndefined2,
  parseEnv as parseEnv2,
  styleText as styleText2,
  types as unenvUtilTypes
} from "./index.mjs";
const workerdUtil = process.getBuiltinModule("node:util");
export const {
  MIMEParams,
  MIMEType,
  TextDecoder,
  TextEncoder,
  _extend,
  aborted,
  callbackify,
  debug,
  debuglog,
  deprecate,
  format,
  formatWithOptions,
  inherits,
  inspect,
  log,
  parseArgs,
  promisify,
  stripVTControlCharacters,
  toUSVString,
  transferableAbortController,
  transferableAbortSignal
} = workerdUtil;
export const types = {
  isExternal: unenvUtilTypes.isExternal,
  isAnyArrayBuffer: workerdUtil.types.isAnyArrayBuffer,
  ...workerdUtil.types
};
export default {
  /**
   * manually unroll unenv-polyfilled-symbols to make it tree-shakeable
   */
  // @ts-expect-error undocumented public API
  _errnoException: _errnoException2,
  _exceptionWithHostPort: _exceptionWithHostPort2,
  getSystemErrorMap: getSystemErrorMap2,
  getSystemErrorName: getSystemErrorName2,
  isArray: isArray2,
  isBoolean: isBoolean2,
  isBuffer: isBuffer2,
  isDate: isDate2,
  isDeepStrictEqual: isDeepStrictEqual2,
  isError: isError2,
  isFunction: isFunction2,
  isNull: isNull2,
  isNullOrUndefined: isNullOrUndefined2,
  isNumber: isNumber2,
  isObject: isObject2,
  isPrimitive: isPrimitive2,
  isRegExp: isRegExp2,
  isString: isString2,
  isSymbol: isSymbol2,
  isUndefined: isUndefined2,
  parseEnv: parseEnv2,
  styleText: styleText2,
  /**
   * manually unroll workerd-polyfilled-symbols to make it tree-shakeable
   */
  MIMEParams,
  MIMEType,
  TextDecoder,
  TextEncoder,
  _extend,
  aborted,
  callbackify,
  debug,
  debuglog,
  deprecate,
  format,
  formatWithOptions,
  inherits,
  inspect,
  log,
  parseArgs,
  promisify,
  stripVTControlCharacters,
  toUSVString,
  transferableAbortController,
  transferableAbortSignal,
  // special-cased deep merged symbols
  types
};
