"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gzipSync = exports.gzip = exports.gunzipSync = exports.gunzip = exports.createGzip = exports.createGunzip = exports.Gzip = exports.Gunzip = void 0;
var _utils = require("../../../../_internal/utils.cjs");
var _shared = require("./_shared.cjs");
class Gzip extends _shared.ZlibCompress {
  _format = "gzip";
}
exports.Gzip = Gzip;
const gzip = exports.gzip = (0, _shared.notImplementedCompress)("gzip");
const createGzip = () => new Gzip();
exports.createGzip = createGzip;
const gzipSync = exports.gzipSync = (0, _utils.notImplemented)("zlib.gzipSync");
class Gunzip extends _shared.ZLibDecompress {
  _format = "gzip";
}
exports.Gunzip = Gunzip;
const gunzip = exports.gunzip = (0, _shared.notImplementedCompress)("gunzip");
const createGunzip = () => new Gunzip();
exports.createGunzip = createGunzip;
const gunzipSync = exports.gunzipSync = (0, _utils.notImplemented)("zlib.gunzipSync");