"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._supportedEntryTypes = exports._PerformanceResourceTiming = exports._PerformanceMeasure = exports._PerformanceMark = exports._PerformanceEntry = exports.PerformanceResourceTiming = exports.PerformanceMeasure = exports.PerformanceMark = exports.PerformanceEntry = void 0;
const _supportedEntryTypes = exports._supportedEntryTypes = ["event",
// PerformanceEntry
"mark",
// PerformanceMark
"measure",
// PerformanceMeasure
"resource"
// PerformanceResourceTiming
];

class _PerformanceEntry {
  __unenv__ = true;
  detail;
  entryType = "event";
  name;
  startTime;
  constructor(name, options) {
    this.name = name;
    this.startTime = options?.startTime || performance.now();
    this.detail = options?.detail;
  }
  get duration() {
    return performance.now() - this.startTime;
  }
  toJSON() {
    return {
      name: this.name,
      entryType: this.entryType,
      startTime: this.startTime,
      duration: this.duration,
      detail: this.detail
    };
  }
}
exports._PerformanceEntry = _PerformanceEntry;
const PerformanceEntry = exports.PerformanceEntry = globalThis.PerformanceEntry || _PerformanceEntry;
class _PerformanceMark extends _PerformanceEntry {
  entryType = "mark";
}
exports._PerformanceMark = _PerformanceMark;
const PerformanceMark = exports.PerformanceMark = globalThis.PerformanceMark || _PerformanceMark;
class _PerformanceMeasure extends _PerformanceEntry {
  entryType = "measure";
}
exports._PerformanceMeasure = _PerformanceMeasure;
const PerformanceMeasure = exports.PerformanceMeasure = globalThis.PerformanceMeasure || _PerformanceMeasure;
class _PerformanceResourceTiming extends _PerformanceEntry {
  entryType = "resource";
  serverTiming = [];
  connectEnd = 0;
  connectStart = 0;
  decodedBodySize = 0;
  domainLookupEnd = 0;
  domainLookupStart = 0;
  encodedBodySize = 0;
  fetchStart = 0;
  initiatorType = "";
  name = "";
  nextHopProtocol = "";
  redirectEnd = 0;
  redirectStart = 0;
  requestStart = 0;
  responseEnd = 0;
  responseStart = 0;
  secureConnectionStart = 0;
  startTime = 0;
  transferSize = 0;
  workerStart = 0;
}
exports._PerformanceResourceTiming = _PerformanceResourceTiming;
const PerformanceResourceTiming = exports.PerformanceResourceTiming = globalThis.PerformanceResourceTiming || _PerformanceResourceTiming;