/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.Cookie;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.CookieBasedSessionManagementMethodType;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.ZapHtmlLabel;
import org.zaproxy.zap.view.LayoutHelper;

public class ManualAuthenticationMethodType
extends AuthenticationMethodType {
    private static final int METHOD_IDENTIFIER = 0;
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.manual.name");
    private static final String API_METHOD_NAME = "manualAuthentication";
    private static final String ACTION_SET_CREDENTIALS = "manualAuthenticationCredentials";
    private static final String PARAM_SESSION_NAME = "sessionName";

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public boolean hasOptionsPanel() {
        return false;
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public ManualAuthenticationMethod createAuthenticationMethod(int contextId) {
        return new ManualAuthenticationMethod(contextId);
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return null;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials credentials, Context uiSharedContext) {
        return new ManualAuthenticationCredentialsOptionsPanel((ManualAuthenticationCredentials)credentials, uiSharedContext);
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod method) {
        return method instanceof ManualAuthenticationMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public AuthenticationMethod loadMethodFromSession(Session session, int contextId) {
        return new ManualAuthenticationMethod(contextId);
    }

    @Override
    public void persistMethodToSession(Session session, int contextId, AuthenticationMethod authMethod) {
    }

    @Override
    public int getUniqueIdentifier() {
        return 0;
    }

    @Override
    public ManualAuthenticationCredentials createAuthenticationCredentials() {
        return new ManualAuthenticationCredentials();
    }

    public Class<ManualAuthenticationCredentials> getAuthenticationCredentialsType() {
        return ManualAuthenticationCredentials.class;
    }

    public static ManualAuthenticationCredentials createAuthenticationCredentials(HttpSession session) {
        ManualAuthenticationCredentials c = new ManualAuthenticationCredentials();
        c.setSelectedSession(session);
        return c;
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, null, null){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                ManualAuthenticationMethod method = ManualAuthenticationMethodType.this.createAuthenticationMethod(context.getId());
                context.setAuthenticationMethod(method);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return new ApiDynamicActionImplementor(ACTION_SET_CREDENTIALS, new String[]{PARAM_SESSION_NAME}, null){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                int userId = ApiUtils.getIntParam(params, "userId");
                if (!ManualAuthenticationMethodType.this.isTypeForMethod(context.getAuthenticationMethod())) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "User's credentials should match authentication method type of the context: " + context.getAuthenticationMethod().getType().getName());
                }
                ExtensionUserManagement extensionUserManagement = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                User user = extensionUserManagement.getContextUserAuthManager(context.getId()).getUserById(userId);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, "userId");
                }
                String sessionName = ApiUtils.getNonEmptyStringParam(params, ManualAuthenticationMethodType.PARAM_SESSION_NAME);
                ExtensionHttpSessions extensionHttpSessions = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHttpSessions.class);
                if (extensionHttpSessions == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "HttpSessions extension is not loaded.");
                }
                List<HttpSession> sessions = extensionHttpSessions.getHttpSessionsForContext(context);
                HttpSession matchedSession = null;
                for (HttpSession session : sessions) {
                    if (!session.getName().equals(sessionName)) continue;
                    matchedSession = session;
                    break;
                }
                if (matchedSession == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ManualAuthenticationMethodType.PARAM_SESSION_NAME);
                }
                ManualAuthenticationCredentials credentials = ManualAuthenticationMethodType.this.createAuthenticationCredentials();
                credentials.setSelectedSession(matchedSession);
                user.setAuthenticationCredentials(credentials);
            }
        };
    }

    @Override
    public void exportData(Configuration config, AuthenticationMethod authMethod) {
    }

    @Override
    public void importData(Configuration config, AuthenticationMethod authMethod) throws ConfigurationException {
    }

    private static class ManualAuthenticationCredentialsOptionsPanel
    extends AbstractCredentialsOptionsPanel<ManualAuthenticationCredentials> {
        private static final long serialVersionUID = -8081914793980311435L;
        private static final Logger LOGGER = LogManager.getLogger(ManualAuthenticationCredentialsOptionsPanel.class);
        private JComboBox<HttpSession> sessionsComboBox;
        private Context uiSharedContext;

        public ManualAuthenticationCredentialsOptionsPanel(ManualAuthenticationCredentials credentials, Context uiSharedContext) {
            super(credentials);
            this.uiSharedContext = uiSharedContext;
            this.initialize();
        }

        protected void initialize() {
            this.setLayout(new GridBagLayout());
            JLabel sessionsLabel = new JLabel(Constant.messages.getString("authentication.method.manual.field.session"));
            this.add((Component)sessionsLabel, LayoutHelper.getGBC(0, 0, 1, 0.5));
            this.add(this.getSessionsComboBox(), LayoutHelper.getGBC(1, 0, 1, 0.5));
            this.getSessionsComboBox().setRenderer(new HttpSessionRenderer());
            this.add((Component)new ZapHtmlLabel(Constant.messages.getString("authentication.method.manual.field.description")), LayoutHelper.getGBC(0, 1, 2, 0.0, 0.0));
        }

        private JComboBox<HttpSession> getSessionsComboBox() {
            if (this.sessionsComboBox == null) {
                ExtensionHttpSessions extensionHttpSessions = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHttpSessions.class);
                List<HttpSession> sessions = extensionHttpSessions.getHttpSessionsForContext(this.uiSharedContext);
                LOGGER.debug("Found sessions for Manual Authentication Config: {}", sessions);
                this.sessionsComboBox = new JComboBox<HttpSession>(sessions.toArray(new HttpSession[sessions.size()]));
                this.sessionsComboBox.setSelectedItem(((ManualAuthenticationCredentials)this.getCredentials()).getSelectedSession());
            }
            return this.sessionsComboBox;
        }

        @Override
        public boolean validateFields() {
            return true;
        }

        @Override
        public void saveCredentials() {
            LOGGER.info("Saving Manual Authentication Method: {}", this.getSessionsComboBox().getSelectedItem());
            ((ManualAuthenticationCredentials)this.getCredentials()).setSelectedSession((HttpSession)this.getSessionsComboBox().getSelectedItem());
        }

        private static class HttpSessionRenderer
        extends BasicComboBoxRenderer {
            private static final long serialVersionUID = 3654541772447187317L;

            private HttpSessionRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    HttpSession item = (HttpSession)value;
                    this.setText(item.getName());
                }
                return this;
            }
        }
    }

    private static class ManualAuthenticationCredentials
    implements AuthenticationCredentials {
        private static final String API_NAME = "ManualAuthenticationCredentials";
        private HttpSession selectedSession;

        private ManualAuthenticationCredentials() {
        }

        protected HttpSession getSelectedSession() {
            return this.selectedSession;
        }

        @Override
        public boolean isConfigured() {
            return this.selectedSession != null;
        }

        protected void setSelectedSession(HttpSession selectedSession) {
            this.selectedSession = selectedSession;
        }

        @Override
        public String encode(String parentStringSeparator) {
            if (this.selectedSession == null) {
                return "";
            }
            return Base64.encodeBase64String(this.selectedSession.getName().getBytes());
        }

        @Override
        public void decode(String encodedCredentials) {
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("type", API_NAME);
            values.put(ManualAuthenticationMethodType.PARAM_SESSION_NAME, this.selectedSession != null ? this.selectedSession.getName() : "");
            return new ApiResponseSet("credentials", values);
        }
    }

    public static class ManualAuthenticationMethod
    extends AuthenticationMethod {
        private int contextId;

        public ManualAuthenticationMethod(int contextId) {
            this.contextId = contextId;
        }

        protected int getContextId() {
            return this.contextId;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new ManualAuthenticationCredentials();
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials credentials, User user) {
            if (!(credentials instanceof ManualAuthenticationCredentials)) {
                LogManager.getLogger(ManualAuthenticationMethod.class).error("Manual authentication credentials should be used for Manual authentication.");
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Manual authentication credentials should be used for Manual authentication.");
            }
            ManualAuthenticationCredentials mc = (ManualAuthenticationCredentials)credentials;
            HttpSession httpSession = mc.getSelectedSession();
            if (httpSession == null) {
                return null;
            }
            CookieBasedSessionManagementMethodType.CookieBasedSession session = new CookieBasedSessionManagementMethodType.CookieBasedSession();
            for (Map.Entry<String, Cookie> v : httpSession.getTokenValuesUnmodifiableMap().entrySet()) {
                session.getHttpState().addCookie(v.getValue());
            }
            return session;
        }

        @Override
        public AuthenticationMethodType getType() {
            return new ManualAuthenticationMethodType();
        }

        @Override
        public AuthenticationMethod duplicate() {
            return new ManualAuthenticationMethod(this.contextId);
        }

        @Override
        public void onMethodPersisted() {
        }

        @Override
        public void onMethodDiscarded() {
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("methodName", ManualAuthenticationMethodType.API_METHOD_NAME);
            return new AuthenticationMethod.AuthMethodApiResponseRepresentation(values);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.contextId;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ManualAuthenticationMethod other = (ManualAuthenticationMethod)obj;
            return this.contextId == other.contextId;
        }

        @Override
        public void replaceUserDataInPollRequest(HttpMessage msg, User user) {
        }
    }
}

