/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class ResponseCountSnapshot {
    private Date date;
    private int period;
    private AtomicInteger resp100;
    private AtomicInteger resp200;
    private AtomicInteger resp300;
    private AtomicInteger resp400;
    private AtomicInteger resp500;

    public ResponseCountSnapshot() {
        this.date = new Date();
        this.period = -1;
        this.resp100 = new AtomicInteger();
        this.resp200 = new AtomicInteger();
        this.resp300 = new AtomicInteger();
        this.resp400 = new AtomicInteger();
        this.resp500 = new AtomicInteger();
    }

    public ResponseCountSnapshot(Date date, int period, int resp100, int resp200, int resp300, int resp400, int resp500) {
        this.date = date;
        this.period = period;
        this.resp100 = new AtomicInteger(resp100);
        this.resp200 = new AtomicInteger(resp200);
        this.resp300 = new AtomicInteger(resp300);
        this.resp400 = new AtomicInteger(resp400);
        this.resp500 = new AtomicInteger(resp500);
    }

    public ResponseCountSnapshot getDifference(ResponseCountSnapshot previous) {
        return new ResponseCountSnapshot(this.date, this.getPeriod(), this.getResp100() - previous.getResp100(), this.getResp200() - previous.getResp200(), this.getResp300() - previous.getResp300(), this.getResp400() - previous.getResp400(), this.getResp500() - previous.getResp500());
    }

    public Date getDate() {
        return this.date;
    }

    public int getResponseCodeCount(RESPONSE_CODE_RANGE rcr) {
        switch (rcr) {
            case RC_100: {
                return this.getResp100();
            }
            case RC_200: {
                return this.getResp200();
            }
            case RC_300: {
                return this.getResp300();
            }
            case RC_400: {
                return this.getResp400();
            }
            case RC_500: {
                return this.getResp500();
            }
        }
        return -1;
    }

    public void incResponseCodeCount(int responseCode) {
        switch (responseCode / 100) {
            case 1: {
                this.incResponseCodeCount(RESPONSE_CODE_RANGE.RC_100);
                break;
            }
            case 2: {
                this.incResponseCodeCount(RESPONSE_CODE_RANGE.RC_200);
                break;
            }
            case 3: {
                this.incResponseCodeCount(RESPONSE_CODE_RANGE.RC_300);
                break;
            }
            case 4: {
                this.incResponseCodeCount(RESPONSE_CODE_RANGE.RC_400);
                break;
            }
            case 5: {
                this.incResponseCodeCount(RESPONSE_CODE_RANGE.RC_500);
                break;
            }
        }
    }

    public void incResponseCodeCount(RESPONSE_CODE_RANGE rcr) {
        switch (rcr) {
            case RC_100: {
                this.resp100.incrementAndGet();
                break;
            }
            case RC_200: {
                this.resp200.incrementAndGet();
                break;
            }
            case RC_300: {
                this.resp300.incrementAndGet();
                break;
            }
            case RC_400: {
                this.resp400.incrementAndGet();
                break;
            }
            case RC_500: {
                this.resp500.incrementAndGet();
            }
        }
    }

    public int getPeriod() {
        return this.period;
    }

    public int getResp100() {
        return this.resp100.get();
    }

    public int getResp200() {
        return this.resp200.get();
    }

    public int getResp300() {
        return this.resp300.get();
    }

    public int getResp400() {
        return this.resp400.get();
    }

    public int getResp500() {
        return this.resp500.get();
    }

    public int getTotal() {
        return this.getResp100() + this.getResp200() + this.getResp300() + this.getResp400() + this.getResp500();
    }

    public ResponseCountSnapshot clone() {
        return new ResponseCountSnapshot(new Date(), this.period, this.resp100.get(), this.resp200.get(), this.resp300.get(), this.resp400.get(), this.resp500.get());
    }

    public static enum RESPONSE_CODE_RANGE {
        RC_100,
        RC_200,
        RC_300,
        RC_400,
        RC_500;

    }
}

