import * as configureKey from './lib/configureKey';
import type { Feature, Numeric, Enum, Binary, Text, Composite, List, Light, Climate, Switch, Lock, Cover, Fan } from './lib/exposes';
import toZigbee from './converters/toZigbee';
import fromZigbee from './converters/fromZigbee';
import * as ota from './lib/ota';
import { Definition, Zh, OnEventData, OnEventType, Expose, Tz, OtaUpdateAvailableResult, KeyValue } from './lib/types';
import * as logger from './lib/logger';
export { Definition as Definition, OnEventType as OnEventType, Feature as Feature, Expose as Expose, Numeric as Numeric, Binary as Binary, Enum as Enum, Text as Text, Composite as Composite, List as List, Light as Light, Climate as Climate, Switch as Switch, Lock as Lock, Cover as Cover, Fan as Fan, toZigbee as toZigbee, fromZigbee as fromZigbee, Tz as Tz, OtaUpdateAvailableResult as OtaUpdateAvailableResult, ota as ota, };
export declare const getConfigureKey: typeof configureKey.getConfigureKey;
export declare const definitions: Definition[];
export declare function postProcessConvertedFromZigbeeMessage(definition: Definition, payload: KeyValue, options: KeyValue): void;
export declare function addDefinition(definition: Definition): void;
export declare function findByDevice(device: Zh.Device, generateForUnknown?: boolean): Promise<Definition>;
export declare function findDefinition(device: Zh.Device, generateForUnknown?: boolean): Promise<Definition>;
export declare function generateExternalDefinitionSource(device: Zh.Device): Promise<string>;
export declare function findByModel(model: string): Definition;
export declare function onEvent(type: OnEventType, data: OnEventData, device: Zh.Device): Promise<void>;
export declare const setLogger: typeof logger.setLogger;
//# sourceMappingURL=index.d.ts.map